/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Some code in here contributed by the FSF
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <regex.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <libxfce4util/util.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "filter.h"
#include "misc.h"

static GList *filter_list = NULL;
static history_combo_info_t filter_combo_info={
	NULL,NULL,NULL,NULL,NULL
};

static void save_f_text(char *p)
{				
    char fname[_POSIX_PATH_MAX];
    if (!p ) return;
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, "xffm%cxffm.flist.2.dbh",
		    G_DIR_SEPARATOR); 
    save_to_history(fname,p);
}

char *load_f_list(GList **g){
    static char fname[_POSIX_PATH_MAX];
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, "xffm%cxffm.flist.dbh",
		    G_DIR_SEPARATOR);
    unlink(fname);
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, "xffm%cxffm.flist.2.dbh",
		    G_DIR_SEPARATOR);
    get_history_list(g,fname,NULL);
    return fname;
}

void set_filter_combo(GtkTreeView *treeview){
    GtkWidget *filter_combo = lookup_widget((GtkWidget *)treeview, "filter_combo");
    
    filter_combo_info.treeview=treeview;
    filter_combo_info.active_dbh_file=load_f_list(&filter_list);
    filter_list = g_list_prepend(filter_list, g_strdup(""));
    filter_combo_info.list=filter_list;
    filter_combo_info.combo=filter_combo;
    filter_combo_info.entry=lookup_widget((GtkWidget *)treeview,"combo_entry2");
    g_signal_connect(G_OBJECT(filter_combo_info.entry), "key_press_event", 
		    G_CALLBACK(on_key_press_history), (gpointer) &filter_combo_info);
    set_limited_combo(&filter_combo_info,NULL);
    return;
}
char *get_filter(GtkWidget * window)
{
    GtkWidget *filter_entry, *filter_combo;
    char *f;
    static gchar *last_filter=NULL;
    

    filter_entry = lookup_widget(window, "combo_entry2");
    filter_combo = lookup_widget(window, "filter_combo");
    if(!GTK_WIDGET_VISIBLE(lookup_widget(window, "filter_box")))
    {
	return "*";
    }
    if(!filter_entry) g_assert_not_reached();
    
    f = (char *)gtk_entry_get_text(GTK_ENTRY(filter_entry));
    if(!f || !strlen(f)) return "*";
    if (last_filter && strcmp(last_filter,f)==0) return last_filter;
    g_free(last_filter);
    last_filter=NULL;
    last_filter=g_strdup(f);  
    load_f_list(&filter_list);
    filter_list = g_list_prepend(filter_list,g_strdup(f));
    save_f_text(f);
    gtk_combo_set_popdown_strings(GTK_COMBO(filter_combo), filter_list);
    if (!strlen(last_filter)) return "*";
    else return last_filter;
}

char *filter2regex(tree_entry_t * en)
{
    char *regex;
    char *filter = en->filter;
    /* change stars to regexp */
    if(!filter || strcmp(filter, "*") == 0 || strlen(filter) == 0)
    {
	regex = g_strdup("^.+$");
    }
    else
    {
	/*Let's translate stars to regexp */
	regex = (char *)malloc(2 * strlen(filter) + 1 + strlen("|^\\..+"));
	if(filter[0] == '*' && filter[strlen(filter) - 1] == '*')
	{
	    strcpy(regex, filter + 1);
	    regex[strlen(regex) - 1] = 0;
	}
	else if(filter[0] == '*')
	{
	    strcpy(regex, filter + 1);
	    strcat(regex, "$");
	    if(SHOWS_HIDDEN(en->type))
	    {
		strcat(regex, "|\\.");
		strcat(regex, filter + 1);
		strcat(regex, "$");
	    }
	}
	else if(filter[strlen(filter) - 1] == '*')
	{
	    strcpy(regex + 1, filter);
	    regex[0] = '^';
	    regex[strlen(filter)] = 0;
	    if(SHOWS_HIDDEN(en->type))
	    {
		strcat(regex, "|^\\.");
		strcat(regex, filter);
		regex[strlen(regex) - 1] = 0;
	    }
	}
	else if(strchr(filter, '*'))
	{
	    strcpy(regex + 1, filter);
	    regex[0] = '^';
	    *strchr(regex, '*') = 0;
	    strcat(regex, ".+");
	    strcat(regex, strchr(filter, '*') + 1);
	    strcat(regex, "$");
	    if(SHOWS_HIDDEN(en->type))
	    {
		char *aux;
		aux = g_strdup(regex + 1);
		strcat(regex, "|^\\.");
		strcat(regex, aux);
		g_free(aux);
		aux=NULL;
	    }
	}
	else
	    strcpy(regex, filter);

    }
    /*printf("DBG:regex=%s\n",regex); */
    return regex;
}

/* OjO return value must be freed */
regex_t *get_regex_filter(GtkTreeView * treeview, tree_entry_t * en)
{
    static regex_t preg;
    char *regex;
    tree_details_t *tree_details = get_tree_details(treeview);
    char *filter = get_filter(tree_details->window);

    if(en->filter){
	g_free(en->filter);
	en->filter=NULL;
    }
    if(filter)
	en->filter = g_strdup(filter);
    else
	en->filter = g_strdup("*");
    regex = filter2regex(en);

    regcomp(&preg, regex, REG_EXTENDED | REG_ICASE | REG_NOSUB);
    g_free(regex);
    regex=NULL;
    return &preg;
}

/* callbacks */

void on_filter_activate(GtkEntry * entry, gpointer user_data)
{
    on_refresh((GtkButton *) entry, user_data);
}

void on_filter_clear(GtkButton * button, gpointer user_data)
{
    GtkEntry *entry;
    entry = (GtkEntry *) lookup_widget((GtkWidget *) button, "combo_entry2");
    gtk_entry_set_text(entry, "");
}
