#!/sbin/sh
#
# XFCE4 installer script.  
# 
# Run this script to install the XFCE Desktop Environment.
#
# If you have any problems with this script please send an e-mail to:
# sol-pkgs@ckgreenman.net
#
# Enjoy!
#
# Chris Greenman

	
################
# Set some Variables
################
PATH=/bin:/sbin:/usr/sbin
INSTDIR=`dirname $0`		# location of packages to be installed
echo=/bin/echo
ADMIN=/tmp/xfceadmin		# location of admin file to control package install.

if [ "$LOGNAME" != "root" ] ; then
	$echo
	$echo "You must be root to run this script.  Permission Denied."
	exit 1
fi

clear

cat << EOF 
XFCE Installer

Welcome to the XFCE Installer.  This script will install all the required packages
for the XFCE Desktop Environment.  


By default the XFCE packages will be installed into /usr/local.  If you wish to 
install into a directory OTHER THAN /usr/local, please enter the installation path 
at the prompt.

Please report any problems with this script or the Solaris packages to 
Chris Greenman <sol-pkgs@ckgreenman.net>



EOF

################
# Get Install Path
################
$echo "Please enter the installation path.[default=/usr/local]? \c"

read DESTPATH		# Prompt for install path

if [ "$DESTPATH" = "" ] ; then
	DESTPATH=/usr/local
fi

if [ ! -d $DESTPATH -a ! -h $DESTPATH ] ; then
	$echo 
	$echo "$DESTPATH does not exist.  Create? [default=y] \c"
	read RESP
	if [ "$RESP" = "n" -o $RESP = "N" ] ; then
		$echo
		$echo "Directory not created.  Exiting."
		exit 1
	fi
fi


################
# Build Admin file
################
cat << EOF > $ADMIN
mail=
conflict=nochange
setuid=nocheck
action=nocheck
partial=nocheck
instance=overwrite
idepend=quit
rdepend=quit
space=quit
basedir=$DESTPATH
EOF


################
# check for and remove Ver 4.0
################

$echo 
$echo "Checking for a previous XFCE install:\c"

for i in XFCEdt XFCEextra XFCEcore ; do 
	$echo ".\c"
	OLDVER=`pkginfo -l $i 2>/dev/null |grep VERSION |awk '{print $2}'`
	if [ ?$ -eq 0 -a "$OLDVER" = "4.0" ] ; then
		$echo $i >> /tmp/pkgexist.tmp
		EXISTS=yes
	fi
done

if [ "$EXISTS" = "yes" ] ; then
	$echo
	$echo
	$echo "You appear to have an incompatible version of XFCE on your system"
	$echo "which cannot be upgraded."
	$echo
	$echo "The following packages are already installed:"
	cat /tmp/pkgexist.tmp
	$echo
	$echo "Would you like to remove these packages? [default=y] \c"
	read RESP
	if [ "$RESP" = "n" -o "$RESP" = "N" ] ; then
		$echo
		$echo "You have chosen NOT to remove the packages."
		$echo "These packages MUST be removed before installation can continue"
		$echo 
		$echo "If you want to remove them by hand use the following command:"
		$echo "pkgrm \c"
		for i in `cat /tmp/pkgexist.tmp` ; do
			$echo "$i \c"
		done
		$echo
		rm /tmp/pkgexist.tmp
		exit 1
	else
		for i in `cat /tmp/pkgexist.tmp` ; do
			pkgrm -n -a $ADMIN $i
		done
	fi

	rm /tmp/pkgexist.tmp
fi


################
# Make sure install-order exists
################

if [ ! -f $INSTDIR/install-order ] ; then
	$echo "Your install collection is not complete."
	$echo "Please go to www.xfce.org and download the complete collection."
	$echo
	$echo "Cannot continue."
	exit 1
fi

################
# Install standard XFCE packages
################
$echo
$echo "Installing XFce packages.  Please wait."
for i in `cat $INSTDIR/install-order` ; do 

	pkgadd -d $INSTDIR -n -a $ADMIN $i
	if [ $? -gt 0 ] ; then
		echo $i >> /tmp/xfce-failed-pkgs # Make list of failures
		FAILED=yes
	fi
done


################
# Install XFCEdt (uses different basedir)
################
cat << EOF > $ADMIN
mail=
conflict=nochange
setuid=nocheck
action=nocheck
partial=nocheck
instance=overwrite
idepend=quit
rdepend=quit
space=quit
EOF

$echo "Installing dtlogin integration..."
pkgadd -d $INSTDIR -n -a $ADMIN XFCEdt

if [ $? -gt 0 ] ; then
	echo XFCEdt >> /tmp/xfce-failed-pkgs
	FAILED=yes
fi

 
################
# Print list of failed packages
################

if [ "$FAILED" = "yes" ] ; then
	$echo 
	$echo "The following packages were not installed:"
	$echo
	cat /tmp/xfce-failed-pkgs
	$echo
	rm /tmp/xfce-failed-pkgs
fi


rm $ADMIN


################
# Tell user we're done
################
cat << EOF


Installation complete

To use XFCE from the graphical login prompt you must logout, login using the
command line, then kill and restart dtlogin.

Enjoy!

EOF
