/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <limits.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "aux.h"
#include "misc.h"
#include "smb_misc.h"



XID get_xid(GtkTreeView * treeview)
{
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    GtkWidget *w = lookup_widget(tree_details->window, "vbox1");
    return GDK_WINDOW_XID(gtk_widget_get_parent_window(w));
}


char *our_host_name(GtkTreeView * treeview)
{
    static char *name = NULL;
    unsigned char *property_data;
    unsigned long items, remaining;
    int actual_format;
    Atom atomo, actual_atom;

    if(name)
	return name;
    atomo = XInternAtom(GDK_DISPLAY(), "WM_CLIENT_MACHINE", FALSE);
    if(XGetWindowProperty(GDK_DISPLAY(), get_xid(treeview), atomo, 0, 255, FALSE, XA_STRING, &actual_atom, &actual_format, &items, &remaining, &property_data) == Success)
    {
	/*printf("dbg: property_data=%s\n",property_data); */
	name = g_strdup(property_data);
	XFree(property_data);
    }
    else
	name = g_strdup("localhost");

    return name;
}


void set_title(GtkTreeView * treeview, gchar **path)
{
    Atom atomo;
    char title[_POSIX_PATH_MAX], iconname[_POSIX_PATH_MAX], *hostname;
    char *word;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);


    hostname = our_host_name(treeview);

    snprintf(title, _POSIX_PATH_MAX-1,"//%s%s", hostname, *path);
    title[_POSIX_PATH_MAX-1]=0;
    
    /* the following line is only for SMB paths, but shouldn't hurt for locals */

    word = strrchr(*path, '/');
    if(!word)
	snprintf(iconname, _POSIX_PATH_MAX-1,"xffm: %s /", *path);
    else
	snprintf(iconname, _POSIX_PATH_MAX-1,"xffm: %s /", word + 1);
    iconname[_POSIX_PATH_MAX-1]=0;
   
    gtk_window_set_title(
		    GTK_WINDOW(gtk_widget_get_toplevel(tree_details->window)), 
		    my_utf_string(title));
    gdk_window_set_icon_name(
		    gtk_widget_get_toplevel(tree_details->window)->window, 
		    my_utf_string(iconname));

    atomo = XInternAtom(GDK_DISPLAY(), "WM_COMMAND", FALSE);
    XChangeProperty(GDK_DISPLAY(), get_xid(treeview), atomo, XA_STRING, 8, PropModeReplace, (unsigned char *)"xffm", strlen("xffm") + 1);

    XChangeProperty(GDK_DISPLAY(), get_xid(treeview), atomo, XA_STRING,	/* GdkAtom type, */
		    8,		/* bit per data element: gint format */
		    PropModeAppend, (unsigned char *)"-H", 3);
    XChangeProperty(GDK_DISPLAY(), get_xid(treeview), atomo, XA_STRING,	/* GdkAtom type, */
		    8,		/* bit per data element: gint format */
		    PropModeAppend, (unsigned char *)hostname, strlen(hostname) + 1);

    XChangeProperty(GDK_DISPLAY(), get_xid(treeview), atomo, XA_STRING,	/* GdkAtom type, */
		    8,		/* bit per data element: gint format */
		    PropModeAppend, (unsigned char *)(*path), strlen(*path) + 1);

}
