/*#define DISABLE_MONITOR*/
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * monitors:
 * 1- all elements in open folders
 *   a) stat information
 *   b) files no longer present
 *   c) files which appeared after last refresh
 *
 *   */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>


#include <errno.h>
#include <regex.h>
#include <dirent.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "add_file.h"
#include "add_node_contents.h"
#include "dummies.h"
#include "entry.h"
#include "icons.h"
#include "input.h"
#include "filter.h"
#include "goto.h"
#include "misc.h"
#include "monitor.h"
#include "widgets.h"

/*#define TIMERVAL 1000*/
#define TIMERVAL 5000

#define D(x)



extern int stop;


/*static gboolean monitor_running;*/
static GList *cut_list = NULL;
static GList *update_list = NULL;
static long long pasteboard_checksum = 0;


static GList *zap_list(GList * list)
{
    GList *tmp;
    if(!list)
	return NULL;
    for(tmp = list; tmp; tmp = tmp->next)
    {
	if(tmp->data)
	{
	    GtkTreeRowReference *reference;
	    reference = (GtkTreeRowReference *) tmp->data;
	    gtk_tree_row_reference_free(reference);
	}
    }
    g_list_free(list);
    return NULL;
}


/* OjO: should be same algorithm as in add_folder.c, read_files_d_type() */
static int read_and_add(GtkTreeView * treeview, GtkTreeRowReference * reference, regex_t * preg, GList ** list)
{
    DIR *directory;
    struct dirent *d;
    char *fullpath;
    struct stat st;
    GList *tmp;
    gboolean found;
    tree_entry_t *c_en, *en;
    GtkTreeIter target;
    tree_details_t *tree_details = get_tree_details(treeview);

    if(!gtk_tree_row_reference_valid(reference))
	return TRUE;
    if(!get_entry_from_reference(treeview, reference, &target, &en))
	return TRUE;

    directory = opendir(en->path);
    if(!directory)
	return FALSE;
    while((d = readdir(directory)) != NULL)
    {
	found = FALSE;
	if(!strcmp(d->d_name, ".") || !strcmp(d->d_name, ".."))
	    continue;
	/* double dot files are not considered hidden in xffm */
	if(d->d_name[0] == '.' && d->d_name[1] != '.' && !SHOWS_HIDDEN(en->type))
	    continue;
	if((strcmp(d->d_name, "..Wastebasket") == 0) && tree_details->preferences & HIDE_WASTE_B)
	    continue;

	fullpath = mk_path(en->path, d->d_name);
	/* must check result of stat, because file may have dissappeared! */
	if (stat(fullpath, &st)<0) continue;
	if(!S_ISDIR(st.st_mode) && regexec(preg, d->d_name, 0, NULL, 0))
	    continue;
	tmp = *list;
	while(tmp)
	{
	    char *fullname;
	    fullname = (char *)tmp->data;
	    if(strcmp(fullname, fullpath) == 0)
	    {
		found = TRUE;
		break;
	    }

	    tmp = tmp->next;
	}
	if(!found)
	{
	    c_en = stat_entry(fullpath, en->type);
    	    if (getenv("XFFM_APPEND_FILES")&& strlen(getenv("XFFM_APPEND_FILES")))
		    add_file(treeview, &target, c_en, 
			    (tree_details->preferences & ABBREVIATE_P) ? 
			    abreviate(d->d_name) : d->d_name);
	    else 
		    prepend_file(treeview, &target, c_en, 
			    (tree_details->preferences & ABBREVIATE_P) ? 
			    abreviate(d->d_name) : d->d_name);
	    

	}
    }
    closedir(directory);
    return (FALSE);
}

static void update_cells(GtkTreeView * treeview, GtkTreeIter * target, tree_entry_t ** en)
{
    tree_entry_t *new_en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    if (!(*en) || !((*en)->path)) return;
    new_en = stat_entry((*en)->path, (*en)->type);
    if (!new_en) return;
    
    if(IS_ROOT_TYPE((*en)->type))
	SET_ROOT_TYPE(new_en->type);
    if(IS_FSTAB_TYPE((*en)->type))
	SET_FSTAB_TYPE(new_en->type);
    if(IS_XF_FSTAB((*en)->type))
	SET_XF_FSTAB(new_en->type);
    if(IS_LOCAL_TYPE((*en)->type))
	SET_LOCAL_TYPE(new_en->type);
    if(IS_LOADED((*en)->type))
	SET_LOADED(new_en->type);
    if(IS_INCOMPLETE((*en)->type))
	SET_INCOMPLETE(new_en->type);
    if(IS_EXPANDED((*en)->type))
	SET_EXPANDED(new_en->type);
    if(IS_LOADED((*en)->type))
	SET_LOADED(new_en->type);

    /* changes from dir<-->file */

    if(IS_FILE((*en)->type) && IS_DIR(new_en->type))
    {
	add_dummy(treeview, target);
    }
    if(IS_FILE(new_en->type) && IS_DIR((*en)->type))
    {
	erase_children(treemodel, target);
    }

    memcpy((*en)->st, new_en->st, sizeof(struct stat));
    (*en)->type = new_en->type;
    destroy_entry(new_en);
    update_columns(treemodel, target, (*en));
}

/* this removes it from the treeview only */
static void a_remove_it(GtkTreeView * treeview, GtkTreeRowReference * reference)
{
    tree_entry_t *en, *p_en;
    GtkTreeIter iter, parent;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreePath *treepath = gtk_tree_row_reference_get_path(reference);

    if(!gtk_tree_row_reference_valid(reference))
	goto endfor;
    if(!gtk_tree_model_get_iter(treemodel, &iter, treepath))
	goto endfor;

    /* this takes care of ignoring ROOT_TYPE: */
    if(!gtk_tree_model_iter_parent(treemodel, &parent, &iter))
	goto endfor;


    gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);



    if(gtk_tree_model_iter_n_children(treemodel, &iter) >= 1)
    {
	/*printf("ERASING CHILDREN\n"); */
	erase_children(treemodel, &iter);
    }


    /*check if last item in folder, if so, turn to dummy */
    if(gtk_tree_model_iter_n_children(treemodel, &parent) == 1)
    {
	tree_entry_t *p_en,*c_en;
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
    
	c_en = mk_entry(p_en->type);	
	SET_DUMMY_TYPE(c_en->type);
	gtk_tree_store_set((GtkTreeStore *) treemodel, &iter, 
			NAME_COLUMN, "", 
			PIXBUF_COLUMN, NULL, 
			ENTRY_COLUMN,c_en,
			MODE_COLUMN, "", 
			DATE_COLUMN, "", 
			GROUP_COLUMN, "", 
			OWNER_COLUMN, "", 
			SIZE_COLUMN, "", -1);
	destroy_entry(en);
	gtk_tree_model_row_changed(treemodel, treepath, &iter);
    }

    else
    {
	destroy_entry(en);
	/*      printf("ERASING NODE\n"); */
	gtk_tree_store_remove((GtkTreeStore *) treemodel, &iter);
	/*printf("DBG:rowremoved \n"); */

    }
    p_en->count--;

  endfor:
    if(treepath)
	gtk_tree_path_free(treepath);
    return;
}

void remove_it(GtkTreeView * treeview, GtkTreeRowReference * reference)
{
    a_remove_it(treeview, reference);
}

/* must be called with wait enabled */
gboolean update_dir(GtkTreeView * treeview, GtkTreeRowReference * reference)
{
    tree_entry_t *en, *c_en;
    GList *list = NULL, *tmp;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter, child;
    tree_details_t *tree_details = get_tree_details(treeview);
    struct stat st;
    regex_t *preg;
    int i;

    if(!tree_details->loading)
    {
	/*printf("DBG: tree_details->loading not set! (update_dir())\n");*/
	return FALSE;
    }
    if(!gtk_tree_row_reference_valid(reference))
	return FALSE;
    if(!get_entry_from_reference(treeview, reference, &iter, &en))
	return FALSE;

    if (IS_NETWORK_TYPE(en->type)) return FALSE;
    if (IS_NETTHING(en->subtype)) return FALSE;
    if (IS_FSTAB_TYPE(en->type)&&IS_ROOT_TYPE(en->type)) 
	    return FALSE;
    if (IS_BOOKMARK_TYPE(en->type)&&IS_ROOT_TYPE(en->type)) 
	    return FALSE;
    if (IS_FIND_TYPE(en->type)&&IS_ROOT_TYPE(en->type)) 
	    return FALSE;

    /* modify changed stat information */
    
    if (!IS_XF_FND(en->type)) {
    
     if(lstat(en->path, &st) < 0)
     {
	/* printf("DBG:removing %s\n",en->path); */
	if (gtk_tree_row_reference_valid) remove_it(treeview, reference);
	return TRUE;
     }

     if (!en->st) return TRUE;
    
     if (S_ISLNK(st.st_mode)) {
	    if (stat(en->path, &st)<0) {
			      SET_BROKEN_LNK(c_en->type);
			      return TRUE;
		      }
     }
     if (!en->st) return TRUE;
     if(en->st->st_mtime != st.st_mtime || en->st->st_ctime != st.st_ctime)
     {
	/*printf("DBG:updating cell st!=st %s\n",en->path); */
	update_cells(treeview, &iter, &en);
	set_icon(treeview, &iter);
     }

     if(!IS_DIR(en->type) || (IS_DIR(en->type) && (!IS_LOADED(en->type) || IS_INCOMPLETE(en->type))))
     {
	return TRUE;
     }
    }
 
    /* remove stuff that is gone */

    if(gtk_tree_model_iter_children(treemodel, &child, &iter))
    {
	if(!tree_details->window)
	    return FALSE;
	do
	{
	    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	    if(IS_DUMMY_TYPE(c_en->type))
		continue;
	    if(lstat(c_en->path, &st) < 0)
	    {
		GtkTreePath *tpath;
		GtkTreeRowReference *ref;
		if(!tree_details->window)
		    return FALSE;
		tpath = gtk_tree_model_get_path(treemodel, &child);
		ref = gtk_tree_row_reference_new(treemodel, tpath);
		list = g_list_append(list, ref);
		gtk_tree_path_free(tpath);
	    }
	    else {
              if (S_ISLNK(st.st_mode)) {
		      if (stat(c_en->path, &st)<0) {
			      SET_BROKEN_LNK(c_en->type);
			      continue;
		      }
	      }
	      if(c_en->st->st_mtime != st.st_mtime || c_en->st->st_ctime != st.st_ctime)
	      {
	        /*printf("DBG:updating child cell st!=st %s\n",c_en->path); */
		update_cells(treeview, &child, &c_en);
		set_icon(treeview, &child);
	      }
	    }
	}
	while(gtk_tree_model_iter_next(treemodel, &child));
	/* remove erase list */
	for(tmp = list; tmp; tmp = tmp->next)
	{
	    GtkTreeRowReference *ref = (GtkTreeRowReference *) tmp->data;
	    if (gtk_tree_row_reference_valid(ref)) remove_it(treeview, ref);
	    if(ref) gtk_tree_row_reference_free(ref);
	}
	g_list_free(list);
	list = NULL;
    }

    /* add new stuff */
    
    if (!IS_XF_FND(en->type)) {
     if(gtk_tree_model_iter_children(treemodel, &child, &iter))
     {
	do
	{
	    if(!tree_details->window)
		return FALSE;
	    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	    if(c_en && !IS_DUMMY_TYPE(c_en->type))
	    {
		list = g_list_append(list, c_en->path);
	    }
	}
	while(gtk_tree_model_iter_next(treemodel, &child));
     }
     preg = get_regex_filter(treeview, en);
     read_and_add(treeview, reference, preg, &list);
     regfree(preg);
     g_list_free(list);
     list = NULL;

     /* reload iter in case it became invalid */
     if(!get_entry_from_reference(treeview, reference, &iter, &en))
	return FALSE;

     /* update the filecount (this includes hidden files) */
     i=count_files(en->path);
     if (i != en->count) {
      char *tag; 
      en->count=i;
      tag = sizetag(-1, en->count);
      gtk_tree_store_set((GtkTreeStore *) treemodel, &iter, 
	SIZE_COLUMN, tag, 
	-1);
     }
    }
    
    
    /* check if is dummy still necessary */
    if(gtk_tree_model_iter_n_children(treemodel,&iter) > 1){
        if (!gtk_tree_model_iter_children (treemodel,&child,&iter))
		g_assert_not_reached();

	do
	{
	    if(!tree_details->window) return FALSE;
	    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	    if (!c_en) return FALSE;
	    if(IS_DUMMY_TYPE(c_en->type))
	    {
	       if (c_en->path && strcmp(c_en->path,"..")==0) break;
	       /*printf("DBG: removing %s\n",(c_en->path?c_en->path:"null");*/
	       gtk_tree_store_remove((GtkTreeStore *) treemodel, &child);
	       break;
	    }
	}
	while(gtk_tree_model_iter_next(treemodel, &child));
    }
   
    return TRUE;

}


static void doall_update_list(GtkTreeView * treeview)
{
    GList *tmp;
    for(tmp = update_list; tmp; tmp = tmp->next)
    {
	GtkTreeRowReference *reference = (GtkTreeRowReference *) tmp->data;
	update_dir(treeview, reference);
    }
}


/* get a g_list AFAP */

static gboolean find_cut_icons(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_entry_t *en;
    struct stat st;

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(en && en->path && IS_CUT(en->type) && !IS_NETWORK_TYPE(en->type) 
		    && lstat(en->path, &st) < 0)
    {
	GtkTreeRowReference *reference;
	reference = gtk_tree_row_reference_new(treemodel, treepath);
	if(gtk_tree_row_reference_valid(reference))
	{
	    cut_list = g_list_prepend(cut_list, reference);
	}

    }
    update_icon(treeview, iter);
    return FALSE;
}

/* get a g_list AFAP */


static gboolean find_update_list(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    /*GtkTreeView *treeview=(GtkTreeView *)data; */
    tree_entry_t *en;
    GtkTreeRowReference *reference;

    if(!gtk_tree_model_iter_has_child(treemodel, iter))
	return FALSE;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en )return FALSE;
    if(!IS_DIR(en->type) || !IS_LOADED(en->type) || IS_INCOMPLETE(en->type))
	return FALSE;
    /* if NFS, return false. How to tell?*/
    if (IS_NETWORK_TYPE(en->type)) return FALSE;
    if (IS_ROOT_TYPE(en->type) && !IS_LOCAL_TYPE(en->type)) return FALSE;
    if(en->load_time >= 2)return FALSE;
  
    if(!en->path || strcmp(en->path, "/dev") == 0)
	return FALSE;

    reference = gtk_tree_row_reference_new(treemodel, treepath);
    update_list = g_list_append(update_list, reference);

    return FALSE;
}

gint timeout_monitor(GtkTreeView * treeview){
   local_monitor(treeview,FALSE);
   return TRUE;
}


gint local_monitor(GtkTreeView * treeview,gboolean force)
{
    /*gboolean erased; */
    /*static int count=0; */
    tree_entry_t *en;
    GtkTreeIter iter;
    GList *tmp;
    char *b;
    int len = -1;
    long long new_pasteboard_checksum = 0;

    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);


    if (processing_pending()) return FALSE;
    if(!tree_details || !tree_details->window)
	return FALSE;
    if (tree_details->input != OTHER_INPUT) return FALSE;
    if(!tree_details->timer)
    {

	tree_details->timer = g_timeout_add_full(0, TIMERVAL, 
			(GtkFunction) timeout_monitor, treeview, NULL);
	return TRUE;
    }
    set_processing_pending();

    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    if(b && strlen(b))
    {
	char *c;
	for(c = b; *c; c++)
	    new_pasteboard_checksum += (long long)(*c);
    }
    if(b)
	XFree(b);


    if(new_pasteboard_checksum != pasteboard_checksum)
    {
	/*D("pasteboard differs\n"); */
	pasteboard_checksum = new_pasteboard_checksum;
	gtk_tree_model_foreach(treemodel, find_cut_icons, treeview);

	for(tmp = cut_list; tmp; tmp = tmp->next)
	{
	    if(tmp->data)
	    {
		GtkTreeRowReference *reference;
		reference = (GtkTreeRowReference *) tmp->data;
		if (gtk_tree_row_reference_valid) remove_it(treeview, reference);
		gtk_tree_row_reference_free(reference);
	    }
	}
	g_list_free(cut_list);
	cut_list = NULL;
    }


#if 0
    {
	GtkTreeRowReference *reference;
	GtkTreePath *tp;
	tp = gtk_tree_model_get_path(treemodel, &iter);
	reference = gtk_tree_row_reference_new(treemodel, tp);

	update_list = g_list_append(update_list, reference);
	gtk_tree_path_free(tp);

    }
#endif

    if(force || (tree_details->preferences & ENABLE_MONITOR))
    {
	D("O");
	get_local_root(treeview, &iter, &en);
	if (!en)  g_assert_not_reached();
	if (!IS_LOCAL_TYPE(en->type)) g_assert_not_reached();
	if(access(en->path, F_OK) != 0)
	{
	    const gchar *home=get_xffm_home();
	    print_diagnostics(treeview,"xf_ERROR_ICON",en->path,
	    " ","is no longer available... Going to home directory now.\n",
	    NULL);
	    /*printf("DBG:doing goto en->path=%s\n",en->path);*/
	    /*if(!go_to(treeview, home, en->type)) g_assert_not_reached();*/
	    go_to(treeview, home);
	    goto end;
	}
	if(!set_load_wait(&tree_details))
	    goto end;
	gtk_widget_freeze_child_notify((GtkWidget *) treeview);


	gtk_tree_model_foreach(treemodel, find_update_list, treeview);
	doall_update_list(treeview);
	update_list = zap_list(update_list);
	gtk_widget_thaw_child_notify((GtkWidget *) treeview);
	unset_load_wait(&tree_details);
	D("o");
    }
end:
    unset_processing_pending();
    return TRUE;

}
