/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "entry.h"
#include "rename.h"
#include "icons.h"
#include "input.h"
#include "misc.h"
#include "monitor.h"
#include "widgets.h"
#include "remove.h"


int rename_it(GtkTreeView * treeview, GtkTreeIter * iter, char *nfile, char *ofile)
{

    struct stat st;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    tree_entry_t *en;

    if(!nfile || !ofile)
	g_assert_not_reached();

    if(!set_load_wait(&tree_details))
	return FALSE;

    if(lstat(nfile, &st) >= 0)
    {
	if (!query_rm(treeview, nfile, ofile)){
    		    unset_load_wait(&tree_details);
		    return FALSE;
	}
    }
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);


    if(rename(ofile, nfile) == -1)
    {
	print_diagnostics(treeview, "xf_ERROR_ICON", strerror(errno), " ", ofile, " --> ", nfile,  "\n", NULL);
	print_status(treeview, "xf_ERROR_ICON", strerror(errno), NULL);
        unset_load_wait(&tree_details);
	return FALSE;
    }

    unset_load_wait(&tree_details);
    return TRUE;

}



/*   callback  */

void on_rename_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    en = get_selected_entry(treeview, &iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(treeview, "xf_ERROR_ICON", strerror(EINVAL), NULL);
	return;
    }
    show_input(treeview, RENAME_INPUT);

}
