/*
 * Copyright (C) 2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "dummies.h"
#include "master_lookup.h"
#include "misc.h"
#include "smb_list.h"
#include "smblookup.h"
#include "smb_misc.h"
#include "tubo.h"

void *smb_object=NULL;
GtkTreeView *smb_treeview=NULL;
unsigned net_root_type;


int smb_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(smb_treeview, "xf_ERROR_ICON", line, NULL);
    return TRUE;
}


int open_smb(GtkTreeView * treeview, 
		GtkTreeIter * iter, 
		GtkTreePath * treepath, 
		gpointer user_data){

  char *checkfiles[]={
	  "nmblookup",
	  "smbclient",
	  NULL
  };
  int i;
  GtkTreeIter root_iter;
  GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
  tree_details_t *tree_details = get_tree_details(treeview);
  tree_entry_t *en;
  
  get_network_root(treeview, &root_iter, &en);
  net_root_type=en->type;

  for (i=0;checkfiles[i];i++){
	gchar *test;
	test=g_find_program_in_path(checkfiles[i]);
	if (!test) {
	  print_diagnostics(treeview,"xf_ERROR_ICON",
			  _("File not found"),
			  checkfiles[i],"\n",
			  NULL);
	  return (0);
	} else g_free(test);
  }
  gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
  if (IS_ROOT_TYPE(en->type)) {
	  NMBmastersLookup(treeview);
  }
  else if (IS_XF_NETWG(en->subtype)){
	  SMBLookup(treeview,en->path,iter,FALSE,NULL);
  }
  else if (IS_XF_NETWS(en->subtype)){
	  int r;
	  char *smb_user=en->tag;
	  if (!smb_user){
            if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))
		&& strchr(getenv("SMB_USER"),'%'))
               smb_user=getenv("SMB_USER");
            else smb_user="GUEST%%";
          }
ask_again:
	  r=SMBLookup(treeview,en->path,iter,TRUE,smb_user);
	  if (r==CHALLENGED){
	       char *p;
	       p=passwd_dialog (tree_details->window,1); 
       	       if (strlen(p)) {
		       g_free(en->tag);
		       smb_user=en->tag=g_strdup(p);
		       goto ask_again;
	       } else {
		       reset_dummy(treeview,iter,-3);
	       }

	  }
  } 
  else if (IS_XF_NETSHARE(en->subtype) || IS_NETDIR(en->subtype)){
	  int r;
	  char *smb_user=en->tag;
	  if (!smb_user) {
            if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))
			    && strchr(getenv("SMB_USER"),'%'))
               smb_user=getenv("SMB_USER");
            else smb_user="GUEST%%";
          }
and_ask_again:
	  r=SMBList(treeview,en->path,iter,smb_user,SHOWS_HIDDEN(en->type));
	  if (r==CHALLENGED){
	       char *p;
	       p=passwd_dialog (tree_details->window,1); 
       	       if (strlen(p)) {
		       g_free(en->tag);
		       smb_user=en->tag=g_strdup(p);
		       goto and_ask_again;
	       } else {
		       reset_dummy(treeview,iter,-3);
	       }
	  }
  } 
  SET_LOADED(en->type);
  return(1);
}
