/*  Copyright (C) 2001-2003 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>



#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "add_folder.h"
#include "cpy.h"
#include "uri.h"
#include "entry.h"
#include "monitor.h"
#include "misc.h"
#include "smb_list.h"
#include "smb_misc.h"
#include "smb_open.h"
#include "smblookup.h"
#include "tubo.h"



extern GtkTreeView *smb_treeview;
extern char *smb_errors[];
extern void *smb_object;


static int SMBResult;
static GtkWidget *countW=NULL,*count_label;


static void
SMBFork (void *data)
{
  char *the_command,*the_user,*the_netbios;
  FILE *tmpfile;
  struct stat s;
  gchar *SMBtmpfile=(gchar *)data;

  
  if (stat(SMBtmpfile,&s)<0)  _exit(123); /*forgetit("unable to stat temp file");*/
  if ((the_command = (char *)malloc(s.st_size+1))==NULL) _exit(123); 
  tmpfile=fopen(SMBtmpfile,"rb");
  if (tmpfile) {
   if (fread(the_command,1,s.st_size,tmpfile)<s.st_size) _exit(123);
   fclose(tmpfile);
   unlink(SMBtmpfile);
   the_command[s.st_size]=0;
   the_netbios=strtok(the_command,"\n");
   if (!the_netbios) _exit(123); /* error processing */
   the_user=strtok(NULL,"\n");
   if (!the_user) _exit(123); /* error processing */
   the_command=the_user+strlen(the_user)+1;
#ifdef DEBUG  
   fprintf(stderr,"smbclient %s -U %s\n",the_netbios,the_user);
   fprintf(stderr,"%s\n",the_command); fflush(NULL);sleep(1);
#endif
     /*read data from tmpfile */  
   execlp ("smbclient", "smbclient", the_netbios,"-U",the_user, "-c", the_command, (char *) 0);
  _exit(123); /* error processing */
  }
}


static int
SMBStdout (int n, void *data)
{
  char *line;
  int i;
  if (n) return TRUE;		/* this would mean binary data */
  line = (char *) data;
  print_diagnostics (smb_treeview,NULL,line,NULL);
  
  for (i=0;smb_errors[i]!=NULL;i++){
      if (strstr (line, smb_errors[i]))  {
	  print_diagnostics(smb_treeview,"xf_ERROR_ICON",
			strerror(EPERM),NULL);
      }	
  }
  return TRUE;
}


static void
SMBForkOver (pid_t pid)
{
   
  if (countW) {
     gtk_widget_destroy(countW);
     countW=NULL;
  }
  
  switch (SMBResult)
  {
  case CHALLENGED:
    /*printf("dbg:%s\n",_("File download failed."));*/
    print_status(smb_treeview,"xf_ERROR_ICON",_("File download failed."),NULL);
    break;
  default:
    /* upload was successful: */
    /*printf("dbg:%s\n",_("Download done."));*/
    /*xf_dlg_error(SMBparent,"smbclient",_("Download done."));*/
    break;

  }
  smb_object = NULL;
  cursor_reset (smb_treeview);
  local_monitor(smb_treeview,TRUE);//FIXME
}


static void cb_count_destroy(GtkWidget *widget,gpointer data){
	countW=NULL;
}
static void download_window(GtkWidget *parent,char *host){
 	
  countW=gtk_dialog_new ();
  
  gtk_window_set_position (GTK_WINDOW (countW), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (countW), TRUE);
  count_label = gtk_label_new ( _("Downloading files from "));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->vbox), count_label, TRUE, TRUE, 3);
  count_label = gtk_label_new (host);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->vbox), count_label, TRUE, TRUE, 3);
  count_label = gtk_label_new (".............................................................");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->action_area), count_label, TRUE, TRUE, 3);
  gtk_widget_realize (countW);
  if (parent) gtk_window_set_transient_for (GTK_WINDOW (countW), GTK_WINDOW (parent)); 
  g_signal_connect (G_OBJECT (countW), "destroy", GTK_SIGNAL_FUNC (cb_count_destroy), NULL);
  gtk_widget_show_all(countW);
  gdk_flush();
  return ;
}


void
SMBGetFile (GtkTreeView *treeview, char *target,GList *list)
{
  char *dndS,*host=NULL,*user,*orig_share=NULL,*share,*file,*filename=NULL;
  uri *u;
  gchar *s;
  static char *fname;
  FILE *tmpfile=NULL;
  char *w;
  int i;
  gchar *SMBtmpfile;
  gboolean first=TRUE,isdir;
  tree_details_t *tree_details = get_tree_details(treeview);
  gboolean samba_server=FALSE;
    

  smb_treeview=treeview;
  s=g_find_program_in_path("smbclient");
  if (!s){
	  print_status(treeview,"xf_ERROR_ICON",strerror(ENOENT),":","smbclient",NULL);
	  return;
  }

  if ((fname=randomTmpName(NULL))==NULL) return;
    if ((tmpfile=fopen(fname,"w"))==NULL) {
	print_status(treeview,"xf_ERROR_ICON",strerror(EPERM),":",(fname)?fname:"/tmp/?",NULL);
	return;
  }
  
 for (;list!=NULL;list=list->next){
  u = list->data;
  if (strchr(u->url,'\n')) u->url=strtok(u->url,"\n");
  if (strchr(u->url,'\r')) u->url=strtok(u->url,"\r");
  dndS=u->url;
  /*fprintf(stderr,"dbg: processing %s\n",dndS);*/
/*
 * 1- parse file into NMBcommand
 * 2- open modal dialog with animation
 * 3- download via tubo. 
 * 4- on forkover, close modal animation dialog
 * 5- process errors
 * */
	
/* * 1- parse file into NMBcommand */
/* format smb://user@host:share/file */

  /*printf("dbg:dnd=%s\n",dndS);*/

  if (strncmp("smb://",dndS,strlen("smb://")!=0)&&
      strncmp("SMB://",dndS,strlen("SMB://")!=0)		  ) {
	incorrect_DND:
	print_status(treeview,"xf_ERROR_ICON",_("Incorrect DnD specification"),
			NULL);
	return;
  }
  if (strncmp("SMB://",dndS,strlen("SMB://"))==0) samba_server=TRUE;
  user=dndS+strlen("smb://");
  user=strtok(user,"@");  if (!user) goto incorrect_DND;
  host=strtok(NULL,":");  if (!host) goto incorrect_DND;
  share=strtok(NULL,"/"); if (!share) goto incorrect_DND;
  file=share+strlen(share)+1;
 
  w=strrchr(file,'/');
  if (w) {
	  if (w[1]==0) {
	    isdir=TRUE;
	    w[0]=0;
            w=strrchr(file,'/');
	    if (!w) w=file;
	    else w++; 
	  } else {
	    isdir=FALSE;
	    w++;
	  }
	  if (!strlen(w)) continue;
	  else filename=g_strdup(w);	  
  }
  else {
	  isdir=FALSE;
	  filename=g_strdup(file);
  }

  for (i=0;i<strlen(file);i++) if (file[i]=='/') file[i]='\\'; 
/* 2.5- get drop target */  
  
/* 3- download via tubo */ 
  if (first){
    first=FALSE;
    orig_share=g_strdup(share);
    fprintf(tmpfile,"//%s/%s\n",host,share);
    fprintf(tmpfile,"%s\n",user);
  }
  /* only process files from first drop */
  if (orig_share && strcmp(share,orig_share)!=0) {
	  print_diagnostics(treeview,"xf_ERROR_ICON",
			  _("Only drops from a single share are allowed"),
			  NULL);
	  g_free(orig_share);
	  return;
  }
  {
    gchar *local_file=g_strdup(filename);
    if (!samba_server) ascii_readable(local_file);
   print_diagnostics(treeview,"xf_INFO_ICON","get ",
		      file,local_file,";\n",NULL);
   if (isdir){
      fprintf(tmpfile,
	"lcd \"%s\";cd \"/%s\";cd ..;prompt;recurse; mget \"%s\";recurse;prompt;cd /;",
	target,file,local_file);
    } else {
      fprintf(tmpfile,"lcd \"%s\";get \"%s\" \"%s\";",
			    target,file,local_file); 
			    /*target,file,filename); */
    }
    g_free(local_file);
  }
 } /* end for list elements */
 
  fclose(tmpfile);
  SMBtmpfile=g_strdup(fname); 
  if (filename) g_free(filename);
  filename=NULL;
  /* wait until OK to proceed */
  cursor_wait (treeview);
  smb_wait(FALSE);
  download_window(tree_details->window,host);
  SMBResult=0;
  smb_object = Tubo (SMBFork,
		  (void *)SMBtmpfile,
		  SMBForkOver, 
		  TRUE, 
		  SMBStdout, 
		  smb_stderr);
  if (orig_share) g_free(orig_share);

  return;
}

/*****************************  upload section  *******************************/

static void
SMBDropForkOver (pid_t pid)
{
  while (gtk_events_pending()) gtk_main_iteration();
  gdk_flush();
  cursor_reset (smb_treeview);
  switch (SMBResult)
  {
  case CHALLENGED:
    print_status (smb_treeview,"xf_ERROR_ICON",
		    strerror(EPERM),
		    NULL);
    break;
  default:
    /* upload was successful: */
    print_status (smb_treeview,"xf_INFO_ICON",_("Command done"),NULL);
    break;

  }
  smb_object = NULL;
}

static void forgetit(char *why,char *who){
          fprintf (stderr, "xfsamba: %s %s\n",(why)?why:" ",(who)?who:" ");
	  fflush(NULL);
	  usleep(50000);
          _exit(123);
}

/* function executed after all pipes
*  timeouts and inputs have been set up */
static void
SMBDropFork (void *data)
{
  FILE *file;
  char **argv=(char **)data;
 
  char line[256];
  struct stat s;
  gchar *tmpfile;
  
  tmpfile=g_strdup(argv[5]);
  /*argv[5]=tmpfile;*/

  if (stat(tmpfile,&s)<0)   
	  forgetit("unable to stat temp file",tmpfile);
  if ((argv[5] = (char *)malloc(s.st_size+1))==NULL) 
	  forgetit("unable allocate memory for",tmpfile);
  if ((file=fopen(tmpfile,"r"))==NULL) 
	  forgetit("unable to open",tmpfile);
  strcpy(argv[5],"");
  while (!feof(file) && fgets(line,255,file)){
	  char *w;
	  line[255]=0;
	  if (!strstr(line,"\n")) continue;
	  w=strtok(line,"\n");
          /*fprintf (stderr, "DBG:child->%s\n", w);fflush(NULL);*/
	  strcat(argv[5],w);	  
  }
 
#ifdef DEBUG  
   fprintf(stderr,"%s %s %s %s %s %s\n",argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]); fflush(NULL);sleep(1);
#endif
  execvp (argv[0],argv);
}


void
SMBDropFile (GtkTreeView *treeview,tree_entry_t *t_en, 
		GtkTreeIter *iter,char *tmpfile)
{
  char *argv[12];
  gchar *g;
  
  if (!IS_XF_NETSHARE(t_en->subtype) && !IS_NETFILE(t_en->subtype) && !IS_NETDIR(t_en->subtype))
	  return;
  init_smb_list(treeview,t_en->path,SHOWS_HIDDEN(t_en->type));
  
  argv[0]="smbclient";
  
  /*argv[1]=netbios...; */
  if (IS_XF_NETSHARE(t_en->subtype)){
    g=g_strdup(t_en->path); 	  
  } else {
    gchar *p;
    g=g_strdup(t_en->path);
    p=strchr(g+2,'/')+1;
    *strchr(p,'/')=0;
  } 
  argv[1]=g;
  argv[2]="-U";
  argv[3]=t_en->tag; /* user%pass */
  argv[4]="-c";
  argv[5]=tmpfile;
  argv[6]=0;
  
  /*stopcleanup = FALSE;*/
  print_diagnostics (treeview,"xf_INFO_ICON",_("Copying"),"...","\n",NULL);
  print_status (treeview,"xf_INFO_ICON",_("Copying"),"...",NULL);
  
  
  /* wait until OK to proceed */
  cursor_wait (treeview);
  smb_wait(FALSE);
  
  smb_object = Tubo (SMBDropFork, 
		  (void *)argv,
		  SMBDropForkOver, 
		  TRUE, 
		  SMBListStdout,
		  smb_stderr);

  smb_wait(TRUE);
  g_free(g);

  remove_folder(treeview,iter);
  add_smb_stuff(treeview,iter,t_en->tag);
  SET_LOADED(t_en->type);
  UNSET_EXPANDED(t_en->type);
  unlink(tmpfile);
  cursor_reset (treeview);
  return;
}

/************  rm stuff **********************/
static GList *local_remove_list;


static int
SMBrmStdout (int n, void *data)
{
  char *line;
  int i;
  if (n)
    return TRUE;		/* this would mean binary data */
  line = (char *) data;
  print_diagnostics (smb_treeview,NULL,line,NULL);
  for (i=0;smb_errors[i]!=NULL;i++){
      if (strstr (line, smb_errors[i]))  {
	    gchar *f,*g;
	    GList *tmp;
	    if (!strchr(line,'\\')) g_assert_not_reached();
	    f=g_strdup(strchr(line,'\\')+1);
	    for (g=f;*g;g++) if (*g=='\\') *g='/';
	    for (tmp=local_remove_list;tmp;tmp = tmp->next)
	    {
	      tree_entry_t *en;
	      GtkTreeIter iter;
	      GtkTreeRowReference *reference = (GtkTreeRowReference *) tmp->data;
	      get_entry_from_reference(smb_treeview,reference, &iter, &en);
	      if (strstr(en->path,g)){
	      	 local_remove_list = g_list_remove(local_remove_list, tmp->data);
	    	 gtk_tree_row_reference_free(reference);
	   	 print_diagnostics(smb_treeview,"xf_ERROR_ICON",
			strerror(EPERM),": rm ",en->path,NULL);
		 break;
	      }
	    }
      }	
  }

  return TRUE;
}


GList *
SMBrmFile (GtkTreeView *treeview,char *remote_location,
	       char *remote_pass,char *tmpfile,GList *reference_list)
{
  char *argv[12];
  /* remote_location == remote_server / remote_share */

  smb_treeview=treeview;  
  local_remove_list=reference_list;
  argv[0]="smbclient";
  
  argv[1]=remote_location;
  argv[2]="-U";
  argv[3]=remote_pass; /* user%pass */
  argv[4]="-c";
  argv[5]=tmpfile;
  argv[6]=0;
  
  /*stopcleanup = FALSE;*/
  print_diagnostics (treeview,"xf_WARNING_ICON",_("Removing"),"...","\n",NULL);
  print_status (treeview,"xf_WARNING_ICON",_("Removing"),"...",NULL);
  
  
  /* wait until OK to proceed */
  cursor_wait (treeview);
  smb_wait(FALSE);
  
  smb_object = Tubo (SMBDropFork, 
		  (void *)argv,
		  SMBDropForkOver, 
		  TRUE, 
		  SMBrmStdout,
		  smb_stderr);

  smb_wait(TRUE);
  cursor_reset (treeview);

  return local_remove_list;
}


void
SMBmkdir (GtkTreeView *treeview,tree_entry_t *t_en,
	       GtkTreeIter *iter,char *name)
{
  char *argv[12];
  gchar *g=NULL,*target=NULL;
  gchar *command=NULL;

  if (!IS_XF_NETSHARE(t_en->subtype) && 
	!IS_NETDIR(t_en->subtype))  return;
  init_smb_list(treeview,t_en->path,SHOWS_HIDDEN(t_en->type));
  
  argv[0]="smbclient";
  
  /*argv[1]=netbios...; */
  if (IS_XF_NETSHARE(t_en->subtype)){
    target=g_strdup("/"); 	    
    g=g_strdup(t_en->path); 	  
  } else {
    char *p;
    g=g_strdup(t_en->path);
    p=strchr(g+2,'/')+1;
    *strchr(p,'/')=0;
     p=strstr(t_en->path+2,"/")+1;
     target=g_strdup(strstr(p,"/"));
   
  } 

  if (!IS_SAMBA_SERVER(t_en->subtype)) ascii_unreadable(name);
  command=g_strconcat("cd /;cd \"",target,"\";mkdir \"",name,"\";ls;\n",NULL);
  g_free(target);
  
  argv[1]=g;
  argv[2]="-U";
  argv[3]=t_en->tag; /* user%pass */
  argv[4]="-c";
  argv[5]=command;
  argv[6]=0;
  
   
  /*stopcleanup = FALSE;*/
  print_diagnostics (treeview,"xf_WARNING_ICON",
		  "mkdir",t_en->path,"/",name,"\n",NULL);
  print_status (treeview,"xf_WARNING_ICON","mkdir...",NULL);

#ifdef DEBUG  
   print_diagnostics (treeview,"xf_ERROR_ICON",
		  argv[0]," ",argv[1]," ",argv[2]," ",argv[3]," ",
		  argv[4]," ",argv[5],"\n",NULL); 
  
#else
  
  /* wait until OK to proceed */
  cursor_wait (treeview);
  smb_wait(FALSE);
  
  smb_object = Tubo (fork_function, 
		  (void *)argv,
		  SMBDropForkOver, 
		  TRUE, 
		  SMBListStdout,
		  smb_stderr);

  smb_wait(TRUE);
  g_free(g);
  g_free(command);
  remove_folder(treeview,iter);
  add_smb_stuff(treeview,iter,t_en->tag);
  SET_LOADED(t_en->type);
  UNSET_EXPANDED(t_en->type);
  cursor_reset (treeview);
#endif
  return;
}





