/* stopwatch.c generated by valac 0.42.4, the Vala compiler
 * generated from stopwatch.vala, do not modify */

/* stopwatch.vala
 *
 * Copyright (c) 2009 Diego Ongaro <ongardie@gmail.com>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <libxfce4panel/libxfce4panel.h>
#include <libxfce4util/libxfce4util.h>
#include <stdio.h>


#define TYPE_MY_TIME_VAL (my_time_val_get_type ())
typedef struct _MyTimeVal MyTimeVal;

#define TYPE_TIMER (timer_get_type ())
#define TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMER, Timer))
#define TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMER, TimerClass))
#define IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMER))
#define IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMER))
#define TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMER, TimerClass))

typedef struct _Timer Timer;
typedef struct _TimerClass TimerClass;
typedef struct _TimerPrivate TimerPrivate;
enum  {
	TIMER_0_PROPERTY,
	TIMER_ELAPSED_PROPERTY,
	TIMER_NUM_PROPERTIES
};
static GParamSpec* timer_properties[TIMER_NUM_PROPERTIES];
#define _my_time_val_free0(var) ((var == NULL) ? NULL : (var = (my_time_val_free (var), NULL)))
enum  {
	TIMER_CHANGED_SIGNAL,
	TIMER_NUM_SIGNALS
};
static guint timer_signals[TIMER_NUM_SIGNALS] = {0};

#define TYPE_TIMER_BUTTON (timer_button_get_type ())
#define TIMER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMER_BUTTON, TimerButton))
#define TIMER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMER_BUTTON, TimerButtonClass))
#define IS_TIMER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMER_BUTTON))
#define IS_TIMER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMER_BUTTON))
#define TIMER_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMER_BUTTON, TimerButtonClass))

typedef struct _TimerButton TimerButton;
typedef struct _TimerButtonClass TimerButtonClass;
typedef struct _TimerButtonPrivate TimerButtonPrivate;
enum  {
	TIMER_BUTTON_0_PROPERTY,
	TIMER_BUTTON_NUM_PROPERTIES
};
static GParamSpec* timer_button_properties[TIMER_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_STOPWATCH_PLUGIN (stopwatch_plugin_get_type ())
#define STOPWATCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STOPWATCH_PLUGIN, StopwatchPlugin))
#define STOPWATCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STOPWATCH_PLUGIN, StopwatchPluginClass))
#define IS_STOPWATCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STOPWATCH_PLUGIN))
#define IS_STOPWATCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STOPWATCH_PLUGIN))
#define STOPWATCH_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STOPWATCH_PLUGIN, StopwatchPluginClass))

typedef struct _StopwatchPlugin StopwatchPlugin;
typedef struct _StopwatchPluginClass StopwatchPluginClass;
typedef struct _StopwatchPluginPrivate StopwatchPluginPrivate;
enum  {
	STOPWATCH_PLUGIN_0_PROPERTY,
	STOPWATCH_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* stopwatch_plugin_properties[STOPWATCH_PLUGIN_NUM_PROPERTIES];
#define __vala_XfceRc_free0(var) ((var == NULL) ? NULL : (var = (_vala_XfceRc_free (var), NULL)))

struct _MyTimeVal {
	glong tv_sec;
	glong tv_usec;
};

struct _Timer {
	GObject parent_instance;
	TimerPrivate * priv;
};

struct _TimerClass {
	GObjectClass parent_class;
};

struct _TimerPrivate {
	MyTimeVal committed;
	guint tickId;
	MyTimeVal* started;
};

struct _TimerButton {
	GtkToggleButton parent_instance;
	TimerButtonPrivate * priv;
};

struct _TimerButtonClass {
	GtkToggleButtonClass parent_class;
};

struct _TimerButtonPrivate {
	Timer* timer;
};

struct _StopwatchPlugin {
	XfcePanelPlugin parent_instance;
	StopwatchPluginPrivate * priv;
};

struct _StopwatchPluginClass {
	XfcePanelPluginClass parent_class;
};

struct _StopwatchPluginPrivate {
	Timer* timer;
	TimerButton* timerButton;
	GtkBox* box;
};


static gint Timer_private_offset;
static gpointer timer_parent_class = NULL;
static GType timer_type_id = 0;
static gint TimerButton_private_offset;
static gpointer timer_button_parent_class = NULL;
static GType timer_button_type_id = 0;
static gint StopwatchPlugin_private_offset;
static gpointer stopwatch_plugin_parent_class = NULL;
static GType stopwatch_plugin_type_id = 0;

GType my_time_val_get_type (void) G_GNUC_CONST;
MyTimeVal* my_time_val_dup (const MyTimeVal* self);
void my_time_val_free (MyTimeVal* self);
void my_time_val_init_now (MyTimeVal *self);
void my_time_val_init_zero (MyTimeVal *self);
void my_time_val_init_add (MyTimeVal *self,
                           MyTimeVal* a,
                           MyTimeVal* b);
void my_time_val_init_sub (MyTimeVal *self,
                           MyTimeVal* a,
                           MyTimeVal* b);
GType timer_register_type (GTypeModule * module);
GType timer_get_type (void) G_GNUC_CONST;
Timer* timer_new (void);
Timer* timer_construct (GType object_type);
void timer_reset (Timer* self);
static gboolean timer_tick (Timer* self);
void timer_start (Timer* self);
static gboolean _timer_tick_gsource_func (gpointer self);
void timer_stop (Timer* self);
void timer_set_elapsed (Timer* self,
                        MyTimeVal * value);
void timer_get_elapsed (Timer* self,
                        MyTimeVal * result);
static void timer_finalize (GObject * obj);
static void _vala_timer_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_timer_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
GType timer_button_register_type (GTypeModule * module);
GType timer_button_get_type (void) G_GNUC_CONST;
static void timer_button_updateDisplay (TimerButton* self,
                                 MyTimeVal* elapsed);
TimerButton* timer_button_new (Timer* timer);
TimerButton* timer_button_construct (GType object_type,
                                     Timer* timer);
static void __lambda4_ (TimerButton* self,
                 GtkToggleButton* s);
void timer_button_start (TimerButton* self);
void timer_button_stop (TimerButton* self);
static void ___lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static void __lambda5_ (TimerButton* self,
                 Timer* s);
static void ___lambda5__timer_changed (Timer* _sender,
                                gpointer self);
void timer_button_reset (TimerButton* self);
static void timer_button_finalize (GObject * obj);
GType stopwatch_plugin_register_type (GTypeModule * module);
GType stopwatch_plugin_get_type (void) G_GNUC_CONST;
static void stopwatch_plugin_load_rc (StopwatchPlugin* self);
static void _vala_XfceRc_free (XfceRc* self);
static void stopwatch_plugin_real_construct (XfcePanelPlugin* base);
static void __lambda6_ (StopwatchPlugin* self,
                 XfcePanelPlugin* s,
                 GtkOrientation orientation);
static void ___lambda6__xfce_panel_plugin_orientation_changed (XfcePanelPlugin* _sender,
                                                        GtkOrientation orientation,
                                                        gpointer self);
static void __lambda7_ (StopwatchPlugin* self,
                 GtkButton* s);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static gboolean __lambda8_ (StopwatchPlugin* self,
                     XfcePanelPlugin* p,
                     gint size);
static gboolean ___lambda8__xfce_panel_plugin_size_changed (XfcePanelPlugin* _sender,
                                                     gint size,
                                                     gpointer self);
static void __lambda9_ (StopwatchPlugin* self);
static void ___lambda9__xfce_panel_plugin_save (XfcePanelPlugin* _sender,
                                         gpointer self);
StopwatchPlugin* stopwatch_plugin_new (void);
StopwatchPlugin* stopwatch_plugin_construct (GType object_type);
static void stopwatch_plugin_finalize (GObject * obj);
GType xfce_panel_module_init (GTypeModule* module);
GType timer_register_type (GTypeModule * module);
GType timer_button_register_type (GTypeModule * module);
GType stopwatch_plugin_register_type (GTypeModule * module);


void
my_time_val_init_now (MyTimeVal *self)
{
	GTimeVal source = {0};
	GTimeVal _tmp0_;
	glong _tmp1_;
	GTimeVal _tmp2_;
	glong _tmp3_;
	memset (self, 0, sizeof (MyTimeVal));
	g_get_current_time (&source);
	_tmp0_ = source;
	_tmp1_ = _tmp0_.tv_sec;
	(*self).tv_sec = _tmp1_;
	_tmp2_ = source;
	_tmp3_ = _tmp2_.tv_usec;
	(*self).tv_usec = _tmp3_;
}


void
my_time_val_init_zero (MyTimeVal *self)
{
	memset (self, 0, sizeof (MyTimeVal));
	(*self).tv_sec = (glong) 0;
	(*self).tv_usec = (glong) 0;
}


void
my_time_val_init_add (MyTimeVal *self,
                      MyTimeVal* a,
                      MyTimeVal* b)
{
	MyTimeVal _tmp0_;
	glong _tmp1_;
	MyTimeVal _tmp2_;
	glong _tmp3_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	memset (self, 0, sizeof (MyTimeVal));
	_tmp0_ = *b;
	_tmp1_ = _tmp0_.tv_usec;
	_tmp2_ = *a;
	_tmp3_ = _tmp2_.tv_usec;
	if ((_tmp1_ + _tmp3_) > ((glong) 1000000)) {
		MyTimeVal _tmp4_;
		glong _tmp5_;
		MyTimeVal _tmp6_;
		glong _tmp7_;
		MyTimeVal _tmp8_;
		glong _tmp9_;
		MyTimeVal _tmp10_;
		glong _tmp11_;
		_tmp4_ = *a;
		_tmp5_ = _tmp4_.tv_usec;
		_tmp6_ = *b;
		_tmp7_ = _tmp6_.tv_usec;
		(*self).tv_usec = (_tmp5_ + _tmp7_) - 1000000;
		_tmp8_ = *a;
		_tmp9_ = _tmp8_.tv_sec;
		_tmp10_ = *b;
		_tmp11_ = _tmp10_.tv_sec;
		(*self).tv_sec = (_tmp9_ + _tmp11_) + 1;
	} else {
		MyTimeVal _tmp12_;
		glong _tmp13_;
		MyTimeVal _tmp14_;
		glong _tmp15_;
		MyTimeVal _tmp16_;
		glong _tmp17_;
		MyTimeVal _tmp18_;
		glong _tmp19_;
		_tmp12_ = *a;
		_tmp13_ = _tmp12_.tv_usec;
		_tmp14_ = *b;
		_tmp15_ = _tmp14_.tv_usec;
		(*self).tv_usec = _tmp13_ + _tmp15_;
		_tmp16_ = *a;
		_tmp17_ = _tmp16_.tv_sec;
		_tmp18_ = *b;
		_tmp19_ = _tmp18_.tv_sec;
		(*self).tv_sec = _tmp17_ + _tmp19_;
	}
}


void
my_time_val_init_sub (MyTimeVal *self,
                      MyTimeVal* a,
                      MyTimeVal* b)
{
	MyTimeVal _tmp0_;
	glong _tmp1_;
	MyTimeVal _tmp2_;
	glong _tmp3_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	memset (self, 0, sizeof (MyTimeVal));
	_tmp0_ = *b;
	_tmp1_ = _tmp0_.tv_usec;
	_tmp2_ = *a;
	_tmp3_ = _tmp2_.tv_usec;
	if (_tmp1_ > _tmp3_) {
		MyTimeVal _tmp4_;
		glong _tmp5_;
		MyTimeVal _tmp6_;
		glong _tmp7_;
		MyTimeVal _tmp8_;
		glong _tmp9_;
		MyTimeVal _tmp10_;
		glong _tmp11_;
		_tmp4_ = *a;
		_tmp5_ = _tmp4_.tv_usec;
		_tmp6_ = *b;
		_tmp7_ = _tmp6_.tv_usec;
		(*self).tv_usec = (_tmp5_ + 1000000) - _tmp7_;
		_tmp8_ = *a;
		_tmp9_ = _tmp8_.tv_sec;
		_tmp10_ = *b;
		_tmp11_ = _tmp10_.tv_sec;
		(*self).tv_sec = (_tmp9_ - 1) - _tmp11_;
	} else {
		MyTimeVal _tmp12_;
		glong _tmp13_;
		MyTimeVal _tmp14_;
		glong _tmp15_;
		MyTimeVal _tmp16_;
		glong _tmp17_;
		MyTimeVal _tmp18_;
		glong _tmp19_;
		_tmp12_ = *a;
		_tmp13_ = _tmp12_.tv_usec;
		_tmp14_ = *b;
		_tmp15_ = _tmp14_.tv_usec;
		(*self).tv_usec = _tmp13_ - _tmp15_;
		_tmp16_ = *a;
		_tmp17_ = _tmp16_.tv_sec;
		_tmp18_ = *b;
		_tmp19_ = _tmp18_.tv_sec;
		(*self).tv_sec = _tmp17_ - _tmp19_;
	}
}


MyTimeVal*
my_time_val_dup (const MyTimeVal* self)
{
	MyTimeVal* dup;
	dup = g_new0 (MyTimeVal, 1);
	memcpy (dup, self, sizeof (MyTimeVal));
	return dup;
}


void
my_time_val_free (MyTimeVal* self)
{
	g_free (self);
}


GType
my_time_val_get_type (void)
{
	static volatile gsize my_time_val_type_id__volatile = 0;
	if (g_once_init_enter (&my_time_val_type_id__volatile)) {
		GType my_time_val_type_id;
		my_time_val_type_id = g_boxed_type_register_static ("MyTimeVal", (GBoxedCopyFunc) my_time_val_dup, (GBoxedFreeFunc) my_time_val_free);
		g_once_init_leave (&my_time_val_type_id__volatile, my_time_val_type_id);
	}
	return my_time_val_type_id__volatile;
}


static inline gpointer
timer_get_instance_private (Timer* self)
{
	return G_STRUCT_MEMBER_P (self, Timer_private_offset);
}


Timer*
timer_construct (GType object_type)
{
	Timer * self = NULL;
	self = (Timer*) g_object_new (object_type, NULL);
	timer_reset (self);
	return self;
}


Timer*
timer_new (void)
{
	return timer_construct (TYPE_TIMER);
}


static gboolean
timer_tick (Timer* self)
{
	gboolean result = FALSE;
	MyTimeVal* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->started;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	g_signal_emit (self, timer_signals[TIMER_CHANGED_SIGNAL], 0);
	result = TRUE;
	return result;
}


static gpointer
_my_time_val_dup0 (gpointer self)
{
	return self ? my_time_val_dup (self) : NULL;
}


static gboolean
_timer_tick_gsource_func (gpointer self)
{
	gboolean result;
	result = timer_tick ((Timer*) self);
	return result;
}


void
timer_start (Timer* self)
{
	MyTimeVal _tmp0_ = {0};
	MyTimeVal* _tmp1_;
	g_return_if_fail (self != NULL);
	my_time_val_init_now (&_tmp0_);
	_tmp1_ = _my_time_val_dup0 (&_tmp0_);
	_my_time_val_free0 (self->priv->started);
	self->priv->started = _tmp1_;
	self->priv->tickId = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _timer_tick_gsource_func, g_object_ref (self), g_object_unref);
}


void
timer_stop (Timer* self)
{
	guint _tmp0_;
	MyTimeVal* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tickId;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->tickId;
		g_source_remove (_tmp1_);
		self->priv->tickId = (guint) 0;
	}
	_tmp2_ = self->priv->started;
	if (_tmp2_ != NULL) {
		MyTimeVal _tmp3_;
		MyTimeVal _tmp4_ = {0};
		MyTimeVal* _tmp5_;
		MyTimeVal _tmp6_ = {0};
		MyTimeVal _tmp7_;
		_tmp3_ = self->priv->committed;
		my_time_val_init_now (&_tmp4_);
		_tmp5_ = self->priv->started;
		_tmp7_ = (MyTimeVal) (*_tmp5_);
		my_time_val_init_sub (&_tmp6_, &_tmp4_, &_tmp7_);
		my_time_val_init_add (&self->priv->committed, &_tmp3_, &_tmp6_);
		_my_time_val_free0 (self->priv->started);
		self->priv->started = NULL;
	}
	g_signal_emit (self, timer_signals[TIMER_CHANGED_SIGNAL], 0);
}


void
timer_reset (Timer* self)
{
	MyTimeVal _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	my_time_val_init_zero (&_tmp0_);
	timer_set_elapsed (self, &_tmp0_);
}


void
timer_get_elapsed (Timer* self,
                   MyTimeVal * result)
{
	MyTimeVal* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->started;
	if (_tmp0_ == NULL) {
		MyTimeVal _tmp1_;
		_tmp1_ = self->priv->committed;
		*result = _tmp1_;
		return;
	} else {
		MyTimeVal _tmp2_;
		MyTimeVal _tmp3_ = {0};
		MyTimeVal* _tmp4_;
		MyTimeVal _tmp5_ = {0};
		MyTimeVal _tmp6_;
		MyTimeVal _tmp7_ = {0};
		_tmp2_ = self->priv->committed;
		my_time_val_init_now (&_tmp3_);
		_tmp4_ = self->priv->started;
		_tmp6_ = (MyTimeVal) (*_tmp4_);
		my_time_val_init_sub (&_tmp5_, &_tmp3_, &_tmp6_);
		my_time_val_init_add (&_tmp7_, &_tmp2_, &_tmp5_);
		*result = _tmp7_;
		return;
	}
}


void
timer_set_elapsed (Timer* self,
                   MyTimeVal * value)
{
	MyTimeVal _tmp0_;
	g_return_if_fail (self != NULL);
	timer_stop (self);
	_tmp0_ = *value;
	self->priv->committed = _tmp0_;
	g_signal_emit (self, timer_signals[TIMER_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, timer_properties[TIMER_ELAPSED_PROPERTY]);
}


static void
timer_class_init (TimerClass * klass)
{
	timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Timer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_timer_set_property;
	G_OBJECT_CLASS (klass)->finalize = timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TIMER_ELAPSED_PROPERTY, timer_properties[TIMER_ELAPSED_PROPERTY] = g_param_spec_boxed ("elapsed", "elapsed", "elapsed", TYPE_MY_TIME_VAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	timer_signals[TIMER_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_TIMER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
timer_instance_init (Timer * self)
{
	self->priv = timer_get_instance_private (self);
}


static void
timer_finalize (GObject * obj)
{
	Timer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TIMER, Timer);
	_my_time_val_free0 (self->priv->started);
	G_OBJECT_CLASS (timer_parent_class)->finalize (obj);
}


GType
timer_get_type (void)
{
	return timer_type_id;
}


GType
timer_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Timer), 0, (GInstanceInitFunc) timer_instance_init, NULL };
	timer_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "Timer", &g_define_type_info, 0);
	Timer_private_offset = sizeof (TimerPrivate);
	return timer_type_id;
}


static void
_vala_timer_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Timer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TIMER, Timer);
	switch (property_id) {
		case TIMER_ELAPSED_PROPERTY:
		{
			MyTimeVal boxed;
			timer_get_elapsed (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_timer_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Timer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TIMER, Timer);
	switch (property_id) {
		case TIMER_ELAPSED_PROPERTY:
		timer_set_elapsed (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
timer_button_get_instance_private (TimerButton* self)
{
	return G_STRUCT_MEMBER_P (self, TimerButton_private_offset);
}


static void
timer_button_updateDisplay (TimerButton* self,
                            MyTimeVal* elapsed)
{
	gint seconds = 0;
	MyTimeVal _tmp0_;
	glong _tmp1_;
	gint minutes = 0;
	MyTimeVal _tmp2_;
	glong _tmp3_;
	gint hours = 0;
	MyTimeVal _tmp4_;
	glong _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elapsed != NULL);
	_tmp0_ = *elapsed;
	_tmp1_ = _tmp0_.tv_sec;
	seconds = (gint) (_tmp1_ % 60);
	_tmp2_ = *elapsed;
	_tmp3_ = _tmp2_.tv_sec;
	minutes = (gint) ((_tmp3_ / 60) % 60);
	_tmp4_ = *elapsed;
	_tmp5_ = _tmp4_.tv_sec;
	hours = (gint) ((_tmp5_ / 60) / 60);
	_tmp6_ = g_strdup_printf ("%02d:%02d:%02d", hours, minutes, seconds);
	_tmp7_ = _tmp6_;
	gtk_button_set_label ((GtkButton*) self, _tmp7_);
	_g_free0 (_tmp7_);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda4_ (TimerButton* self,
            GtkToggleButton* s)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (s != NULL);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		timer_button_start (self);
	} else {
		timer_button_stop (self);
	}
}


static void
___lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda4_ ((TimerButton*) self, _sender);
}


static void
__lambda5_ (TimerButton* self,
            Timer* s)
{
	Timer* _tmp0_;
	MyTimeVal _tmp1_ = {0};
	MyTimeVal _tmp2_;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->timer;
	timer_get_elapsed (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	timer_button_updateDisplay (self, &_tmp2_);
}


static void
___lambda5__timer_changed (Timer* _sender,
                           gpointer self)
{
	__lambda5_ ((TimerButton*) self, _sender);
}


TimerButton*
timer_button_construct (GType object_type,
                        Timer* timer)
{
	TimerButton * self = NULL;
	Timer* _tmp0_;
	Timer* _tmp1_;
	MyTimeVal _tmp2_ = {0};
	MyTimeVal _tmp3_;
	Timer* _tmp4_;
	g_return_val_if_fail (timer != NULL, NULL);
	self = (TimerButton*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (timer);
	_g_object_unref0 (self->priv->timer);
	self->priv->timer = _tmp0_;
	gtk_widget_set_can_default ((GtkWidget*) self, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_widget_set_focus_on_click ((GtkWidget*) self, FALSE);
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	_tmp1_ = self->priv->timer;
	timer_get_elapsed (_tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	timer_button_updateDisplay (self, &_tmp3_);
	g_signal_connect_object ((GtkToggleButton*) self, "toggled", (GCallback) ___lambda4__gtk_toggle_button_toggled, self, 0);
	_tmp4_ = self->priv->timer;
	g_signal_connect_object (_tmp4_, "changed", (GCallback) ___lambda5__timer_changed, self, 0);
	return self;
}


TimerButton*
timer_button_new (Timer* timer)
{
	return timer_button_construct (TYPE_TIMER_BUTTON, timer);
}


void
timer_button_start (TimerButton* self)
{
	Timer* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, TRUE);
	_tmp0_ = self->priv->timer;
	timer_start (_tmp0_);
}


void
timer_button_stop (TimerButton* self)
{
	Timer* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, FALSE);
	_tmp0_ = self->priv->timer;
	timer_stop (_tmp0_);
}


void
timer_button_reset (TimerButton* self)
{
	Timer* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, FALSE);
	_tmp0_ = self->priv->timer;
	timer_reset (_tmp0_);
}


static void
timer_button_class_init (TimerButtonClass * klass)
{
	timer_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TimerButton_private_offset);
	G_OBJECT_CLASS (klass)->finalize = timer_button_finalize;
}


static void
timer_button_instance_init (TimerButton * self)
{
	self->priv = timer_button_get_instance_private (self);
}


static void
timer_button_finalize (GObject * obj)
{
	TimerButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TIMER_BUTTON, TimerButton);
	_g_object_unref0 (self->priv->timer);
	G_OBJECT_CLASS (timer_button_parent_class)->finalize (obj);
}


GType
timer_button_get_type (void)
{
	return timer_button_type_id;
}


GType
timer_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TimerButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timer_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimerButton), 0, (GInstanceInitFunc) timer_button_instance_init, NULL };
	timer_button_type_id = g_type_module_register_type (module, gtk_toggle_button_get_type (), "TimerButton", &g_define_type_info, 0);
	TimerButton_private_offset = sizeof (TimerButtonPrivate);
	return timer_button_type_id;
}


static inline gpointer
stopwatch_plugin_get_instance_private (StopwatchPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, StopwatchPlugin_private_offset);
}


static void
_vala_XfceRc_free (XfceRc* self)
{
	g_boxed_free (xfce_rc_get_type (), self);
}


static void
stopwatch_plugin_load_rc (StopwatchPlugin* self)
{
	XfceRc* rc = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	XfceRc* _tmp2_;
	XfceRc* _tmp3_;
	MyTimeVal elapsed = {0};
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	Timer* _tmp6_;
	MyTimeVal _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xfce_panel_plugin_lookup_rc_file ((XfcePanelPlugin*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = xfce_rc_simple_open (_tmp1_, TRUE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	rc = _tmp3_;
	my_time_val_init_zero (&elapsed);
	_tmp4_ = xfce_rc_read_entry (rc, "elapsed_sec", "0");
	sscanf (_tmp4_, "%ld", &elapsed.tv_sec);
	_tmp5_ = xfce_rc_read_entry (rc, "elapsed_usec", "0");
	sscanf (_tmp5_, "%ld", &elapsed.tv_usec);
	_tmp6_ = self->priv->timer;
	_tmp7_ = elapsed;
	timer_set_elapsed (_tmp6_, &_tmp7_);
	__vala_XfceRc_free0 (rc);
}


static void
__lambda6_ (StopwatchPlugin* self,
            XfcePanelPlugin* s,
            GtkOrientation orientation)
{
	GtkBox* _tmp0_;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->box;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp0_, orientation);
}


static void
___lambda6__xfce_panel_plugin_orientation_changed (XfcePanelPlugin* _sender,
                                                   GtkOrientation orientation,
                                                   gpointer self)
{
	__lambda6_ ((StopwatchPlugin*) self, _sender, orientation);
}


static void
__lambda7_ (StopwatchPlugin* self,
            GtkButton* s)
{
	TimerButton* _tmp0_;
	g_return_if_fail (s != NULL);
	g_signal_emit_by_name ((XfcePanelPlugin*) self, "save");
	_tmp0_ = self->priv->timerButton;
	timer_button_reset (_tmp0_);
}


static void
___lambda7__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda7_ ((StopwatchPlugin*) self, _sender);
}


static gboolean
__lambda8_ (StopwatchPlugin* self,
            XfcePanelPlugin* p,
            gint size)
{
	gboolean result = FALSE;
	g_return_val_if_fail (p != NULL, FALSE);
	result = TRUE;
	return result;
}


static gboolean
___lambda8__xfce_panel_plugin_size_changed (XfcePanelPlugin* _sender,
                                            gint size,
                                            gpointer self)
{
	gboolean result;
	result = __lambda8_ ((StopwatchPlugin*) self, _sender, size);
	return result;
}


static void
__lambda9_ (StopwatchPlugin* self)
{
	XfceRc* rc = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	XfceRc* _tmp2_;
	XfceRc* _tmp3_;
	MyTimeVal elapsed = {0};
	Timer* _tmp4_;
	MyTimeVal _tmp5_ = {0};
	MyTimeVal _tmp6_;
	MyTimeVal _tmp7_;
	glong _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	MyTimeVal _tmp11_;
	glong _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	_tmp0_ = xfce_panel_plugin_save_location ((XfcePanelPlugin*) self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = xfce_rc_simple_open (_tmp1_, FALSE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	rc = _tmp3_;
	_tmp4_ = self->priv->timer;
	timer_get_elapsed (_tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	elapsed = _tmp6_;
	_tmp7_ = elapsed;
	_tmp8_ = _tmp7_.tv_sec;
	_tmp9_ = g_strdup_printf ("%ld", _tmp8_);
	_tmp10_ = _tmp9_;
	xfce_rc_write_entry (rc, "elapsed_sec", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = elapsed;
	_tmp12_ = _tmp11_.tv_usec;
	_tmp13_ = g_strdup_printf ("%ld", _tmp12_);
	_tmp14_ = _tmp13_;
	xfce_rc_write_entry (rc, "elapsed_usec", _tmp14_);
	_g_free0 (_tmp14_);
	__vala_XfceRc_free0 (rc);
}


static void
___lambda9__xfce_panel_plugin_save (XfcePanelPlugin* _sender,
                                    gpointer self)
{
	__lambda9_ ((StopwatchPlugin*) self);
}


static void
stopwatch_plugin_real_construct (XfcePanelPlugin* base)
{
	StopwatchPlugin * self;
	Timer* _tmp0_;
	GtkOrientation orientation = 0;
	GtkBox* _tmp1_;
	Timer* _tmp2_;
	TimerButton* _tmp3_;
	TimerButton* _tmp4_;
	GtkBox* _tmp5_;
	TimerButton* _tmp6_;
	GtkButton* resetButton = NULL;
	GtkButton* _tmp7_;
	GtkImage* refreshImage = NULL;
	GtkImage* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	self = (StopwatchPlugin*) base;
	_tmp0_ = timer_new ();
	_g_object_unref0 (self->priv->timer);
	self->priv->timer = _tmp0_;
	stopwatch_plugin_load_rc (self);
	orientation = xfce_panel_plugin_get_orientation ((XfcePanelPlugin*) self);
	_tmp1_ = (GtkBox*) gtk_box_new (orientation, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp1_;
	g_signal_connect_object ((XfcePanelPlugin*) self, "orientation-changed", (GCallback) ___lambda6__xfce_panel_plugin_orientation_changed, self, 0);
	_tmp2_ = self->priv->timer;
	_tmp3_ = timer_button_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->timerButton);
	self->priv->timerButton = _tmp3_;
	_tmp4_ = self->priv->timerButton;
	xfce_panel_plugin_add_action_widget ((XfcePanelPlugin*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->box;
	_tmp6_ = self->priv->timerButton;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp7_);
	resetButton = _tmp7_;
	gtk_widget_set_can_default ((GtkWidget*) resetButton, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) resetButton, FALSE);
	gtk_widget_set_focus_on_click ((GtkWidget*) resetButton, FALSE);
	gtk_button_set_relief (resetButton, GTK_RELIEF_NONE);
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("view-refresh", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp8_);
	refreshImage = _tmp8_;
	gtk_button_set_image (resetButton, (GtkWidget*) refreshImage);
	g_signal_connect_object (resetButton, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	xfce_panel_plugin_add_action_widget ((XfcePanelPlugin*) self, (GtkWidget*) resetButton);
	_tmp9_ = self->priv->box;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) resetButton);
	_tmp10_ = self->priv->box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((XfcePanelPlugin*) self, "size-changed", (GCallback) ___lambda8__xfce_panel_plugin_size_changed, self, 0);
	g_signal_connect_object ((XfcePanelPlugin*) self, "save", (GCallback) ___lambda9__xfce_panel_plugin_save, self, 0);
	_g_object_unref0 (refreshImage);
	_g_object_unref0 (resetButton);
}


StopwatchPlugin*
stopwatch_plugin_construct (GType object_type)
{
	StopwatchPlugin * self = NULL;
	self = (StopwatchPlugin*) g_object_new (object_type, NULL);
	return self;
}


StopwatchPlugin*
stopwatch_plugin_new (void)
{
	return stopwatch_plugin_construct (TYPE_STOPWATCH_PLUGIN);
}


static void
stopwatch_plugin_class_init (StopwatchPluginClass * klass)
{
	stopwatch_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StopwatchPlugin_private_offset);
	((XfcePanelPluginClass *) klass)->construct = (void (*) (XfcePanelPlugin*)) stopwatch_plugin_real_construct;
	G_OBJECT_CLASS (klass)->finalize = stopwatch_plugin_finalize;
}


static void
stopwatch_plugin_instance_init (StopwatchPlugin * self)
{
	self->priv = stopwatch_plugin_get_instance_private (self);
}


static void
stopwatch_plugin_finalize (GObject * obj)
{
	StopwatchPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STOPWATCH_PLUGIN, StopwatchPlugin);
	_g_object_unref0 (self->priv->timer);
	_g_object_unref0 (self->priv->timerButton);
	_g_object_unref0 (self->priv->box);
	G_OBJECT_CLASS (stopwatch_plugin_parent_class)->finalize (obj);
}


GType
stopwatch_plugin_get_type (void)
{
	return stopwatch_plugin_type_id;
}


GType
stopwatch_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (StopwatchPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) stopwatch_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StopwatchPlugin), 0, (GInstanceInitFunc) stopwatch_plugin_instance_init, NULL };
	stopwatch_plugin_type_id = g_type_module_register_type (module, xfce_panel_plugin_get_type (), "StopwatchPlugin", &g_define_type_info, 0);
	StopwatchPlugin_private_offset = sizeof (StopwatchPluginPrivate);
	return stopwatch_plugin_type_id;
}


GType
xfce_panel_module_init (GTypeModule* module)
{
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	timer_register_type (module);
	timer_button_register_type (module);
	stopwatch_plugin_register_type (module);
	result = TYPE_STOPWATCH_PLUGIN;
	return result;
}



