/*  $Id: xfcesmart.h 3406 2007-10-20 08:44:48Z afb $
 *
 *  Copyright (c) 2007 Anders F Bjorklund <afb@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFCESMART_H__
#define __XFCESMART_H__

G_BEGIN_DECLS

/* plugin structure */
typedef struct
{
    XfcePanelPlugin *plugin;

    /* panel widgets */
    GtkWidget *button;
    GtkWidget *image;
    GtkWidget *menuitem;
    GtkTooltips *tooltip;

    gint      current_icon_size;
    GdkPixbuf *application_icon;
    GdkPixbuf *nopackage_icon;
    GdkPixbuf *newpackage_icon;

    GdkPixbuf *available_icon;
    GdkPixbuf *downloading_icon;
    GdkPixbuf *updated_icon;
    GdkPixbuf *error_icon;

    GTimer *timer;
    guint timeout;
  
    gboolean in_progress;
    GTimeVal in_progress_since;
    gint updates_available;
    gint stdout, stderr;

    /* panel settings */
    gint check_interval;
    gboolean upgrade_directly;
    gboolean dist_upgrade;
    gint package_manager;
    gboolean show_application;
    gboolean show_notifications;
}
SmartPlugin;


void
smart_save (XfcePanelPlugin *plugin,
             SmartPlugin    *smart);

void
smart_configure    (XfcePanelPlugin *plugin,
                     SmartPlugin    *smart);

void
smart_about        (XfcePanelPlugin *plugin);

G_END_DECLS

#endif /* !__XFCESMART_H__ */
