/*
 *  This file is part of Xfce (https://gitlab.xfce.org).
 *
 *  Copyright (c) 2021 Jan Ziak <0xe2.0x9a.0x9b@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _XFCE4PP_UTIL_STRINGUTILS_H_
#define _XFCE4PP_UTIL_STRINGUTILS_H_

#include <glib.h>
#include <string>

namespace xfce4 {

std::string sprintf   (const char *fmt, ...) G_GNUC_PRINTF(1, 2);
std::string trim      (const std::string &s);
std::string trim_left (const std::string &s);
std::string trim_right(const std::string &s);

} /* namespace xfce4 */

#endif /* _XFCE4PP_UTIL_STRINGUTILS_H_ */
