<?xml version='1.0'?>
<!--
This program is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this program; see the file COPYING.LGPL.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mal="http://projectmallard.org/1.0/"
		xmlns:str="http://exslt.org/strings"
		xmlns:exsl="http://exslt.org/common"
		xmlns="http://www.w3.org/1999/xhtml"
		version="1.0">

<!--!!==========================================================================
This stylesheet includes text at the top of the page that precises the version
of the software that it was written for, the license of the documentation and
includes the table of contents with links.
-->

<!-- = page = -->
<xsl:template match="mal:page">
  <div class="header">
    <xsl:apply-templates mode="mal2html.title.mode" select="mal:title"/>
    <xsl:apply-templates mode="mal2html.title.mode" select="mal:subtitle"/>

    <p class="p">
      <xsl:call-template name="l10n.gettext">
        <xsl:with-param name="msgid" select="'This manual describes'"/>
      </xsl:call-template>
      <xsl:text> </xsl:text>
      <span class="app">
        <xsl:value-of select="mal:title"/>
      </span>
      <xsl:text> </xsl:text>
      <xsl:call-template name="l10n.gettext">
        <xsl:with-param name="msgid" select="'version'"/>
      </xsl:call-template>
      <xsl:text> </xsl:text>
      <xsl:value-of select="mal:info/mal:revision/@pkgversion"/>.
    </p>
    <p>
      <xsl:call-template name="l10n.gettext">
        <xsl:with-param name="msgid" select="'Last edited:'"/>
      </xsl:call-template>
      <xsl:text> </xsl:text>
      <xsl:value-of select="mal:info/mal:revision/@date"/>.
    </p>
    <xsl:apply-templates mode="mal2html.block.mode" select="mal:info/mal:license/*">
      <xsl:with-param name="first_child" select="false()"/>
    </xsl:apply-templates>
  </div>

  <div class="section toc">
    <h2 class="title">
      <xsl:call-template name="l10n.gettext">
        <xsl:with-param name="msgid" select="'Table of Contents'"/>
      </xsl:call-template>
    </h2>
    <ol>
      <xsl:for-each select="mal:section[mal:title]">
        <li>
          <p>
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="concat('#', @id)"/>
              </xsl:attribute>
              <xsl:value-of select="mal:title"/>
            </a>
          </p>
        <xsl:for-each select="mal:section[mal:title]">
          <ul>
            <li>
              <p>
                <a>            
                  <xsl:attribute name="href">
                    <xsl:value-of select="concat('#', @id)"/>
                  </xsl:attribute>
                  <xsl:value-of select="mal:title"/>
                </a>
              </p>
            </li>
          </ul>
        </xsl:for-each>
        </li>
      </xsl:for-each>
    </ol>
  </div>

  <xsl:apply-templates select="mal:section"/>
  <xsl:call-template name="mal2html.page.autolinks">
    <xsl:with-param name="node" select="."/>
  </xsl:call-template>
</xsl:template>

<!-- = copyright (bottom page) -->
<xsl:template name="mal2html.page.copyrights">
  <xsl:param name="node"/>
  <div class="copyrights">
    <xsl:for-each select="$node/mal:info/mal:credit[mal:years]">
      <xsl:if test="contains(concat(' ', @type, ' '), ' author ')">
        <div class="copyright">
          Copyright <xsl:value-of select="concat('© ', mal:years, ' ', mal:name)"/>
        </div>
      </xsl:if>
      <xsl:if test="contains(concat(' ', @type, ' '), ' translator ')">
        <div class="copyright">
          <xsl:call-template name="l10n.gettext">
            <xsl:with-param name="msgid" select="'Translation'"/>
          </xsl:call-template>
          <xsl:text> </xsl:text>
          <xsl:value-of select="concat('© ', mal:years, ' ', mal:name)"/>
        </div>
      </xsl:if>
    </xsl:for-each>
  </div>
</xsl:template>

</xsl:stylesheet>
