/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-Franois Wauthy (pollux@xfce.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__XFPRINT_HEAD_PAGE_H__
#define	__XFPRINT_HEAD_PAGE_H__

#include <gtk/gtk.h>
#include <xfprintsettings.h>

#ifdef	__cplusplus
extern "C" {
#endif	/* !__cplusplus */

#define HEAD_PAGE(obj)							\
	G_TYPE_CHECK_INSTANCE_CAST(obj, head_page_get_type(), HeadPage)
#define HEAD_PAGE_CLASS(klass)						\
	G_TYPE_CHECK_CLASS_CAST(klass, Head_page_get_type(), HeadPage)
#define HEAD_IS_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_TYPE(obj, head_page_get_type())

typedef struct _HeadPage	HeadPage;
typedef struct _HeadPageClass	HeadPageClass;

struct _HeadPage
{
	GtkTable	table;

	GtkWidget	*headers;
	GtkWidget	*header;
	GtkWidget	*underlay;
	GtkWidget	*ctitle;
	GtkWidget	*ltitle;
	GtkWidget	*rtitle;
	GtkWidget	*cfooter;
	GtkWidget	*lfooter;
	GtkWidget	*rfooter;
};

struct _HeadPageClass
{
	GtkTableClass	parent_class;
};

extern GtkType		head_page_get_type(void);
extern GtkWidget	*head_page_new(void);
extern void		head_page_set_settings(HeadPage *,
				const XfprintSettingsHeadings *);
extern void		head_page_get_settings(HeadPage *,
				XfprintSettingsHeadings *);

#ifdef	__cplusplus
}
#endif	/* !__cplusplus */

#endif	/* !__XFPRINT_HEAD_PAGE_H__ */
