/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-Franois Wauthy (pollux@xfce.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif	/* !HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <libxfce4mcs/mcs-client.h>
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/dialogs.h>

#include <printing-system.h>

#define CHANNEL         "xfprint"

extern void mainwin_setup (void);

GList *printers_list;

int
main(int argc, char **argv)
{
  char **nargv;
  McsClient *client;
  Display *dpy;
  int screen;

  if (argc > 1  && !(!strcmp (argv[1], "--version") || !strcmp(argv[1], "-V"))) {
    nargv = malloc((argc + 1) * sizeof(char *));
    memcpy(nargv, argv, argc * sizeof(char *));
    nargv[0] = "xfprint4";
    nargv[argc] = NULL;
    execvp("xfprint4", nargv);
    xfce_err(_("Unable to execute xfprint4"));
    exit(127);
  }

#if 0
#ifdef ENABLE_NLS
  /* This is required for UTF-8 at least - Please don't remove it */
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
  textdomain (GETTEXT_PACKAGE);
#endif
#else
  /* This is required for UTF-8 at least - Please don't remove it */
  xfce_textdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");
#endif

  gtk_set_locale ();
  gtk_init(&argc, &argv);

  /* Load the printing system module */
  dpy = GDK_DISPLAY ();
  screen = XDefaultScreen (dpy);
	
  if(!mcs_client_check_manager (dpy, screen, "xfce-mcs-manager"))
    g_warning ("%s: mcs manager not running\n", PACKAGE);
  client = mcs_client_new (dpy, screen, NULL, NULL, NULL);
  if(client){
    McsSetting *setting;

    mcs_client_add_channel (client, CHANNEL);

    if( mcs_client_get_setting (client, "XfPrint/system", CHANNEL, &setting) == MCS_SUCCESS){
      if (!load_printing_system (setting->data.v_string))
	g_error ("Unable to load printing system module %s", setting->data.v_string);
      mcs_setting_free (setting);
    }else{
      gchar *default_system = NULL;

      g_warning ("No mcs-setting found for XfPrint/system in channel %s, using default printing-system", CHANNEL);

      default_system = g_build_filename (PLUGIN_DIR, "file_plugin.so", NULL);

      if (!load_printing_system (default_system)){
	g_error ("Unable to load default printing system module %s", default_system);
      }

      g_free (default_system);
    }

    mcs_client_destroy (client);
  }

  if (argc > 1 && (!strcmp (argv[1], "--version") || !strcmp(argv[1], "-V"))){
    PrintingSystemInfo *psinfo;

    psinfo = g_new0 (PrintingSystemInfo, 1);

    printing_system_info_init (psinfo);

    g_print ("\tThis is %s-manager version %s for Xfce %s\n", PACKAGE, VERSION,
	     xfce_version_string());
    g_print ("\tbuilt with GTK+-%d.%d.%d, ", GTK_MAJOR_VERSION,
	     GTK_MINOR_VERSION, GTK_MICRO_VERSION);
    g_print ("linked with GTK+-%d.%d.%d.\n", gtk_major_version,
	     gtk_minor_version, gtk_micro_version);
    g_print ("\tCurrently it uses the %s printing system.\n", psinfo->name);
    
    printing_system_info_free (psinfo);
    exit(EXIT_SUCCESS);
  }



  /* Initialize printers list */
  printers_list = printing_system_get_printers_list ();

  mainwin_setup();

  gtk_main();

  /* Free dynamicly allocated memory */
  g_list_foreach (printers_list, (GFunc)printer_free, NULL);
  g_list_free (printers_list);

  return(0);
}

