/* `dir', `vdir' and `ls' directory listing programs for GNU.
   Copyright (C) 85, 88, 90, 91, 1995-2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


/* Written by Richard Stallman and David MacKenzie. 
 * Modified by Edscott Wilson Garcia for xffm. */

/* timespec -- System time interface

   Copyright (C) 2000, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

# ifndef PARAMS
#  if defined PROTOTYPES || (defined __STDC__ && __STDC__)
#   define PARAMS(Args) Args
#  else
#   define PARAMS(Args) ()
#  endif
# endif


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>
#include "glade_support.h"


#if ! defined TIMESPEC_H
# define TIMESPEC_H

#include <sys/stat.h>
# include <sys/types.h>
# if TIME_WITH_SYS_TIME
#  include <sys/time.h>
#  include <time.h>
# else
#  if HAVE_SYS_TIME_H
#   include <sys/time.h>
#  else
#   include <time.h>
#  endif
# endif


# ifdef ST_MTIM_NSEC
#  define TIMESPEC_NS(timespec) ((timespec).ST_MTIM_NSEC)
# else
#  define TIMESPEC_NS(timespec) 0
# endif


#endif

#include "ls.h"


/*static time_t current_time = 0;*/
/*static time_t current_time = TYPE_MINIMUM (time_t);*/

G_MODULE_EXPORT
size_t nstrftime PARAMS((char *, size_t, char const *, struct tm const *, int, int));

/* Return a character indicating the type of file described by
   file mode BITS:
   'd' for directories
   'D' for doors
   'b' for block special files
   'c' for character special files
   'n' for network special files
   'm' for multiplexor files
   'M' for an off-line (regular) file
   'l' for symbolic links
   's' for sockets
   'p' for fifos
   'C' for contigous data files
   '-' for regular files
   '?' for any other file type.  */

static char ftypelet(mode_t bits)
{
#ifdef S_ISBLK
    if(S_ISBLK(bits))
	return 'b';
#endif
    if(S_ISCHR(bits))
	return 'c';
    if(S_ISDIR(bits))
	return 'd';
    if(S_ISREG(bits))
	return '-';
#ifdef S_ISFIFO
    if(S_ISFIFO(bits))
	return 'p';
#endif
#ifdef S_ISLNK
    if(S_ISLNK(bits))
	return 'l';
#endif
#ifdef S_ISSOCK
    if(S_ISSOCK(bits))
	return 's';
#endif
#ifdef S_ISMPC
    if(S_ISMPC(bits))
	return 'm';
#endif
#ifdef S_ISNWK
    if(S_ISNWK(bits))
	return 'n';
#endif
#ifdef S_ISDOOR
    if(S_ISDOOR(bits))
	return 'D';
#endif
#ifdef S_ISCTG
    if(S_ISCTG(bits))
	return 'C';
#endif

    /* The following two tests are for Cray DMF (Data Migration
       Facility), which is a HSM file system.  A migrated file has a
       `st_dm_mode' that is different from the normal `st_mode', so any
       tests for migrated files should use the former.  */

#ifdef S_ISOFD
    if(S_ISOFD(bits))
	/* off line, with data  */
	return 'M';
#endif
#ifdef S_ISOFL
    /* off line, with no data  */
    if(S_ISOFL(bits))
	return 'M';
#endif
    return '?';
}

/* Use this to suppress gcc's `...may be used before initialized' warnings. */
#ifdef lint
# define IF_LINT(Code) Code
#else
# define IF_LINT(Code)		/* empty */
#endif

  /* Compute mode string.  On most systems, it's based on st_mode.
     On systems with migration (via the stat.st_dm_mode field), use
     the file's migrated status.  */
enum
{
    time_ctime,
    time_mtime,
    time_atime
};


#if 0
/* strftime formats for non-recent and recent files, respectively, in
   -l output.  */

static char const *long_time_format[2] = {
    /* strftime format for non-recent files (older than 6 months), in
       -l output when --time-style=locale is specified.  This should
       contain the year, month and day (at least), in an order that is
       understood by people in your locale's territory.
       Please try to keep the number of used screen columns small,
       because many people work in windows with only 80 columns.  But
       make this as wide as the other string below, for recent files.  */
    N_("%b %e  %Y"),
    /* strftime format for recent files (younger than 6 months), in
       -l output when --time-style=locale is specified.  This should
       contain the month, day and time (at least), in an order that is
       understood by people in your locale's territory.
       Please try to keep the number of used screen columns small,
       because many people work in windows with only 80 columns.  But
       make this as wide as the other string above, for non-recent files.  */
    N_("%b %e %H:%M")
};
#endif

G_MODULE_EXPORT
char *mode_string(mode_t mode)
{
    static char str[12];
    str[0] = ftypelet(mode);
    str[1] = mode & S_IRUSR ? 'r' : '-';
    str[2] = mode & S_IWUSR ? 'w' : '-';
    str[3] = mode & S_IXUSR ? 'x' : '-';
    str[4] = mode & S_IRGRP ? 'r' : '-';
    str[5] = mode & S_IWGRP ? 'w' : '-';
    str[6] = mode & S_IXGRP ? 'x' : '-';
    str[7] = mode & S_IROTH ? 'r' : '-';
    str[8] = mode & S_IWOTH ? 'w' : '-';
    str[9] = mode & S_IXOTH ? 'x' : '-';
    if (mode & S_ISUID) str[3] = mode & S_IXUSR ? 's' : 'S';
    if (mode & S_ISGID) str[6] = mode & S_IXGRP ? 's' : 'S';
    if (mode & S_ISVTX) str[9] = mode & S_IXOTH ? 't' : 'T'; 
    str[10] = 0;
    return (str);
}


