/*
 * Copyright (C) 2003-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>


#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"

#include "misc.h"

static char *diff_file[2];
static int diff_selected;

static void tag_select(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    tree_entry_t *en;

    if(diff_selected >= 2)
	return;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    diff_file[diff_selected++] = en->path;
    return;
}

static void do_diff(void)
{
    char *argv[4];
    GError *error = NULL;
    gint tree_id = get_active_tree_id();
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;

    const gchar *working_directory=g_get_home_dir();
    if (!working_directory) working_directory=g_get_tmp_dir();

    diff_selected = 0;
    diff_file[0] = diff_file[1] = NULL;
    gtk_tree_selection_selected_foreach(selection, tag_select, NULL);
    argv[0] = "xfdiff4";
    argv[1] = diff_file[0];
    argv[2] = diff_file[1];
    argv[3] = NULL;
    chdir(GETWD);
    if (!g_spawn_async (working_directory,argv,NULL, G_SPAWN_SEARCH_PATH,NULL,NULL,NULL,&error)){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics("xfce/error_icon",msg,":\n",argv[0],NULL);
	g_free (msg);
	g_error_free (error);
    }

}



G_MODULE_EXPORT
void on_differences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    do_diff();

}


G_MODULE_EXPORT
void tb_diff(GtkButton * button, gpointer user_data)
{
    do_diff();

}

G_MODULE_EXPORT
void sb_diff(GtkWidget *w)
{
    do_diff();

}


