/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <dirent.h>
#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <dbh.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <xfce4-modules/constants.h>
#include <xfce4-modules/combo.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "modules.h"

#include "recent.h"

#include "remove.h"
#include "entry.h"
#include "misc.h"
#include "input.h"

#ifdef USE_FILTER_BAR
#include "filter.h"
#endif

#include "widgets.h"

/*
#include "bookmarks.h"
#include "callbacks.h"
#include "icons.h"
#include "ls.h"
#include "remove.h"
#include "refresh.h"
*/

#define RECENT_DAYS (recent_days)
#define RECENT_TIME (RECENT_DAYS * 24 *3600)
#define FREQUENT_TIME	(frequent_count)

static DBHashTable *recentbin = NULL;
static time_t now;
#ifdef USE_FILTER_BAR
static const regex_t *target_preg;
#endif
static gboolean just_count;
static gboolean frequent;
static xfdir_t recent_xfdir;
static int target_type;
static unsigned int recentcount;
static GtkTreeIter *target_iter;
static GtkTreeView *target_treeview;
static unsigned frequent_count, recent_days;
extern time_t historytime;


/*#define DEBUG*/


G_MODULE_EXPORT
int add2history(GtkTreeView * treeview, char *path)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    gchar *recentfile = g_build_filename(xdg_dir,RECENT_DBH,NULL);
    GtkTreeIter iter, child;
    tree_entry_t *en;
    int i;
    
    g_free(xdg_dir);
    recent_days = tree_details->recent_days;
    frequent_count = tree_details->frequent_count;
    
#ifdef DEBUG
    printf("adding to recent: %s\n",path);
#endif
    set_load_wait();
    
    XFC_save_to_history(recentfile,path);
    {
	struct stat st;
	if (stat(recentfile,&st) >= 0) historytime=st.st_mtime;
    }
    /* if recent loaded, check if path is in there,
     * if not, then add the row to the treeview. */
    for (i=0;i<2;i++){
	if (i) {
	    DBHashTable *dbh;
	    if (!find_root(treeview,ROOT_FREQUENT)) {
#ifdef DEBUG
		g_message("!find_root(treeview,ROOT_FREQUENT)");
#endif
		continue;
	    }
	    dbh=DBH_open(recentfile);
	    if (dbh) {
		GString *gs;
		int hits=0;
		history_dbh_t *history_dbh;
		history_dbh = (history_dbh_t *)DBH_DATA(dbh);
		gs = g_string_new(path);
		sprintf((char *)DBH_KEY(dbh), "%10u", g_string_hash(gs));
		g_string_free(gs, TRUE);
		if (DBH_load(dbh)){
		    hits = history_dbh->hits;
		} 
		DBH_close(dbh);
		if (hits < FREQUENT_TIME) continue;
	    }
	    get_frequent_root(treeview, &iter, &en);
	}
	else {
	    if (!find_root(treeview,ROOT_RECENT)) continue;
	    get_recent_root(treeview, &iter, &en);
	}
    
#ifdef DEBUG
	printf("recent/frequent root is %s, isloaded=%d\n",en->path,IS_LOADED(en->type));
#endif
	if (IS_LOADED(en->type))
	{
	    /* check if not already there, if there, then just update...*/
	    gboolean found=FALSE;	
	    if(gtk_tree_model_iter_children(treemodel, &child, &iter)){
		do {
		    tree_entry_t *c_en;
		    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
		    if (c_en && c_en->path && strlen(c_en->path) && strcmp(c_en->path,path)==0) found=TRUE;
		} while (gtk_tree_model_iter_next (treemodel,&child));    
	    }
	    if (!found){
		tree_entry_t *c_en = stat_entry(path, en->type);
		if (c_en) {
		    gchar *g = g_path_get_basename(path);
		    add_row(treemodel, &iter, NULL,NULL, c_en, g);
		    g_free(g);
		    erase_dummy_row(treemodel, &iter,NULL);
		}
	    }
	} 
    } /* end for 0,1*/
    unset_load_wait();
    return 1;
}


static void add_bin(DBHashTable * dbh)
{
    gchar *p;
    history_dbh_t *history = (history_dbh_t *)DBH_DATA(dbh);

    
#ifdef DEBUG
    g_message("%s:",history->path);
    printf("DBG:history->hits = %d FREQUENT_TIME = %d\n",history->hits,FREQUENT_TIME); 
    printf("DBG:now - history->last_hit = %u  RECENT_TIME= %u\n",(unsigned)(now - history->last_hit),(unsigned)(RECENT_TIME)); 
#endif

    if (frequent && (history->hits < FREQUENT_TIME)) {
	return;
    }
    if (!frequent && now - history->last_hit > RECENT_TIME) {
	return;
    }
    
    p = g_path_get_basename(history->path);

    if(!p || strlen(p) < 1) return;
#ifdef USE_FILTER_BAR
    if((target_preg && regexec(target_preg, (const char *)p, 0, NULL, 0)) || !g_file_test(history->path,G_FILE_TEST_EXISTS)) {
	g_free(p);
	return;
    }
#else
    if(!g_file_test(history->path,G_FILE_TEST_EXISTS)) {
	g_free(p);
	return;
    }
#endif
    if(just_count) recentcount++;
    else {
	recent_xfdir.gl[recent_xfdir.pathc].en = stat_entry(history->path, target_type);
	if(!recent_xfdir.gl[recent_xfdir.pathc].en)
	{
	    printf("xffm: holy smokes! could not stat %s!!\n", history->path);
	    return;
	}
	recent_xfdir.gl[recent_xfdir.pathc].pathv = p;
	recent_xfdir.pathc++;
    }
    return;
}


G_MODULE_EXPORT
int open_history(GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * treepath, gpointer user_data){
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    gchar *recentfile = g_build_filename(xdg_dir,RECENT_DBH,NULL);
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

    g_free(xdg_dir);
    now = time(NULL);
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return -1;   
    recent_days = tree_details->recent_days;
    frequent_count = tree_details->frequent_count;
    if (IS_FREQUENT_TYPE(en->type)) frequent = TRUE; else frequent = FALSE; 
    
    target_iter = iter;
    target_treeview = treeview;
    target_type = en->type;

    SET_LOADED(en->type);
    {
	struct stat st;
	if (stat(recentfile,&st) >= 0) {
	    /*printf("DBG: setting historytime=%d\n",st.st_mtime);*/
	    historytime=st.st_mtime;
	}
    }

    if (!g_file_test(recentfile,G_FILE_TEST_EXISTS)) {
errnoset:
	reset_dummy_row(treemodel, iter, NULL,en,NULL,NULL);
	cursor_reset();
	return -1;
    }
    if ((recentbin = DBH_openR(recentfile)) == NULL) {
nothing:
	reset_dummy_row(treemodel, iter, NULL,en,NULL,NULL);
	cursor_reset();
	return 0;
    }

    recentcount = 0;		/* for count step */
    recent_xfdir.pathc = 0;	/* for read step */
    cursor_wait();

#ifdef USE_FILTER_BAR
/* returns compiled regex and sets filter in tree_entry */
    if (!en) target_preg = NULL;
    else target_preg = compile_regex_filter(en->filter,SHOWS_HIDDEN(en->type));
    /*target_preg = get_regex_filter(en);*/
#endif


    just_count = TRUE;

    DBH_foreach_sweep(recentbin, add_bin);
#ifdef DEBUG
    printf("DBG:pathc=%d\n",recent_xfdir.pathc); 
#endif

    if(recentcount)
    {
	recent_xfdir.gl = (dir_t *) malloc(recentcount * sizeof(dir_t));
	if(!recent_xfdir.gl)
	{
	    DBH_close(recentbin);
	    goto errnoset;
	}
	just_count = FALSE;
	DBH_foreach_sweep(recentbin, add_bin);
#ifdef DEBUG
        printf("DBG:pathc=%d\n",recent_xfdir.pathc); 
	printf("DBG:count=%d\n",recentcount); 
#endif
	add_contents_row(treemodel, iter, &recent_xfdir);
	erase_dummy_row(treemodel, iter, NULL);
	xfdirfree(&recent_xfdir);
	DBH_close(recentbin);
    }
    else
    {
	DBH_close(recentbin);
	goto nothing;
    }

    if (en->tag){
	    g_free(en->tag);
	    en->tag=NULL;
    }

    /*gtk_widget_thaw_child_notify  ((GtkWidget *)treeview);*/
    cursor_reset();

    return 0;
}

DBHashTable * newbin;

static void clear_bin(DBHashTable * dbh)
{
    history_dbh_t *history = (history_dbh_t *)DBH_DATA(dbh);
    if (frequent) {
	history->hits = 0;
    } else {
	history->last_hit = 0;
    }
    memcpy((void *)DBH_KEY(newbin),(void *)DBH_KEY(dbh),DBH_KEYLENGTH(dbh));
    memcpy(DBH_DATA(newbin),DBH_DATA(dbh),DBH_RECORD_SIZE(dbh));
    DBH_set_recordsize(newbin,DBH_RECORD_SIZE(dbh));
    if (history->hits || history->last_hit) DBH_update(newbin);
    return;
}

static void on_clear(GtkWidget *w,gboolean is_frequent)
{
    GtkTreeIter parent;
    tree_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;

    if (is_frequent) {
	frequent = TRUE;
	get_frequent_root(treeview, &parent, &en);
    } else {
	frequent = FALSE; 
	get_recent_root(treeview, &parent, &en);
    }
    prune_row(treemodel, &parent, NULL, en);
    insert_dummy_row(treemodel, &parent, NULL, en,NULL,NULL);

    if (fork()==0) {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	gchar *recentfile = g_build_filename(xdg_dir,RECENT_DBH,NULL);
	gchar *n = g_build_filename(xdg_dir,RECENT_DBH,NULL);
	gchar *newfile = g_strconcat(n,".new",NULL);
	g_free(xdg_dir);
	g_free(n);
	
	if ((recentbin = DBH_open(recentfile)) != NULL){
	    if ((newbin=DBH_create(newfile,DBH_KEYLENGTH(recentbin)))!=NULL){
		DBH_foreach_sweep(recentbin, clear_bin);
		DBH_close(recentbin);
		DBH_close(newbin);
		unlink(recentfile);
		rename(newfile,recentfile);
	    } else {
		g_warning("Cannot create %s",newfile);
		DBH_close(recentbin);
	    }
	}
	else g_warning("Cannot open %s",recentfile);
	g_free(recentfile);	
	g_free(newfile);	
	_exit(321);
    }
    UNSET_LOADED(en->type);  
}


G_MODULE_EXPORT
void on_clear_recent_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   on_clear((GtkWidget *) menuitem,FALSE);    
}
G_MODULE_EXPORT
void on_clear_frequent_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   on_clear((GtkWidget *) menuitem,TRUE);    
}
G_MODULE_EXPORT
void on_set_frequency_threshold_activate(GtkMenuItem * menuitem, gpointer user_data){
    show_input(FREQUENCY_INPUT);
}
G_MODULE_EXPORT
void on_set_recent_threshold_activate(GtkMenuItem * menuitem, gpointer user_data){
    show_input(RECENT_INPUT);
}

static GList *undo_list=NULL;
static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeRowReference *reference;
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en) {
	/*printf("!en at check\n");*/
	return;
    }
    if(!IS_RECENT_TYPE(en->type) && !IS_FREQUENT_TYPE(en->type)){
	/*printf("!type at check\n");*/
	return;
    }
    reference = gtk_tree_row_reference_new(treemodel, path);
    undo_list = g_list_prepend(undo_list, reference);    
    return;
}


G_MODULE_EXPORT
void on_undo_history_activate(GtkMenuItem * menuitem, gpointer user_data){
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;
    GtkTreeIter iter;
    gchar *recentfile;
    GList *tmp;
    struct stat st;
    
    
    if(!set_load_wait()){
	/*printf("!set_load_wait(&tree_details)\n");*/
	return;
    }
    gtk_tree_selection_selected_foreach(selection, check_select, (gpointer) treeview);
    if (!undo_list) {
	print_diagnostics("xfce/error",strerror(EINVAL),NULL);
	/*printf("!undo_list\n");*/
	goto done;
    }
    {
      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
      recentfile = g_build_filename(xdg_dir,RECENT_DBH,NULL);
      g_free(xdg_dir);
    }
    if ((recentbin = DBH_open(recentfile)) != NULL){
      for (tmp=undo_list;tmp;tmp=tmp->next){
	GString *gs;
	GtkTreeRowReference *reference=(GtkTreeRowReference *)tmp->data;
	tree_entry_t *en;
	history_dbh_t *history = (history_dbh_t *)DBH_DATA(recentbin);
	
	if (!reference) continue;
	get_entry_from_reference(treeview, reference, &iter, &en);
	if (!en) {
	    /*printf("!!en\n");*/
	    continue;
	}
	    /*printf("%s\n",en->path);*/
	gs = g_string_new(en->path);
	sprintf((char *)DBH_KEY(recentbin), "%10u", g_string_hash(gs));
	g_string_free(gs, TRUE);
	if (DBH_load(recentbin)){
	    if (IS_FREQUENT_TYPE(en->type)) {
#ifdef DEBUG
		g_message("history->hits = 0;");
#endif
		history->hits = 0; 
	    } else {
#ifdef DEBUG
		g_message("history->last_hit = 0;");
#endif
		history->last_hit = 0;
	    }
	    DBH_update(recentbin);
	}
	remove_row(treemodel, &iter,NULL,en);
      }
      DBH_close(recentbin);
    }
    if (stat(recentfile,&st) >= 0) historytime=st.st_mtime;
done:
    undo_list=clear_remove_list(undo_list);
    unset_load_wait();
    return;
}

