
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <pwd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <libxfcegui4/libxfcegui4.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "menu_callbacks.h"

#include "dnd.h"
#include "refresh.h"
#include "entry.h"
#include "icons.h"
#include "input.h"
#include "menu.h"
#include "misc.h"
#include "password_dialog.h" 
#include "monitor.h"
#include "remove.h"
#include "run.h"
#include "options.h"
#include "settings.h"
#include "trash.h"
#include "treestore.h"
#include "tubo.h"
#include "widgets.h"


/****************/

extern GtkWidget *autotype_C;
extern GtkWidget *autotype_D;
extern autotype_t autotype[];
extern autotype_t autotype_dir[];
extern gchar *workdir;

static pid_t parent_pid;
static GtkTreeView *autotype_treeview;
static void *autotype_fork_obj=NULL;
static int childFD;

static int auto_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    if (childFD >= 0 && strncmp(line,"Password:",strlen("Password:"))==0){
	const char *p;
    	print_diagnostics("xfce/warning",_("Sudo password requested"),"\n", NULL);
	p=get_password(tree_details->window,_("Sudo password requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));
	return TRUE;
    }
    if (line[0] != '\n') print_diagnostics("xfce/error", line, NULL);
    return TRUE;
}

static int rwStdout (int n, void *data){
  char *line;
  static int count=0;
  if (n) return TRUE; 
  else{
	  line = (char *) data;
	  if (line[0]=='%') {
		  print_diagnostics(NULL,".",NULL);
		  if (++count == 80) {
		     print_diagnostics(NULL,"\n",NULL);
		     count=0;
		  }
	  }
	  else {
		  print_diagnostics("nonverbose",line,NULL);
		  count=0;
	  }
  }
  return TRUE;
}

/* function called when child is dead */
static void rwForkOver (pid_t pid)
{
  autotype_fork_obj=NULL;
  /* this hack should no longer be necessary, since tubo signals
   * the child with SIGCONT before waiting... */
  /* another wait just in case the one in tubo misses 
   * (shouldn't happen, but it does)*/
  /*waitpid(pid, &status, WNOHANG);*/

  print_diagnostics(NULL,_("Command done"),"\n",NULL);
  print_status("xfce/info",_("Command done"),NULL);
  local_monitor(TRUE);
}

extern char **environ;

static void tubo_cmd(void *data){
	char **argv=(char **)data;
	int i=0;
	int status;
	usleep(5000);
	/*argv[i++]="sh";	argv[i++]="-c";*/
	/*for (i=0;argv[i]!=NULL;i++) fprintf(stdout,"--arg[%d]=%s\n",i,argv[i]);
	  fflush(NULL);sleep(2);*/ 
	i=fork();
	if (i<0){
		fprintf(stderr,"unable to fork\n");
	       	_exit(123);
	}
	if (!i){
           if (execvp (argv[0], argv) == -1) {
	     fprintf(stdout,"%s: %s\n",strerror(errno),argv[0]);
	     /*fprintf(stdout,"parentpid=%d\n",parent_pid);*/
	   }
	   fflush(NULL);
	   sleep(1);
	   _exit(123);
	} else usleep(5000);
	wait(&status);
	fflush(NULL);
	sleep(1);
	_exit(123);
}





/***************/



/***   callbacks   **/
G_MODULE_EXPORT
void titles_off(GtkTreeViewColumn * column, gpointer data)
{
    quick_hide((GtkButton *) tree_details->window, (gpointer) ((long)(SHOW_TITLES)));
}

G_MODULE_EXPORT
void titles_toggle(GtkButton * button, gpointer user_data)
{
    unsigned l = (unsigned)((long)user_data);
    if(l & 0x100){
       tree_details->preferences |= (QUICK_HIDE_MASK & l);
    } else {
        tree_details->preferences &= (BIT_MASK ^ l);
    }
    hide_bars();
}

G_MODULE_EXPORT
void on_stop(GtkButton * button, gpointer user_data)
{
    tree_details->stop = TRUE;
    hideit((GtkWidget *) button, "stop");
    showit((GtkWidget *) button, "clear_text");
}

extern gboolean disable_branch_action;
/* this will toggle visibility on/off */
G_MODULE_EXPORT
void on_activate_branch(GtkMenuItem * menuitem, gpointer user_data){
    int l = (int)((long)user_data);
    static gboolean red=FALSE;
    GtkTreeIter  iter;
    GtkTreePath *treepath=NULL;
    tree_entry_t * en;
    gint tree_id = get_relative_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;

    if (!treeview) return;
    if (disable_branch_action)return;
    
    if (red) return;
    red=TRUE;
    if (find_root(treeview,l)) {
	erase_the_root(treeview,(int)l);  
	/*reselect_dnd_list(treeview);*/
	if (!gtk_tree_selection_count_selected_rows(selection)){
	    if(gtk_tree_model_get_iter_first(treemodel, &iter)){
	      treepath=gtk_tree_model_get_path(treemodel, &iter);
	    }
	}
    } else {
      get_the_root(treeview,&iter, &en,(int)l);
      treepath=gtk_tree_model_get_path(treemodel, &iter);
      gtk_tree_view_expand_row(treeview, treepath, FALSE);  
      gdk_flush();
      gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    }
	/* reselect dnd or select first */
    if (treepath) {
      gtk_tree_selection_select_path (selection,treepath);
      gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
      gtk_tree_path_free(treepath);
    } 
    switch (l){
	case ROOT_FILES:
	    toggle_preference(NULL, (gpointer)((long)(ACTIVATE_LOCAL|INDIVIDUAL_TOGGLE)));
	    break;
#ifdef USE_SMB_BRANCH
	case ROOT_NETWORK:
	    toggle_preference(NULL, (gpointer)((long)(ACTIVATE_SMB|INDIVIDUAL_TOGGLE)));
#endif
	    break;
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	case ROOT_FSTAB:
	    toggle_preference(NULL, (gpointer)((long)(ACTIVATE_FSTAB|INDIVIDUAL_TOGGLE)));
	    break;
#endif
	case ROOT_BOOKMARKS:
	    toggle_preference(NULL, (gpointer)((long)(ACTIVATE_BOOK|INDIVIDUAL_TOGGLE)));
	    break;
	case ROOT_TRASH:
	    toggle_preference(NULL, (gpointer)((long)(ACTIVATE_TRASH|INDIVIDUAL_TOGGLE)));
	    break;
	case ROOT_RECENT:
	    toggle_preference(NULL, (gpointer)((long)(ACTIVATE_RECENT|INDIVIDUAL_TOGGLE)));
	    break;
	case ROOT_FREQUENT:
	    toggle_preference(NULL, (gpointer)((long)(ACTIVATE_FREQUENT|INDIVIDUAL_TOGGLE)));
	    break;
    }
    red=FALSE;
}

G_MODULE_EXPORT
void on_close_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    disable_diagnostics();
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    if (strstr(tree_details->argv[0],"xffstab") && tree_details->argv[1]) {
	int is_mounted(const gchar *mnt_point);
	/* if argv[1] was already mounted, this will unmount it too
	 * (if not busy, of course).*/
	chdir(GETWD);
	if (fork()){
	   if (is_mounted((const gchar *)tree_details->argv[1])){
	     char *arguments[3];
#ifdef DEBUG
	     printf("DBG:umount %s\n",tree_details->argv[1]);
#endif
     	     arguments[0]="umount";
	     arguments[1]=tree_details->argv[1];	     
	     arguments[2]=0;
	     execvp(arguments[0],arguments);
	     _exit(123);
	   }
#ifdef DEBUG
	   else printf("DBG:not mounted %s\n",tree_details->argv[1]);
#endif
	} 
	
    }
#endif


    cleanup_tmpfiles();
    if (tree_details) {
      cancel_input(NULL,NULL);
      write_local_xffm_config();
      tree_details->window = NULL;
    } 
     _exit(123);
    return;
}

G_MODULE_EXPORT
void on_tb_close(GtkWidget * w){
    on_close_activate(NULL, NULL);
}

G_MODULE_EXPORT
void on_clear_text_window(GtkButton * button, gpointer user_data)
{
    clear_diagnostics();
}


G_MODULE_EXPORT
void on_show_text(GtkButton * button, gpointer user_data)
{
    show_text(GTK_WIDGET(button));
}

G_MODULE_EXPORT
void on_hide_text(GtkButton * button, gpointer user_data)
{
    hide_text(GTK_WIDGET(button));
}

G_MODULE_EXPORT
gboolean on_xffm_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    on_close_activate(NULL,NULL );
    return FALSE;
}

G_MODULE_EXPORT
gboolean on_xffm_delete_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    on_close_activate(NULL,NULL );
    return FALSE;
}

static int
autofunction_workdir  (GtkTreeView *treeview, tree_entry_t *en,
		const gchar *querypath) 
{
         
  g_free(workdir);
  workdir=NULL;
  if (querypath){
      workdir=g_strdup(querypath); 
      /* remove any previous gtk loop: */ 
      cancel_input(NULL,NULL);    
      /* this starts a new gtk loop */
      show_input(WORKDIR_INPUT);
      /* on returning from the loop, tree_details->input == OTHER_INPUT
       * means it was cancelled by button press, or menu selection */
      if (tree_details->input == OTHER_INPUT) return FALSE;
      tree_details->input = OTHER_INPUT;
      if (!workdir){
	 print_status("xfce/warning",strerror(ENOTDIR),NULL);
	 return FALSE;
      }	 
  } else {
  	workdir=g_path_get_dirname (en->path);
  }
  if(!workdir || chdir(workdir)<0){
	 print_status("xfce/error",strerror(errno), NULL);
	 g_free(workdir);
	 workdir=NULL;
	 chdir(GETWD);
	 return FALSE;
  }
  chdir(GETWD);
  return TRUE;
}

/* autofunction for directories works different: 
 * directories: the path argument is relative, so we must do a chdir
 * 		to the path directory.
 * 		The output specified will carry along the fullpath for 
 * 		output. The workdir will be that where the directory 
 * 		resides. We must do a chdir here.
 * files:	the path argument is absolute. So we just do a chdir to
 * 		the specified workdir before execution.
 *
 * 		*/
static void
autofunction  (GtkTreeView *treeview, tree_entry_t *en,
		char **arguments,gboolean queued) 
{
    static gchar *sudo_prompt=NULL;
         
  gboolean first=TRUE;
  int *FD=NULL;
  autotype_treeview=treeview;
  print_diagnostics(NULL, _("processing"),"...\n",NULL);
  print_status("xfce/info", _("processing")," ",arguments[0],"...",NULL);
/* put in a \n to the password prompt to flush the pipe: fluusshh */
   
  if (strcmp(arguments[0],"sudo")==0){
	if (sudo_prompt) g_free(sudo_prompt);
  	sudo_prompt = g_strconcat("SUDO_PROMPT=","Password:","\n",NULL);
  	putenv(sudo_prompt);
	FD=&childFD;
  } 
  
  while (1){
	if (!autotype_fork_obj){
		int i;
		int read_delay=0;
		
		parent_pid=getpid();
		for (i=0;arguments[i];i++){
		   /*print_diagnostics(NULL,arguments[i]," ",NULL);*/
		   /*hack: burncd running in piped background leaves little time for gtk loop */ 
		   if (strcmp(arguments[i],"burncd")==0)read_delay=200; 
		}
		/*print_diagnostics(NULL,"\n",NULL);*/
		autotype_fork_obj=Tubo (tubo_cmd, 
				(void *)arguments, 
				rwForkOver, 
				FD,rwStdout, auto_stderr,read_delay,
				TRUE);
		if (!queued){
			/*printf("DBG:not queued!\n");*/
		       	autotype_fork_obj=NULL;
		}
		break;
	} else if (first) {
		first=FALSE;
		print_diagnostics(NULL, _("command queued"),"\n",NULL);
		print_status("xfce/info", _("command queued"),"\n",NULL);
	}
    
	process_pending_gtk();

	/*printf(".");fflush(NULL);usleep(500000);*/
	usleep(500);
  }
  return;
}

void
on_autotype_C                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    const gchar *command;
    static gchar *new_command=NULL;
    GtkTreeIter iter;
    gboolean *queued;
    const gchar *querypath,*output_arg,*output_ext;
    gint tree_id = get_active_tree_id();
    tree_entry_t *en;
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    gint argc;
    gchar **argv;
    GError *error=NULL;

    en = get_selected_entry(&iter);
    command=g_object_get_data(G_OBJECT(menuitem),"command");
    querypath=g_object_get_data(G_OBJECT(menuitem),"querypath");
    queued=g_object_get_data(G_OBJECT(menuitem),"queued");
    output_arg=g_object_get_data(G_OBJECT(menuitem),"output_arg");
    output_ext=g_object_get_data(G_OBJECT(menuitem),"output_ext");
    if (output_arg && !output_ext) g_warning("output_arg && !output_ext not met"); 
    if (querypath && !autofunction_workdir (treeview, en,querypath)) return;
    if (output_arg) {
	gchar *outputdir=workdir;
	workdir=g_path_get_dirname(en->path);
	if (new_command) g_free(new_command);
	new_command = g_strconcat(command," \"",outputdir,G_DIR_SEPARATOR_S,output_arg,output_ext,"\" \"",output_arg,"\"",NULL);
	command = (const gchar *)new_command;
	g_free(outputdir);
    }
    
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics("xfce/error",msg,": ",command,"\n",NULL);
	g_error_free(error);
	g_free (msg);
    }
    if (!queued || *queued == FALSE){
       runvwd(workdir,argv);
	g_strfreev (argv);
       return;
    } 

    if (workdir) {
	if (strcmp(workdir,GETWD)!=0) print_diagnostics(NULL,"$chdir ",workdir,"\n",NULL);
	if (chdir(workdir)<0){
	   print_diagnostics("xfce/error",strerror(errno),"\n",NULL);
	}
    }   
    
    autofunction(treeview,en,argv,(queued && *queued));
    

    chdir(GETWD);
    if (workdir && strcmp(workdir,GETWD)!=0) print_diagnostics(NULL,"$chdir ",GETWD,"\n",NULL);
    g_strfreev (argv);

	
}

G_MODULE_EXPORT
void
on_autotype_R                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    en = get_selected_entry(&iter);
    double_click_open_with(en);
    return;
}

void
on_autotype_run                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    en = get_selected_entry(&iter);
    /*  assume in_term to be safe */
    SET_IN_TERM(en->subtype);
    double_click_run(en);
    return;
}

G_MODULE_EXPORT
void
on_preview_this_image_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GdkPixbuf *tgt;
    tree_entry_t *en;
    GtkTreeIter iter;
    gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    en = get_selected_entry(&iter);
    print_status("xfce/warning", 
			_("Preview"), ": ", FILENAME(en), 
			NULL);
    process_pending_gtk();

    tgt = create_preview(en->path, REAL_BIG);
    if (!tgt) print_status("xfce/error", 
			strerror(EINVAL), ": ", FILENAME(en), 
			NULL);
    else {
	update_iconcolumn_for_row(treemodel, &iter, tgt);	
	
        g_object_unref (G_OBJECT (tgt));
    }
}

G_MODULE_EXPORT
void on_about_activate (GtkMenuItem *menuitem, gpointer data)
{
	XfceAboutInfo *info;
	GtkWidget *dialog;
	GdkPixbuf *pixbuf = MIME_ICON_create_pixbuf ("b-xffm");
	struct passwd *p;
	gchar *g;
	
	
	if((p = getpwuid(geteuid())) != NULL){
	    g=g_strdup_printf("%s@%s",p->pw_name,tree_details->argv[0]);
	} else {
	    g=g_strdup_printf("%d@%s",geteuid(),tree_details->argv[0]);
	}
	info = xfce_about_info_new(
		g,
		VERSION,
		"Xfce fast file manager",
		XFCE_COPYRIGHT_TEXT("2002-2004", "The XFce development team"),
		XFCE_LICENSE_LGPL);

	xfce_about_info_set_homepage(info, "http://www.xfce.org/");
	xfce_about_info_add_credit(info,
		"Edscott Wilson Garcia and others",
		"xfce4-dev@xfce.org",
		_("Xffm evolved from the Xfce3 applications:\n   xftree, xfglob, xfsamba, xfdiff"));

	dialog = xfce_about_dialog_new(NULL, info,pixbuf );
	gtk_window_set_default_size(GTK_WINDOW(dialog), 500, 400);
	xfce_about_info_free(info);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy (dialog);
	if (pixbuf) g_object_unref(G_OBJECT(pixbuf));
	g_free(g);
}

