/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <limits.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#if 0
#ifdef HAVE_LIBRSVG
#include <librsvg/rsvg.h>
#endif
#endif


#include <libxml/parser.h>
#include <libxml/tree.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "modules.h"

#include "basic_row.h"

#include "icons.h"

#include "entry.h"
#include "misc.h"
#include "pasteboard.h"
#include "settings.h"
#include "xfstab.h"
#include "toolbar.h"

/*#define DEBUG*/


static GtkStyle *style;
static gchar *icon_theme=NULL;
static const gchar *composite_type_id(const gchar *path,int type,int subtype,const gchar *id){
	static gchar *composite_type=NULL;
	gboolean greenball=FALSE,redball=FALSE;
	gchar *p;
	g_free(composite_type);
	composite_type=g_strdup(id);
	if (path){
	    if (IS_DIR(type) && is_mounted(path)==1) greenball=TRUE;
	    else if (is_in_fstab(path) && !IS_XF_FSTAB(type)) redball=TRUE;
	}
	if (IS_NOWRITE(type)||IS_XF_LNK(type)||HAS_HIDDEN(type)||greenball||redball||IS_NETREADONLY(subtype)||IS_XF_NETSHARE(subtype)){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/composite",NULL);
	    g_free(p);	
	}
	if(HAS_HIDDEN(type)){
	    p=composite_type;
	    if(SHOWS_HIDDEN(type)) composite_type = g_strconcat(p,"/shows_hidden",NULL);
	    else composite_type = g_strconcat(p,"/has_hidden",NULL);
	    g_free(p);
	}
	if (IS_NOWRITE(type)||IS_NETREADONLY(subtype)){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/no_write",NULL);
	    g_free(p);	
	}
	if (IS_XF_LNK(type)||IS_XF_NETSHARE(subtype)){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/link",NULL);
	    g_free(p);	
	}
	/*if (path && IS_FSTAB_TYPE(type) && IS_XF_FSTAB(type)){*/
	if (path && greenball){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/fstab_mounted",NULL);
	    g_free(p);	
	} else if (path && redball){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/fstab_unmounted",NULL);
	    g_free(p);	
	}
#ifdef DEBUG
	printf("DBG 1 s:%s composite type=%s type=0x%x (link=%d)\n",path,composite_type,type,IS_XF_LNK(type));
#endif 

	return composite_type;
}

static gboolean set_size_icons(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    set_icon(treemodel,  iter);
    return FALSE;
}

G_MODULE_EXPORT
gboolean is_image (gchar *file){
    static GSList *pix_formats=NULL;
    GSList *l;
    gboolean result=FALSE;
    
    const gchar *mimetype = MIME_get_type(file,TRUE);
    /* check for image support types */

    if (!pix_formats) pix_formats = gdk_pixbuf_get_formats();
    for(l = pix_formats; l; l = l->next) {
	gchar **pix_mimetypes;
	int i;
	GdkPixbufFormat *fmt = l->data;
	pix_mimetypes = gdk_pixbuf_format_get_mime_types(fmt);
	for(i = 0; pix_mimetypes[i]; i++) {
		if(!g_ascii_strcasecmp(pix_mimetypes[i],mimetype)) {
		    result=TRUE;
		    break;
		}
	}
	g_strfreev(pix_mimetypes);
	if (result) break;
    }
    /* let's keep this one in memory to reduce overhead */
    /*g_slist_free(pix_formats);*/
    return result;
}


G_MODULE_EXPORT
GdkPixbuf *create_preview (char *file, int size)
{
    GdkPixbuf *src, *tgt;
    int max_w, w, h;
    int pw, ph;
    double scaleW, scaleH, scale;
    GError *error = NULL;

    switch (size)
    {
	default:
	    max_w = w = 48, h = 24;
	    break;
	case MEDIUM:
	    max_w = w = 68, h = 34;
	    break;
	case BIG:
	    max_w = w = 100, h = 50;
	    break;
	case REAL_BIG:
	    max_w = w = 200, h = 100;
	    break;
    }
#if 0
#ifdef HAVE_LIBRSVG
    if (strstr(file,".svg")) {
	
	src = rsvg_pixbuf_from_file ((const gchar *)file,&error);
	if (error) {
	    /*g_warning("%s: %s",file,error->message);*/
	    g_error_free(error);
	    error=NULL;
	}
	/******************/
	/* FIXME: this block of code repeats itself a few lines below 
	 * there should be a better way to get the w and h of a svg file...*/
    ph = gdk_pixbuf_get_height(src);
    pw = gdk_pixbuf_get_width(src);
    if ((ph > h || pw > w) && pw > 0 && ph > 0){
      scaleH = (double)h / ph;
      scaleW = (double)w / pw;
      if (scaleW*pw > max_w) scaleW=(double)max_w / pw;
      scale = (scaleH < scaleW) ? scaleH : scaleW;
      h = scale * ph;
      w = scale * pw;
    } else return (src);
    if(w < 10 || h < 10)
    {
	if (src) g_object_unref(G_OBJECT(src));
	return NULL;
    }
	/********************/
	tgt = rsvg_pixbuf_from_file_at_size((const gchar *)file,w,h,&error);
	if (src) g_object_unref(G_OBJECT(src));

	
	if (error){
	    /*g_warning("%s: %s",file,error->message);*/
	    g_error_free(error);
	    error=NULL;
	}
	return tgt;
    }
#endif
#endif
    src = gdk_pixbuf_new_from_file(file, &error);
    if(!src)
    {
	/*printf("DBG: pixbuf error, file=%s\n",file); */
	return NULL;
    }
    if(error){
	g_error_free(error);
	error=NULL;
    }

    ph = gdk_pixbuf_get_height(src);
    pw = gdk_pixbuf_get_width(src);
    if ((ph > h || pw > w) && pw > 0 && ph > 0){
      scaleH = (double)h / ph;
      scaleW = (double)w / pw;
      if (scaleW*pw > max_w) scaleW=(double)max_w / pw;
      scale = (scaleH < scaleW) ? scaleH : scaleW;
      h = scale * ph;
      w = scale * pw;
    } else return (src);
    if(w < 10 || h < 10)
    {
	if (src) g_object_unref(G_OBJECT(src));
	return NULL;
    }

    if(!src)
	return NULL;
    tgt = gdk_pixbuf_scale_simple(src, w, h, GDK_INTERP_BILINEAR);
    if (tgt) g_object_unref(G_OBJECT(src));
    return tgt;
}
G_MODULE_EXPORT
GdkPixbuf *create_full_pixbuf (char *file)
{
    GdkPixbuf *src;
    GError *error = NULL;

    src = gdk_pixbuf_new_from_file(file, &error);
    if(!src)
    {
	printf("DBG: pixbuf error, file=%s\n",file); 
	return NULL;
    }
    if(error)
	g_error_free(error);

    return src;
}


/*void */
G_MODULE_EXPORT
gboolean
increase_size (GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en)
	return(FALSE);
    set_icon(treemodel,  iter);
    return FALSE;
}

/*void */
G_MODULE_EXPORT
gboolean
decrease_size (GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return(FALSE);   
    set_icon(treemodel, iter);
    return FALSE;
}


G_MODULE_EXPORT
const gchar *resolve_folder_icon (tree_entry_t * en)
{
    int type = en->type;
    const gchar *basic_type;
 
    if (IS_NOACCESS(en->type)){
	    return "xfce/no-access";
    }
    
    if (en->path && strcmp(g_get_home_dir(),en->path)==0){
	/*printf("%s==%s\n",g_get_home_dir(),en->path);*/
	basic_type="xfce/b-home";
    }
   
    else if(IS_EXPANDED(type)) basic_type="xfce/open_folder";
    else basic_type="xfce/closed_folder";
    
    return (basic_type);

}
       

G_MODULE_EXPORT
void 
insert_pixbuf_tag (		const gchar *id, 
				GdkPixbuf **tgt,
			        int size,	
				int scale, 
				const gchar *where){
    int x_tgt=0,y_tgt=0; /* default: NW */
    GdkPixbuf *tag,*otag;
    int width, height;
    
    width=gdk_pixbuf_get_width(*tgt);
    height=gdk_pixbuf_get_height(*tgt);

    /* only use stock gtk here: */
    if (strncmp(id,"gtk-",strlen("gtk-"))==0){
	otag = gtk_widget_render_icon(tree_details->window, id ,size, NULL);
    }
    else  otag = icon_tell(size,id);
    if (!otag) return;
    tag = gdk_pixbuf_scale_simple(otag, width/scale,height/scale, GDK_INTERP_BILINEAR);	
    g_object_unref(G_OBJECT(otag));
    
    if (strcmp(where,"NE")==0) 
	x_tgt=(scale-1)*width/scale, y_tgt=0;
    else if (strcmp(where,"SW")==0)
       	x_tgt=0, y_tgt=(scale-1)*width/scale;
    else if (strcmp(where,"SE")==0) 
	x_tgt=(scale-1)*width/scale, y_tgt=(scale-1)*width/scale;
    gdk_pixbuf_copy_area (tag,0,0,width/scale,height/scale,*tgt,x_tgt,y_tgt);
    g_object_unref(G_OBJECT(tag));
}


static GdkPixbuf *icon_tell_cut(int size, const gchar *id, gboolean cut)
{
    GtkIconSet *iconset;
    int gtksize;
    if (!id || !strlen(id)) return NULL;
    iconset = MIME_ICON_get_iconset(id,tree_details->window);
   

    if (strncmp(id,"gtk-",strlen("gtk-"))==0){
	return load_stock_icon(id ,size);
	/*return gtk_widget_render_icon(tree_details->window, id ,size, NULL);*/
    } 	

    if (strstr(id,"/composite")) {
	gchar *basic_type=g_strdup(id);
	
	GdkPixbuf *folder,*ofolder;
	    
	*(strstr(basic_type,"/composite"))=0;
	
	ofolder = icon_tell(size,basic_type);
	folder=gdk_pixbuf_copy(ofolder);
	g_object_unref(G_OBJECT(ofolder));
	
	
	if (strstr(id,"/shows_hidden")){
	    insert_pixbuf_tag("gtk-add",&folder,size,4,"NE");
	}
	else if (strstr(id,"/has_hidden")) {
	    insert_pixbuf_tag("gtk-remove",&folder,size,4,"NE");
	}
	
	if (strstr(id,"/no_write")){
	    insert_pixbuf_tag("gtk-cancel",&folder,size,4,"SE");
	}
	if (strstr(id,"/link")){
	    insert_pixbuf_tag("xfce/link",&folder,size,3,"SW");
	}
	if (strstr(id,"/fstab_mounted")){
	    insert_pixbuf_tag("gtk-yes",&folder,size,5,"NW");
	}
	else if (strstr(id,"/fstab_unmounted")){
	    insert_pixbuf_tag("gtk-no",&folder,size,5,"NW");
	}
	if (cut){
	    iconset=gtk_icon_set_new_from_pixbuf(folder);
	    g_object_unref(G_OBJECT(folder));
	} else return folder;
    }
    
    if (!iconset) {
	GdkPixbuf *pb;
	pb = MIME_ICON_create_pixbuf (id);
	if (pb) {
	    iconset=gtk_icon_set_new_from_pixbuf(pb);
	    g_object_unref(G_OBJECT(pb));
	}
    }
    
    if(!iconset) 
    {
        iconset = MIME_ICON_get_iconset("xfce/default",tree_details->window);
/*#ifdef DEBUG
        printf("icon for %s not found in $theme/mime.xml\n",id); 
        printf("DBG: looking for iconset %s...%s\n",id,(iconset)?"found":"not found"); 
#endif*/
    }

    if(!style) style = gtk_style_new();
    switch (size)
    {
	case REAL_BIG:
	    gtksize = GTK_ICON_SIZE_DIALOG;
	    break;
	case BIG:
	    gtksize = GTK_ICON_SIZE_DND;
	    break;
	case MEDIUM:
	default:
	    gtksize = GTK_ICON_SIZE_LARGE_TOOLBAR;
	    break;
	case SMALL:
	    gtksize = GTK_ICON_SIZE_BUTTON;
	    break;
	    /*gtksize=GTK_ICON_SIZE_SMALL_TOOLBAR; break;*/
    }
    if(!iconset) return NULL;
    return gtk_icon_set_render_icon(iconset, style, GTK_DIR_RIGHT, (cut) ? GTK_STATE_INSENSITIVE : GTK_STATE_NORMAL, gtksize, NULL, NULL);
}

G_MODULE_EXPORT
GdkPixbuf *icon_tell(int size, const gchar *id)
{
    return icon_tell_cut(size, id, FALSE);
}




G_MODULE_EXPORT
const gchar *resolve_icon_id (tree_entry_t * en)
{
    if(!en) assert_not_reached();
    if(IS_ROOT_TYPE(en->type))
    {
	if(IS_NETWORK_TYPE(en->type)) return ("xfce/b-network");
	else if(IS_FIND_TYPE(en->type)) return ("xfce/b-find");
	else if(IS_FSTAB_TYPE(en->type)) return ("xfce/b-fstab");
	else if(IS_BOOKMARK_TYPE(en->type)) 
	{
	    if(IS_EXPANDED(en->type)) return ("xfce/b-book");
	    return ("xfce/b-book");
	}
	else if(IS_RECENT_TYPE(en->type)) return ("xfce/b-recent");
	else if(IS_FREQUENT_TYPE(en->type)) return ("xfce/b-frequent");
	else if(IS_TRASH_TYPE(en->type))
	{ /*FIXME: monitor trash icon
	    if(IS_EXPANDED(en->type)) return (""); 
	    return ("xfce/trash_closed");*/
		return ("xfce/b-trash");
	}
	else if(!IS_LOCAL_TYPE(en->type)) return (NULL);
    }
    
    if(IS_NETWORK_TYPE(en->type)||IS_BOOKMARK_TYPE(en->type)) {
      if(IS_XF_NETWG(en->subtype)) return ("xfce/b-network");
      if(IS_XF_NETWS(en->subtype)) return ("xfce/netws");
      if(IS_XF_NETSHARE(en->subtype)) {
	      if(IS_EXPANDED(en->type)) return ("xfce/share_open");
	      else return ("xfce/share");
      }
      if(IS_XF_NETIPC(en->subtype)) return ("xfce/ipc");
      if(IS_XF_NETPRINT(en->subtype)) return ("xfce/p-print");
      if(IS_NETDIR(en->subtype)) { 
	 if (IS_EXPANDED(en->type)){
	      return "xfce/open_folder";
   	 } else {
	      return "xfce/closed_folder";
	 }
      }
      if (IS_NETWORK_TYPE(en->type)) {
	    const gchar *g=MIME_get_type(en->path,FALSE);
	    if (strcmp(g,"undetermined type")==0) return "application/default";
	    else return g;
      }
    }

    if(IS_FSTAB_TYPE(en->type) && IS_XF_FSTAB(en->type)){
	const gchar *t="xfce/disk";
	if (IS_NFS_TYPE(en->subtype)) t = "xfce/nfs";
	else if (IS_PROC_TYPE(en->subtype)) t = "xfce/process";
	else if (IS_CDFS_TYPE(en->subtype)) t = "xfce/cdrom";
	else if (strstr(en->path,"floppy")) t = "xfce/floppy";
	else if (strstr(en->path,"cdrom")) t = "xfce/cdrom";
	else if (strstr(en->path,"cdrw")) t = "xfce/cdrom";
	else if (strstr(en->path,"dvd")) t = "xfce/dvd";
	return t;
    }
    

    /* broken links : */
    if(IS_BROKEN_LNK(en->type)) return "xfce/broken";

    /* find results */
    if(IS_XF_FND(en->type)) return "xfce/find_result";

    if(IS_DIR(en->type))
    {
	/*printf("folder %s link=%d\n",en->path,IS_XF_LNK(en->type)); */
	/* strstr makes all folders inside wastebasket use this icon */
	if(strstr(en->path, "/..Wastebasket"))
	{
	    if(en->count)
		return "xfce/waste_basket_full";
	    return "xfce/waste_basket_empty";
	}

	return resolve_folder_icon(en);
    }

    /* non-broken links: */
    /*printf("file %s link=%d\n",en->path,IS_XF_LNK(en->type)); */
    /*if(IS_XF_LNK(en->type)) return "inode/symlink";*/

    /* d_types: */
    else if(IS_XF_CHR(en->type)) return ("inode/chardevice");
    else if(IS_XF_BLK(en->type)) return ("inode/blockdevice");
    else if(IS_XF_FIFO(en->type)) return ("inode/fifo");
    else if(IS_XF_SOCK(en->type)) return ("inode/socket");

    if (IS_NOACCESS(en->type)) return ("xfce/no-access");


    /*if all else fails: */
    return NULL;
}

 /* 
  *options for icons... use GTK_STATE_INSENSITIVE for files that
  have been cut to the pasteboard, until the pasteboard has been
  found invalid... 
  *  GTK_STATE_NORMAL,
  GTK_STATE_ACTIVE,
  GTK_STATE_PRELIGHT,
  GTK_STATE_SELECTED,
  GTK_STATE_INSENSITIVE*/

static GdkPixbuf *resolve_icon (tree_entry_t * en, tree_entry_t * p_en)
{
    int gtksize, size;
    char *loc = NULL;
    const gchar *id=NULL;
    int max_preview_size=256;
    gboolean cut = FALSE;
    /*GdkPixbuf *Icon;
    GtkIconSet *iconset;
    char *l, *stock_id = NULL;*/
       const gchar *mimetype;


    if(!style) style = gtk_style_new();

    switch (tree_details->icon_size){
      case 3:
	gtksize = GTK_ICON_SIZE_DIALOG;
	size = REAL_BIG;
	break;
      case 2:
	gtksize = GTK_ICON_SIZE_DND;
	size = BIG;
	break;
      case 1:
	gtksize = GTK_ICON_SIZE_LARGE_TOOLBAR;
	size = MEDIUM;
	break;
      case 0:
      default:
	gtksize = GTK_ICON_SIZE_BUTTON;
	size = SMALL;
	break;
    }
    if(valid_pasteboard() == 2)
    {
	cut = in_pasteboard(en);
	if(cut){  SET_CUT(en->type); }
    }
    else UNSET_CUT(en->type);

    if (!id) id = resolve_icon_id(en);
    if(id){
#ifdef DEBUG
	printf("ICON RESOLVED: %s --> %s\n",en->path,id);
#endif
     	return icon_tell_cut(size, composite_type_id(en->path,en->type,en->subtype,id), cut);
    }

    /* image previews before executable */
    if(en->path) loc = strrchr(en->path, '/');
    if (getenv("XFFM_MAX_PREVIEW_SIZE") && strlen( getenv("XFFM_MAX_PREVIEW_SIZE"))){
	if (is_number(getenv("XFFM_MAX_PREVIEW_SIZE"))) {   
	   max_preview_size=(atoi(getenv("XFFM_MAX_PREVIEW_SIZE")));
	}	   
    }
    
    if ( !cut && loc && IS_FILE(en->type) && !IS_NETWORK_TYPE(en->type) &&
	 !IS_TRASH_TYPE(en->type) && !strstr(en->path, "/..Wastebasket") &&
	 en->st->st_size <= max_preview_size*1024 && 
	 (tree_details->preferences & IMAGE_PREVIEW ||
	  (p_en && SHOWS_IMAGES(p_en->type)) 
	 ) && (IS_IMAGE(loc))
	)
    {
 	GdkPixbuf *tgt;
        process_pending_gtk(); 
	tgt = create_preview(en->path, size);
	if(tgt) return tgt;
    }
    

    /* mime type (before executables) : */
#if 0
       gchar *p=strrchr(en->path,G_DIR_SEPARATOR);
       if (p && strchr(p,'-')){
	       p=g_strdup(en->path);
	       *strrchr(p,'-')=0;
	       mimetype = MIME_get_type(p,FALSE); /* don't try magic here, too expensive */
	       g_free(p);
       } 
       else 
#endif
       mimetype = MIME_get_type(en->path,FALSE);
       if ((strcmp("application/octet-stream",mimetype)==0 ||strcmp("text/plain",mimetype)==0) && IS_EXE(en->type)){
	   return icon_tell_cut(size, composite_type_id(en->path,en->type,en->subtype,"xfce/executable"), cut); 
       } else if (strcmp("undetermined type",mimetype)==0) {
    /* icon determination has failed, return the default icon */
	   return icon_tell_cut(size, composite_type_id(NULL,en->type,en->subtype,"xfce/default"), cut);
       }
       
 
    return  icon_tell_cut(size, composite_type_id(en->path,en->type,en->subtype,mimetype), cut);
    
}

G_MODULE_EXPORT
GdkPixbuf *resolve_icon_size (tree_entry_t * en,int size)
{
    int gtksize;
    static GtkStyle *style = NULL;
    char *loc;
    const gchar *id;


    if(!en || !en->path) return NULL;

    if(!style) style = gtk_style_new();
    gtksize = GTK_ICON_SIZE_LARGE_TOOLBAR;
    /*size = SMALL;*/

    id = resolve_icon_id(en);
    if(!id && IS_EXE(en->type)) id = "xfce/executable";
    if(id) {
	return icon_tell(size, id);
    }

    /* mime type: */
    loc = strrchr(en->path, '/');
    /*printf("path=%s, loc=%s\n",en->path,(loc)?loc:"null");*/
    if(loc)
    {
	GdkPixbuf *Icon;
	GtkIconSet *iconset;
	const gchar *stock_id = NULL;
	stock_id = MIME_get_type(en->path,FALSE);
	if(stock_id)
	{
	    iconset = MIME_ICON_get_iconset(stock_id,tree_details->window);
	    if(!iconset) return NULL;
	    Icon = gtk_icon_set_render_icon(iconset, style, GTK_DIR_RIGHT, GTK_STATE_NORMAL, gtksize, NULL, NULL);
	    return Icon;
	}
	/*else printf("key=%s not found loco\n",loc); */
    }
    return icon_tell(size, "xfce/default");

}


G_MODULE_EXPORT
void set_icon (GtkTreeModel *treemodel, GtkTreeIter * iterator)
{
    GdkPixbuf *Icon;
    tree_entry_t *en;
    tree_entry_t *p_en = NULL;
    GtkTreeIter parent;
    gtk_tree_model_get(treemodel, iterator, ENTRY_COLUMN, &en, -1);
    if (!en) return;   
    if(gtk_tree_model_iter_parent(treemodel, &parent, iterator))
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);

    if(!en) return;
    if(IS_DUMMY_TYPE(en->type))
	return;
    /*if (en->path) printf("DBG: icon setting for %s\n",en->path); */
    set_font(treemodel,iterator); 
    Icon = resolve_icon(en, p_en);
    update_iconcolumn_for_row(treemodel, iterator,Icon);	
    if (Icon) g_object_unref (G_OBJECT (Icon));    
}

G_MODULE_EXPORT
void update_icon (GtkTreeModel *treemodel, GtkTreeIter * iterator)
{
    GtkTreeIter parent;
    GdkPixbuf *Icon;
    tree_entry_t *en;
    tree_entry_t *p_en = NULL;
    gtk_tree_model_get(treemodel, iterator, ENTRY_COLUMN, &en, -1);
    if (!en) return;   
    if(gtk_tree_model_iter_parent(treemodel, &parent, iterator))
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);    

    if(!tree_details || !tree_details->window)
	return;
    if(!en)
	return;

    if(IS_DUMMY_TYPE(en->type) || IS_XF_BLK(en->type) || IS_XF_CHR(en->type))
	return;
    if(IS_DIR(en->type))
    {
	struct stat st;
	stat(en->path, &st);
	if(st.st_mtime != en->st->st_mtime || st.st_ctime != en->st->st_ctime)
	{
	    memcpy(en->st, &st, sizeof(struct stat));
	    en->count = count_files(en->path);
	    Icon = resolve_icon(en, p_en);
	    D(printf(".");fflush(NULL);)
	    update_iconcolumn_for_row(treemodel, iterator,Icon);	
	    update_text_cell_for_row(SIZE_COLUMN,treemodel, iterator,sizetag((off_t)-1, en->count)); 

    	    if (Icon) g_object_unref (G_OBJECT (Icon));    
	}

    }
    /*in_pasteboard(en)==2 implies cut, ==1 implies copy */
    if(IS_CUT(en->type) || in_pasteboard(en)==2)
    {
	/*printf("dbg update icon %s\n",en->path); */
	Icon = resolve_icon(en, p_en);
        update_iconcolumn_for_row(treemodel, iterator,Icon);	
	if (Icon) g_object_unref (G_OBJECT (Icon));    
	if(in_pasteboard(en)==2){
	    SET_CUT(en->type);
	} else {
	    UNSET_CUT(en->type);
	}

    }
    return;
}


G_MODULE_EXPORT
GtkWidget *icon_image (char *id)
{

    if(id)
    {
	GdkPixbuf *Icon;
	GtkIconSet *iconset;
	if(!style) style = gtk_style_new();
	if (strncmp(id,"gtk-",strlen("gtk-"))==0) {
	  Icon = load_stock_icon(id, GTK_ICON_SIZE_SMALL_TOOLBAR);
	  /*Icon = gtk_widget_render_icon(tree_details->window, id, GTK_ICON_SIZE_SMALL_TOOLBAR, NULL);*/
	} else {
	  iconset = MIME_ICON_get_iconset(id,tree_details->window);
	  if(!iconset) return NULL;
	  Icon = gtk_icon_set_render_icon(iconset, style, GTK_DIR_RIGHT, GTK_STATE_NORMAL, GTK_ICON_SIZE_SMALL_TOOLBAR, NULL, NULL);
	}
	if(Icon){
	   GtkWidget *image=gtk_image_new_from_pixbuf(Icon);
	   g_object_unref(G_OBJECT(Icon));
	   return image;
	}
    }
    return NULL;
}


G_MODULE_EXPORT
void recreate_icons (GtkTreeView *treeview)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    /* create new icons */
    if (icon_theme){
	    g_free(icon_theme);
    }
    icon_theme=g_strdup(tree_details->theme);
    
    if (!MIME_ICON_load_theme()){
	    g_warning("Your installation is broken");
    }
    /* reset icons */
    gtk_widget_freeze_child_notify((GtkWidget *) (treeview));
    gtk_tree_model_foreach(treemodel, set_size_icons, (gpointer) (tree_details));
    gtk_widget_thaw_child_notify((GtkWidget *) (treeview));
}

G_MODULE_EXPORT
GdkPixbuf *load_stock_icon (const gchar *id, int size){
    gchar *s,*p=NULL;
    GdkPixbuf *pixbuf=NULL;
    if (strncmp(id,"gtk-",strlen("gtk-"))!=0){
	g_warning("load_stock_icon called on non stock item %d",id);
	return NULL;
    }
    s = g_strconcat("stock_",id+strlen("gtk-"),".png",NULL);
    /*for (p=s;*p;p++) if (*p=='-') *p='_';*/
    p=MIME_ICON_find_pixmap_file ((const gchar *)s);
    if (p) {
      pixbuf = icon_tell(size,s);
      g_free(p);
    }
    D(else g_warning("cannot locate %s",s);)
    g_free(s);
    if (pixbuf) return pixbuf;

    pixbuf=gtk_widget_render_icon(tree_details->window,id,size, NULL);
    return pixbuf;
}

G_MODULE_EXPORT
void on_full_preview1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}
