/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#include <errno.h>
#include <glob.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "add_file.h"
#include "entry.h"
#include "cpy.h"
#include "new.h"
#include "ls.h"
#include "misc.h"
#include "smb_misc.h"
#include "monitor.h"
#include "remove.h"
#include "trash.h"
#include "widgets.h"
#include "smb_download.h"



enum
{
    WASTE,
    UNLINK,
    SCHRED
};

extern int stop;
static GList *remove_list = NULL;
static GList *remote_remove_list = NULL;
static gboolean waste = TRUE;
static gboolean unlink_mode = FALSE;
static gboolean all;
static gboolean cancel_remove;
static gchar *remote_pass=NULL;
static gchar *remote_location=NULL;
static gboolean invalid_input = FALSE;

static gboolean on_destroy_event(GtkWidget * widget, 
		GdkEvent * event, gpointer user_data);
static void on_remove_no_activate(GtkButton * button, gpointer user_data);
static void on_remove_yes_activate(GtkButton * button, gpointer user_data);
static void on_remove_all_toggled(GtkToggleButton * togglebutton, gpointer user_data);



static char  *CreateRmTmpList(GtkTreeView *treeview){
  GList *tmp;
  tree_entry_t *en;
  FILE *tmpfile;
  gchar *path,*directory=NULL,*file=NULL;
  static char *fname=NULL;
       
  if ((fname=randomTmpName(NULL))==NULL) return NULL;
  if ((tmpfile=fopen(fname,"w"))==NULL) return NULL;

  for (tmp=remote_remove_list;tmp;tmp=tmp->next){
    GtkTreeIter iter;
    get_entry_from_reference(treeview, 
		    (GtkTreeRowReference *) tmp->data, &iter, &en);  
    path=strstr(en->path+2,"/")+1; /* this gives us path with share.*/    
    path=g_strdup(strstr(path,"/"));/* this gives us the path.*/
    file=strrchr(path,'/');
    if (!file) g_assert_not_reached();
    file++;
    if (!strlen(file)) g_assert_not_reached();
    directory=g_strdup(path);
    if (!strchr(directory,'/')) g_assert_not_reached();
    *(strrchr(directory,'/'))=0;
    if (!strlen(directory)) {directory[0]='/';directory[1]=0;}
    /* smbclient is screwed with window server here. */
    fprintf(tmpfile,"cd \"%s\";\n",directory);
    if (IS_NETDIR(en->subtype)){
	fprintf(tmpfile,"rmdir \"%s\";\n",file);
        /*fprintf(tmpfile,"cd /;rmdir \"%s\\\";\n",t);	     */
     } else {
        if (!IS_SAMBA_SERVER(en->subtype)){
	  char *g;
	  for(g=file;*g;g++)if (*g=='/')*g='\\';
	}
	fprintf(tmpfile,"del \"%s\";\n",file);
     }
     g_free(path);
     g_free(directory);
   }
   fclose (tmpfile);
   return fname;
}


static gboolean schredit(char *path)
{
    return TRUE;
}


gboolean unlinkit(GtkTreeView * treeview, char *path)
{
    struct stat st;

    process_pending_gtk();
    if(stop)
    {
	tree_details_t *tree_details = get_tree_details(treeview);
	stop = FALSE;
	cancel_remove = TRUE;
	hide_stop(tree_details->window);
	return FALSE;
    }
    if(cancel_remove)
	return FALSE;
    if(lstat(path, &st) < 0)
    {
	print_diagnostics(treeview, "xf_ERROR_ICON",
			    strerror(errno),":",path, "\n", NULL);
	return FALSE;
    }
    if(!S_ISDIR(st.st_mode))
    {
	if(unlink(path) < 0)
	{
	    print_diagnostics(treeview, "xf_ERROR_ICON",
			    strerror(errno),":",path, "\n", NULL);
	    return FALSE;
	}
#if 0
	/* this sloooows things down */
	if(path && strlen(path) >= 2)
	    print_status(treeview, "xf_WARNING_ICON", _("Deleted"), " ", __VY_FN__(path), NULL);
#endif
	return TRUE;
    }
    else
    {
	gchar *fullpath;
	DIR *directory;
	struct dirent *dir;
	directory = opendir(path);
	if(!directory)
	{
	    return FALSE;
	}
	while((dir = readdir(directory)) != NULL && !cancel_remove)
	{
	    if(strcmp(dir->d_name, ".") == 0 || strcmp(dir->d_name, "..") == 0)
		continue;

	    fullpath=g_strconcat(path,"/",dir->d_name,NULL);

	    if(!unlinkit(treeview, fullpath))
	    {
		g_free(fullpath);
		return FALSE;
	    }
	    g_free(fullpath);
	}
	closedir(directory);
	if(cancel_remove)
	    return FALSE;
	if(rmdir(path) < 0)
	{
	    print_diagnostics(treeview, "xf_ERROR_ICON",
			    strerror(errno),":",path, "\n", NULL);
	    return FALSE;
	}
    }
#if 0
    if(strstr(path, "/..Wastebasket/"))
    {
	char *p = g_strdup(path);
	*(strrchr(p, '/')) = 0;
	/*printf("DBG:unlinking %s\n",path); */
	rmdir(p);
	g_free(p);
    }
#endif
    return TRUE;
}


static void move2trash(GtkTreeView * treeview, char *path)
{
    struct stat st;

    lstat(path, &st);
    if(S_ISDIR(st.st_mode))
    {
	char *globstring;
	glob_t dirlist;
	globstring = (char *)malloc(strlen(path) + 3);
	if(!globstring)
	    g_assert_not_reached();
	sprintf(globstring, "%s/*", path);
	if(glob(globstring, GLOB_ERR, NULL, &dirlist) == 0)
	{
	    int i;
	    for(i = 0; i < dirlist.gl_pathc; i++)
	    {
		/*printf("DBG:move2trash %s\n",dirlist.gl_pathv[i]); */
		move2trash(treeview, dirlist.gl_pathv[i]);
	    }
	}
	g_free(globstring);
	globfree(&dirlist);
    }
    add2trash(treeview, path);
}

gboolean wasteit(GtkTreeView * treeview, char *path)
{
    gchar *directory;
    gchar *wastepath=NULL;
    gchar *wastename=NULL;
    tree_details_t *tree_details = get_tree_details(treeview);
    if(!strchr(path, '/'))
	g_assert_not_reached();
    if(strlen(path) == 1)
	return FALSE;
    directory = g_path_get_dirname(path);
    wastepath=g_strconcat(directory,"/..Wastebasket",NULL);
    g_free(directory);
    /*printf("DBG:wastepath=%s\n",wastepath); */
    if(access(wastepath, F_OK) != 0)
    {
	if(mkdir(wastepath, 0xFFFF) < 0){
	    print_diagnostics(treeview, "xf_ERROR_ICON",
			    strerror(errno), "\n", NULL);
	    g_free(wastepath);
	    return FALSE;
	}

    }
    wastename=g_strconcat( wastepath,"/",strrchr(path, '/') + 1,NULL);
    /*printf("DBG:wastename=%s path=%s\n",wastename,path); */
    if(access(wastename, F_OK) == 0)
    {
	/* too harsh: if (!unlinkit(wastename)) return FALSE; */
	gchar *wastebackup=NULL;
	wastebackup=g_strconcat(wastepath,"/",
			new_name(wastepath, strrchr(wastename, '/') + 1),
			NULL);
	/*printf("DBG:wastebackup=%s\n",wastebackup); */
	if(rename(wastename, wastebackup) < 0){
	    print_diagnostics(treeview, "xf_ERROR_ICON",
			    strerror(errno), "\n", NULL);
	    g_free(wastebackup); 
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	if(rename(path, wastename) < 0){
	    print_diagnostics(treeview, "xf_ERROR_ICON",
			    strerror(errno), "\n", NULL);
	    g_free(wastebackup); 
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	/* ENABLE_AUTO_T is really to disable */
	if(!(tree_details->preferences & ENABLE_AUTO_T))
	    move2trash(treeview, wastebackup);
    }
    else
    {
	if(rename(path, wastename) < 0){
	    print_diagnostics(treeview, "xf_ERROR_ICON",
			    strerror(errno), "\n", NULL);
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	if(!(tree_details->preferences & ENABLE_AUTO_T))
	    move2trash(treeview, wastename);
    }
    g_free(wastename);
    g_free(wastepath);
    return TRUE;
}



static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en = get_entry(treeview, iter);
    GtkTreeRowReference *reference;
    if(!en || invalid_input) return;
     /*don't allow a remove of IS_ROOT_TYPE (for now)*/
    if(IS_ROOT_TYPE(en->type))
	return;
    if(!IS_PATH(en->type)&&!IS_NETDIR(en->subtype)&&!IS_NETFILE(en->subtype))
	return;
    if(strstr(en->path, "/..Wastebasket")||IS_TRASH_TYPE(en->type)||
      IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)){
	unlink_mode = TRUE;
	if (IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)){
	   gchar *server_pass=g_strdup(en->tag);
	   gchar *location=g_strdup(en->path);
	   if (!strchr(location+2,'/')) g_assert_not_reached();
	   strtok(strchr(location+2,'/')+1,"/");
	   /*printf("DBG:location=%s\n",location);*/
	   if (!location || !strlen(location)) g_assert_not_reached();
   	   if (!remote_location)remote_location=location;
	   else {
	     if (strcmp(remote_location,location)!=0)invalid_input=TRUE;
	     g_free(location);
	   }
   	   if (!remote_pass)remote_pass=server_pass;
	   else {
	     if (strcmp(remote_pass,server_pass)!=0)invalid_input=TRUE;
	     g_free(server_pass);
	   }
	}
    }
    if (IS_PATH(en->type)&&remote_location) invalid_input=TRUE;
    tree_details->selectionOK++;
    reference = gtk_tree_row_reference_new(treemodel, path);
    remove_list = g_list_append(remove_list, reference);    
    return;
}

GList *clear_remove_list(GList *list)
{
    GList *tmp = list;
    while(tmp)
    {
	if(tmp->data)
	{
	    GtkTreeRowReference *reference;
	    reference = (GtkTreeRowReference *) tmp->data;
	    gtk_tree_row_reference_free(reference);
	}
	tmp = tmp->next;
    }
    g_list_free(list);
    return NULL;

}

static void make_dialog(GtkTreeView * treeview, gboolean question)
{
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeIter iter;
    tree_entry_t *en;
    gchar *mess=NULL;
    gchar *mess1=NULL;

    if(!remove_list)
	return;
    if(tree_details->remove)
	g_assert_not_reached();

    if(stop)
	stop = FALSE;
    hide_stop(tree_details->window);
    tree_details->remove = create_remove();
    gtk_window_set_position(GTK_WINDOW(tree_details->remove), GTK_WIN_POS_MOUSE);

/*  g_signal_connect_object ( 
		  lookup_widget(tree_details->remove,"button203"),
		  "clicked",
                  G_CALLBACK (on_remove_stop_activate),
                  (gpointer)treeview, 0);*/
    g_signal_connect_object(lookup_widget(tree_details->remove, "button204"), "clicked", G_CALLBACK(on_remove_no_activate), (gpointer) treeview, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove, "button224"), "clicked", G_CALLBACK(on_remove_yes_activate), (gpointer) treeview, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove, "togglebutton1"), "toggled", G_CALLBACK(on_remove_all_toggled), (gpointer) treeview, 0);

    g_signal_connect_object(tree_details->remove, "delete-event", G_CALLBACK(on_destroy_event), (gpointer) treeview, 0);
    g_signal_connect_object(tree_details->remove, "destroy-event", G_CALLBACK(on_destroy_event), (gpointer) treeview, 0);

    /* dialog specifics */
    /* FIXME when schred is implemented, dont hide anymore: */
    hideit(tree_details->remove, "radiobutton3");

    /* deleting from a wastebasket forces unlink */
    if (unlink_mode || (getenv("XFFM_DEFAULT_UNLINK") && strlen(getenv("XFFM_DEFAULT_UNLINK"))))
    {
	if(unlink_mode) hideit(tree_details->remove, "radiobutton1");
	gtk_toggle_button_set_active((GtkToggleButton *) lookup_widget(tree_details->remove, "radiobutton2"), TRUE);
    }

    if(tree_details->selectionOK < 2)
    {
	/*hideit(tree_details->remove,"button203"); */
	hideit(tree_details->remove, "togglebutton1");
    }
    gtk_label_set_text((GtkLabel *) lookup_widget(tree_details->remove, 
			    "label16"),"");
    if(question)
    {
	mess1=g_strdup(" ");
	hideit(tree_details->remove, "warning");
    }
    else
    {
	mess1=g_strconcat(" ",_("Try again?"),"\n",NULL);
	hideit(tree_details->remove, "question");
    }

    get_entry_from_reference(treeview, 
		    (GtkTreeRowReference *) remove_list->data, &iter, &en);
    
    
    {
	gchar *t=g_strdup(FILENAME(en));
	if (IS_NETTHING(en->subtype) && !IS_SAMBA_SERVER(en->subtype))
		ascii_readable(t);
        mess=g_strconcat(mess1,_("Remove:"),"\n",
		    	    my_cut_utf_string(t),"\n",
			    "(",time_to_string(en->st->st_mtime)," ",
			    sizetag((long long)en->st->st_size, -1),")",
			    NULL); 
	g_free(t);
    }

    gtk_label_set_text((GtkLabel *) 
		    lookup_widget(tree_details->remove, "label20"), 
		    mess);
    g_free(mess);
    g_free(mess1);
    gtk_widget_realize(tree_details->remove);
    /*gdk_window_set_decorations (
       tree_details->remove->window,
       GDK_DECOR_BORDER); */
    gtk_widget_show(tree_details->remove);

    gtk_window_set_transient_for(GTK_WINDOW(tree_details->remove), GTK_WINDOW(tree_details->window));
    gtk_main();

}

static void do_remove(GtkWidget * widget)
{

    GtkTreeView *treeview = get_selected_treeview(widget);
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);

    g_free(remote_location); remote_location=NULL;
    g_free(remote_pass); remote_pass=NULL;
    
    if(!set_load_wait(&tree_details))
	return;
    tree_details->selectionOK = FALSE;
    all = FALSE;
    unlink_mode = FALSE;
    invalid_input = FALSE;
    gtk_tree_selection_selected_foreach(selection, 
		    check_select, (gpointer) treeview);
    if (invalid_input){
	    remove_list=clear_remove_list(remove_list);
	    tree_details->selectionOK=0;
    }
    unset_load_wait(&tree_details);
    if(!tree_details->selectionOK)
    {
	print_status(treeview, "xf_WARNING_ICON,",strerror(EINVAL),NULL);
	return;
    }

    /*if (tree_details->selectionOK==1) {
	    tree_entry_t *en;
	    GtkTreeIter iter;
	    get_entry_from_reference(treeview, 
			    (GtkTreeRowReference *) remove_list->data, 
			    &iter, &en);	    
	    query_rm(treeview, en->path, NULL);
    	    remove_list = g_list_remove(remove_list, remove_list->data);
    }
    else */
    make_dialog(treeview, TRUE);
}

static void close_it(tree_details_t * tree_details)
{
    gtk_main_quit();
    gtk_widget_destroy(tree_details->remove);
    tree_details->remove = NULL;
}

/*****    dialog callbacks   *****/

gboolean on_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) user_data;
    tree_details_t *tree_details = get_tree_details(treeview);
    close_it(tree_details);
    return TRUE;
}


#if 0
static void on_remove_stop_activate(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) user_data;
    tree_details_t *tree_details = get_tree_details(treeview);


    /*printf("DBG:remove stop\n"); */
    clear_remove_list();
    close_it(tree_details);

}
#endif

static void on_remove_no_activate(GtkButton * button, gpointer user_data)
{
    GtkWidget *check;
    GtkTreeView *treeview = (GtkTreeView *) user_data;
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeRowReference *reference;

    /*printf("DBG:remove no\n"); */
    check = lookup_widget(tree_details->remove, "togglebutton1");
    all = gtk_toggle_button_get_active((GtkToggleButton *) check);
    close_it(tree_details);

  loop:
    reference = (GtkTreeRowReference *) remove_list->data;
    remove_list = g_list_remove(remove_list, remove_list->data);
    gtk_tree_row_reference_free(reference);
    if(all && remove_list)
	goto loop;
    if(remove_list)
	make_dialog(treeview, TRUE);

}


static void on_remove_yes_activate(GtkButton * button, gpointer user_data)
{
    GList *tmp;
    GtkWidget *check;
    int method = WASTE;
    GtkTreeIter iter;
    tree_entry_t *en;
    gboolean result = FALSE;
    GtkTreeView *treeview = (GtkTreeView *) user_data;
    tree_details_t *tree_details = get_tree_details(treeview);

    if(!set_load_wait(&tree_details))
	g_assert_not_reached();

    cancel_remove = FALSE;
    check = lookup_widget(tree_details->remove, "togglebutton1");
    all = gtk_toggle_button_get_active((GtkToggleButton *) check);

    check = lookup_widget(tree_details->remove, "radiobutton1");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check))
	method = WASTE;
    check = lookup_widget(tree_details->remove, "radiobutton2");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check))
	method = UNLINK;
    check = lookup_widget(tree_details->remove, "radiobutton3");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check))
	method = SCHRED;


    close_it(tree_details);
    /* printf("DBG:remove yes\n"); */

    print_status(treeview, "xf_WARNING_ICON", _("Removing"), NULL);

  loop:
    get_entry_from_reference(treeview, (GtkTreeRowReference *) remove_list->data, &iter, &en);
    switch (method)
    {
	case WASTE:
	    /*printf("DBG:remove WASTE %s\n",(char *)remove_list->data); */
	    if(strstr(en->path, "..Wastebasket"))
	    {
#ifdef ENOTSUP
		errno = ENOTSUP;	/* Not supported message */
#else 
#ifdef EOPNOTSUPP
		errno = EOPNOTSUPP;
#else
		errno = ENODEV;
#endif
#endif
		result = FALSE;
	    }
	    else
		result = wasteit(treeview, en->path);
	    break;
	case UNLINK:
	    print_status(treeview,"xf_WARNING_ICON",_("Deleting..."),NULL);
	    if (remote_location){
	      /*printf("DBG: schedule rm %s\n",en->path); */
	      result=TRUE; /* schedule ok */	  
	    }
	    else /* local path */
	    {
	      /*printf("DBG:remove UNLINK %s\n",(char *)remove_list->data); */
	      show_stop(tree_details->window);
	      result = unlinkit(treeview, en->path);
	    }
	    break;
	case SCHRED:
	    /*printf("DBG:remove SCHRED %s\n",(char *)remove_list->data) */ ;
	    result = schredit(en->path);
	    break;
	default:
	    g_assert_not_reached();
    }
    if(cancel_remove)
    {
	print_status(treeview, "xf_ERROR_ICON",
		strerror(ETIMEDOUT),
		NULL);
	unset_load_wait(&tree_details);
	remove_list = g_list_remove(remove_list, remove_list->data);
	hide_stop(tree_details->window);
	return;
    }

    if(!result && errno == ENOENT)
	result = TRUE;		/* duh */
#if 0
    if(result)
    {
	print_status(treeview, "xf_INFO_ICON", "Removed", " ", 
			FILENAME(en), NULL);
    }
    else
    {
	print_diagnostics(treeview, "xf_ERROR_ICON", "Error", " : ", 
			strerror(errno), " ", error_file, "\n", NULL);
	print_status(treeview, "xf_ERROR_ICON", strerror(errno), NULL);
    }
#endif

    if(!result && !all)
    {
	unset_load_wait(&tree_details);
	make_dialog(treeview, FALSE);
	return;
    }

    {
	GtkTreeRowReference *reference;
	reference = (GtkTreeRowReference *) remove_list->data;
    	if (result) remote_remove_list = g_list_append(remote_remove_list,reference); 
        remove_list = g_list_remove(remove_list, remove_list->data);
    }
    
    if(all && remove_list) goto loop;
    unset_load_wait(&tree_details);
    if(remove_list) make_dialog(treeview, TRUE);
    hide_stop(tree_details->window);
    
    if (remote_location){
      char *rmfile;
      
      /*printf("DBG: this here creates the rm command file...\n");*/
      rmfile=CreateRmTmpList(treeview);
      if (!rmfile || !remote_pass){
	      print_diagnostics(treeview,"xf_ERROR_ICON",strerror(EPERM),NULL);
	      if (rmfile) unlink(rmfile);
      }
      else {
            /*printf("DBG: this here does the SMB delete:%s \n",rmfile);*/
	    /*FIXME: if files cannot be removed, then SMBrmFile should 
	     * remove them from the remote_remove_list.
	     * */
	     remote_remove_list=SMBrmFile (treeview,remote_location,
			     remote_pass,rmfile,
	     		     remote_remove_list);
	    
	     unlink(rmfile);
    	     print_status(treeview, "xf_INFO_ICON", 
		    _("Command done"), NULL);
      }
    } else print_status(treeview, "xf_INFO_ICON", 
		    _("Command done"), NULL);
 
    /*printf("DBG:    clean up remote_remove_list...\n");*/
    /* local and net files, removed from tree */
    for (tmp=remote_remove_list;tmp;tmp=tmp->next){
	remove_it(treeview,(GtkTreeRowReference *) tmp->data);
    }
    
    remote_remove_list=clear_remove_list(remote_remove_list);

    return;
}

/**************/

static char dlg_result;


static void on_single_rm_no_activate(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) user_data;
    tree_details_t *tree_details = get_tree_details(treeview);
    dlg_result = DLG_NO;
    close_it(tree_details);
}


static void on_single_rm_yes_activate(GtkButton * button, gpointer user_data)
{
    GtkWidget *check;
    GtkTreeView *treeview = (GtkTreeView *) user_data;
    tree_details_t *tree_details = get_tree_details(treeview);
    waste = TRUE;
    dlg_result = DLG_YES;
    check = lookup_widget(tree_details->remove, "radiobutton2");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check))
	waste = FALSE;

    close_it(tree_details);
}

static void make_single_rm_dialog(GtkTreeView * treeview, 
		char *nfile, char *ofile, gboolean err)
{
    gchar *mess=NULL,*mess1=NULL;
    struct stat st;
    tree_details_t *tree_details = get_tree_details(treeview);
    if(tree_details->remove)
	g_assert_not_reached();
    if (!nfile) g_assert_not_reached();

    waste = TRUE;
    tree_details->remove = create_remove();
    gtk_window_set_position(GTK_WINDOW(tree_details->remove), 
		    GTK_WIN_POS_MOUSE);

    g_signal_connect_object(lookup_widget(tree_details->remove, "button204"), 
		    "clicked", G_CALLBACK(on_single_rm_no_activate), 
		    (gpointer) treeview, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove, "button224"), 
		    "clicked", G_CALLBACK(on_single_rm_yes_activate), 
		    (gpointer) treeview, 0);

    g_signal_connect_object(tree_details->remove, "delete-event", 
		    G_CALLBACK(on_destroy_event), (gpointer) treeview, 
		    0);
    g_signal_connect_object(tree_details->remove, "destroy-event", 
		    G_CALLBACK(on_destroy_event), (gpointer) treeview, 
		    0);

    /* dialog specifics */
    /* no real use schreding before overwriting */
    hideit(tree_details->remove, "radiobutton3");

    gtk_label_set_text((GtkLabel *) 
			lookup_widget(tree_details->remove, "label16"),
		       	"");   
    if(err)
    {
	hideit(tree_details->remove, "question");	
	mess1=g_strconcat(" ",_("Try again?"),"\n",NULL);
	hideit(tree_details->remove, "question");
    } else {
	hideit(tree_details->remove, "warning");
	mess1=g_strdup(" ");
    }


    /* working in a wastebasket forces unlink */
    if((ofile && strstr(ofile,"../Wastebasket"))||
       (getenv("XFFM_DEFAULT_UNLINK") && strlen(getenv("XFFM_DEFAULT_UNLINK"))))
    {
	if(ofile && strstr(ofile,"../Wastebasket")) 
		hideit(tree_details->remove, "radiobutton1");
	gtk_toggle_button_set_active((GtkToggleButton *) 
			lookup_widget(tree_details->remove, "radiobutton2"), 
			TRUE);
    }
   
    lstat(nfile,&st);
    mess=g_strconcat(mess1,(ofile)?_("Overwrite:"):_("Remove:"),"\n",
		    	    my_cut_utf_string(nfile),"\n",
			    "(",time_to_string(st.st_mtime)," ",
			    sizetag((long long)st.st_size, -1),")",
			    NULL); 

    gtk_label_set_text((GtkLabel *) 
		    lookup_widget(tree_details->remove,"label20"), 
		    mess);
    g_free(mess);
    g_free(mess1);
    gtk_widget_realize(tree_details->remove);
    gtk_widget_show(tree_details->remove);

    gtk_window_set_transient_for(GTK_WINDOW(tree_details->remove), 
		    GTK_WINDOW(tree_details->window));
    /*hideit (tree_details->remove, "button203"); */
    hideit(tree_details->remove, "togglebutton1");
    gtk_main();
    return ;

}



int query_rm(GtkTreeView * treeview, char *nfile, 
		char *ofile){	 
	gboolean err=FALSE;
    	dlg_result = DLG_NO;
try_again:
 	make_single_rm_dialog(treeview, 
			nfile, ofile, err);
	if(dlg_result == DLG_YES)
	{
	    if(waste){
		if(!wasteit(treeview, nfile)) {
		        err=TRUE;
			goto try_again;
		}
	    } else {
		if (unlink(nfile)<0) {
		        err=TRUE;
			goto try_again;
		}
	    }
	    return TRUE;
	}
	return FALSE;
}


/*****    global callbacks   *****/

static void on_remove_all_toggled(GtkToggleButton * togglebutton, gpointer user_data)
{
}

void on_remove_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    do_remove((GtkWidget *) menuitem);

}

void tb_delete(GtkButton * button, gpointer user_data)
{
     do_remove((GtkWidget *) button);
}
