
/*
 * Copyright (C) 2002-2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <unistd.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "misc.h"


typedef struct help_message_t {
	int id;
	char *message;
}help_message_t;

help_message_t help_widgets[]={
	{1,"book1"},
	{2,"local1"},
	{3,"smb_network1"},
	{4,"applications1"},
	{5,"find4"},
	{6,"trash1"},
	{7,"fstab1"},
	{8,"TERM"},
	{9,"XFFM_HOLD_XTERM"},
	{10,"XFFM_HOME"},
	{11,"XFFM_STATUS_LINE_LENGTH"},
	{12,"XFFM_MAX_PREVIEW_SIZE"},
	{13,"XFFM_APPEND_FILES"},
	{14,"XFFM_HIDE_BOOK"},
	{15,"XFFM_HIDE_LOCAL"},
	{16,"XFFM_HIDE_NETWORK"},
	{17,"XFFM_HIDE_APPS"},
	{18,"XFFM_HIDE_FIND"},
	{19,"XFFM_HIDE_TRASH"},
	{20,"XFFM_HIDE_FSTAB"},
	{21,"SMB_USER"},
	{22,"SMB_CODESET"},
	/*{,""},*/
	{0,NULL}
	
};

static help_message_t help_message[]={
/*BRANCHES*/
	/*Book*/
	{1,N_("This is a branch where you can drag and drop or cut and paste your favorite folders or files. Once in the book, you can perform all normal operations on them. Items that can be booked:\n--local folders\n--local files\n--remote SMB servers\n--remote SMB shares\n--remote SMB folders\n--remote SMB files")},
/* Local */
	{2,N_("This is where local file system navigation is done. You open and close folders and use drag and drop and cut and paste in the traditional way.")},
       	/* SMB Network */
	{3,N_("This is where SMB network navigation is done. You have different element types here: Workgroups, Servers, Shares, Network directories and Network files.")},
/* Applications */
	{4,N_("This is a tree representation of the xfce4 panel. To configure it, configure the panel. Only valid applications in the panel configuration are shown. To execute a particular application, double click on it. You can also drag and drop or cut and paste to the applications to pass on arguments.")},
/* Find */
	{5,N_("In this branch the results of searches will be listed. You may use all the normal file operations on the find results. You can search for files based on name, content or other qualifiers.")},
/* Trash */
	{6,N_("This branch represents a new concept in trash management. Instead of having a single directory to put all trashed files, xffm uses wastebaskets.\nEach directory has its wastebasket (when needed only), just like every office in a building has its wastebasket.\nThe trash bin is the place where all the wastebaskets are collected, just as all the trash in an office building is collected into a huge trashbin in the alley. Just as the trashbin in the alley, it's not a good place to recover something (except in desperate situations). Trash recovery is best done at the office (or directory) level from the wastebasket.\nTabulation of wastebasket contents into the trash bin is done automatically (but may be turned off). Additionally, you may tabulate the contents of wastebaskets of any directory on demand, using the \"Collect trash\" tool. It will even tabulate trash from GNOME or KDE trash bins.")},
/* Fstab */
	{7,N_("This is the branch used to mount/unmount filesystems listed in the fstab file. You can mount/unmount by double clicking on the entries or selecting the mount/unmount options from the popup or main menu.")},

/*Environment variables*/
/* TERM */
	{8,N_("TERM: this environment variable, if defined, will set what terminal command to use, default: xterm.")},
/* XFFM_HOLD_XTERM */
	{9,N_("XFFM_HOLD_XTERM: this environment variable, if defined, will instruct xffm to hold output of xterms, default: off. Only applies to xterm.")},
/* XFFM_HOME */
	{10,N_("XFFM_HOME: this environment variable, if defined, will set the home directory for local files, default: $HOME.")},
/* XFFM_STATUS_LINE_LENGTH */
	{11,N_("XFFM_STATUS_LINE_LENGTH: this environment variable, if defined, will set the cutoff length of status line messages, default 48 characters.")},
/* XFFM_MAX_PREVIEW_SIZE */
	{12,N_("XFFM_MAX_PREVIEW_SIZE: this environment variable, if defined, will set the maximum size of images to preview, default 256KB")},
/* XFFM_APPEND_FILES */
	{13,N_("XFFM_APPEND_FILES: this environment variable, if defined, will instruct the xffm monitor to place new files at the bottom of folder. Otherwise, the xffm monitor will place them at the top.")},
/* XFFM_HIDE_BOOK */
	{14,N_("XFFM_HIDE_BOOK: this environment variable will hide the book branch.")},
/* XFFM_HIDE_LOCAL */
	{15,N_("XFFM_HIDE_LOCAL: this environment variable will hide the local files branch.")},
/* XFFM_HIDE_NETWORK */
	{16,N_("XFFM_HIDE_NETWORK: this environment variable will hide the SMB network branch.")},
/* XFFM_HIDE_APPS */
	{17,N_("XFFM_HIDE_APPS: this environment variable will hide the applications branch.")},
/* XFFM_HIDE_FIND */
	{18,N_("XFFM_HIDE_FIND: this environment variable will hide the find branch.")},
/* XFFM_HIDE_TRASH */
	{19,N_("XFFM_HIDE_TRASH: this environment variable will hide the branch.")},
/* XFFM_HIDE_FSTAB */
	{20,N_("XFFM_HIDE_FSTAB: this environment variable will hide the fstab branch.")},
/* SMB_USER */
	{21,N_("SMB_USER: this environment variable sets user%password to use as default in SMB network. Default:GUEST%. (Using valuable passwords in insecure networks in this fashion might be a bad idea.)")},
/* SMB_CODESET */
	{22,N_("SMB_CODESET: if codeset cannot be determined from $LANG, this environment variable sets the codeset for correct display of accentuated or cyrillic characters on samba 2.x series, defaults to ISO-8859-1. YMMV.")},

/* KNOWN BUGS */
/*  */
	{0,NULL}
};


char *get_help_txt(int id){
  int i;
  for (i=0;help_message[i].id;i++){
	if (id==help_message[i].id) 
		return help_message[i].message;
  }
  return NULL;
}

void on_about2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GdkPixbuf *pixbuf;
    FILE *file;
    char path[_POSIX_PATH_MAX],line[256];
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    tree_details_t *tree_details = get_tree_details(treeview);

    sprintf(path,"%s/%s/AUTHORS",PACKAGE_DATA_DIR,PACKAGE);
    file=fopen(path,"r");
    if (file) {
	    while (fgets(line,255,file) && !feof(file)){
		    line[255]=0;
		    print_diagnostics(treeview, NULL,
		    line,NULL);
    process_pending_gtk();

		    usleep(400000);
	    }
	    fclose(file);
    }

    pixbuf = gtk_image_get_pixbuf((GtkImage *) 
		    create_pixmap(tree_details->window,"ubu_head.jpg"));
    print_diagnostics(treeview, NULL,
		     "(C) Edscott Wilson Garcia 2001-2003\n",
		     NULL);
    process_pending_gtk();

    usleep(1500000);
    print_diagnostics_tmp(treeview, pixbuf,
		     "\"Toqui toqui! kiuo kiou!\"",
		     NULL);
    process_pending_gtk();

    usleep(2500000);
    print_diagnostics_tmp(treeview, NULL,"\n",PACKAGE," ",VERSION,"\n",NULL);

}

void print_help (GtkMenuItem * menuitem, gpointer user_data)
{
    int lastchar=0;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
/*    tree_details_t *tree_details = get_tree_details(treeview);*/
    gchar *p,*g=g_strdup(my_utf_string(_(get_help_txt((int)((long)user_data)))));
    
    p=g;
    if (!p) return;
    print_diagnostics(treeview,"xf_HELP_ICON"," ",NULL);

    do {
      gunichar u;
      gchar o[13];
      int len;
      u=g_utf8_get_char(p);
      len=g_unichar_to_utf8(u,o);
      o[len]=0;
      print_diagnostics(treeview,NULL,o,NULL);
      p=g_utf8_next_char(p);
    process_pending_gtk();

      gdk_flush();
      switch (lastchar){
	      case '\n': usleep(1500000); break;
	      case '.':  
              case ';': usleep(700000);break;
	      case ':':
	      case  ',': usleep(300000);break;
	      default: usleep(4000);break;
      }
      lastchar=*p;
    } while (p && *p);
    /*usleep(1500000);*/
    print_diagnostics(treeview, NULL,"\n",NULL);
    print_diagnostics(treeview, "xf_INFO_ICON",PACKAGE," ",VERSION,"\n",NULL);
    g_free(g);
}

void connect_help(GtkTreeView *treeview){
  GtkWidget *w;
  int i;
  for (i=0;help_widgets[i].message;i++){
    w=lookup_widget((GtkWidget *)treeview,help_widgets[i].message);
    g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (print_help),
                   (gpointer)((long)help_widgets[i].id));
  }
}

