/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "entry.h"
#include "icons.h"
#include "input.h"
#include "misc.h"
#include "monitor.h"
#include "run.h"
#include "widgets.h"
#include "remove.h"



int scramble_it(GtkTreeView * treeview, GtkTreeIter * iter, char *file, gboolean scram)
{

    struct stat st;
    char nfile[_POSIX_PATH_MAX];
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    tree_entry_t *en;
    char *scramble_cmd;

    if(!file)
	g_assert_not_reached();
    if(!set_load_wait(&tree_details))
	return FALSE;
    if(scram)
	scramble_cmd = "scramble -e";
    else
	scramble_cmd = "scramble -d";

    if(!file)
	g_assert_not_reached();

    sprintf(nfile, "%s.cyt", file);
    if(lstat(nfile, &st) >= 0)
    {
	if (!query_rm(treeview, nfile, nfile)){
    		    unset_load_wait(&tree_details);
		    return FALSE;
	}
    }

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);

    {
	int status;
	char *argv[10], *term="xterm";
	pid_t child;
	if (getenv("TERM") && strlen( getenv("TERM"))){
		gchar *c=g_find_program_in_path(getenv("TERM"));
		if (c && access(c,X_OK)==0) term = getenv("TERM");
		g_free(c);	
	}



	argv[0] = term;
	argv[1] = "-e";
	argv[2] = "scramble";
	argv[3] = (scram) ? "-e" : "-d";
	argv[4] = en->path;
	argv[5] = 0;
	child = fork();
	if(child < 0)
	    g_assert_not_reached();
	if(!child)
	{
	    execvp(argv[0], argv);
	    _exit(1);
	}
	print_status(treeview, "xf_INFO_ICON", _("Executing"), " ", scramble_cmd, NULL);
	do
	{
    process_pending_gtk();
	    usleep(50000);
	}
	while(!waitpid(child, &status, WNOHANG));
    }



    unset_load_wait(&tree_details);
    return TRUE;
}



/*   callback  */

void on_scramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    en = get_selected_entry(treeview, &iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(treeview, "xf_ERROR_ICON", strerror(EINVAL), NULL);
	return;
    }
    show_input(treeview, SCRAMBLE_INPUT);

}

void on_unscramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    en = get_selected_entry(treeview, &iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(treeview, "xf_ERROR_ICON", strerror(EINVAL), NULL);
	return;
    }
    show_input(treeview, UNSCRAMBLE_INPUT);

}
