/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include <errno.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#ifdef XFCE_SUPPORT
#include <libxfce4util/util.h>
#endif

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "goto.h"
#include "entry.h"
#include "duplicate.h"
#include "input.h"
#include "new.h"
#include "misc.h"
#include "monitor.h"
#include "print.h"
#include "rename.h"
#include "run.h"
#include "scramble.h"
#include "symlink.h"
#include "widgets.h"

#define PRINT_STATUS_INPUT print_status(treeview, "xf_QUESTION_ICON", _("Input requested"), NULL)
#define PRINT_STATUS_DONE print_status(treeview, "xf_INFO_ICON", _("Command done"), NULL)

gchar *workdir=NULL;
extern gchar *bookfile;
static GList *list;

#define CURRENT_WORKDIR_HISTORY "xffm%cxffm.workdir.2.dbh"
static void save_workdir_history(char *p){
    char fname[_POSIX_PATH_MAX];
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, CURRENT_WORKDIR_HISTORY,
		    G_DIR_SEPARATOR);
    	save_to_history(fname,p);
}
static GList *set_workdir_combo(GtkTreeView * treeview)
{
    static GList *g=NULL;
    char fname[_POSIX_PATH_MAX];
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkWidget *w;
    int i;
 
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, CURRENT_WORKDIR_HISTORY,
		    G_DIR_SEPARATOR);

    if (access(fname,F_OK)!=0){
	    /* create a new list  */
    	const gchar *cname=g_get_home_dir();
    	if (!cname) cname=g_get_tmp_dir();
    	if (!cname) cname="/";
    	save_to_history(fname,(char *)cname);
    }
    get_history_list(&g,fname,"");
    w = lookup_widget(tree_details->window, "input_combo");
   
    gtk_combo_set_popdown_strings(GTK_COMBO(w),g );
    return g;
}


static gint on_key_press(GtkWidget * entry, GdkEventKey * event, gpointer data)
{
    void ok_input(GtkTreeView * treeview);
    GtkTreeView *treeview = (GtkTreeView *) data;

    /*printf("DBG(1):got key= 0x%x\n",event->keyval);*/
    if(event->keyval == GDK_Escape)
    {
	cancel_input(treeview);
	print_status(treeview,"xf_INFO_ICON",_("Cancelled"),NULL);
	gtk_widget_grab_focus((GtkWidget *) treeview);
	
	return (TRUE);
    }
    return (FALSE);
}
static gint on_key_press2(GtkWidget * entry, GdkEventKey * event, gpointer data)
{
    void ok_input(GtkTreeView * treeview);
    gchar *text[2];
    gchar c[]={0,0};
    gchar *fulltext;
    GList *tmp;
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkEditable *editable=(GtkEditable *)entry;
    gint pos2,pos=gtk_editable_get_position(editable);
   /* printf("DBG(2):got key= 0x%x\n",event->keyval);*/
    
 if (event->keyval == GDK_BackSpace) {
	if (event->state&GDK_CONTROL_MASK){
	    gtk_editable_delete_text (editable,0,-1);
	    return TRUE;
	}
 }
 if (event->keyval == GDK_Tab) {
	gint start,end,i;
    	if (gtk_editable_get_selection_bounds(editable,&start,&end)){
	/*printf("selection at %d %d\n",start,end);*/
	  for (;start<=end;start++){
		gchar *p;
		p=gtk_editable_get_chars (editable,start,end);
		/*printf("start=%d got char %s\n",start,p);*/
		if (*p =='/') {
			gtk_editable_delete_text (editable,start,end);
			g_free(p);
			break;
		}
		g_free(p);
	  }
   	  gtk_editable_select_region (editable, 0,0);
    	  gtk_editable_set_position(editable,-1);
	  return(TRUE);
	  
	}
    
   
    return TRUE;
 }

 if ((event->keyval >= GDK_A && event->keyval <= GDK_Z) || 
	    (event->keyval >= GDK_a && event->keyval <= GDK_z) ){
	 if (event->keyval >= GDK_a && event->keyval <= GDK_z)
		*c=event->keyval - GDK_a + 'a';
	 else
		*c=event->keyval - GDK_A + 'A';
	    
    /* get entry text */
    text[0]=gtk_editable_get_chars (editable,0,pos);
    text[1]=gtk_editable_get_chars (editable,pos+1,-1);
    fulltext=g_strconcat(text[0],c,text[1],NULL);
    g_free(text[0]);
    g_free(text[1]);

    /* look for in ordered GList*/
    for (tmp=list;tmp;tmp=tmp->next){
	gchar *p=(gchar *)tmp->data;
	if (!p) continue;
	if (strncmp(fulltext,p,strlen(fulltext))==0){
	    gchar *to_write=p+strlen(fulltext);
	    /*printf("DBG: gotcha %s->%s, to write=%s\n",fulltext,p,to_write);*/
            /* if found, complete with untyped part selected.*/
	    gtk_editable_delete_text (editable,0,-1);
	    pos=0;
	    gtk_editable_insert_text (editable,(const gchar *)fulltext,
			     strlen(fulltext),&pos);
	    pos2=pos;
	    gtk_editable_insert_text (editable,(const gchar *)to_write,
			     strlen(to_write),&pos2);
    	    gtk_editable_select_region (GTK_EDITABLE (entry), pos, -1);

	    return TRUE;
	}
    }
 }
			    
    return (FALSE);
}


void show_input(GtkTreeView * treeview, int which)
{
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkCheckButton *check_button1, *check_button2;
    GtkLabel *label;
    GtkEntry *entry;
    GtkWidget *combo;
    /*GtkToggleButton *w; */
    GtkTreeIter iter;
    char *path, *name;
    tree_entry_t *en;
    gchar *sname;

    if(tree_details->tubo_object)
	g_assert_not_reached();
    
    if (tree_details->input != OTHER_INPUT){
      cancel_input(treeview);
    }

    label = (GtkLabel *) lookup_widget(tree_details->window, "input_label");
    entry = (GtkEntry *) lookup_widget(tree_details->window, "input_entry");
    combo = lookup_widget(tree_details->window, "input_combo");
    hideit(tree_details->window, "filter_box");
    showit(tree_details->window, "input_box");
    showit(tree_details->window, "input_combo");
    /* tie escape to cancel: */
    g_signal_connect(G_OBJECT(combo), "key_press_event", 
		    G_CALLBACK(on_key_press), (gpointer) treeview);


    hideit(tree_details->window, "checkbutton1");
    hideit(tree_details->window, "checkbutton2");

    check_button1 = (GtkCheckButton *) lookup_widget(tree_details->window, "checkbutton1");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button1))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, FALSE);
    if (which==NEW_INPUT)
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, TRUE);

    check_button2 = (GtkCheckButton *) lookup_widget(tree_details->window, "checkbutton2");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button2))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button2, FALSE);

    tree_details->input = which;

    en = get_selected_entry(treeview, &iter);
    if(!en || !en->path)
    {
#ifdef XFCE_SUPPORT
	path = g_strdup(xfce_get_homedir());
#else
	path = g_strdup(g_get_home_dir());
#endif
	name = _("New");
    }
    else
    {
	path = g_strdup(en->path);
	if(IS_PATH(en->type))
	{
	    name = strrchr(path, '/');
	    *name = 0;
	    name++;
	}
	else
	{
	    name = _("New");
	}
    }


    switch (which)
    {
	case OPEN_BOOK_INPUT: 
	{	
	    set_book_combo(treeview);
	    gtk_label_set_text(label,_("Book"));
	    PRINT_STATUS_INPUT;
	    break;
	}
	case NEW_BOOK_INPUT: 
	{	
	    gtk_entry_set_text(entry, "");
	    gtk_label_set_text(label,_("Book"));
	    PRINT_STATUS_INPUT;
	    break;
	}
	case WORKDIR_INPUT: 
	{	
	    list=set_workdir_combo(treeview);
	    gtk_label_set_text(label,workdir?_(workdir):_("Output dir"));
    	    g_signal_connect(G_OBJECT(entry), "key_press_event", 
		    G_CALLBACK(on_key_press2), (gpointer) treeview);
	    PRINT_STATUS_INPUT;
	    break;
	}
	case SYMLINK_INPUT:
	    sname=g_strconcat(name,"-lnk",NULL);
	    gtk_entry_set_text(entry, sname);
	    g_free(sname);
	    gtk_label_set_text(label, _("Name"));
	    PRINT_STATUS_INPUT;
	    break;
	case PRINT_INPUT:
	    gtk_entry_set_text(entry, "lpr");
	    gtk_label_set_text(label, _("Command"));
	    print_status(treeview, "xf_QUESTION_ICON", 
			    " ", 
			    FILENAME(en), NULL);
	    break;
	case SCRAMBLE_INPUT:
	    sname=g_strconcat(_("Confirm"), " ",FILENAME(en),NULL);
	    gtk_label_set_text(label, sname);
	    g_free(sname);    
	    hideit(tree_details->window, "input_combo");
	    print_status(treeview, "xf_QUESTION_ICON", 
			    _("Scramble"),
			    NULL);
	    break;
	case UNSCRAMBLE_INPUT:
	    sname=g_strconcat(_("Confirm"), " ",FILENAME(en),NULL);
	    gtk_label_set_text(label, sname);
	    g_free(sname);    
	    hideit(tree_details->window, "input_combo");
	    print_status(treeview, "xf_QUESTION_ICON", 
			    _("Unscramble"), NULL);
	    break;
	case RENAME_INPUT:
	    gtk_entry_set_text(entry, new_name(path, name));
	    gtk_label_set_text(label, _("Name"));
	    PRINT_STATUS_INPUT;
	    break;
	case DUPLICATE_INPUT:
	    gtk_entry_set_text(entry, new_name(path, name));
	    gtk_label_set_text(label, _("Name"));
	    PRINT_STATUS_INPUT;
	    break;


	case NEW_INPUT:
	    set_new_combo(treeview);
	    gtk_label_set_text(label, _("Name"));
	    print_status(treeview, "xf_QUESTION_ICON", _("Name"), NULL);
	    gtk_button_set_label((GtkButton *) check_button1, _("Directory"));
	    showit(tree_details->window, "checkbutton1");


	    break;
	case GOTO_INPUT:
	    list=set_goto_combo(treeview);
	    gtk_label_set_text(label, _("Go to"));
	    PRINT_STATUS_INPUT;
    	    g_signal_connect(G_OBJECT(entry), "key_press_event", 
		    G_CALLBACK(on_key_press2), (gpointer) treeview);
	    break;
	case RUN_INPUT:
	case RUN_DOUBLE_CLICK:
	    switch (which)
	    {
		case RUN_INPUT:
		    list=set_run_combo(treeview);
		    gtk_label_set_text(label, _("Run"));
		    PRINT_STATUS_INPUT;
    	    g_signal_connect(G_OBJECT(entry), "key_press_event", 
		    G_CALLBACK(on_key_press2), (gpointer) treeview);
		    break;
		case RUN_DOUBLE_CLICK:
		    list=set_run_combo(treeview);
		    gtk_label_set_text(label, _("Open with"));
		    gtk_button_set_label((GtkButton *) check_button2, 
				    _("Remember"));
		    showit(tree_details->window, "checkbutton2");
		    PRINT_STATUS_INPUT;
    	    g_signal_connect(G_OBJECT(entry), "key_press_event", 
		    G_CALLBACK(on_key_press2), (gpointer) treeview);
		    break;

	    }

	    gtk_button_set_label((GtkButton *) check_button1, _("In terminal"));
	    showit(tree_details->window, "checkbutton1");
	    break;

	default:
	    break;
    }
    g_free(path);
    gtk_widget_grab_focus((GtkWidget *) entry);
    /* these will preselect */
    
    if (which == NEW_INPUT || which == SYMLINK_INPUT ||
	which ==  RUN_INPUT || which == RUN_DOUBLE_CLICK ||
        which == PRINT_INPUT){
      gtk_editable_set_position(GTK_EDITABLE (entry),0);
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);
    } else {
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, 0);
      gtk_editable_set_position(GTK_EDITABLE (entry),-1);
    }
    if (which==WORKDIR_INPUT) gtk_main();
}

void ok_input(GtkTreeView * treeview)
{
    gchar *choice;
    GtkTreeIter iter;
    GtkEntry *entry;
    int type;
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    gchar *nfile=NULL;
    GtkTreePath *treepath;
    GtkTreeRowReference *reference;


    print_status(treeview,NULL," ",NULL);
    entry = (GtkEntry *) lookup_widget(tree_details->window, "input_entry");
    choice = g_strdup((gchar *)gtk_entry_get_text(entry));
    g_strstrip(choice);
    hideit(tree_details->window, "input_box");
    if(tree_details->preferences & SHOW_F)
	showit(tree_details->window, "filter_box");
    gtk_widget_grab_focus((GtkWidget *) treeview);

    switch (tree_details->input)
    {
	default:
	    break;
	case OPEN_BOOK_INPUT:
	case NEW_BOOK_INPUT:
	    if (!choice || !strlen(choice)) return;
	    g_free(bookfile);
	    bookfile=g_strdup(choice);
    	    g_free(choice);
    	    reload_book(treeview); 
	    return;
	case WORKDIR_INPUT:
	    g_free(workdir);
	    workdir=g_strdup(choice);
	    save_workdir_history(workdir);
    	    g_free(choice);
	    /* OTHER_INPUT should cancel whatever is waiting on gtk loop */
    	    /*tree_details->input = OTHER_INPUT;*/
	    gtk_main_quit();
	    return;
	case RENAME_INPUT:
	case SCRAMBLE_INPUT:
	case UNSCRAMBLE_INPUT:
	case PRINT_INPUT:
	case SYMLINK_INPUT:
	case DUPLICATE_INPUT:
	    en = get_selected_entry(treeview, &iter);
	    if(!en || !IS_PATH(en->type))
		g_assert_not_reached();
	    treepath = gtk_tree_model_get_path(treemodel, &iter);
	    gtk_tree_path_up(treepath);
	    reference = gtk_tree_row_reference_new(treemodel, treepath);
	    gtk_tree_path_free(treepath);
	    {

		char *path = g_strdup(en->path);
		*(strrchr(path, '/')) = 0;
		switch (tree_details->input)
		{
		    default:
			break;
		    case RENAME_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			if (rename_it(treeview, &iter, nfile, en->path))
			PRINT_STATUS_DONE;
			break;
		    case PRINT_INPUT:
			if (print_it(treeview, &iter, choice, en->path))
				PRINT_STATUS_DONE;
			break;
		    case UNSCRAMBLE_INPUT:
			if (scramble_it(treeview, &iter, en->path, FALSE))
				PRINT_STATUS_DONE;
			break;
		    case SCRAMBLE_INPUT:
			if (scramble_it(treeview, &iter, en->path, TRUE))
				PRINT_STATUS_DONE;
			break;
		    case SYMLINK_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			if (symlink_it(treeview, &iter, nfile, en->path))
				PRINT_STATUS_DONE;
			break;
		    case DUPLICATE_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			if (duplicate_it(treeview, &iter, nfile, en->path))
				PRINT_STATUS_DONE;
			break;
		}
	    }

	    if(set_load_wait(&tree_details))
	    {
		update_dir(treeview, reference);
		unset_load_wait(&tree_details);
	    }

	    gtk_tree_row_reference_free(reference);

	    break;
	case RUN_DOUBLE_CLICK:
	case RUN_INPUT:
	    {
		gboolean in_terminal, remember;
		GtkWidget *check;
		char *in_cmd = g_strdup(choice);
		check = lookup_widget(tree_details->window, "checkbutton1");
		in_terminal = gtk_toggle_button_get_active((GtkToggleButton *) check);
		if(tree_details->input == RUN_INPUT)
		{
		    remember = FALSE;
		    en = NULL;
		}
		else
		{		/*RUN_DOUBLE_CLICK */
		    check = lookup_widget(tree_details->window, "checkbutton2");
		    remember = gtk_toggle_button_get_active((GtkToggleButton *) check);
		    en = get_selected_entry(treeview, &iter);
		}
		if(on_run(treeview, in_cmd, en, in_terminal, remember,TRUE))
		{
		    print_status(treeview, "xf_INFO_ICON", 
				    _("Executing"), " ", 
				    in_cmd, NULL);
		}
		g_free(in_cmd);
	    }
	    break;
	case GOTO_INPUT:
	    get_local_root(treeview, &iter, &en);
	    type = en->type;
	    if((access(choice, X_OK) && strncmp(choice,"//",2)) ||
	       (strncmp(choice,"//",2)==0 && strlen(choice)<3) )
	    {
	        if (access(choice, F_OK))
		       	print_status(treeview, "xf_ERROR_ICON",
			       strerror(ENOENT), " : ", 
			       choice, NULL);
		else print_status(treeview, "xf_ERROR_ICON",
			       strerror(EPERM), " : ", 
			       choice, NULL);
	    }
	    else
	    {
		if (strncmp(choice,"//",2)==0)
		  get_network_root(treeview, &iter, &en);
		else
		  get_local_root(treeview, &iter, &en);
	        type = en->type;
		tree_details->gogo = pushgo(treeview, choice, tree_details->gogo);
		go_to(treeview, choice);
    		/*save_go_list(); */
		
	    }
	    
	    break;
	case NEW_INPUT:
	    {

		GtkWidget *w = lookup_widget(tree_details->window, "checkbutton1");

		en = get_selected_entry(treeview, &iter);
    		if(!en || 
		   (!IS_PATH(en->type) &&
	            !IS_NETDIR(en->subtype) &&
 	            !IS_NETFILE(en->subtype) && 
 	            !IS_XF_NETSHARE(en->subtype)
 	           )) break;
		if (!gtk_toggle_button_get_active((GtkToggleButton *) w) &&
		    (IS_NETDIR(en->subtype) || 
 	            IS_NETFILE(en->subtype) || 
	            IS_XF_NETSHARE(en->subtype))
		   ){
	    		print_status(treeview, "xf_ERROR_ICON",
#ifdef ENOTSUP
			    strerror(ENOTSUP),
#else 
#ifdef EOPNOTSUPP
			    strerror(EOPNOTSUPP),
#else
			    strerror(EINVAL),
#endif
#endif
			    NULL);
			break;
		}

		treepath = gtk_tree_model_get_path(treemodel, &iter);
		reference = gtk_tree_row_reference_new(treemodel, treepath);
		gtk_tree_path_free(treepath);

		{
		    char *path = g_strdup(en->path);
		    char *name = g_strdup(choice);
		    if(!IS_DIR(en->type))
		    {
			*(strrchr(path, '/')) = 0;
		    }
		    new_it(treeview, path, name, gtk_toggle_button_get_active((GtkToggleButton *) w));
		    g_free(path);
		    g_free(name);
		}
		if(set_load_wait(&tree_details))
		{
		    update_dir(treeview, reference);
		    unset_load_wait(&tree_details);
		}

		gtk_tree_row_reference_free(reference);
	    }
	    break;
    }
    g_free(nfile);
    g_free(choice);
    tree_details->input = OTHER_INPUT;
    local_monitor(treeview,TRUE);
}

void cancel_input(GtkTreeView * treeview)
{
    tree_details_t *tree_details = get_tree_details(treeview);
    hideit(tree_details->window, "input_box");
    if(tree_details->preferences & SHOW_F)
	showit(tree_details->window, "filter_box");
    if (tree_details->input==WORKDIR_INPUT){
	    g_free(workdir);
	    workdir=NULL;
	    tree_details->input = OTHER_INPUT;
	    gtk_main_quit(); /* this lets on_autotype_C continue */
    } else {
	    tree_details->input = OTHER_INPUT;
    }
}

/* callbacks */



void on_input_cancel(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) button);
    cancel_input(treeview);
}


void on_input_ok(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) button);
    ok_input(treeview);

}


void on_input_activate(GtkEntry * entry, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) entry);
    ok_input(treeview);

}
