/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Some code in here contributed by the FSF
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"

#include "gdir.h"

static int gdir_compare_opt = 0;

void gdir_sort_type(gboolean order)
{
    gdir_compare_opt = order;
}

static int compare_loc(const void *a, const void *b)
{
    char *loc1, *loc2;
    const dir_t *d1 = (const dir_t *)a;
    const dir_t *d2 = (const dir_t *)b;
    loc1 = strrchr(d1->pathv, '.');
    loc2 = strrchr(d2->pathv, '.');
    if((!loc1) && (!loc2))
	return 0;
    if((!loc1) && (loc2))
	return strcmp(".", loc2);
    if((loc1) && (!loc2))
	return strcmp(loc1, ".");
    return strcmp(loc1, loc2);
}



#define CASE_SENSITIVE

int gdir_compare(const void *a, const void *b)
{

    int subsort;

    const dir_t *d1 = (const dir_t *)a;
    const dir_t *d2 = (const dir_t *)b;
    /* first dir types. Directories always on top.
     * directories always sorted by name */

    /* this is bug workaround: */
/*  if (!d1->en && !d2->en) return 0;
  if (d1->en && !d2->en) return -1;
  if (!d1->en && d2->en) return 1;*/

    if(IS_DIR(d1->en->type) && !IS_DIR(d2->en->type))
	return -1;
    if(IS_NETDIR(d1->en->subtype) && !IS_NETDIR(d2->en->subtype))
	return -1;
    if(!IS_DIR(d1->en->type) && IS_DIR(d2->en->type))
	return 1;
    if(!IS_NETDIR(d1->en->subtype) && IS_NETDIR(d2->en->subtype))
	return 1;
    if(IS_DIR(d1->en->type) && IS_DIR(d2->en->type))
	return strcmp(d1->pathv, d2->pathv);
    if(IS_NETDIR(d1->en->subtype) && IS_NETDIR(d2->en->subtype))
	return strcmp(d1->pathv, d2->pathv);

    /* replacing for this would make it 
     * respect ascending and descending for dirs */
    /* return (gdir_compare_opt & SORT_DESCENDING)?
       strcmp(d2->pathv,d1->pathv):strcmp(d1->pathv,d2->pathv); */



    /* type subsort is always ascending */
    if(IS_TYPE_SUBSORT(gdir_compare_opt))
    {
	if((subsort = compare_loc(a, b)) != 0)
	    return subsort;
    }

    /* consider descending scenario */
    if(IS_DESCENDING(gdir_compare_opt))
    {
	d1 = (const dir_t *)b;
	d2 = (const dir_t *)a;
    }

    if(IS_SORT_NAME(gdir_compare_opt))
    {
	if(d1->pathv == d2->pathv)
	    return 0;
	if(d1->pathv == NULL)
	    return 1;
	if(d2->pathv == NULL)
	    return -1;
	if(d1->pathv[0] == '.' || d2->pathv[0] == '.')
	    return strcmp(d1->pathv, d2->pathv);
    }
    else if(IS_SORT_TIME(gdir_compare_opt))
	return (d1->en->st->st_mtime - d2->en->st->st_mtime);
    else if(IS_SORT_SIZE(gdir_compare_opt))
	return (d1->en->st->st_size - d2->en->st->st_size);
    else if(IS_SORT_UID(gdir_compare_opt))
	return (d1->en->st->st_uid - d2->en->st->st_uid);
    else if(IS_SORT_GID(gdir_compare_opt))
	return (d1->en->st->st_gid - d2->en->st->st_gid);
#ifdef CASE_SENSITIVE
    return strcmp(d1->pathv, d2->pathv);
#else
    return strcoll(d1->pathv, d2->pathv);
#endif
}


/* field gdir->gl[i].en not freed since it is transferred to another
 * object*/
void gdirfree(gdir_t * gdir)
{
    if(gdir->gl != NULL)
    {
	int i;
	for(i = 0; i < gdir->pathc; i++)
	{
	    if(gdir->gl[i].pathv != NULL)
		g_free(gdir->gl[i].pathv);
	}
	g_free(gdir->gl);
    }
}
