/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>
#include <glob.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "input.h"
#include "entry.h"
#include "misc.h"
#include "remove.h"
#include "widgets.h"
#include "smb_download.h"



char *new_name(char *path, char *base)
{
    int num = 0;
    int i, j;
    char *wd;
    struct stat st;
    static char nfile[_POSIX_PATH_MAX];
    glob_t dirlist;
    /* get highest version number */

    sprintf(nfile, "%s/%s-*", path, base);
    if(glob(nfile, GLOB_ERR, NULL, &dirlist) == 0)
    {
	for(i = 0; i < dirlist.gl_pathc; i++)
	{
	    wd = strrchr(dirlist.gl_pathv[i], '-') + 1;
	    for(j = 0; j < strlen(wd); j++)
		if((wd[j] > '9') || (wd[j] < '0'))
		    goto next;
	    if(num <= atoi(wd))
		num = atoi(wd) + 1;
	    /*printf("%d:%s\n",i,dirlist.gl_pathv[i]); */
	}
      next:;
    }
    globfree(&dirlist);
    sprintf(nfile, "%s-%d", base, num++);
    while(lstat(nfile, &st) == 0)
    {
	sprintf(nfile, "%s-%d", base, num++);
    }
    return nfile;
}


int new_it(GtkTreeView * treeview, char *path, char *in_name, gboolean directory)
{
    char fullpath[_POSIX_PATH_MAX];
    FILE *fp;
    tree_details_t *tree_details = get_tree_details(treeview);
    struct stat st;
    char *name=utf_2_local_string(in_name);

    if(!path || !name)
	return FALSE;
   if(!set_load_wait(&tree_details))
	return FALSE;
    sprintf(fullpath, "%s/%s", path, name);

    if (strncmp(path,"//",strlen("//"))==0){
	tree_entry_t *t_en;
	GtkTreeIter iter;
	gboolean will_expand;
	GtkTreePath *treepath;
	GtkTreeRowReference *reference;
        GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
	
	if (!get_selectpath_iter(treeview,&iter,&t_en)) return FALSE; 
	treepath=gtk_tree_model_get_path(treemodel,&iter);
	reference = gtk_tree_row_reference_new(treemodel, treepath);
    	gtk_tree_path_free(treepath);
	will_expand=IS_EXPANDED(t_en->type);
	
	SMBmkdir (treeview,t_en,&iter,name);
    	unset_load_wait(&tree_details);
	
	if (will_expand) {
	   treepath=gtk_tree_row_reference_get_path(reference);
    	   gtk_tree_view_expand_row(treeview, treepath, FALSE);  
    	   gtk_tree_path_free(treepath);
        }
	gtk_tree_row_reference_free(reference);
	return FALSE;
    }	   
    else if(lstat(fullpath, &st) >= 0)
    {
	if (!query_rm(treeview, fullpath, fullpath)){
    		    unset_load_wait(&tree_details);
		    return FALSE;
	}
    }
 
    if(directory)
    {
	if(mkdir(fullpath, 0xFFFF) < 0)
	{
	    print_diagnostics(treeview, "xf_ERROR_ICON", strerror(errno), " : ", fullpath, "\n", NULL);
	    print_status(treeview, "xf_ERROR_ICON", 
			    strerror(errno), NULL);
    	    unset_load_wait(&tree_details);
	    return FALSE;
	}
    }
    else
    {
	fp = fopen(fullpath, "w");
	if(fp)
	    fclose(fp);
	else
	{
	    print_diagnostics(treeview, "xf_ERROR_ICON", strerror(errno), " : ", fullpath, "\n", NULL);
	    print_status(treeview, "xf_ERROR_ICON", strerror(errno), NULL);
    	    unset_load_wait(&tree_details);
	    return FALSE;
	}
    }
    print_status(treeview, "xf_INFO_ICON", fullpath, " ", "created", NULL);
    unset_load_wait(&tree_details);
    return TRUE;
}


void set_new_combo(GtkTreeView * treeview)
{
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkWidget *w = lookup_widget(tree_details->window, "input_combo");
    GList *new_list = NULL;
    GtkTreeIter iter;
    tree_entry_t *en;
    char *path;


    en = get_selected_entry(treeview, &iter);
    path = g_strdup(en->path);
    if(!IS_DIR(en->type))
	*(strrchr(path, '/')) = 0;
    if (IS_NETTHING(en->subtype))
	new_list = g_list_append(new_list,  _("New"));
    else 
	new_list = g_list_append(new_list, new_name(path, _("New")));
    gtk_combo_set_popdown_strings(GTK_COMBO(w), new_list);
    g_list_free(new_list);
    g_free(path);
}


void do_it(GtkTreeView * treeview)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    en = get_selected_entry(treeview, &iter);
    if(!en || 
       (!IS_PATH(en->type) &&
        !IS_NETDIR(en->subtype) &&
        !IS_NETFILE(en->subtype) && 
        !IS_XF_NETSHARE(en->subtype)
       )) return;
    show_input(treeview, NEW_INPUT);

}

/**************    callbacks *******************/

void on_new_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    do_it(get_treeview((GtkWidget *) menuitem));
}


void tb_new(GtkButton * button, gpointer user_data)
{
    do_it(get_treeview((GtkWidget *) button));
}
