/******************************************************************************
 * Copyright (c) 2003 Tobias Henle <tobias@page23.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef __XFCE_HVBOX_H__
#define __XFCE_HVBOX_H__ 1

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#define XFCE_TYPE_HVBOX		 (xfce_hvbox_get_type ())
#define XFCE_HVBOX(obj)		 (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFCE_TYPE_HVBOX, XfceHVBox))
#define XFCE_HVBOX_CLASS(klass)	 (G_TYPE_CHECK_CLASS_CAST ((klass), XFCE_TYPE_HVBOX, XfceHVBoxClass))
#define XFCE_IS_HVBOX(obj)	 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFCE_TYPE_HVBOX))
#define XFCE_IS_HVBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFCE_TYPE_HVBOX))
#define XFCE_HVBOX_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), XFCE_TYPE_HVBOX, XfceHVBoxClass))

typedef enum
{
  XFCE_HVBOX_ORIENTATION_HORIZONTAL,
  XFCE_HVBOX_ORIENTATION_VERTICAL,
  XFCE_HVBOX_ORIENTATION_SIZES	
} XfceHVBoxOrientation;

typedef struct _XfceHVBox	XfceHVBox;
typedef struct _XfceHVBoxClass	XfceHVBoxClass;

struct _XfceHVBox
{
  GtkBox 		parent;
  XfceHVBoxOrientation	orientation;
};

struct _XfceHVBoxClass
{
  GtkBoxClass		parent_class;
  GtkHBoxClass		*parent_hbox;
  GtkVBoxClass		*parent_vbox;

  void (*orientation_changed) (GtkWidget *widget, XfceHVBoxOrientation orientation);
};


GType	  	xfce_hvbox_get_type(void);
GtkWidget*	xfce_hvbox_new(gboolean homogeneous, gint spacing, 
    		  XfceHVBoxOrientation orientation);
void		xfce_hvbox_set_orientation(XfceHVBox *hvbox, 
    		  XfceHVBoxOrientation orientation);
#define 	xfce_hvbox_get_orientation(hvbox) XFCE_HVBOX(hvbox)->orientation

#endif 					/* ifndef __XFCE_HVBOX_H__ 		*/
