/*  xfce4
 *  
 *  Copyright (C) 2002 Jasper Huijsmans (huysmans@users.sourceforge.net)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <glib.h>
#include <gdk/gdkx.h>
#include <gmodule.h>
#include <gtk/gtk.h>

#include <libxfce4util/i18n.h>
#include <libxfcegui4/libxfcegui4.h>
#include <xfce-mcs-manager/manager-plugin.h>

#include "inline-icon.h"
#include "xfce-mcs-dialog.h"

/* this seems to be the standard border width gtk uses for the action
 * area, so the dialog looks best using the same border width */
#define BORDER 6

/*
 * To improve the responsiveness of the UI
 */
static gboolean
delayed_run_plugin_dialog(McsPlugin *plugin)
{
	plugin->run_dialog(plugin);
	return(FALSE);
}

static void
run_plugin_dialog(GtkWidget *b, McsPlugin *plugin)
{
	(void)g_idle_add((GSourceFunc)delayed_run_plugin_dialog,
			 (gpointer)plugin);
}

static void close_dialog(GtkWidget *dlg)
{
    gtk_widget_destroy(dlg);
}

static int plugincmp(McsPlugin *a, McsPlugin *b)
{
    if (!a || !b || !(a->caption) || !(b->caption))
	return -1;
    
    return strcmp(a->caption, b->caption);
}

void run_manager_dialog(GSList *plugin_list)
{
    GSList *sorted_list, *li;
    GtkWidget *dlg, *vbox1, *scroll, *hbox, *vbox2, *vbox3, *button, *header;
    McsPlugin *plugin;
    GdkPixbuf *icon;
    int i;

    xfce_textdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");

    gtk_set_locale ();

    dlg = gtk_dialog_new_with_buttons(_("XFce Settings Manager"), NULL,
	    			      GTK_DIALOG_NO_SEPARATOR, 
				      GTK_STOCK_CLOSE, GTK_RESPONSE_OK, 
				      NULL);
    
    icon = inline_icon_at_size(default_icon_data, 32, 32);
    gtk_window_set_icon(GTK_WINDOW(dlg), icon);

    vbox1 = GTK_DIALOG(dlg)->vbox;

    header = create_header(icon, _("XFce Settings Manager"));
    gtk_widget_show(header);
    gtk_box_pack_start(GTK_BOX(vbox1), header, FALSE, TRUE, 0);
    g_object_unref(icon);

#if 0
    label = gtk_label_new(_("Choose a module from the list below to change its options"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_misc_set_padding(GTK_MISC(label), BORDER, 4);
    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
    gtk_widget_show(label);
    gtk_box_pack_start(GTK_BOX(vbox1), label, FALSE, TRUE, 0);
#endif    
    /* scroll window */
    scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_container_set_border_width(GTK_CONTAINER(scroll), BORDER);

    /* I made this 'ALWAYS', because gtk draws an empty space anyway ... */
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), 
	    			   GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

    gtk_box_pack_start(GTK_BOX(vbox1), scroll, TRUE, TRUE, 0);
    gtk_widget_show(scroll);

    hbox = gtk_hbox_new(FALSE, BORDER);
    gtk_container_set_border_width(GTK_CONTAINER(hbox), 2);
    gtk_widget_show(hbox);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll), hbox);
    
    vbox2 = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox2);
    gtk_box_pack_start(GTK_BOX(hbox), vbox2, FALSE, FALSE, 0);
    
    vbox3 = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox3);
    gtk_box_pack_start(GTK_BOX(hbox), vbox3, FALSE, FALSE, 0);
    
    /* buttons */
    sorted_list = g_slist_copy(plugin_list);
    sorted_list = g_slist_sort(sorted_list, (GCompareFunc) plugincmp);

    for (i=0, li = sorted_list; li; i++, li = li->next)
    {
	plugin = li->data;

	button = xfce_menubutton_new_with_pixbuf(plugin->caption, 
						 plugin->icon);
	gtk_widget_set_size_request(button, -1, SETTINGS_MANAGER_ICON_SIZE);
	gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
	gtk_widget_show(button);

	if ((i+1) % 2 == 1)
	    gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	else
	    gtk_box_pack_start(GTK_BOX(vbox3), button, FALSE, FALSE, 0);

	g_signal_connect(button, "clicked", 
			 G_CALLBACK(run_plugin_dialog), plugin);
    }
    
    g_slist_free (sorted_list);
    
    gtk_widget_set_size_request(dlg, -1, 400);

    g_signal_connect_swapped(dlg, "response", 
	    		     G_CALLBACK(close_dialog), dlg);
    g_signal_connect_swapped(dlg, "delete-event", 
	    		     G_CALLBACK(close_dialog), dlg);
    
    gtk_window_set_position(GTK_WINDOW(dlg), GTK_WIN_POS_CENTER);
    gtk_widget_show(dlg);
}

