/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  menubar.cc - GtkMenuBar C++ wrapper implementation
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "menubar.hh"
#include "private/menubarclass.hh"

using namespace Xfc;

/*  Gtk::MenuBar
 */

Gtk::MenuBar::MenuBar(GtkMenuBar *menu_bar, bool owns_reference)
: MenuShell((GtkMenuShell*)menu_bar, owns_reference)
{
}

Gtk::MenuBar::MenuBar()
: MenuShell((GtkMenuShell*)MenuBarClass::create())
{
}

Gtk::MenuBar::~MenuBar()
{
}

/*  Gtk::MenuBarClass
 */

void
Gtk::MenuBarClass::init(GtkMenuBarClass *g_class)
{
	MenuShellClass::init((GtkMenuShellClass*)g_class);
}

GType
Gtk::MenuBarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_MENU_BAR, (GClassInitFunc)&init);
	}
	return type;
}

void*
Gtk::MenuBarClass::create()
{
	return g_object_new(get_type(), 0);
}

