/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The XFC Development Team.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

/// @file xfc/gdk/gdk.hh
/// @brief Main Gdk header file
///
/// This header file includes all the Gdk header files. You can safely include
/// this header file only, with minimal extra overhead, because each header file
/// uses include guards to prevent multiple inclusions.

#ifndef XFC_GDK_HH
#define XFC_GDK_HH

#include <xfc/gdk/color.hh>
#include <xfc/gdk/cursor.hh>
#include <xfc/gdk/display.hh>
#include <xfc/gdk/displaymanager.hh>
#include <xfc/gdk/dnd.hh>
#include <xfc/gdk/image.hh>
#include <xfc/gdk/input.hh>
#include <xfc/gdk/keymap.hh>
#include <xfc/gdk/keyval.hh>
#include <xfc/gdk/pixmap.hh>
#include <xfc/gdk/region.hh>
#include <xfc/gdk/screen.hh>
#include <xfc/gdk/spawn.hh>
#include <xfc/gdk/visual.hh>
#include <xfc/gdk/window.hh>

#endif // XFC_GDK_HH

