/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  toolitemclass.hh - Private interface
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef XFC_GTK_TOOL_ITEM_CLASS_H
#define XFC_GTK_TOOL_ITEM_CLASS_H

#include <xfc/gtk/private/binclass.hh>

namespace Xfc {

namespace Gtk {

class ToolItemClass
{
public:
	static void init(GtkToolItemClass *g_class);

	static GtkToolItemClass* get_parent_class(void *instance);
	
	static GType get_type();

	static void* create();

	static gboolean create_menu_proxy_proxy(GtkToolItem *tool_item);
	
	static void toolbar_reconfigured_proxy(GtkToolItem *tool_item);
	
	static gboolean set_tooltip_proxy(GtkToolItem *tool_item, GtkTooltips *tooltips, const gchar *tip_text, const gchar *tip_private);
};

} // namespace Gtk

} // namespace Xfc

#endif // XFC_GTK_TOOL_ITEM_CLASS_H

