/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The XFC Development Team.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

/// @file xfc/atk/atk.hh
/// @brief Main Atk header file
///
/// This header file includes all the Atk header files. You can safely include
/// this header file only, with minimal extra overhead, because each header file
/// uses include guards to prevent multiple inclusions.

#ifndef XFC_ATK_HH
#define XFC_ATK_HH

#include <xfc/atk/component.hh>
#include <xfc/atk/document.hh>
#include <xfc/atk/editabletext.hh>
#include <xfc/atk/gobjectaccessible.hh>
#include <xfc/atk/hyperlink.hh>
#include <xfc/atk/hypertext.hh>
#include <xfc/atk/image.hh>
#include <xfc/atk/implementor.hh>
#include <xfc/atk/object.hh>
#include <xfc/atk/objectfactory.hh>
#include <xfc/atk/registry.hh>
#include <xfc/atk/relation.hh>
#include <xfc/atk/selection.hh>
#include <xfc/atk/stateset.hh>
#include <xfc/atk/streamablecontent.hh>
#include <xfc/atk/table.hh>
#include <xfc/atk/text.hh>
#include <xfc/atk/value.hh>

#endif // XFC_ATK_HH


