/*  XFC: Xfce Foundation Classes (Core Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  objectsignals.cc - G::Object virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "object.hh"
#include "objectsignals.hh"
#include "quark.hh"
#include "private/objectclass.hh"
#include <glib/gmessages.h>

using namespace Xfc;

/*  G::ObjectSignals
 */

G::ObjectSignals::ObjectSignals(Object *object)
{
	if (object)	
		object->set_data(quark(), this);
	else
		g_error("Invalid pointer: you must not pass a null pointer to a G::ObjectSignals class constructor.");
}

G::ObjectSignals::~ObjectSignals()
{
}

void
G::ObjectSignals::on_notify(GParamSpec *pspec)
{
	GObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class && g_class->notify)
		g_class->notify((GObject*)instance_, pspec);
}

GQuark
G::ObjectSignals::quark()
{
	static GQuark quark = 0;
	if (!quark)
	{
		quark = g_quark_from_static_string("xfc_object_signals");
	}
	return quark;
}

G::ObjectSignals* 
G::ObjectSignals::pointer(GObject* object)
{
	return static_cast<ObjectSignals*>(g_object_get_qdata(object, quark()));
}

