/*  xfce4-terminal
 *
 *  Copyright (C) 2004 Eduard Roccatello (eduard@xfce.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define NEW_TAB_ACCEL "<CTRL><SHIFT>T"
#define CLOSE_TAB_ACCEL "<CTRL><SHIFT>W"
#define QUIT_ACCEL "<CTRL><SHIFT>Q"
#define COPY_ACCEL "<CTRL><SHIFT>C"
#define PASTE_ACCEL "<CTRL><SHIFT>V"
#define RENAME_TAB_ACCEL "<CTRL><SHIFT>R"
#define PREVIOUS_TAB_ACCEL "<CTRL><SHIFT>P"
#define NEXT_TAB_ACCEL "<CTRL><SHIFT>N"

typedef struct _terminal Terminal;
struct _terminal {
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *menubar;
	GtkWidget *notebook;
	
	GtkWidget *file;
	GtkWidget *file_menu;
	GtkWidget *file_exit;
	GtkWidget *file_newtab;
	GtkWidget *file_sep;
	GtkWidget *edit;
	GtkWidget *help;
	GtkWidget *help_menu;
	GtkWidget *help_about;

	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;

	GPtrArray *terms;	/* pointer array for the tabs */
};

typedef struct _shell Shell;
struct _shell {
    Terminal *parent;
	GtkWidget *vte;
	GtkWidget *label;
    gint page;
};

typedef struct _settings Settings;
struct _settings {
    gchar *font;
    gint menu;
    gint accels;
};


/* The menu interface */
static GtkItemFactoryEntry menu_items[] = {
	{ "/File", NULL, NULL, 0, "<Branch>" },
	{ "/File/New Tab", NEW_TAB_ACCEL, cb_newtab, 1, "<StockItem>", GTK_STOCK_ADD },
	{ "/File/Close Tab", CLOSE_TAB_ACCEL, cb_closetab, 1, "<StockItem>", GTK_STOCK_CLOSE },
	{ "/File/sep1", NULL, NULL, 0, "<Separator>" },
	{ "/File/Quit", QUIT_ACCEL, gtk_main_quit, 0, "<StockItem>", GTK_STOCK_QUIT },
	{ "/Edit", NULL, NULL, 0, "<Branch>" },
	{ "/Edit/Copy", COPY_ACCEL, cb_copy, 0, "<StockItem>", GTK_STOCK_COPY },
	{ "/Edit/Paste", PASTE_ACCEL, cb_paste, 0, "<StockItem>", GTK_STOCK_PASTE },
	{ "/Edit/sep1", NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Settings...", NULL, cb_settings, 0, "<StockItem>", GTK_STOCK_EXECUTE },
	{ "/Tabs", NULL, NULL, 0, "<Branch>" },
	{ "/Tabs/Rename Tab", RENAME_TAB_ACCEL, cb_renametab, 1, "<Item>" },
	{ "/Tabs/Previous Tab", PREVIOUS_TAB_ACCEL, cb_prevtab, 1, "<Item>"},
	{ "/Tabs/Next Tab", NEXT_TAB_ACCEL, cb_nexttab, 1, "<Item>"},
	{ "/Help", NULL, NULL, 0, "<Branch>" },
	{ "/Help/About", NULL, cb_help_about, 0, "<StockItem>", GTK_STOCK_DIALOG_INFO }
};

static GtkItemFactoryEntry vte_menu_items[] = {
	{ "/New Tab", NEW_TAB_ACCEL, cb_newtab, 1, "<StockItem>", GTK_STOCK_ADD },
	{ "/sep1", NULL, NULL, 0, "<Separator>" },
	{ "/Copy", COPY_ACCEL, cb_copy, 0, "<StockItem>", GTK_STOCK_COPY },
	{ "/Paste", PASTE_ACCEL, cb_paste, 0, "<StockItem>", GTK_STOCK_PASTE },
	{ "/sep2", NULL, NULL, 0, "<Separator>" },
	{ "/Settings...", NULL, cb_settings, 0, "<StockItem>", GTK_STOCK_EXECUTE },
	{ "/sep3", NULL, NULL, 0, "<Separator>" },
	{ "/Close Tab", CLOSE_TAB_ACCEL, cb_closetab, 1, "<StockItem>", GTK_STOCK_CLOSE }
};

Shell *create_terminal(const gchar *shell, const gchar *pwd, const gchar *label, gpointer data);

McsClient *settings_init(Terminal *t);
void update_settings(Terminal *t);
GdkFilterReturn mcs_client_event_filter (GdkXEvent * xevent, GdkEvent * event, gpointer data);
