/*  xfce4-terminal
 *
 *  Copyright (C) 2004 Eduard Roccatello (eduard@xfce.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <vte/vte.h>

#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>
#include <settings/settings.h>

#include <callbacks.h>
#include <xfce4-terminal.h>
#include <accelerators.h>
#include <globals.h>
#include "inline-icon.h"

void cb_switch_notebook_tab (GtkNotebook *notebook, GtkNotebookPage *page, guint num, gpointer data)
{
    Terminal *t = data;
    Shell *s;

    if (t->terms->len > num)
        s = g_ptr_array_index(t->terms, num);
    else
        return;

    gtk_window_set_title (GTK_WINDOW(t->window), vte_terminal_get_window_title (VTE_TERMINAL(s->vte)));
}

gboolean cb_vte_button_press (VteTerminal *vte, GdkEventButton *event, gpointer data)
{
    GtkItemFactory *f;
    GtkWidget *m;

    if (event->button == 3) {
        f = gtk_item_factory_new(GTK_TYPE_MENU, "<main>", NULL);
        gtk_item_factory_create_items(f, vte_nmenu_items, vte_menu_items, data);
        gtk_menu_popup (GTK_MENU(gtk_item_factory_get_widget(f, "<main>")), NULL, NULL, NULL, NULL, event->button, event->time);
    }
    
    return FALSE;
}

void cb_closetab (gpointer data, guint action, GtkWidget *item)
{
	Terminal *t = data;
    Shell *s = g_ptr_array_index (t->terms, gtk_notebook_get_current_page (GTK_NOTEBOOK(t->notebook)));

    if (s)
        cb_childexit(NULL, s);
}

void cb_settings (gpointer data, guint action, GtkWidget *item)
{
    mcs_client_show (GDK_DISPLAY (), DefaultScreen (GDK_DISPLAY ()), CHANNEL);
}

void cb_paste (gpointer callback_data, guint callback_action, GtkWidget *menu_item)
{
	Terminal *t = callback_data;
    gint page = gtk_notebook_get_current_page (GTK_NOTEBOOK(t->notebook));
    Shell *s = g_ptr_array_index(t->terms, page);

    vte_terminal_paste_clipboard (VTE_TERMINAL(s->vte));
}

void cb_copy (gpointer callback_data, guint callback_action, GtkWidget *menu_item)
{
	Terminal *t = callback_data;
    gint page = gtk_notebook_get_current_page (GTK_NOTEBOOK(t->notebook));
    Shell *s = g_ptr_array_index(t->terms, page);

    vte_terminal_copy_clipboard (VTE_TERMINAL(s->vte));
}

void cb_title_changed (VteTerminal *vte, gpointer data)
{
    Shell *s = data;
    Terminal *t = s->parent;

    gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(t->notebook), 
        gtk_notebook_get_nth_page(GTK_NOTEBOOK(t->notebook), s->page),
        vte_terminal_get_window_title (VTE_TERMINAL(vte)));

    gtk_window_set_title (GTK_WINDOW(t->window), vte_terminal_get_window_title (VTE_TERMINAL(vte)));
}

/*
	Answer to "child-exited" signal
	If there are only a tab opened it will exit.
 */
void cb_childexit(VteTerminal *vte, gpointer data)
{
	Shell *s = data;
    Shell *st;
	Terminal *t = s->parent;
    gint i;
	
	if(gtk_notebook_get_n_pages(GTK_NOTEBOOK(t->notebook)) == 1)
	{
		if (s->label && GTK_IS_WIDGET(s->label)) gtk_widget_destroy(s->label);
        if (s->vte && GTK_IS_WIDGET(s->vte)) gtk_widget_destroy(s->vte);
        g_ptr_array_free (t->terms, TRUE);
		gtk_main_quit();
	}
	else
	{
		g_ptr_array_remove_index (t->terms, s->page);
        for (i=s->page; i < t->terms->len; i++)
        {
            st = (Shell *) g_ptr_array_index(t->terms, i);
            st->page--;
        }

		if (s->label && GTK_IS_WIDGET(s->label)) gtk_widget_destroy(s->label);
        if (s->vte && GTK_IS_WIDGET(s->vte)) gtk_widget_destroy(s->vte);

    	gtk_notebook_remove_page (GTK_NOTEBOOK(t->notebook), s->page);
        g_free(s);

		if (gtk_notebook_get_n_pages(GTK_NOTEBOOK(t->notebook)) == 1)
			gtk_notebook_set_show_tabs (GTK_NOTEBOOK(t->notebook), FALSE);
	}

}

/* Callback function bodies */

void cb_help_about (gpointer data, guint action, GtkWidget *item)
{
	XfceAboutInfo *info;
	GtkWidget *dialog;

	info = xfce_about_info_new(
		"Xfce4 Terminal",
		VERSION,
		"A terminal emulator for XFce4",
		XFCE_COPYRIGHT_TEXT("2002-2004", "The XFce development team"),
		XFCE_LICENSE_LGPL);

	xfce_about_info_set_homepage(info, "http://www.xfce.org/");
	xfce_about_info_add_credit(info,
		"Eduard Roccatello",
		"eduard@xfce.org",
		"Core Developer");

	dialog = xfce_about_dialog_new(NULL, info, xfce_inline_icon_at_size (default_icon_data_48_48, 48, 48));
	gtk_window_set_default_size(GTK_WINDOW(dialog), 500, 400);
	xfce_about_info_free(info);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy (dialog);
}

void cb_newtab (gpointer data, guint action, GtkWidget *item)
{
	Shell *s;
	Terminal *t = data;
	gint page;

	s = (Shell *)create_terminal(getenv("SHELL"), getenv("PWD"), NULL, (gpointer)t);
	g_ptr_array_add (t->terms, s);

    /* GTK < 2.4 workaround */
	gtk_notebook_append_page (GTK_NOTEBOOK(t->notebook), s->vte, s->label);
    s->page = gtk_notebook_get_n_pages (GTK_NOTEBOOK(t->notebook)) - 1;
    
	gtk_notebook_set_current_page (GTK_NOTEBOOK(t->notebook), s->page);
	if (s->page > 0)
		gtk_notebook_set_show_tabs (GTK_NOTEBOOK(t->notebook), TRUE);
}

/* Thank you to Randy Chung (aoshi@OCF.Berkeley.EDU) to have done this */
void cb_renametab (gpointer data, guint action, GtkWidget *item)
{
	Terminal *t = data;
	GtkWidget *dialog, *label, *entry;
	Shell *s;
	GtkNotebook *n;
	gint page;

	dialog = gtk_dialog_new_with_buttons("Rename tab", GTK_WINDOW(t->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK, GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
	label = gtk_label_new("Enter a new name for this tab:");
	entry = gtk_entry_new();
	
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), label);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), entry);
	gtk_widget_show_all(dialog);

	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK)
	{
		n = GTK_NOTEBOOK(t->notebook);
		page = gtk_notebook_get_current_page(n);
		gtk_notebook_set_tab_label_text(n, gtk_notebook_get_nth_page(n, page), gtk_entry_get_text(GTK_ENTRY(entry)));
	}
	gtk_widget_destroy(dialog);
}

/* Thank you to Randy Chung (aoshi@OCF.Berkeley.EDU) to have done this */
void cb_nexttab (gpointer data, guint action, GtkWidget *item)
{
	Terminal *t = data;
	GtkNotebook *n = GTK_NOTEBOOK(t->notebook);
	
	if (gtk_notebook_get_current_page(n) == gtk_notebook_get_n_pages(n) - 1)
		gtk_notebook_set_current_page(n, 0);
	else
		gtk_notebook_next_page(n);
}

/* Thank you to Randy Chung (aoshi@OCF.Berkeley.EDU) to have done this */
void cb_prevtab (gpointer data, guint action, GtkWidget *item)
{
	Terminal *t = data;
	GtkNotebook *n = GTK_NOTEBOOK(t->notebook);
	
	if (gtk_notebook_get_current_page(n) == 0)
		gtk_notebook_set_current_page(n, -1);
	else
		gtk_notebook_prev_page(n);
}
