/*  xfce4-terminal
 *
 *  Copyright (C) 2004 Eduard Roccatello (eduard@xfce.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <vte/vte.h>

#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>
#include <settings/settings.h>

#include <callbacks.h>
#include <xfce4-terminal.h>
#include <accelerators.h>
#include <globals.h>
#include "inline-icon.h"

void init_terminal_accelerators (Terminal *t)
{
    guint key;
    GdkModifierType mods;

    t->accel_group = gtk_accel_group_new ();

    gtk_accelerator_parse (NEW_TAB_ACCEL, &key, &mods);
    gtk_accel_group_connect (t->accel_group, key, mods, GTK_ACCEL_LOCKED, g_cclosure_new_swap (G_CALLBACK(cb_newtab), (gpointer)t, NULL));

    gtk_accelerator_parse (CLOSE_TAB_ACCEL, &key, &mods);
    gtk_accel_group_connect (t->accel_group, key, mods, GTK_ACCEL_LOCKED, g_cclosure_new_swap (G_CALLBACK(cb_closetab), (gpointer)t, NULL));

    gtk_accelerator_parse (QUIT_ACCEL, &key, &mods);
    gtk_accel_group_connect (t->accel_group, key, mods, GTK_ACCEL_LOCKED, g_cclosure_new_swap (G_CALLBACK(gtk_main_quit), NULL, NULL));

    gtk_accelerator_parse (COPY_ACCEL, &key, &mods);
    gtk_accel_group_connect (t->accel_group, key, mods, GTK_ACCEL_LOCKED, g_cclosure_new_swap (G_CALLBACK(cb_copy), (gpointer)t, NULL));

    gtk_accelerator_parse (PASTE_ACCEL, &key, &mods);
    gtk_accel_group_connect (t->accel_group, key, mods, GTK_ACCEL_LOCKED, g_cclosure_new_swap (G_CALLBACK(cb_paste), (gpointer)t, NULL));

    gtk_accelerator_parse (RENAME_TAB_ACCEL, &key, &mods);
    gtk_accel_group_connect (t->accel_group, key, mods, GTK_ACCEL_LOCKED, g_cclosure_new_swap (G_CALLBACK(cb_renametab), (gpointer)t, NULL));

    gtk_accelerator_parse (PREVIOUS_TAB_ACCEL, &key, &mods);
    gtk_accel_group_connect (t->accel_group, key, mods, GTK_ACCEL_LOCKED, g_cclosure_new_swap (G_CALLBACK(cb_prevtab), (gpointer)t, NULL));

    gtk_accelerator_parse (NEXT_TAB_ACCEL, &key, &mods);
    gtk_accel_group_connect (t->accel_group, key, mods, GTK_ACCEL_LOCKED, g_cclosure_new_swap (G_CALLBACK(cb_nexttab), (gpointer)t, NULL));

    gtk_accel_group_lock (t->accel_group);
   	gtk_window_add_accel_group(GTK_WINDOW(t->window), t->accel_group);
}




