/* $Id: settings.h,v 1.1.1.1 2004/08/25 21:19:47 eduard Exp $ */
/*-
 * Copyright (c) 2004 Benedikt Meurer <benny@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SETTINGS_SETTINGS_H__
#define __SETTINGS_SETTINGS_H__

#define CHANNEL                   "terminal"
#define RCDIR                     "settings"
#define RCFILE                    "terminal.xml"

#define TOGGLE_PRESSED    1
#define TOGGLE_UNPRESSED  0
#define DEFAULT_ACCEL     "<CTRL>F10"
#define VOID_ACCEL        "VoidSymbol"

/* possible scrollbar settings */
typedef enum {
  TERMINAL_SCROLLBAR_NONE = 0,
  TERMINAL_SCROLLBAR_LEFT = 1,
  TERMINAL_SCROLLBAR_RIGHT = 2,
} TerminalScrollbar;

/* settings names */
#define CHANNEL_TERMINAL_FONTNAME   "Terminal/FontName"
#define CHANNEL_TERMINAL_SCROLLBACK "Terminal/Scrollback"
#define CHANNEL_TERMINAL_SCROLLBAR  "Terminal/Scrollbar"
#define CHANNEL_TERMINAL_SHOWMENU   "Terminal/ShowMenu"
#define CHANNEL_TERMINAL_ACCELS     "Terminal/Accels"

/* settings defaults */
#define DEFAULT_TERMINAL_FONTNAME   "Andale Mono 10"
#define DEFAULT_TERMINAL_SCROLLBACK 500
#define DEFAULT_TERMINAL_SCROLLBAR  TERMINAL_SCROLLBAR_RIGHT
#define DEFAULT_TERMINAL_SHOWMENU   TOGGLE_PRESSED
#define DEFAULT_TERMINAL_ACCELS     TOGGLE_PRESSED

#endif  /* !__SETTINGS_SETTINGS_H__ */

