/* $Id: plugin.c,v 1.1.1.1 2004/08/25 21:19:47 eduard Exp $ */
/*-
 * Copyright (c) 2004 Eduard Roccatello <eduard@xfce.org>
 * Copyright (c) 2004 Benedikt Meurer <benny@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libxfce4mcs/mcs-common.h>
#include <libxfce4mcs/mcs-manager.h>
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <xfce-mcs-manager/manager-plugin.h>

#include <settings/plugin.h>
#include <settings/terminal-icon.h>

/* prototypes */
static void     plugin_create_channel (McsPlugin *mcs_plugin);
static gboolean plugin_write_options (McsPlugin *mcs_plugin);

static McsPlugin  *plugin = NULL;
static gchar      *plugin_terminal_fontname = NULL;
static gint       plugin_terminal_scrollback = DEFAULT_TERMINAL_SCROLLBACK;
static gint       plugin_terminal_scrollbar = DEFAULT_TERMINAL_SCROLLBAR;
static gint       plugin_terminal_showmenu = DEFAULT_TERMINAL_SHOWMENU;
static gint       plugin_terminal_accels = DEFAULT_TERMINAL_ACCELS;

void
plugin_set_terminal_fontname (const gchar *fontname)
{
  if (plugin_terminal_fontname != NULL)
    g_free (plugin_terminal_fontname);

  if (fontname != NULL)
    plugin_terminal_fontname = g_strdup (fontname);
  else
    plugin_terminal_fontname = g_strdup (DEFAULT_TERMINAL_FONTNAME);

  mcs_manager_set_string (plugin->manager, CHANNEL_TERMINAL_FONTNAME, CHANNEL,
      plugin_terminal_fontname);
  mcs_manager_notify (plugin->manager, CHANNEL);
  plugin_write_options (plugin);
}

G_CONST_RETURN gchar*
plugin_get_terminal_fontname (void)
{
  return plugin_terminal_fontname;
}

void
plugin_set_terminal_scrollback (gint lines)
{
  plugin_terminal_scrollback = lines;
  mcs_manager_set_int (plugin->manager, CHANNEL_TERMINAL_SCROLLBACK, CHANNEL,
      plugin_terminal_scrollback);
  mcs_manager_notify (plugin->manager, CHANNEL);
  plugin_write_options (plugin);
}

gint
plugin_get_terminal_scrollback (void)
{
  return plugin_terminal_scrollback;
}

void
plugin_set_terminal_scrollbar (gint scrollbar)
{
  plugin_terminal_scrollbar = scrollbar;
  mcs_manager_set_int (plugin->manager, CHANNEL_TERMINAL_SCROLLBAR, CHANNEL,
      plugin_terminal_scrollbar);
  mcs_manager_notify (plugin->manager, CHANNEL);
  plugin_write_options (plugin);
}

gint
plugin_get_terminal_scrollbar (void)
{
  return plugin_terminal_scrollbar;
}

void
plugin_set_terminal_showmenu (gint showmenu)
{
  plugin_terminal_showmenu = showmenu;
  mcs_manager_set_int (plugin->manager, CHANNEL_TERMINAL_SHOWMENU, CHANNEL,
      plugin_terminal_showmenu);
  mcs_manager_notify (plugin->manager, CHANNEL);
  plugin_write_options (plugin);
}

gint
plugin_get_terminal_showmenu (void)
{
  return plugin_terminal_showmenu;
}

void
plugin_set_terminal_accels (gint accels)
{
  plugin_terminal_accels = accels;
  mcs_manager_set_int (plugin->manager, CHANNEL_TERMINAL_ACCELS, CHANNEL,
      plugin_terminal_accels);
  mcs_manager_notify (plugin->manager, CHANNEL);
  plugin_write_options (plugin);
}

gint
plugin_get_terminal_accels (void)
{
  return plugin_terminal_accels;
}


static McsSetting *
plugin_lookup_setting (const gchar *name)
{
  return mcs_manager_setting_lookup (plugin->manager, name, CHANNEL);
}

static void
plugin_create_channel (McsPlugin *mcs_plugin)
{
  McsSetting *setting;
  gchar *rcfile;

  /* load stored settings */
  rcfile = xfce_get_userfile (RCDIR, RCFILE, NULL);
  mcs_manager_add_channel_from_file (plugin->manager, CHANNEL, rcfile);
  g_free (rcfile);

  /* setup terminal font name */
  if ((setting = plugin_lookup_setting (CHANNEL_TERMINAL_FONTNAME)) != NULL) {
    if (plugin_terminal_fontname != NULL)
      g_free (plugin_terminal_fontname);

    plugin_terminal_fontname = g_strdup (setting->data.v_string);
  }
  else {
    if (plugin_terminal_fontname != NULL)
      g_free (plugin_terminal_fontname);

    plugin_terminal_fontname = g_strdup (DEFAULT_TERMINAL_FONTNAME);
    mcs_manager_set_string (plugin->manager, CHANNEL_TERMINAL_FONTNAME,
        CHANNEL, plugin_terminal_fontname);
  }

  /* setup terminal menubar show up */
  if ((setting = plugin_lookup_setting (CHANNEL_TERMINAL_SHOWMENU)) != NULL)
    plugin_terminal_showmenu = setting->data.v_int;
  else {
    mcs_manager_set_int (plugin->manager, CHANNEL_TERMINAL_SHOWMENU,
        CHANNEL, plugin_terminal_showmenu);
  }

  /* setup terminal menubar accels show up */
  if ((setting = plugin_lookup_setting (CHANNEL_TERMINAL_ACCELS)) != NULL)
    plugin_terminal_accels = setting->data.v_int;
  else {
    mcs_manager_set_int (plugin->manager, CHANNEL_TERMINAL_ACCELS,
        CHANNEL, plugin_terminal_accels);
  }

  /* setup terminal scrollback lines */
  if ((setting = plugin_lookup_setting (CHANNEL_TERMINAL_SCROLLBACK)) != NULL)
    plugin_terminal_scrollback = setting->data.v_int;
  else {
    mcs_manager_set_int (plugin->manager, CHANNEL_TERMINAL_SCROLLBACK,
        CHANNEL, plugin_terminal_scrollback);
  }

  /* setup terminal scrollbar type */
  if ((setting = plugin_lookup_setting (CHANNEL_TERMINAL_SCROLLBAR)) != NULL)
    plugin_terminal_scrollbar = setting->data.v_int;
  else {
    mcs_manager_set_int (plugin->manager, CHANNEL_TERMINAL_SCROLLBAR,
        CHANNEL, plugin_terminal_scrollbar);
  }
}

static gboolean
plugin_write_options (McsPlugin *mcs_plugin)
{
  gboolean result;
  gchar *rcfile;

  rcfile = xfce_get_userfile (RCDIR, RCFILE, NULL);
  result = mcs_manager_save_channel_to_file (mcs_plugin->manager, CHANNEL,
                  rcfile);
  g_free (rcfile);

  return result;
}

static void
plugin_run_dialog (McsPlugin *mcs_plugin)
{
  extern void dialog_show_for_plugin (McsPlugin *mcs_plugin);
  dialog_show_for_plugin (mcs_plugin);
}

McsPluginInitResult
mcs_plugin_init (McsPlugin *mcs_plugin)
{
  xfce_textdomain (GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

  /* store plugin pointer for later use */
  plugin = mcs_plugin;

  /* create the XSettings channel */
  plugin_create_channel (plugin);

  plugin->plugin_name = g_strdup (CHANNEL);
  plugin->caption = g_strdup (_("Xfce Terminal Emulator"));
  plugin->run_dialog = plugin_run_dialog;
  plugin->icon = inline_icon_at_size (terminal_icon_data, 48, 48);

  return MCS_PLUGIN_INIT_OK;
}

/* defined in manager-plugin.h */
MCS_PLUGIN_CHECK_INIT;
