/* $Id: dialog.c,v 1.1.1.1 2004/08/25 21:19:44 eduard Exp $ */
/*-
 * Copyright (c) 2004 Eduard Roccatello <eduard@xfce.org>
 * Copyright (c) 2004 Benedikt Meurer <benny@xfce.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <gtk/gtk.h>

#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <xfce-mcs-manager/manager-plugin.h>

#include <settings/plugin.h>
#include <settings/terminal-icon.h>

#define BORDER 5


typedef struct _Dialog Dialog;
struct _Dialog
{
  McsPlugin *plugin;

  GtkWidget *window;
  GtkWidget *header;
  GtkWidget *notebook;

  /* "General" tab */
  GtkWidget *general_fontbutton;
  GtkWidget *general_checkAccels;
  GtkWidget *general_checkMenu;

  /* "Scrolling" tab */
  GtkWidget *scrolling_linesspinner;

  /* button box */
  GtkWidget *closebutton;

  /* external windows */
  GtkWidget *font_selection;
};


static Dialog *dialog = NULL;


typedef struct _MenuTemplate MenuTemplate;
struct _MenuTemplate
{
  gchar *title;
  gchar *action;
};

static MenuTemplate scrollbar_choices[] = {
  { N_("Disabled"), "none" },
  { N_("On the left side"), "left" },
  { N_("On the right side"), "right" },
  { NULL, NULL },
};

static GtkWidget *
create_option_menu_box (MenuTemplate *template, guint selected_index,
                        GCallback handler, gpointer user_data)
{
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *menu;
  GtkWidget *omenu;
  GtkWidget *item;
  guint index;

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  omenu = gtk_option_menu_new ();
  gtk_box_pack_start (GTK_BOX (hbox), omenu, TRUE, TRUE, 0);
  gtk_widget_show (omenu);

  menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
  gtk_widget_show (menu);

  for (index = 0; template[index].title != NULL; ++index) {
    item = gtk_menu_item_new_with_mnemonic (_(template[index].title));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
    gtk_widget_show(item);

    g_object_set_data (G_OBJECT (item), "user-data", template[index].action);
    g_signal_connect (G_OBJECT (item), "activate", handler, user_data);
  }
    
  if (selected_index < index)
    gtk_option_menu_set_history (GTK_OPTION_MENU (omenu), selected_index);

  return vbox;
}


static void
dialog_general_font_selection_ok_clicked (GtkWidget *button, Dialog *dialog)
{
  gchar *fontname;

  fontname = gtk_font_selection_dialog_get_font_name (
      GTK_FONT_SELECTION_DIALOG (dialog->font_selection));

  if (fontname != NULL && strcmp (fontname, plugin_get_terminal_fontname ())) {
    gtk_button_set_label (GTK_BUTTON (dialog->general_fontbutton), fontname);
    plugin_set_terminal_fontname (fontname);
    g_free (fontname);
  }

  gtk_widget_destroy (dialog->font_selection);
  dialog->font_selection = NULL;
}

static void
dialog_general_fontbutton_clicked (GtkWidget *fontbutton, Dialog *dialog)
{
  if (dialog->font_selection == NULL) {
    dialog->font_selection = gtk_font_selection_dialog_new (
        _("Font Selection Dialog"));

    gtk_window_set_position (GTK_WINDOW (dialog->font_selection),
        GTK_WIN_POS_MOUSE);

    gtk_font_selection_dialog_set_font_name (
        GTK_FONT_SELECTION_DIALOG (dialog->font_selection),
        gtk_button_get_label (GTK_BUTTON (fontbutton)));

    g_signal_connect (G_OBJECT (dialog->font_selection), "destroy",
        G_CALLBACK (gtk_widget_destroyed), &dialog->font_selection);

    g_signal_connect (G_OBJECT (GTK_FONT_SELECTION_DIALOG (
            dialog->font_selection)->ok_button), "clicked",
        G_CALLBACK (dialog_general_font_selection_ok_clicked), dialog);

    g_signal_connect_swapped (G_OBJECT (GTK_FONT_SELECTION_DIALOG (
            dialog->font_selection)->cancel_button), "clicked",
        G_CALLBACK (gtk_widget_destroy), dialog->font_selection);

    gtk_widget_show (dialog->font_selection);
  }
  else {
    gtk_widget_destroy (dialog->font_selection);
    dialog->font_selection = NULL;
  }
}

static void
dialog_general_checkMenu_toggled (GtkWidget *checkMenu, Dialog *dialog)
{
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkMenu))) {
        plugin_set_terminal_showmenu(TOGGLE_PRESSED);
        gtk_widget_set_sensitive(dialog->general_checkAccels, TRUE);
    }
    else {
        plugin_set_terminal_showmenu(TOGGLE_UNPRESSED);
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(dialog->general_checkAccels), FALSE);
        gtk_widget_set_sensitive(dialog->general_checkAccels, FALSE);
    }
}

static void
dialog_general_checkAccels_toggled (GtkWidget *checkAccels, Dialog *dialog)
{
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkAccels))) {
        plugin_set_terminal_accels (TOGGLE_PRESSED);
    }
    else {
        plugin_set_terminal_accels (TOGGLE_UNPRESSED);
    }
}

static void
dialog_create_general_tab (Dialog *dialog)
{
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *hbox;
  GtkWidget *vbox;

  GtkWidget *ac_frame;
  GtkWidget *ac_vbox;
  GtkWidget *ac_check;
  GtkWidget *ac_check_menu;

  label = gtk_label_new (_("General"));
  vbox = gtk_vbox_new (FALSE, BORDER);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), BORDER);
  gtk_notebook_append_page (GTK_NOTEBOOK (dialog->notebook), vbox, label);

  frame = xfce_framebox_new (_("Font"), TRUE);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, BORDER);
  xfce_framebox_add (XFCE_FRAMEBOX (frame), hbox);

  dialog->general_fontbutton = gtk_button_new ();
  gtk_button_set_label (GTK_BUTTON (dialog->general_fontbutton),
      plugin_get_terminal_fontname());
  gtk_box_pack_start (GTK_BOX (hbox), dialog->general_fontbutton,
      FALSE, FALSE, 0);

  ac_frame = xfce_framebox_new (_("Menu"), TRUE);
  gtk_box_pack_start (GTK_BOX (vbox), ac_frame, TRUE, FALSE, 0);

  ac_vbox = gtk_vbox_new (FALSE, BORDER);
  gtk_container_set_border_width (GTK_CONTAINER (ac_vbox), BORDER);
  xfce_framebox_add (XFCE_FRAMEBOX (ac_frame), ac_vbox);

  dialog->general_checkMenu = gtk_check_button_new_with_label (_("Show terminal menubar"));
  gtk_box_pack_start (GTK_BOX (ac_vbox), dialog->general_checkMenu, TRUE, FALSE, 0);
  dialog->general_checkAccels = gtk_check_button_new_with_label (_("Enable default menu accelerator (Ctrl+F10)"));
  gtk_box_pack_start (GTK_BOX (ac_vbox), dialog->general_checkAccels, TRUE, FALSE, 0);

  if (plugin_get_terminal_showmenu()==TOGGLE_PRESSED)
  {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(dialog->general_checkMenu), TRUE);
      if (plugin_get_terminal_accels()==TOGGLE_PRESSED)
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(dialog->general_checkAccels), TRUE);
  }
  else
      gtk_widget_set_sensitive (dialog->general_checkAccels, FALSE);
}

static void
dialog_scrolling_scrollback_changed (GtkSpinButton *spinner, Dialog *dialog)
{
  plugin_set_terminal_scrollback ((gint)gtk_spin_button_get_value (spinner));
}

static void
dialog_scrolling_scrollbar_changed (GtkWidget *item, Dialog *dialog)
{
  gchar *action;
  guint n;

  if ((action = g_object_get_data (G_OBJECT (item), "user-data")) != NULL) {
    for (n = 0; scrollbar_choices[n].action != NULL; ++n) {
      if (strcmp (scrollbar_choices[n].action, action) == 0) {
        plugin_set_terminal_scrollbar (n);
        break;
      }
    }
  }
}

static void
dialog_create_scrolling_tab (Dialog *dialog)
{
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *menubox;

  label = gtk_label_new (_("Scrolling"));
  vbox = gtk_vbox_new (FALSE, BORDER);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), BORDER);
  gtk_notebook_append_page (GTK_NOTEBOOK (dialog->notebook), vbox, label);

  frame = xfce_framebox_new (_("Scrollback lines"), TRUE);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, BORDER);
  xfce_framebox_add (XFCE_FRAMEBOX (frame), hbox);

  dialog->scrolling_linesspinner = gtk_spin_button_new (
      GTK_ADJUSTMENT (gtk_adjustment_new (
          plugin_get_terminal_scrollback (),
          50.0,
          1000.0 * 1000.0,
          1.0,
          20.0,
          20.0)),
      5.0,
      0);
  gtk_box_pack_start (GTK_BOX (hbox), dialog->scrolling_linesspinner,
      FALSE, FALSE, 0);

  frame = xfce_framebox_new (_("Scrollbar"), TRUE);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, BORDER);
  xfce_framebox_add (XFCE_FRAMEBOX (frame), hbox);

  menubox = create_option_menu_box (scrollbar_choices, 
      plugin_get_terminal_scrollbar (),
      G_CALLBACK (dialog_scrolling_scrollbar_changed),
      dialog);
  gtk_box_pack_start (GTK_BOX (hbox), menubox, FALSE, FALSE, 0);
}


static void
dialog_response (GtkWidget *window, gint response)
{
  if (response != GTK_RESPONSE_HELP && dialog != NULL) {
    gtk_widget_destroy (dialog->window);
    g_free (dialog);
    dialog = NULL;
  }
}

static void
dialog_setup_signals (Dialog *dialog)
{
  g_signal_connect (G_OBJECT (dialog->window), "response",
      G_CALLBACK (dialog_response), dialog);
  g_signal_connect (G_OBJECT (dialog->general_fontbutton), "clicked",
      G_CALLBACK (dialog_general_fontbutton_clicked), dialog);
  g_signal_connect (G_OBJECT (dialog->general_checkMenu), "toggled",
      G_CALLBACK (dialog_general_checkMenu_toggled), dialog);
  g_signal_connect (G_OBJECT (dialog->general_checkAccels), "toggled",
      G_CALLBACK (dialog_general_checkAccels_toggled), dialog);
  g_signal_connect (G_OBJECT (dialog->scrolling_linesspinner), "value-changed",
      G_CALLBACK (dialog_scrolling_scrollback_changed), dialog);
}

static void
dialog_create_buttons (Dialog *dialog)
{
  dialog->closebutton = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialog->window),
      dialog->closebutton, GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS (dialog->closebutton, GTK_CAN_DEFAULT);
}

static Dialog *
dialog_create_for_plugin (McsPlugin *mcs_plugin)
{
  GdkPixbuf *icon;
  Dialog *dialog;

  dialog = g_new0 (Dialog, 1);
  dialog->plugin = mcs_plugin;

  /* load icon */
  icon = inline_icon_at_size (terminal_icon_data, 32, 32);

  /* create dialog window */
  dialog->window = gtk_dialog_new ();
  gtk_dialog_set_has_separator (GTK_DIALOG (dialog->window), FALSE);
  gtk_window_set_title (GTK_WINDOW (dialog->window), _("Terminal Preferences"));
  gtk_window_set_icon (GTK_WINDOW (dialog->window), icon);

  /* create header */
  dialog->header = create_header (icon, _("Terminal Preferences"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog->window)->vbox),
      dialog->header, FALSE, TRUE, 0);

  /* unload icon */
  g_object_unref (G_OBJECT (icon));

  /* create notebook */
  dialog->notebook = gtk_notebook_new ();
  gtk_container_set_border_width (GTK_CONTAINER (dialog->notebook), BORDER + 1);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog->window)->vbox),
      dialog->notebook, FALSE, TRUE, 0);

  /* add notebook tabs */
  dialog_create_general_tab (dialog);
  /*dialog_create_scrolling_tab (dialog);*/

  /* create button box */
  dialog_create_buttons (dialog);

  /* connect signals */
  dialog_setup_signals (dialog);

  return dialog;
}


void
dialog_show_for_plugin (McsPlugin *mcs_plugin)
{
  if (dialog == NULL)
    dialog = dialog_create_for_plugin (mcs_plugin);

  gtk_widget_show_all (dialog->window);
}

