/*  xfce4
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _LIBXFCEGUI4_ICONS_H
#define _LIBXFCEGUI4_ICONS_H

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#ifdef HAVE_GDK_PIXBUF_NEW_FROM_STREAM
#define gdk_pixbuf_new_from_inline gdk_pixbuf_new_from_stream
#endif

GdkPixbuf *xfce_inline_icon_at_size (const guint8 * data, int width, int height);
void xfce_set_icon_theme(const gchar *theme_name);
gchar *xfce_themed_icon_lookup (const gchar *name, gint size);
GdkPixbuf *xfce_themed_icon_load (const gchar *name, gint size);
GdkPixbuf *xfce_pixbuf_new_from_file_at_size(const gchar *filename, gint width,
		gint height, GError **error);

#ifndef XFCE_DISABLE_DEPRECATED
GdkPixbuf *inline_icon_at_size (const guint8 * data, int width, int height);
GdkPixbuf *xfce_load_themed_icon (const gchar *name, gint size);
#endif

#endif /* _LIBXFCEGUI4_ICONS_H */
