/* Xlib utilities */

/*
 * Copyright (C) 2001 Havoc Pennington
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef NETK_XUTILS_H
#define NETK_XUTILS_H

#include <glib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xmd.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include "netk-window.h"

G_BEGIN_DECLS

#define NETK_APP_WINDOW_EVENT_MASK (PropertyChangeMask | StructureNotifyMask)

#define NETK_STOCK_MAXIMIZE     "gtk-zoom-100"
#define NETK_STOCK_UNMAXIMIZE   "gtk-zoom-out"
#define NETK_STOCK_MINIMIZE     "gtk-undo"
#define NETK_STOCK_UNMINIMIZE   "gtk-redo"
#define NETK_STOCK_SHADE        "gtk-goto-top"
#define NETK_STOCK_UNSHADE      "gtk-goto-bottom"
#define NETK_STOCK_STICK        "gtk-add"
#define NETK_STOCK_UNSTICK      "gtk-remove"
#define NETK_STOCK_DELETE       "gtk-close"

typedef struct p_DesktopMargins
{
    int left;
    int top;
    int right;
    int bottom;
}
p_DesktopMargins;

gboolean p_netk_get_cardinal (Window xwindow, Atom atom, int *val);
int p_netk_get_wm_state (Window xwindow);
gboolean p_netk_get_window (Window xwindow, Atom atom, Window * val);
gboolean p_netk_get_pixmap (Window xwindow, Atom atom, Pixmap * val);
gboolean p_netk_get_atom (Window xwindow, Atom atom, Atom * val);
char *p_netk_get_text_property (Window xwindow, Atom atom);
char *p_netk_get_utf8_property (Window xwindow, Atom atom);
gboolean p_netk_get_window_list (Window xwindow, Atom atom, Window ** windows,
                                 int *len);
gboolean p_netk_get_atom_list (Window xwindow, Atom atom, Atom ** atoms,
                               int *len);
gboolean p_netk_get_cardinal_list (Window xwindow, Atom atom,
                                   gulong ** cardinals, int *len);
char **p_netk_get_utf8_list (Window xwindow, Atom atom);
void p_netk_set_utf8_list (Window xwindow, Atom atom, char **list);

void p_netk_error_trap_push (void);
int p_netk_error_trap_pop (void);

Atom p_netk_atom_get (const char *atom_name);
const char *p_netk_atom_name (Atom atom);

void p_netk_event_filter_init (void);

int p_netk_xid_equal (gconstpointer v1, gconstpointer v2);
guint p_netk_xid_hash (gconstpointer v);

void p_netk_iconify (Window xwindow);
void p_netk_deiconify (Window xwindow);

void p_netk_close (Screen * screen, Window xwindow);

void p_netk_change_state (Screen * screen, Window xwindow, gboolean add,
                          Atom state1, Atom state2);
void p_netk_change_workspace (Screen * screen, Window xwindow, int new_space);
void p_netk_activate (Screen * screen, Window xwindow);
void p_netk_activate_workspace (Screen * screen, int new_active_space);
void p_netk_change_viewport (Screen * screen, int x, int y);

Window p_netk_get_group_leader (Window xwindow);
char *p_netk_get_session_id (Window xwindow);
int p_netk_get_pid (Window xwindow);
char *p_netk_get_name (Window xwindow);
char *p_netk_get_res_class_utf8 (Window xwindow);
void p_netk_get_wmclass (Window xwindow, char **res_class, char **res_name);

void p_netk_select_input (Window xwindow, int mask);

void p_netk_keyboard_move (Screen * screen, Window xwindow);

void p_netk_keyboard_size (Screen * screen, Window xwindow);
void p_netk_toggle_showing_desktop (Screen * screen, gboolean show);

typedef struct _NetkIconCache NetkIconCache;

NetkIconCache *p_netk_icon_cache_new (void);
void p_netk_icon_cache_free (NetkIconCache * icon_cache);
void p_netk_icon_cache_property_changed (NetkIconCache * icon_cache,
                                         Atom atom);
gboolean p_netk_icon_cache_get_icon_invalidated (NetkIconCache * icon_cache);
void p_netk_icon_cache_set_want_fallback (NetkIconCache * icon_cache,
                                          gboolean setting);
gboolean p_netk_icon_cache_get_is_fallback (NetkIconCache * icon_cache);

gboolean p_netk_read_icons (Window xwindow, NetkIconCache * icon_cache,
                            GdkPixbuf ** iconp, int ideal_width,
                            int ideal_height, GdkPixbuf ** mini_iconp,
                            int ideal_mini_width, int ideal_mini_height);
void p_netk_get_fallback_icons (GdkPixbuf ** iconp, int ideal_width,
                                int ideal_height, GdkPixbuf ** mini_iconp,
                                int ideal_mini_width, int ideal_mini_height);



void p_netk_get_window_geometry (Screen * screen, Window xwindow, int *xp,
                                 int *yp, int *widthp, int *heightp);

void p_netk_get_window_position (Screen * screen, Window xwindow, int *xp,
                                 int *yp);

void p_netk_set_icon_geometry (Window xwindow, int x, int y, int width,
                               int height);

/* p_netk_set_dock_type_hint() kept for backward compat */
#define p_netk_set_dock_type_hint (w) \
        p_netk_set_type_hint (w, NETK_WINDOW_DOCK)
void p_netk_set_type_hint (Window xwindow, NetkWindowType type);

void p_netk_set_desktop_layout (Screen * xscreen, int rows, int columns);

GdkPixbuf *p_netk_gdk_pixbuf_get_from_pixmap (GdkPixbuf * dest,
                                              Pixmap xpixmap, int src_x,
                                              int src_y, int dest_x,
                                              int dest_y, int width,
                                              int height);

#define NETK_NO_MANAGER_TOKEN 0

int p_netk_try_desktop_layout_manager (Screen * xscreen, int current_token);
void p_netk_release_desktop_layout_manager (Screen * xscreen,
                                            int current_token);
gboolean p_netk_desktop_layout_manager_process_event (XEvent * xev);

gboolean p_netk_get_desktop_margins (Screen * xscreen,
                                     p_DesktopMargins * margins);
void p_netk_set_desktop_margins (Window xwindow, p_DesktopMargins * margins);


G_END_DECLS
#endif /* NETK_XUTILS_H */
