/* $Id: xfce_iconbutton.c,v 1.19 2004/06/15 18:21:58 jasper Exp $
 * 
 * Copyright 2002-2004 Jasper Huijsmans (jasper@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

#include <gdk/gdk.h>
#include <gtk/gtkbutton.h>

#include "xfce_scaled_image.h"
#include "xfce_iconbutton.h"

#define DEBUGGING 0

/* XXX: this is used by gtkbutton. hope they won't change it soon ... */
#define CHILD_SPACING 1

/* Forward declarations */

static void xfce_iconbutton_class_init (XfceIconbuttonClass * class);
static void xfce_iconbutton_init (XfceIconbutton * iconbutton);

/* Local data */

static GtkWidgetClass *parent_class = NULL;

GtkType
xfce_iconbutton_get_type (void)
{
    static GtkType iconbutton_type = 0;

    if (!iconbutton_type)
    {
	static const GTypeInfo iconbutton_info = {
	    sizeof (XfceIconbuttonClass),
	    NULL,		/* base_init */
	    NULL,		/* base_finalize */
	    (GClassInitFunc) xfce_iconbutton_class_init,
	    NULL,		/* class_finalize */
	    NULL,		/* class_data */
	    sizeof (XfceIconbutton),
	    0,			/* n_preallocs */
	    (GInstanceInitFunc) xfce_iconbutton_init
	};

	iconbutton_type =
	    g_type_register_static (GTK_TYPE_BUTTON, "XfceIconbutton",
				    &iconbutton_info, 0);
    }

    return iconbutton_type;
}

static void
xfce_iconbutton_class_init (XfceIconbuttonClass * class)
{
    parent_class = gtk_type_class (gtk_button_get_type ());
}

static void
xfce_iconbutton_init (XfceIconbutton * iconbutton)
{
    iconbutton->image = xfce_scaled_image_new ();
    gtk_widget_show (iconbutton->image);
    gtk_container_add (GTK_CONTAINER (iconbutton), iconbutton->image);

    iconbutton->icon_width = iconbutton->icon_height = -1;
    iconbutton->pb = NULL;
}

GtkWidget *
xfce_iconbutton_new (void)
{
    return GTK_WIDGET (g_object_new (xfce_iconbutton_get_type (), NULL));
}

GtkWidget *
xfce_iconbutton_new_from_pixbuf (GdkPixbuf * pixbuf)
{
    GtkWidget *iconbutton;

    iconbutton = xfce_iconbutton_new ();
    xfce_iconbutton_set_pixbuf (XFCE_ICONBUTTON (iconbutton), pixbuf);

    return iconbutton;
}

void
xfce_iconbutton_set_pixbuf (XfceIconbutton * iconbutton, GdkPixbuf * pixbuf)
{
    g_return_if_fail (iconbutton != NULL);
    g_return_if_fail (XFCE_IS_ICONBUTTON (iconbutton));

    xfce_scaled_image_set_from_pixbuf (XFCE_SCALED_IMAGE (iconbutton->image),
	    			       pixbuf);
}


