/* $Id: xfce_aboutdialog.h,v 1.5 2004/03/17 23:18:20 benny Exp $ */
/*-
 * Copyright (c) 2002-2004 Benedikt Meurer <benny@xfce.org>
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __LIBXFCEGUI4_XFCE_ABOUTDIALOG_H__
#define __LIBXFCEGUI4_XFCE_ABOUTDIALOG_H__

#include <gtk/gtkdialog.h>

#include <libxfce4util/libxfce4util.h>

G_BEGIN_DECLS;

typedef struct _XfceAboutInfo XfceAboutInfo;

#define XFCE_COPYRIGHT_TEXT(years, owner) \
  ("Copyright (c) " years "\n" owner ".\nAll rights reserved.")

XfceAboutInfo*    xfce_about_info_new           (const gchar *program,
                                                 const gchar *version,
                                                 const gchar *description,
                                                 const gchar *copyright,
                                                 const gchar *license);

void              xfce_about_info_free          (XfceAboutInfo *info);

void              xfce_about_info_set_homepage  (XfceAboutInfo *info,
                                                 const gchar *homepage);

void              xfce_about_info_add_credit    (XfceAboutInfo *info,
                                                 const gchar *name,
                                                 const gchar *mail,
                                                 const gchar *task);

#define XFCE_TYPE_ABOUT_DIALOG  xfce_about_dialog_get_type()
#define XFCE_ABOUT_DIALOG(obj) \
  G_TYPE_CHECK_INSTANCE_CAST(obj, XFCE_TYPE_ABOUT_DIALOG, XfceAboutDialog)
#define XFCE_ABOUT_DIALOG_CLASS(klass) \
  G_TYPE_CHECK_CLASS_CAST(klass, XFCE_TYPE_ABOUT_DIALOG, XfceAboutDialogClass)
#define XFCE_IS_ABOUT_DIALOG(obj) \
  G_TYPE_CHECK_INSTANCE_TYPE(obj, XFCE_TYPE_ABOUT_DIALOG)

typedef struct _XfceAboutDialogClass XfceAboutDialogClass;

typedef struct _XfceAboutDialog XfceAboutDialog;

struct _XfceAboutDialogClass
{
  GtkDialogClass parent_class;
};

struct _XfceAboutDialog
{
  GtkDialog parent;

  struct _XfceAboutDialogPrivate *priv;
};

GType       xfce_about_dialog_get_type (void);

GtkWidget*  xfce_about_dialog_new (GtkWindow            *parent,
                                   const XfceAboutInfo  *info,
                                   GdkPixbuf            *icon);

G_END_DECLS;

#endif  /* !__LIBXFCEGUI4_XFCE_ABOUTDIALOG_H__ */
