/* Private stuff */

/*
 * Copyright (C) 2001 Havoc Pennington
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef NETK_PRIVATE_H
#define NETK_PRIVATE_H

#include <libxfce4util/libxfce4util.h>

#include <libxfcegui4/netk-screen.h>
#include <libxfcegui4/netk-window.h>
#include <libxfcegui4/netk-workspace.h>
#include <libxfcegui4/netk-application.h>
#include <libxfcegui4/netk-xutils.h>
#include <libxfcegui4/netk-pager.h>

G_BEGIN_DECLS

void p_netk_application_process_property_notify (NetkApplication * app,
                                                 XEvent * xevent);
void p_netk_window_process_property_notify (NetkWindow * window,
                                            XEvent * xevent);

void p_netk_screen_process_property_notify (NetkScreen * screen,
                                            XEvent * xevent);
void p_netk_window_process_configure_notify (NetkWindow * window,
                                             XEvent * xevent);
NetkWindow *p_netk_window_create (Window xwindow, NetkScreen * screen);
void p_netk_window_destroy (NetkWindow * window);

NetkWorkspace *p_netk_workspace_create (int number, NetkScreen * screen);
void p_netk_workspace_destroy (NetkWorkspace * space);

void p_netk_window_set_application (NetkWindow * window,
                                    NetkApplication * app);
void p_netk_window_set_class_group (NetkWindow     *window,
                                   NetkClassGroup *class_group);

void p_netk_application_add_window (NetkApplication * app,
                                    NetkWindow * window);
void p_netk_application_remove_window (NetkApplication * app,
                                       NetkWindow * window);

NetkApplication *p_netk_application_create (Window xwindow,
                                            NetkScreen * screen);
void p_netk_application_destroy (NetkApplication * app);

void p_netk_workspace_update_name (NetkWorkspace * workspace,
                                   const char *name);
void p_netk_screen_change_workspace_name (NetkScreen * screen, int number,
                                          const char *name);

gboolean p_netk_workspace_set_geometry (NetkWorkspace * space, int w, int h);
gboolean p_netk_workspace_set_viewport (NetkWorkspace * space, int x, int y);

void p_netk_init (void);

#define DEFAULT_ICON_WIDTH 32
#define DEFAULT_ICON_HEIGHT 32
#define DEFAULT_MINI_ICON_WIDTH 16
#define DEFAULT_MINI_ICON_HEIGHT 16

#define NETK_SCREEN_XSCREEN(screen) (p_netk_screen_get_xscreen (screen))

Screen *p_netk_screen_get_xscreen (NetkScreen * screen);
int p_netk_screen_get_number (NetkScreen * screen);

void p_netk_pager_activate_workspace (NetkWorkspace * wspace);
int p_netk_pager_get_n_workspaces (NetkPager * pager);
const char *p_netk_pager_get_workspace_name (NetkPager * pager, int i);
NetkWorkspace *p_netk_pager_get_active_workspace (NetkPager * pager);
NetkWorkspace *p_netk_pager_get_workspace (NetkPager * pager, int i);
void p_netk_pager_get_workspace_rect (NetkPager * pager, int i,
                                      GdkRectangle * rect);

void p_make_gtk_label_bold (GtkLabel *label);
void p_make_gtk_label_normal (GtkLabel *label);

G_END_DECLS
#endif /* NETK_PRIVATE_H */
