/*  xfce4
 *  Copyright (C) 2002 Olivier Fourdan (fourdan@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __XFCE_DECORBUTTON_H__
#define __XFCE_DECORBUTTON_H__

#include <gdk/gdk.h>
#include <gtk/gtkmisc.h>


#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */


#define XFCE_DECORBUTTON(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, xfce_decorbutton_get_type (), XfceDecorbutton)
#define XFCE_DECORBUTTON_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, xfce_decorbutton_get_type (), XfceDecorbuttonClass)
#define XFCE_IS_DECORBUTTON(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, xfce_decorbutton_get_type ())

    typedef struct _XfceDecorbutton XfceDecorbutton;
    typedef struct _XfceDecorbuttonClass XfceDecorbuttonClass;

    typedef enum
    {
	XFCE_DECORBUTTON_CLOSE,
	XFCE_DECORBUTTON_HIDE
    }
    XfceDecorbuttonType;

    struct _XfceDecorbutton
    {
	GtkMisc misc;
	XfceDecorbuttonType type;

	/* Private data */

	GdkBitmap *close_dark_bmap;
	GdkBitmap *close_mid_bmap;
	GdkBitmap *close_light_bmap;

	GdkBitmap *hide_dark_bmap;
	GdkBitmap *hide_mid_bmap;
	GdkBitmap *hide_light_bmap;
    };

    struct _XfceDecorbuttonClass
    {
	GtkMiscClass parent_class;
    };


    GtkType xfce_decorbutton_get_type (void);
    GtkWidget *xfce_decorbutton_new (XfceDecorbuttonType type);

#ifdef __cplusplus
}
#endif				/* __cplusplus */


#endif				/* __XFCE_DECORBUTTON_H__ */
