/* dbbrowser.c generated by valac 0.42.5, the Vala compiler
 * generated from dbbrowser.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define XFMPC_TYPE_DBBROWSER (xfmpc_dbbrowser_get_type ())
#define XFMPC_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser))
#define XFMPC_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))
#define XFMPC_IS_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_DBBROWSER))
#define XFMPC_IS_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_DBBROWSER))
#define XFMPC_DBBROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))

typedef struct _XfmpcDbbrowser XfmpcDbbrowser;
typedef struct _XfmpcDbbrowserClass XfmpcDbbrowserClass;
typedef struct _XfmpcDbbrowserPrivate XfmpcDbbrowserPrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;
enum  {
	XFMPC_DBBROWSER_0_PROPERTY,
	XFMPC_DBBROWSER_NUM_PROPERTIES
};
static GParamSpec* xfmpc_dbbrowser_properties[XFMPC_DBBROWSER_NUM_PROPERTIES];
typedef enum  {
	XFMPC_DBBROWSER_COLUMNS_COLUMN_ID,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT,
	XFMPC_DBBROWSER_COLUMNS_N_COLUMNS
} XfmpcDbbrowserColumns;


#define XFMPC_DBBROWSER_TYPE_COLUMNS (xfmpc_dbbrowser_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define XFMPC_TYPE_PLAYLIST (xfmpc_playlist_get_type ())
#define XFMPC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylist))
#define XFMPC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))
#define XFMPC_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PLAYLIST))
#define XFMPC_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PLAYLIST))
#define XFMPC_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))

typedef struct _XfmpcPlaylist XfmpcPlaylist;
typedef struct _XfmpcPlaylistClass XfmpcPlaylistClass;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _XfmpcDbbrowser {
	GtkBox parent_instance;
	XfmpcDbbrowserPrivate * priv;
};

struct _XfmpcDbbrowserClass {
	GtkBoxClass parent_class;
};

struct _XfmpcDbbrowserPrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkListStore* store;
	GtkTreeView* treeview;
	GtkMenu* menu;
	GtkEntry* search_entry;
	GtkMenuItem* mi_browse;
	gchar* wdir;
	gchar* last_wdir;
	gboolean is_searching;
	guint search_timeout;
};


static gint XfmpcDbbrowser_private_offset;
static gpointer xfmpc_dbbrowser_parent_class = NULL;

GType xfmpc_dbbrowser_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
static GType xfmpc_dbbrowser_columns_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void xfmpc_dbbrowser_reload (XfmpcDbbrowser* self);
GType xfmpc_playlist_get_type (void) G_GNUC_CONST;
static void xfmpc_dbbrowser_clear (XfmpcDbbrowser* self);
gboolean xfmpc_dbbrowser_wdir_is_root (XfmpcDbbrowser* self);
gchar* xfmpc_dbbrowser_get_parent_wdir (XfmpcDbbrowser* self);
void xfmpc_dbbrowser_append (XfmpcDbbrowser* self,
                             const gchar* filename,
                             const gchar* basename,
                             gboolean is_dir,
                             gboolean is_bold);
gboolean xfmpc_playlist_has_filename (XfmpcPlaylist* self,
                                      const gchar* filename,
                                      gboolean is_dir);
static void _vala_GtkTreePath_free (GtkTreePath* self);
void xfmpc_dbbrowser_set_wdir (XfmpcDbbrowser* self,
                               const gchar* dir);
void xfmpc_dbbrowser_add_selected_rows (XfmpcDbbrowser* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
void xfmpc_dbbrowser_search (XfmpcDbbrowser* self,
                             const gchar* query);
static void xfmpc_dbbrowser_menu_popup (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_playlist_changed (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_popup_menu (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_key_pressed (XfmpcDbbrowser* self,
                                         GdkEventKey* event);
static gboolean xfmpc_dbbrowser_cb_button_released (XfmpcDbbrowser* self,
                                             GdkEventButton* event);
static void xfmpc_dbbrowser_cb_row_activated (XfmpcDbbrowser* self,
                                       GtkTreePath* path,
                                       GtkTreeViewColumn* column);
static void xfmpc_dbbrowser_cb_replace_with_selected_rows (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_browse (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_search_entry_activated (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_search_entry_key_released (XfmpcDbbrowser* self,
                                                       GdkEventKey* event);
static void xfmpc_dbbrowser_cb_search_entry_changed (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_timeout_search (XfmpcDbbrowser* self);
static gboolean _xfmpc_dbbrowser_timeout_search_gsource_func (gpointer self);
static void xfmpc_dbbrowser_cb_search_entry_icon_activated (XfmpcDbbrowser* self,
                                                     GtkEntryIconPosition icon_pos,
                                                     GdkEvent* event);
XfmpcDbbrowser* xfmpc_dbbrowser_new (void);
XfmpcDbbrowser* xfmpc_dbbrowser_construct (GType object_type);
static GObject * xfmpc_dbbrowser_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
XfmpcPreferences* xfmpc_preferences_get_default (void);
static void _xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                gpointer self);
static void _xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                            gpointer self);
static void _xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                        gpointer self);
static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected (XfmpcMpdclient* _sender,
                                                        gpointer self);
static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed (XfmpcMpdclient* _sender,
                                                               gpointer self);
static void _xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender,
                                                                            gpointer self);
static void _xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                    GtkTreePath* path,
                                                                    GtkTreeViewColumn* column,
                                                                    gpointer self);
static gboolean _xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                     GdkEventKey* event,
                                                                     gpointer self);
static gboolean _xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                            GdkEventButton* event,
                                                                            gpointer self);
static gboolean _xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                               gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                    gpointer self);
static gboolean _xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                                     GdkEventKey* event,
                                                                                     gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                    gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender,
                                                                             GtkEntryIconPosition icon_pos,
                                                                             GdkEventButton* event,
                                                                             gpointer self);
static void _xfmpc_dbbrowser_reload_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self);
static void xfmpc_dbbrowser_finalize (GObject * obj);


static inline gpointer
xfmpc_dbbrowser_get_instance_private (XfmpcDbbrowser* self)
{
	return G_STRUCT_MEMBER_P (self, XfmpcDbbrowser_private_offset);
}


static GType
xfmpc_dbbrowser_columns_get_type (void)
{
	static volatile gsize xfmpc_dbbrowser_columns_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_dbbrowser_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{XFMPC_DBBROWSER_COLUMNS_COLUMN_ID, "XFMPC_DBBROWSER_COLUMNS_COLUMN_ID", "column-id"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, "XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF", "column-pixbuf"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, "XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME", "column-filename"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, "XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME", "column-basename"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, "XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR", "column-is-dir"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, "XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT", "column-weight"}, {XFMPC_DBBROWSER_COLUMNS_N_COLUMNS, "XFMPC_DBBROWSER_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType xfmpc_dbbrowser_columns_type_id;
		xfmpc_dbbrowser_columns_type_id = g_enum_register_static ("XfmpcDbbrowserColumns", values);
		g_once_init_leave (&xfmpc_dbbrowser_columns_type_id__volatile, xfmpc_dbbrowser_columns_type_id);
	}
	return xfmpc_dbbrowser_columns_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}


void
xfmpc_dbbrowser_reload (XfmpcDbbrowser* self)
{
	gchar* filename = NULL;
	gchar* basename = NULL;
	gboolean is_dir = FALSE;
	gboolean is_bold = FALSE;
	gint i = 0;
	XfmpcPlaylist* playlist = NULL;
	gconstpointer _tmp0_;
	XfmpcPlaylist* _tmp1_;
	gboolean _tmp2_;
	XfmpcMpdclient* _tmp3_;
	g_return_if_fail (self != NULL);
	filename = NULL;
	basename = NULL;
	is_dir = FALSE;
	is_bold = FALSE;
	i = 0;
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp1_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp0_);
	playlist = _tmp1_;
	_tmp2_ = self->priv->is_searching;
	if (_tmp2_) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	xfmpc_dbbrowser_clear (self);
	_tmp3_ = self->priv->mpdclient;
	if (!xfmpc_mpdclient_is_connected (_tmp3_)) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	if (!xfmpc_dbbrowser_wdir_is_root (self)) {
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		_tmp4_ = xfmpc_dbbrowser_get_parent_wdir (self);
		_g_free0 (filename);
		filename = _tmp4_;
		_tmp5_ = filename;
		xfmpc_dbbrowser_append (self, _tmp5_, "..", TRUE, FALSE);
		_tmp6_ = i;
		i = _tmp6_ + 1;
	}
	while (TRUE) {
		XfmpcMpdclient* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		XfmpcPlaylist* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp7_ = self->priv->mpdclient;
		_tmp8_ = self->priv->wdir;
		_tmp12_ = xfmpc_mpdclient_database_read (_tmp7_, _tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
		_g_free0 (filename);
		filename = _tmp9_;
		_g_free0 (basename);
		basename = _tmp10_;
		is_dir = _tmp11_;
		if (!_tmp12_) {
			break;
		}
		_tmp13_ = playlist;
		_tmp14_ = filename;
		_tmp15_ = is_dir;
		is_bold = xfmpc_playlist_has_filename (_tmp13_, _tmp14_, _tmp15_);
		_tmp16_ = filename;
		_tmp17_ = basename;
		_tmp18_ = is_dir;
		_tmp19_ = is_bold;
		xfmpc_dbbrowser_append (self, _tmp16_, _tmp17_, _tmp18_, _tmp19_);
		_tmp20_ = filename;
		_tmp21_ = self->priv->last_wdir;
		if (g_utf8_collate (_tmp20_, _tmp21_) == 0) {
			GtkTreePath* path = NULL;
			gint _tmp22_;
			GtkTreePath* _tmp23_;
			GtkTreeView* _tmp24_;
			GtkTreePath* _tmp25_;
			GtkTreeView* _tmp26_;
			GtkTreePath* _tmp27_;
			_tmp22_ = i;
			_tmp23_ = gtk_tree_path_new_from_indices (_tmp22_, -1, -1);
			path = _tmp23_;
			_tmp24_ = self->priv->treeview;
			_tmp25_ = path;
			gtk_tree_view_set_cursor (_tmp24_, _tmp25_, NULL, FALSE);
			_tmp26_ = self->priv->treeview;
			_tmp27_ = path;
			gtk_tree_view_scroll_to_cell (_tmp26_, _tmp27_, NULL, TRUE, (gfloat) 0.10, (gfloat) 0);
			i = -1;
			__vala_GtkTreePath_free0 (path);
		} else {
			gint _tmp28_;
			_tmp28_ = i;
			i = _tmp28_ + 1;
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (basename);
	_g_free0 (filename);
}


gboolean
xfmpc_dbbrowser_wdir_is_root (XfmpcDbbrowser* self)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->wdir;
	result = g_strcmp0 (_tmp0_, "") == 0;
	return result;
}


static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar*
xfmpc_dbbrowser_get_parent_wdir (XfmpcDbbrowser* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->wdir;
	if (string_index_of (_tmp0_, "/", 0) == -1) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->wdir;
		_tmp3_ = g_path_get_dirname (_tmp2_);
		result = _tmp3_;
		return result;
	}
}


void
xfmpc_dbbrowser_append (XfmpcDbbrowser* self,
                        const gchar* filename,
                        const gchar* basename,
                        gboolean is_dir,
                        gboolean is_bold)
{
	GtkTreeIter iter = {0};
	const gchar* _tmp0_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	GtkIconTheme* _tmp1_;
	GdkPixbuf* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	PangoWeight _tmp5_ = 0;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (basename != NULL);
	if (is_dir) {
		_tmp0_ = "folder";
	} else {
		_tmp0_ = "text-x-generic";
	}
	_tmp1_ = gtk_icon_theme_get_default ();
	_tmp2_ = gtk_icon_theme_load_icon (_tmp1_, _tmp0_, (gint) GTK_ICON_SIZE_MENU, 0, &_inner_error_);
	pixbuf = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = self->priv->store;
	gtk_list_store_append (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (is_bold) {
		_tmp5_ = PANGO_WEIGHT_BOLD;
	} else {
		_tmp5_ = PANGO_WEIGHT_NORMAL;
	}
	_tmp6_ = self->priv->store;
	_tmp7_ = iter;
	gtk_list_store_set (_tmp6_, &_tmp7_, XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, pixbuf, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, filename, XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, basename, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, is_dir, XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, _tmp5_, -1, -1);
	_g_object_unref0 (pixbuf);
}


void
xfmpc_dbbrowser_set_wdir (XfmpcDbbrowser* self,
                          const gchar* dir)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = self->priv->wdir;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->last_wdir);
	self->priv->last_wdir = _tmp1_;
	_tmp2_ = g_strdup (dir);
	_g_free0 (self->priv->wdir);
	self->priv->wdir = _tmp2_;
}


static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}


static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}


static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}


static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}


void
xfmpc_dbbrowser_add_selected_rows (XfmpcDbbrowser* self)
{
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter iter = {0};
	gchar* filename = NULL;
	gchar* _tmp2_;
	GList* list = NULL;
	GtkTreeView* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeModel* _tmp5_ = NULL;
	GList* _tmp6_;
	GtkTreeModel* _tmp7_;
	GList* _tmp8_;
	XfmpcMpdclient* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = g_strdup ("");
	filename = _tmp2_;
	_tmp3_ = self->priv->treeview;
	_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
	_tmp6_ = gtk_tree_selection_get_selected_rows (_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp5_);
	model = _tmp7_;
	list = _tmp6_;
	_tmp8_ = list;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp8_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp9_;
			GtkTreePath* path = NULL;
			_tmp9_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp9_;
			{
				GtkTreeModel* _tmp10_;
				GtkTreePath* _tmp11_;
				GtkTreeIter _tmp12_ = {0};
				gboolean _tmp13_;
				_tmp10_ = model;
				_tmp11_ = path;
				_tmp13_ = gtk_tree_model_get_iter (_tmp10_, &_tmp12_, _tmp11_);
				iter = _tmp12_;
				if (_tmp13_) {
					GtkTreeModel* _tmp14_;
					GtkTreeIter _tmp15_;
					gchar* _tmp16_ = NULL;
					XfmpcMpdclient* _tmp17_;
					const gchar* _tmp18_;
					_tmp14_ = model;
					_tmp15_ = iter;
					gtk_tree_model_get (_tmp14_, &_tmp15_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &_tmp16_, -1, -1);
					_g_free0 (filename);
					filename = _tmp16_;
					_tmp17_ = self->priv->mpdclient;
					_tmp18_ = filename;
					xfmpc_mpdclient_queue_add (_tmp17_, _tmp18_);
				}
				__vala_GtkTreePath_free0 (path);
			}
		}
	}
	_tmp19_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_commit (_tmp19_);
	(list == NULL) ? NULL : (list = (_g_list_free___vala_GtkTreePath_free0_ (list), NULL));
	_g_free0 (filename);
	_g_object_unref0 (model);
}


void
xfmpc_dbbrowser_search (XfmpcDbbrowser* self,
                        const gchar* query)
{
	gchar* filename = NULL;
	gchar* basename = NULL;
	gboolean is_bold = FALSE;
	gint i = 0;
	XfmpcPlaylist* playlist = NULL;
	gconstpointer _tmp0_;
	XfmpcPlaylist* _tmp1_;
	XfmpcMpdclient* _tmp2_;
	gboolean no_result_buf = FALSE;
	gboolean no_result = FALSE;
	gint _tmp13_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gint _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	filename = NULL;
	basename = NULL;
	i = 0;
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp1_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp0_);
	playlist = _tmp1_;
	_tmp2_ = self->priv->mpdclient;
	if (!xfmpc_mpdclient_is_connected (_tmp2_)) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	self->priv->is_searching = TRUE;
	xfmpc_dbbrowser_clear (self);
	while (TRUE) {
		XfmpcMpdclient* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_;
		XfmpcPlaylist* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_;
		gint _tmp12_;
		_tmp3_ = self->priv->mpdclient;
		_tmp6_ = xfmpc_mpdclient_database_search (_tmp3_, query, &_tmp4_, &_tmp5_);
		_g_free0 (filename);
		filename = _tmp4_;
		_g_free0 (basename);
		basename = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = playlist;
		_tmp8_ = filename;
		is_bold = xfmpc_playlist_has_filename (_tmp7_, _tmp8_, FALSE);
		_tmp9_ = filename;
		_tmp10_ = basename;
		_tmp11_ = is_bold;
		xfmpc_dbbrowser_append (self, _tmp9_, _tmp10_, FALSE, _tmp11_);
		_tmp12_ = i;
		i = _tmp12_ + 1;
	}
	no_result_buf = FALSE;
	no_result = FALSE;
	_tmp13_ = i;
	if (_tmp13_ == 0) {
		no_result = TRUE;
	} else {
		gboolean _tmp14_;
		_tmp14_ = no_result;
		if (_tmp14_) {
			no_result = FALSE;
		}
	}
	_tmp16_ = no_result;
	_tmp17_ = no_result_buf;
	if (_tmp16_ == _tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = no_result;
		_tmp15_ = _tmp18_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GtkEntry* _tmp19_;
		GtkStyleContext* _tmp20_;
		_tmp19_ = self->priv->search_entry;
		_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
		gtk_style_context_add_class (_tmp20_, "red");
	} else {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp22_ = no_result;
		_tmp23_ = no_result_buf;
		if (_tmp22_ == _tmp23_) {
			gboolean _tmp24_;
			_tmp24_ = no_result;
			_tmp21_ = !_tmp24_;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			GtkEntry* _tmp25_;
			GtkStyleContext* _tmp26_;
			_tmp25_ = self->priv->search_entry;
			_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
			gtk_style_context_remove_class (_tmp26_, "red");
		}
	}
	_tmp27_ = i;
	if (_tmp27_ == 0) {
		GtkEntry* _tmp28_;
		GtkStyleContext* _tmp29_;
		_tmp28_ = self->priv->search_entry;
		_tmp29_ = gtk_widget_get_style_context ((GtkWidget*) _tmp28_);
		gtk_style_context_add_class (_tmp29_, "red");
	} else {
		gboolean _tmp30_;
		_tmp30_ = no_result;
		if (_tmp30_) {
			GtkEntry* _tmp31_;
			GtkStyleContext* _tmp32_;
			_tmp31_ = self->priv->search_entry;
			_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
			gtk_style_context_remove_class (_tmp32_, "red");
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (basename);
	_g_free0 (filename);
}


static void
xfmpc_dbbrowser_clear (XfmpcDbbrowser* self)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	gtk_list_store_clear (_tmp0_);
}


static void
xfmpc_dbbrowser_menu_popup (XfmpcDbbrowser* self)
{
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	gint count = 0;
	GtkTreeSelection* _tmp3_;
	gboolean _tmp4_;
	GtkMenu* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	count = gtk_tree_selection_count_selected_rows (_tmp3_);
	_tmp4_ = self->priv->is_searching;
	if (_tmp4_) {
		GtkMenuItem* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gint _tmp7_;
		GtkMenuItem* _tmp8_;
		_tmp5_ = self->priv->mi_browse;
		gtk_widget_show ((GtkWidget*) _tmp5_);
		_tmp7_ = count;
		if (_tmp7_ == 1) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp8_ = self->priv->mi_browse;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp6_);
	} else {
		GtkMenuItem* _tmp9_;
		_tmp9_ = self->priv->mi_browse;
		gtk_widget_hide ((GtkWidget*) _tmp9_);
	}
	_tmp10_ = self->priv->menu;
	gtk_menu_popup_at_pointer (_tmp10_, NULL);
	_g_object_unref0 (selection);
}


static void
xfmpc_dbbrowser_cb_playlist_changed (XfmpcDbbrowser* self)
{
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter iter = {0};
	gchar* filename = NULL;
	gchar* _tmp2_;
	gboolean is_bold = FALSE;
	gboolean is_dir = FALSE;
	XfmpcPlaylist* playlist = NULL;
	gconstpointer _tmp3_;
	XfmpcPlaylist* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = g_strdup ("");
	filename = _tmp2_;
	is_bold = FALSE;
	is_dir = FALSE;
	_tmp3_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp4_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp3_);
	playlist = _tmp4_;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (!_tmp7_) {
		_g_object_unref0 (playlist);
		_g_free0 (filename);
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			GtkTreeModel* _tmp11_;
			GtkTreeIter _tmp12_;
			gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			XfmpcPlaylist* _tmp15_;
			const gchar* _tmp16_;
			gboolean _tmp17_;
			PangoWeight _tmp18_ = 0;
			gboolean _tmp19_;
			GtkListStore* _tmp20_;
			GtkTreeIter _tmp21_;
			if (!_tmp8_) {
				GtkTreeModel* _tmp9_;
				gboolean _tmp10_;
				_tmp9_ = model;
				_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
				if (!_tmp10_) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp11_ = model;
			_tmp12_ = iter;
			gtk_tree_model_get (_tmp11_, &_tmp12_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &_tmp13_, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, &_tmp14_, -1, -1);
			_g_free0 (filename);
			filename = _tmp13_;
			is_dir = _tmp14_;
			_tmp15_ = playlist;
			_tmp16_ = filename;
			_tmp17_ = is_dir;
			is_bold = xfmpc_playlist_has_filename (_tmp15_, _tmp16_, _tmp17_);
			_tmp19_ = is_bold;
			if (_tmp19_) {
				_tmp18_ = PANGO_WEIGHT_BOLD;
			} else {
				_tmp18_ = PANGO_WEIGHT_NORMAL;
			}
			_tmp20_ = self->priv->store;
			_tmp21_ = iter;
			gtk_list_store_set (_tmp20_, &_tmp21_, XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, _tmp18_, -1, -1);
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (filename);
	_g_object_unref0 (model);
}


static gboolean
xfmpc_dbbrowser_cb_popup_menu (XfmpcDbbrowser* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_dbbrowser_menu_popup (self);
	result = TRUE;
	return result;
}


static gboolean
xfmpc_dbbrowser_cb_key_pressed (XfmpcDbbrowser* self,
                                GdkEventKey* event)
{
	gboolean result = FALSE;
	GdkEventType _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->type;
	if (_tmp0_ != GDK_KEY_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp1_ = event->keyval;
	switch (_tmp1_) {
		case 0xff0d:
		{
			GtkTreeSelection* selection = NULL;
			GtkTreeView* _tmp2_;
			GtkTreeSelection* _tmp3_;
			GtkTreeSelection* _tmp4_;
			GtkTreeSelection* _tmp5_;
			_tmp2_ = self->priv->treeview;
			_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
			_tmp4_ = _g_object_ref0 (_tmp3_);
			selection = _tmp4_;
			_tmp5_ = selection;
			if (gtk_tree_selection_count_selected_rows (_tmp5_) > 1) {
				xfmpc_dbbrowser_add_selected_rows (self);
			} else {
				result = FALSE;
				_g_object_unref0 (selection);
				return result;
			}
			_g_object_unref0 (selection);
			break;
		}
		case 0xff08:
		{
			gchar* filename = NULL;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = xfmpc_dbbrowser_get_parent_wdir (self);
			filename = _tmp6_;
			_tmp7_ = filename;
			xfmpc_dbbrowser_set_wdir (self, _tmp7_);
			xfmpc_dbbrowser_reload (self);
			_g_free0 (filename);
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean
xfmpc_dbbrowser_cb_button_released (XfmpcDbbrowser* self,
                                    GdkEventButton* event)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventType _tmp1_;
	GtkTreePath* path = NULL;
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GtkTreeView* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GtkTreePath* _tmp9_ = NULL;
	gboolean _tmp10_;
	GtkTreeSelection* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event->type;
	if (_tmp1_ != GDK_BUTTON_PRESS) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_;
		_tmp2_ = event->button;
		_tmp0_ = _tmp2_ != ((guint) 3);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->treeview;
	_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	selection = _tmp5_;
	_tmp6_ = self->priv->treeview;
	_tmp7_ = event->x;
	_tmp8_ = event->y;
	_tmp10_ = gtk_tree_view_get_path_at_pos (_tmp6_, (gint) _tmp7_, (gint) _tmp8_, &_tmp9_, NULL, NULL, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp9_;
	if (_tmp10_) {
		GtkTreeSelection* _tmp11_;
		GtkTreePath* _tmp12_;
		_tmp11_ = selection;
		_tmp12_ = path;
		if (!gtk_tree_selection_path_is_selected (_tmp11_, _tmp12_)) {
			GtkTreeSelection* _tmp13_;
			GtkTreeSelection* _tmp14_;
			GtkTreePath* _tmp15_;
			_tmp13_ = selection;
			gtk_tree_selection_unselect_all (_tmp13_);
			_tmp14_ = selection;
			_tmp15_ = path;
			gtk_tree_selection_select_path (_tmp14_, _tmp15_);
		}
	}
	_tmp16_ = selection;
	if (gtk_tree_selection_count_selected_rows (_tmp16_) < 1) {
		result = TRUE;
		_g_object_unref0 (selection);
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	xfmpc_dbbrowser_menu_popup (self);
	result = TRUE;
	_g_object_unref0 (selection);
	__vala_GtkTreePath_free0 (path);
	return result;
}


static void
xfmpc_dbbrowser_cb_row_activated (XfmpcDbbrowser* self,
                                  GtkTreePath* path,
                                  GtkTreeViewColumn* column)
{
	GtkTreePath* ppath = NULL;
	GtkTreePath* _tmp0_;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter iter = {0};
	gchar* filename = NULL;
	gchar* _tmp3_;
	gboolean is_dir = FALSE;
	GtkTreeModel* _tmp4_;
	GtkTreePath* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreeIter _tmp9_;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = __vala_GtkTreePath_copy0 (path);
	ppath = _tmp0_;
	_tmp1_ = self->priv->store;
	_tmp2_ = _g_object_ref0 ((GtkTreeModel*) _tmp1_);
	model = _tmp2_;
	_tmp3_ = g_strdup ("");
	filename = _tmp3_;
	is_dir = FALSE;
	_tmp4_ = model;
	_tmp5_ = ppath;
	_tmp7_ = gtk_tree_model_get_iter (_tmp4_, &_tmp6_, _tmp5_);
	iter = _tmp6_;
	if (!_tmp7_) {
		_g_free0 (filename);
		_g_object_unref0 (model);
		__vala_GtkTreePath_free0 (ppath);
		return;
	}
	_tmp8_ = model;
	_tmp9_ = iter;
	gtk_tree_model_get (_tmp8_, &_tmp9_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &_tmp10_, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, &_tmp11_, -1, -1);
	_g_free0 (filename);
	filename = _tmp10_;
	is_dir = _tmp11_;
	_tmp12_ = is_dir;
	if (_tmp12_) {
		const gchar* _tmp13_;
		_tmp13_ = filename;
		xfmpc_dbbrowser_set_wdir (self, _tmp13_);
		xfmpc_dbbrowser_reload (self);
	} else {
		XfmpcMpdclient* _tmp14_;
		const gchar* _tmp15_;
		XfmpcMpdclient* _tmp16_;
		_tmp14_ = self->priv->mpdclient;
		_tmp15_ = filename;
		xfmpc_mpdclient_queue_add (_tmp14_, _tmp15_);
		_tmp16_ = self->priv->mpdclient;
		xfmpc_mpdclient_queue_commit (_tmp16_);
	}
	_g_free0 (filename);
	_g_object_unref0 (model);
	__vala_GtkTreePath_free0 (ppath);
}


static void
xfmpc_dbbrowser_cb_replace_with_selected_rows (XfmpcDbbrowser* self)
{
	gboolean playing = FALSE;
	XfmpcMpdclient* _tmp0_;
	XfmpcMpdclient* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	playing = xfmpc_mpdclient_is_playing (_tmp0_);
	_tmp1_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_clear (_tmp1_);
	xfmpc_dbbrowser_add_selected_rows (self);
	_tmp2_ = playing;
	if (_tmp2_) {
		XfmpcMpdclient* _tmp3_;
		_tmp3_ = self->priv->mpdclient;
		xfmpc_mpdclient_play (_tmp3_);
	}
}


static void
xfmpc_dbbrowser_cb_browse (XfmpcDbbrowser* self)
{
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter iter = {0};
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GList* list = NULL;
	GtkTreeSelection* _tmp6_;
	GtkTreeModel* _tmp7_ = NULL;
	GList* _tmp8_;
	GtkTreeModel* _tmp9_;
	GtkTreePath* path = NULL;
	GList* _tmp10_;
	gconstpointer _tmp11_;
	GtkTreePath* _tmp12_;
	GtkTreeModel* _tmp13_;
	GtkTreePath* _tmp14_;
	GtkTreeIter _tmp15_ = {0};
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	selection = _tmp4_;
	_tmp5_ = selection;
	if (gtk_tree_selection_count_selected_rows (_tmp5_) > 1) {
		_g_object_unref0 (selection);
		_g_object_unref0 (model);
		return;
	}
	_tmp6_ = selection;
	_tmp8_ = gtk_tree_selection_get_selected_rows (_tmp6_, &_tmp7_);
	_g_object_unref0 (model);
	_tmp9_ = _g_object_ref0 (_tmp7_);
	model = _tmp9_;
	list = _tmp8_;
	_tmp10_ = list;
	_tmp11_ = g_list_nth_data (_tmp10_, (guint) 0);
	_tmp12_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp11_);
	path = _tmp12_;
	_tmp13_ = model;
	_tmp14_ = path;
	_tmp16_ = gtk_tree_model_get_iter (_tmp13_, &_tmp15_, _tmp14_);
	iter = _tmp15_;
	if (_tmp16_) {
		gchar* filename = NULL;
		GtkTreeModel* _tmp17_;
		GtkTreeIter _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* dir = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp17_ = model;
		_tmp18_ = iter;
		gtk_tree_model_get (_tmp17_, &_tmp18_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &_tmp19_, -1, -1);
		_g_free0 (filename);
		filename = _tmp19_;
		_tmp20_ = filename;
		_tmp21_ = g_path_get_dirname (_tmp20_);
		dir = _tmp21_;
		_tmp22_ = dir;
		xfmpc_dbbrowser_set_wdir (self, _tmp22_);
		xfmpc_dbbrowser_reload (self);
		_g_free0 (dir);
		_g_free0 (filename);
	}
	__vala_GtkTreePath_free0 (path);
	(list == NULL) ? NULL : (list = (_g_list_free___vala_GtkTreePath_free0_ (list), NULL));
	_g_object_unref0 (selection);
	_g_object_unref0 (model);
}


static void
xfmpc_dbbrowser_cb_search_entry_activated (XfmpcDbbrowser* self)
{
	gchar* entry_text = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	entry_text = _tmp2_;
	_tmp3_ = entry_text;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GtkEntry* _tmp4_;
		GtkStyleContext* _tmp5_;
		self->priv->is_searching = FALSE;
		xfmpc_dbbrowser_reload (self);
		_tmp4_ = self->priv->search_entry;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		gtk_style_context_remove_class (_tmp5_, "red");
		_g_free0 (entry_text);
		return;
	}
	_tmp6_ = entry_text;
	xfmpc_dbbrowser_search (self, _tmp6_);
	_g_free0 (entry_text);
}


static gboolean
xfmpc_dbbrowser_cb_search_entry_key_released (XfmpcDbbrowser* self,
                                              GdkEventKey* event)
{
	gboolean result = FALSE;
	GdkEventType _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->type;
	if (_tmp0_ != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = event->keyval;
	if (_tmp1_ == ((guint) 0xff1b)) {
		GtkEntry* _tmp2_;
		_tmp2_ = self->priv->search_entry;
		gtk_entry_set_text (_tmp2_, "");
	}
	result = TRUE;
	return result;
}


static gboolean
_xfmpc_dbbrowser_timeout_search_gsource_func (gpointer self)
{
	gboolean result;
	result = xfmpc_dbbrowser_timeout_search ((XfmpcDbbrowser*) self);
	return result;
}


static void
xfmpc_dbbrowser_cb_search_entry_changed (XfmpcDbbrowser* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GtkEntry* _tmp2_;
		_tmp2_ = self->priv->search_entry;
		gtk_entry_set_icon_from_icon_name (_tmp2_, GTK_ENTRY_ICON_SECONDARY, "edit-clear");
	} else {
		GtkEntry* _tmp3_;
		_tmp3_ = self->priv->search_entry;
		gtk_entry_set_icon_from_icon_name (_tmp3_, GTK_ENTRY_ICON_SECONDARY, NULL);
	}
	_tmp4_ = self->priv->search_timeout;
	if (_tmp4_ > ((guint) 0)) {
		guint _tmp5_;
		_tmp5_ = self->priv->search_timeout;
		g_source_remove (_tmp5_);
	}
	self->priv->search_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 642, _xfmpc_dbbrowser_timeout_search_gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean
xfmpc_dbbrowser_timeout_search (XfmpcDbbrowser* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_dbbrowser_cb_search_entry_activated (self);
	self->priv->search_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static void
xfmpc_dbbrowser_cb_search_entry_icon_activated (XfmpcDbbrowser* self,
                                                GtkEntryIconPosition icon_pos,
                                                GdkEvent* event)
{
	GtkEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	if (icon_pos != GTK_ENTRY_ICON_SECONDARY) {
		return;
	}
	_tmp0_ = self->priv->search_entry;
	gtk_entry_set_text (_tmp0_, "");
}


XfmpcDbbrowser*
xfmpc_dbbrowser_construct (GType object_type)
{
	XfmpcDbbrowser * self = NULL;
	self = (XfmpcDbbrowser*) g_object_new (object_type, NULL);
	return self;
}


XfmpcDbbrowser*
xfmpc_dbbrowser_new (void)
{
	return xfmpc_dbbrowser_construct (XFMPC_TYPE_DBBROWSER);
}


static void
_xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                           gpointer self)
{
	xfmpc_dbbrowser_add_selected_rows ((XfmpcDbbrowser*) self);
}


static void
_xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                       gpointer self)
{
	xfmpc_dbbrowser_cb_replace_with_selected_rows ((XfmpcDbbrowser*) self);
}


static void
_xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                   gpointer self)
{
	xfmpc_dbbrowser_cb_browse ((XfmpcDbbrowser*) self);
}


static void
_xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected (XfmpcMpdclient* _sender,
                                                   gpointer self)
{
	xfmpc_dbbrowser_reload ((XfmpcDbbrowser*) self);
}


static void
_xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed (XfmpcMpdclient* _sender,
                                                          gpointer self)
{
	xfmpc_dbbrowser_reload ((XfmpcDbbrowser*) self);
}


static void
_xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender,
                                                                       gpointer self)
{
	xfmpc_dbbrowser_cb_playlist_changed ((XfmpcDbbrowser*) self);
}


static void
_xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                               GtkTreePath* path,
                                                               GtkTreeViewColumn* column,
                                                               gpointer self)
{
	xfmpc_dbbrowser_cb_row_activated ((XfmpcDbbrowser*) self, path, column);
}


static gboolean
_xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                            GdkEventKey* event,
                                                            gpointer self)
{
	gboolean result;
	result = xfmpc_dbbrowser_cb_key_pressed ((XfmpcDbbrowser*) self, event);
	return result;
}


static gboolean
_xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                   GdkEventButton* event,
                                                                   gpointer self)
{
	gboolean result;
	result = xfmpc_dbbrowser_cb_button_released ((XfmpcDbbrowser*) self, event);
	return result;
}


static gboolean
_xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                      gpointer self)
{
	gboolean result;
	result = xfmpc_dbbrowser_cb_popup_menu ((XfmpcDbbrowser*) self);
	return result;
}


static void
_xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                               gpointer self)
{
	xfmpc_dbbrowser_cb_search_entry_activated ((XfmpcDbbrowser*) self);
}


static gboolean
_xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                            GdkEventKey* event,
                                                                            gpointer self)
{
	gboolean result;
	result = xfmpc_dbbrowser_cb_search_entry_key_released ((XfmpcDbbrowser*) self, event);
	return result;
}


static void
_xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self)
{
	xfmpc_dbbrowser_cb_search_entry_changed ((XfmpcDbbrowser*) self);
}


static void
_xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender,
                                                                        GtkEntryIconPosition icon_pos,
                                                                        GdkEventButton* event,
                                                                        gpointer self)
{
	xfmpc_dbbrowser_cb_search_entry_icon_activated ((XfmpcDbbrowser*) self, icon_pos, event);
}


static void
_xfmpc_dbbrowser_reload_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self)
{
	xfmpc_dbbrowser_reload ((XfmpcDbbrowser*) self);
}


static GObject *
xfmpc_dbbrowser_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcDbbrowser * self;
	XfmpcMpdclient* _tmp0_;
	XfmpcPreferences* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeSelection* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkTreeView* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreeView* _tmp12_;
	GtkListStore* _tmp13_;
	GtkCellRendererPixbuf* cell_pixbuf = NULL;
	GtkCellRendererPixbuf* _tmp14_;
	GtkTreeView* _tmp15_;
	GtkCellRendererPixbuf* _tmp16_;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkTreeView* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkMenu* _tmp23_;
	GtkMenuItem* mi = NULL;
	GtkMenuItem* _tmp24_;
	GtkMenu* _tmp25_;
	GtkMenuItem* _tmp26_;
	GtkMenuItem* _tmp27_;
	GtkMenuItem* _tmp28_;
	GtkMenu* _tmp29_;
	GtkMenuItem* _tmp30_;
	GtkMenuItem* _tmp31_;
	GtkMenuItem* _tmp32_;
	GtkMenu* _tmp33_;
	GtkMenuItem* _tmp34_;
	GtkMenuItem* _tmp35_;
	GtkMenu* _tmp36_;
	GtkEntry* _tmp37_;
	GtkEntry* _tmp38_;
	GtkEntry* _tmp39_;
	GtkEntry* _tmp40_;
	GtkScrolledWindow* _tmp41_;
	GtkTreeView* _tmp42_;
	GtkScrolledWindow* _tmp43_;
	GtkEntry* _tmp44_;
	XfmpcMpdclient* _tmp45_;
	XfmpcMpdclient* _tmp46_;
	XfmpcMpdclient* _tmp47_;
	GtkTreeView* _tmp48_;
	GtkTreeView* _tmp49_;
	GtkTreeView* _tmp50_;
	GtkTreeView* _tmp51_;
	GtkEntry* _tmp52_;
	GtkEntry* _tmp53_;
	GtkEntry* _tmp54_;
	GtkEntry* _tmp55_;
	XfmpcPreferences* _tmp56_;
	XfmpcPreferences* _tmp57_;
	parent_class = G_OBJECT_CLASS (xfmpc_dbbrowser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->wdir);
	self->priv->wdir = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->last_wdir);
	self->priv->last_wdir = _tmp3_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp4_ = gtk_list_store_new ((gint) XFMPC_DBBROWSER_COLUMNS_N_COLUMNS, G_TYPE_INT, gdk_pixbuf_get_type (), G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, -1);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp4_;
	_tmp5_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp5_;
	_tmp6_ = self->priv->treeview;
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
	gtk_tree_selection_set_mode (_tmp7_, GTK_SELECTION_MULTIPLE);
	_tmp8_ = self->priv->treeview;
	gtk_tree_view_set_rubber_banding (_tmp8_, TRUE);
	_tmp9_ = self->priv->treeview;
	gtk_tree_view_set_enable_search (_tmp9_, TRUE);
	_tmp10_ = self->priv->treeview;
	gtk_tree_view_set_search_column (_tmp10_, (gint) XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME);
	_tmp11_ = self->priv->treeview;
	gtk_tree_view_set_headers_visible (_tmp11_, FALSE);
	_tmp12_ = self->priv->treeview;
	_tmp13_ = self->priv->store;
	gtk_tree_view_set_model (_tmp12_, (GtkTreeModel*) _tmp13_);
	_tmp14_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp14_);
	cell_pixbuf = _tmp14_;
	_tmp15_ = self->priv->treeview;
	_tmp16_ = cell_pixbuf;
	gtk_tree_view_insert_column_with_attributes (_tmp15_, -1, "", (GtkCellRenderer*) _tmp16_, "pixbuf", XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, NULL, NULL);
	_tmp17_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp17_);
	cell_text = _tmp17_;
	_tmp18_ = cell_text;
	g_object_set (_tmp18_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp19_ = self->priv->treeview;
	_tmp20_ = cell_text;
	gtk_tree_view_insert_column_with_attributes (_tmp19_, -1, "Filename", (GtkCellRenderer*) _tmp20_, "text", XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, "weight", XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	_tmp21_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp21_);
	scrolled = _tmp21_;
	_tmp22_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp22_, GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	_tmp23_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp23_;
	_tmp24_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Add"));
	g_object_ref_sink (_tmp24_);
	mi = _tmp24_;
	_tmp25_ = self->priv->menu;
	_tmp26_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp25_, _tmp26_);
	_tmp27_ = mi;
	g_signal_connect_object (_tmp27_, "activate", (GCallback) _xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate, self, 0);
	_tmp28_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Replace"));
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (mi);
	mi = _tmp28_;
	_tmp29_ = self->priv->menu;
	_tmp30_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp29_, _tmp30_);
	_tmp31_ = mi;
	g_signal_connect_object (_tmp31_, "activate", (GCallback) _xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate, self, 0);
	_tmp32_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Browse"));
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->mi_browse);
	self->priv->mi_browse = _tmp32_;
	_tmp33_ = self->priv->menu;
	_tmp34_ = self->priv->mi_browse;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp33_, _tmp34_);
	_tmp35_ = self->priv->mi_browse;
	g_signal_connect_object (_tmp35_, "activate", (GCallback) _xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate, self, 0);
	_tmp36_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp37_;
	_tmp38_ = self->priv->search_entry;
	gtk_entry_set_icon_from_icon_name (_tmp38_, GTK_ENTRY_ICON_PRIMARY, "edit-find");
	_tmp39_ = self->priv->search_entry;
	gtk_entry_set_icon_activatable (_tmp39_, GTK_ENTRY_ICON_PRIMARY, FALSE);
	_tmp40_ = self->priv->search_entry;
	gtk_entry_set_icon_activatable (_tmp40_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp41_ = scrolled;
	_tmp42_ = self->priv->treeview;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = scrolled;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp43_, TRUE, TRUE, (guint) 0);
	_tmp44_ = self->priv->search_entry;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp44_, FALSE, FALSE, (guint) 0);
	_tmp45_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp45_, "connected", (GCallback) _xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected, self, 0);
	_tmp46_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp46_, "database-changed", (GCallback) _xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed, self, 0);
	_tmp47_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp47_, "playlist-changed", (GCallback) _xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp48_ = self->priv->treeview;
	g_signal_connect_object (_tmp48_, "row-activated", (GCallback) _xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated, self, 0);
	_tmp49_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp49_, "key-press-event", (GCallback) _xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event, self, 0);
	_tmp50_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp50_, "button-press-event", (GCallback) _xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event, self, 0);
	_tmp51_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp51_, "popup-menu", (GCallback) _xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp52_ = self->priv->search_entry;
	g_signal_connect_object (_tmp52_, "activate", (GCallback) _xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate, self, 0);
	_tmp53_ = self->priv->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp53_, "key-release-event", (GCallback) _xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event, self, 0);
	_tmp54_ = self->priv->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp54_, "changed", (GCallback) _xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed, self, 0);
	_tmp55_ = self->priv->search_entry;
	g_signal_connect_object (_tmp55_, "icon-release", (GCallback) _xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release, self, 0);
	_tmp56_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp56_, "notify::song-format", (GCallback) _xfmpc_dbbrowser_reload_g_object_notify, self, 0);
	_tmp57_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp57_, "notify::song-format-custom", (GCallback) _xfmpc_dbbrowser_reload_g_object_notify, self, 0);
	_g_object_unref0 (mi);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (cell_pixbuf);
	return obj;
}


static void
xfmpc_dbbrowser_class_init (XfmpcDbbrowserClass * klass)
{
	xfmpc_dbbrowser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XfmpcDbbrowser_private_offset);
	G_OBJECT_CLASS (klass)->constructor = xfmpc_dbbrowser_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_dbbrowser_finalize;
}


static void
xfmpc_dbbrowser_instance_init (XfmpcDbbrowser * self)
{
	self->priv = xfmpc_dbbrowser_get_instance_private (self);
}


static void
xfmpc_dbbrowser_finalize (GObject * obj)
{
	XfmpcDbbrowser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->mi_browse);
	_g_free0 (self->priv->wdir);
	_g_free0 (self->priv->last_wdir);
	G_OBJECT_CLASS (xfmpc_dbbrowser_parent_class)->finalize (obj);
}


GType
xfmpc_dbbrowser_get_type (void)
{
	static volatile gsize xfmpc_dbbrowser_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_dbbrowser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcDbbrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_dbbrowser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcDbbrowser), 0, (GInstanceInitFunc) xfmpc_dbbrowser_instance_init, NULL };
		GType xfmpc_dbbrowser_type_id;
		xfmpc_dbbrowser_type_id = g_type_register_static (gtk_box_get_type (), "XfmpcDbbrowser", &g_define_type_info, 0);
		XfmpcDbbrowser_private_offset = g_type_add_instance_private (xfmpc_dbbrowser_type_id, sizeof (XfmpcDbbrowserPrivate));
		g_once_init_leave (&xfmpc_dbbrowser_type_id__volatile, xfmpc_dbbrowser_type_id);
	}
	return xfmpc_dbbrowser_type_id__volatile;
}



