/* preferences.c generated by valac 0.32.0, the Vala compiler
 * generated from preferences.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libxfce4util/libxfce4util.h>


#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;
typedef struct _XfmpcPreferencesPrivate XfmpcPreferencesPrivate;

#define XFMPC_PREFERENCES_TYPE_SONG_FORMAT (xfmpc_preferences_song_format_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _xfce_rc_close0(var) ((var == NULL) ? NULL : (var = (xfce_rc_close (var), NULL)))

struct _XfmpcPreferences {
	GObject parent_instance;
	XfmpcPreferencesPrivate * priv;
};

struct _XfmpcPreferencesClass {
	GObjectClass parent_class;
};

typedef enum  {
	XFMPC_PREFERENCES_SONG_FORMAT_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_ALBUM_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE_DATE,
	XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TRACK_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM_FORMAT
} XfmpcPreferencesSongFormat;

struct _XfmpcPreferencesPrivate {
	gint _last_window_posx;
	gint _last_window_posy;
	gint _last_window_width;
	gint _last_window_height;
	gboolean _last_window_state_sticky;
	gboolean _playlist_autocenter;
	gboolean _playlist_show_position;
	gchar* _mpd_hostname;
	gint _mpd_port;
	gchar* _mpd_password;
	gboolean _mpd_use_defaults;
	gboolean _show_status_icon;
	gboolean _show_statusbar;
	XfmpcPreferencesSongFormat _song_format;
	gchar* _song_format_custom;
};


static gpointer xfmpc_preferences_parent_class = NULL;
static XfmpcPreferences* xfmpc_preferences_preferences;
static XfmpcPreferences* xfmpc_preferences_preferences = NULL;

GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_song_format_get_type (void) G_GNUC_CONST;
#define XFMPC_PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesPrivate))
enum  {
	XFMPC_PREFERENCES_DUMMY_PROPERTY,
	XFMPC_PREFERENCES_LAST_WINDOW_POSX,
	XFMPC_PREFERENCES_LAST_WINDOW_POSY,
	XFMPC_PREFERENCES_LAST_WINDOW_WIDTH,
	XFMPC_PREFERENCES_LAST_WINDOW_HEIGHT,
	XFMPC_PREFERENCES_LAST_WINDOW_STATE_STICKY,
	XFMPC_PREFERENCES_PLAYLIST_AUTOCENTER,
	XFMPC_PREFERENCES_PLAYLIST_SHOW_POSITION,
	XFMPC_PREFERENCES_MPD_HOSTNAME,
	XFMPC_PREFERENCES_MPD_PORT,
	XFMPC_PREFERENCES_MPD_PASSWORD,
	XFMPC_PREFERENCES_MPD_USE_DEFAULTS,
	XFMPC_PREFERENCES_SHOW_STATUS_ICON,
	XFMPC_PREFERENCES_SHOW_STATUSBAR,
	XFMPC_PREFERENCES_SONG_FORMAT,
	XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM
};
XfmpcPreferences* xfmpc_preferences_new (void);
XfmpcPreferences* xfmpc_preferences_construct (GType object_type);
static void xfmpc_preferences_load (XfmpcPreferences* self);
XfmpcPreferences* xfmpc_preferences_get_default (void);
static void xfmpc_preferences_store (XfmpcPreferences* self);
gint xfmpc_preferences_get_last_window_posx (XfmpcPreferences* self);
void xfmpc_preferences_set_last_window_posx (XfmpcPreferences* self, gint value);
gint xfmpc_preferences_get_last_window_posy (XfmpcPreferences* self);
void xfmpc_preferences_set_last_window_posy (XfmpcPreferences* self, gint value);
gint xfmpc_preferences_get_last_window_width (XfmpcPreferences* self);
void xfmpc_preferences_set_last_window_width (XfmpcPreferences* self, gint value);
gint xfmpc_preferences_get_last_window_height (XfmpcPreferences* self);
void xfmpc_preferences_set_last_window_height (XfmpcPreferences* self, gint value);
gboolean xfmpc_preferences_get_last_window_state_sticky (XfmpcPreferences* self);
void xfmpc_preferences_set_last_window_state_sticky (XfmpcPreferences* self, gboolean value);
gboolean xfmpc_preferences_get_playlist_autocenter (XfmpcPreferences* self);
void xfmpc_preferences_set_playlist_autocenter (XfmpcPreferences* self, gboolean value);
gboolean xfmpc_preferences_get_playlist_show_position (XfmpcPreferences* self);
void xfmpc_preferences_set_playlist_show_position (XfmpcPreferences* self, gboolean value);
const gchar* xfmpc_preferences_get_mpd_hostname (XfmpcPreferences* self);
void xfmpc_preferences_set_mpd_hostname (XfmpcPreferences* self, const gchar* value);
gint xfmpc_preferences_get_mpd_port (XfmpcPreferences* self);
void xfmpc_preferences_set_mpd_port (XfmpcPreferences* self, gint value);
const gchar* xfmpc_preferences_get_mpd_password (XfmpcPreferences* self);
void xfmpc_preferences_set_mpd_password (XfmpcPreferences* self, const gchar* value);
gboolean xfmpc_preferences_get_mpd_use_defaults (XfmpcPreferences* self);
void xfmpc_preferences_set_mpd_use_defaults (XfmpcPreferences* self, gboolean value);
gboolean xfmpc_preferences_get_show_status_icon (XfmpcPreferences* self);
void xfmpc_preferences_set_show_status_icon (XfmpcPreferences* self, gboolean value);
gboolean xfmpc_preferences_get_show_statusbar (XfmpcPreferences* self);
void xfmpc_preferences_set_show_statusbar (XfmpcPreferences* self, gboolean value);
XfmpcPreferencesSongFormat xfmpc_preferences_get_song_format (XfmpcPreferences* self);
void xfmpc_preferences_set_song_format (XfmpcPreferences* self, XfmpcPreferencesSongFormat value);
const gchar* xfmpc_preferences_get_song_format_custom (XfmpcPreferences* self);
void xfmpc_preferences_set_song_format_custom (XfmpcPreferences* self, const gchar* value);
static GObject * xfmpc_preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void xfmpc_preferences_finalize (GObject* obj);
static void _vala_xfmpc_preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_xfmpc_preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType xfmpc_preferences_song_format_get_type (void) {
	static volatile gsize xfmpc_preferences_song_format_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_preferences_song_format_type_id__volatile)) {
		static const GEnumValue values[] = {{XFMPC_PREFERENCES_SONG_FORMAT_TITLE, "XFMPC_PREFERENCES_SONG_FORMAT_TITLE", "title"}, {XFMPC_PREFERENCES_SONG_FORMAT_ALBUM_TITLE, "XFMPC_PREFERENCES_SONG_FORMAT_ALBUM_TITLE", "album-title"}, {XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE, "XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE", "artist-title"}, {XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE_DATE, "XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE_DATE", "artist-title-date"}, {XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TITLE, "XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TITLE", "artist-album-title"}, {XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TRACK_TITLE, "XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TRACK_TITLE", "artist-album-track-title"}, {XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM_FORMAT, "XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM_FORMAT", "custom-format"}, {0, NULL, NULL}};
		GType xfmpc_preferences_song_format_type_id;
		xfmpc_preferences_song_format_type_id = g_enum_register_static ("XfmpcPreferencesSongFormat", values);
		g_once_init_leave (&xfmpc_preferences_song_format_type_id__volatile, xfmpc_preferences_song_format_type_id);
	}
	return xfmpc_preferences_song_format_type_id__volatile;
}


XfmpcPreferences* xfmpc_preferences_construct (GType object_type) {
	XfmpcPreferences * self = NULL;
	self = (XfmpcPreferences*) g_object_new (object_type, NULL);
	xfmpc_preferences_load (self);
	return self;
}


XfmpcPreferences* xfmpc_preferences_new (void) {
	return xfmpc_preferences_construct (XFMPC_TYPE_PREFERENCES);
}


XfmpcPreferences* xfmpc_preferences_get_default (void) {
	XfmpcPreferences* result = NULL;
	XfmpcPreferences* _tmp0_ = NULL;
	XfmpcPreferences* _tmp4_ = NULL;
	_tmp0_ = xfmpc_preferences_preferences;
	if (_tmp0_ == NULL) {
		XfmpcPreferences* _tmp1_ = NULL;
		XfmpcPreferences* _tmp2_ = NULL;
		_tmp1_ = xfmpc_preferences_new ();
		_g_object_unref0 (xfmpc_preferences_preferences);
		xfmpc_preferences_preferences = _tmp1_;
		_tmp2_ = xfmpc_preferences_preferences;
		g_object_add_weak_pointer ((GObject*) _tmp2_, &xfmpc_preferences_preferences);
	} else {
		XfmpcPreferences* _tmp3_ = NULL;
		_tmp3_ = xfmpc_preferences_preferences;
		g_object_ref ((GObject*) _tmp3_);
	}
	_tmp4_ = xfmpc_preferences_preferences;
	result = _tmp4_;
	return result;
}


static void xfmpc_preferences_load (XfmpcPreferences* self) {
	XfceRc* rc = NULL;
	XfceRc* _tmp0_ = NULL;
	XfceRc* _tmp1_ = NULL;
	XfceRc* _tmp2_ = NULL;
	gchar* entry = NULL;
	GValue src = {0};
	GValue _tmp3_ = {0};
	GType _tmp4_ = 0UL;
	GTypeClass* _tmp5_ = NULL;
	guint _tmp6_;
	GParamSpec** _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = xfce_rc_config_open (XFCE_RESOURCE_CONFIG, "xfce4/xfmpcrc", FALSE);
	rc = _tmp0_;
	_tmp1_ = rc;
	if (_tmp1_ == NULL) {
		g_warning ("preferences.vala:152: Failed to load the preferences");
		_xfce_rc_close0 (rc);
		return;
	}
	g_object_freeze_notify ((GObject*) self);
	_tmp2_ = rc;
	xfce_rc_set_group (_tmp2_, "Configuration");
	g_value_init (&_tmp3_, G_TYPE_STRING);
	src = _tmp3_;
	_tmp4_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp5_ = g_type_class_peek (_tmp4_);
	_tmp7_ = g_object_class_list_properties ((GObjectClass*) _tmp5_, &_tmp6_);
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp7_;
		spec_collection_length1 = _tmp6_;
		for (spec_it = 0; spec_it < _tmp6_; spec_it = spec_it + 1) {
			GParamSpec* spec = NULL;
			spec = spec_collection[spec_it];
			{
				XfceRc* _tmp8_ = NULL;
				GParamSpec* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				GParamSpec* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GValue _tmp17_ = {0};
				_tmp8_ = rc;
				_tmp9_ = spec;
				_tmp10_ = g_param_spec_get_nick (_tmp9_);
				_tmp11_ = xfce_rc_read_entry (_tmp8_, _tmp10_, "");
				_tmp12_ = g_strdup (_tmp11_);
				_g_free0 (entry);
				entry = _tmp12_;
				_tmp13_ = entry;
				if (g_strcmp0 (_tmp13_, "") == 0) {
					continue;
				}
				_tmp14_ = entry;
				g_value_set_static_string (&src, _tmp14_);
				_tmp15_ = spec;
				_tmp16_ = _tmp15_->name;
				_tmp17_ = src;
				g_object_set_property ((GObject*) self, _tmp16_, &_tmp17_);
			}
		}
		spec_collection = (g_free (spec_collection), NULL);
	}
	g_object_thaw_notify ((GObject*) self);
	G_IS_VALUE (&src) ? (g_value_unset (&src), NULL) : NULL;
	_g_free0 (entry);
	_xfce_rc_close0 (rc);
}


static void xfmpc_preferences_store (XfmpcPreferences* self) {
	XfceRc* rc = NULL;
	XfceRc* _tmp0_ = NULL;
	XfceRc* _tmp1_ = NULL;
	XfceRc* _tmp2_ = NULL;
	gchar* entry = NULL;
	GValue dst = {0};
	GValue _tmp3_ = {0};
	GType _tmp4_ = 0UL;
	GTypeClass* _tmp5_ = NULL;
	guint _tmp6_;
	GParamSpec** _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = xfce_rc_config_open (XFCE_RESOURCE_CONFIG, "xfce4/xfmpcrc", FALSE);
	rc = _tmp0_;
	_tmp1_ = rc;
	if (_tmp1_ == NULL) {
		g_warning ("preferences.vala:180: Failed to save the preferences");
		_xfce_rc_close0 (rc);
		return;
	}
	_tmp2_ = rc;
	xfce_rc_set_group (_tmp2_, "Configuration");
	g_value_init (&_tmp3_, G_TYPE_STRING);
	dst = _tmp3_;
	_tmp4_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp5_ = g_type_class_peek (_tmp4_);
	_tmp7_ = g_object_class_list_properties ((GObjectClass*) _tmp5_, &_tmp6_);
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp7_;
		spec_collection_length1 = _tmp6_;
		for (spec_it = 0; spec_it < _tmp6_; spec_it = spec_it + 1) {
			GParamSpec* spec = NULL;
			spec = spec_collection[spec_it];
			{
				GParamSpec* _tmp8_ = NULL;
				GType _tmp9_ = 0UL;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				_tmp8_ = spec;
				_tmp9_ = _tmp8_->value_type;
				if (_tmp9_ == G_TYPE_STRING) {
					GParamSpec* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					_tmp10_ = spec;
					_tmp11_ = _tmp10_->name;
					g_object_get_property ((GObject*) self, _tmp11_, &dst);
				} else {
					GValue src = {0};
					GParamSpec* _tmp12_ = NULL;
					GType _tmp13_ = 0UL;
					GValue _tmp14_ = {0};
					GParamSpec* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					_tmp12_ = spec;
					_tmp13_ = _tmp12_->value_type;
					g_value_init (&_tmp14_, _tmp13_);
					src = _tmp14_;
					_tmp15_ = spec;
					_tmp16_ = _tmp15_->name;
					g_object_get_property ((GObject*) self, _tmp16_, &src);
					g_value_transform (&src, &dst);
					G_IS_VALUE (&src) ? (g_value_unset (&src), NULL) : NULL;
				}
				_tmp17_ = g_value_get_string (&dst);
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (entry);
				entry = _tmp18_;
				_tmp19_ = entry;
				if (_tmp19_ != NULL) {
					XfceRc* _tmp20_ = NULL;
					GParamSpec* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					_tmp20_ = rc;
					_tmp21_ = spec;
					_tmp22_ = g_param_spec_get_nick (_tmp21_);
					_tmp23_ = entry;
					xfce_rc_write_entry (_tmp20_, _tmp22_, _tmp23_);
				}
			}
		}
		spec_collection = (g_free (spec_collection), NULL);
	}
	G_IS_VALUE (&dst) ? (g_value_unset (&dst), NULL) : NULL;
	_g_free0 (entry);
	_xfce_rc_close0 (rc);
}


gint xfmpc_preferences_get_last_window_posx (XfmpcPreferences* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_last_window_posx;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_last_window_posx (XfmpcPreferences* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_last_window_posx = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "last-window-posx");
}


gint xfmpc_preferences_get_last_window_posy (XfmpcPreferences* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_last_window_posy;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_last_window_posy (XfmpcPreferences* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_last_window_posy = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "last-window-posy");
}


gint xfmpc_preferences_get_last_window_width (XfmpcPreferences* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_last_window_width;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_last_window_width (XfmpcPreferences* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_last_window_width = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "last-window-width");
}


gint xfmpc_preferences_get_last_window_height (XfmpcPreferences* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_last_window_height;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_last_window_height (XfmpcPreferences* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_last_window_height = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "last-window-height");
}


gboolean xfmpc_preferences_get_last_window_state_sticky (XfmpcPreferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_last_window_state_sticky;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_last_window_state_sticky (XfmpcPreferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_last_window_state_sticky = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "last-window-state-sticky");
}


gboolean xfmpc_preferences_get_playlist_autocenter (XfmpcPreferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_playlist_autocenter;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_playlist_autocenter (XfmpcPreferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_playlist_autocenter = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "playlist-autocenter");
}


gboolean xfmpc_preferences_get_playlist_show_position (XfmpcPreferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_playlist_show_position;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_playlist_show_position (XfmpcPreferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_playlist_show_position = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "playlist-show-position");
}


const gchar* xfmpc_preferences_get_mpd_hostname (XfmpcPreferences* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mpd_hostname;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_mpd_hostname (XfmpcPreferences* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mpd_hostname);
	self->priv->_mpd_hostname = _tmp1_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "mpd-hostname");
}


gint xfmpc_preferences_get_mpd_port (XfmpcPreferences* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mpd_port;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_mpd_port (XfmpcPreferences* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_mpd_port = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "mpd-port");
}


const gchar* xfmpc_preferences_get_mpd_password (XfmpcPreferences* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mpd_password;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_mpd_password (XfmpcPreferences* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mpd_password);
	self->priv->_mpd_password = _tmp1_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "mpd-password");
}


gboolean xfmpc_preferences_get_mpd_use_defaults (XfmpcPreferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_mpd_use_defaults;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_mpd_use_defaults (XfmpcPreferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_mpd_use_defaults = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "mpd-use-defaults");
}


gboolean xfmpc_preferences_get_show_status_icon (XfmpcPreferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_status_icon;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_show_status_icon (XfmpcPreferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_status_icon = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "show-status-icon");
}


gboolean xfmpc_preferences_get_show_statusbar (XfmpcPreferences* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_statusbar;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_show_statusbar (XfmpcPreferences* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_statusbar = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "show-statusbar");
}


XfmpcPreferencesSongFormat xfmpc_preferences_get_song_format (XfmpcPreferences* self) {
	XfmpcPreferencesSongFormat result;
	XfmpcPreferencesSongFormat _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_song_format;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_song_format (XfmpcPreferences* self, XfmpcPreferencesSongFormat value) {
	XfmpcPreferencesSongFormat _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_song_format = _tmp0_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "song-format");
}


const gchar* xfmpc_preferences_get_song_format_custom (XfmpcPreferences* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_song_format_custom;
	result = _tmp0_;
	return result;
}


void xfmpc_preferences_set_song_format_custom (XfmpcPreferences* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_song_format_custom);
	self->priv->_song_format_custom = _tmp1_;
	xfmpc_preferences_store (self);
	g_object_notify ((GObject *) self, "song-format-custom");
}


static GObject * xfmpc_preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcPreferences * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (xfmpc_preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_PREFERENCES, XfmpcPreferences);
	self->priv->_last_window_posx = 200;
	self->priv->_last_window_posy = 100;
	self->priv->_last_window_width = 330;
	self->priv->_last_window_height = 330;
	self->priv->_last_window_state_sticky = FALSE;
	self->priv->_playlist_autocenter = TRUE;
	self->priv->_playlist_show_position = FALSE;
	_tmp0_ = g_strdup ("localhost");
	_g_free0 (self->priv->_mpd_hostname);
	self->priv->_mpd_hostname = _tmp0_;
	self->priv->_mpd_port = 6600;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->_mpd_password);
	self->priv->_mpd_password = _tmp1_;
	self->priv->_mpd_use_defaults = TRUE;
	self->priv->_show_status_icon = FALSE;
	self->priv->_show_statusbar = TRUE;
	self->priv->_song_format = XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE;
	_tmp2_ = g_strdup ("%a - %t");
	_g_free0 (self->priv->_song_format_custom);
	self->priv->_song_format_custom = _tmp2_;
	return obj;
}


static void xfmpc_preferences_class_init (XfmpcPreferencesClass * klass) {
	xfmpc_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcPreferencesPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_xfmpc_preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xfmpc_preferences_set_property;
	G_OBJECT_CLASS (klass)->constructor = xfmpc_preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_LAST_WINDOW_POSX, g_param_spec_int ("last-window-posx", "last-window-posx", "last-window-posx", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_LAST_WINDOW_POSY, g_param_spec_int ("last-window-posy", "last-window-posy", "last-window-posy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_LAST_WINDOW_WIDTH, g_param_spec_int ("last-window-width", "last-window-width", "last-window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_LAST_WINDOW_HEIGHT, g_param_spec_int ("last-window-height", "last-window-height", "last-window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_LAST_WINDOW_STATE_STICKY, g_param_spec_boolean ("last-window-state-sticky", "last-window-state-sticky", "last-window-state-sticky", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_PLAYLIST_AUTOCENTER, g_param_spec_boolean ("playlist-autocenter", "playlist-autocenter", "playlist-autocenter", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_PLAYLIST_SHOW_POSITION, g_param_spec_boolean ("playlist-show-position", "playlist-show-position", "playlist-show-position", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_MPD_HOSTNAME, g_param_spec_string ("mpd-hostname", "mpd-hostname", "mpd-hostname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_MPD_PORT, g_param_spec_int ("mpd-port", "mpd-port", "mpd-port", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_MPD_PASSWORD, g_param_spec_string ("mpd-password", "mpd-password", "mpd-password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_MPD_USE_DEFAULTS, g_param_spec_boolean ("mpd-use-defaults", "mpd-use-defaults", "mpd-use-defaults", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_SHOW_STATUS_ICON, g_param_spec_boolean ("show-status-icon", "show-status-icon", "show-status-icon", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_SHOW_STATUSBAR, g_param_spec_boolean ("show-statusbar", "show-statusbar", "show-statusbar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_SONG_FORMAT, g_param_spec_enum ("song-format", "song-format", "song-format", XFMPC_PREFERENCES_TYPE_SONG_FORMAT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM, g_param_spec_string ("song-format-custom", "song-format-custom", "song-format-custom", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void xfmpc_preferences_instance_init (XfmpcPreferences * self) {
	self->priv = XFMPC_PREFERENCES_GET_PRIVATE (self);
}


static void xfmpc_preferences_finalize (GObject* obj) {
	XfmpcPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_PREFERENCES, XfmpcPreferences);
	_g_free0 (self->priv->_mpd_hostname);
	_g_free0 (self->priv->_mpd_password);
	_g_free0 (self->priv->_song_format_custom);
	G_OBJECT_CLASS (xfmpc_preferences_parent_class)->finalize (obj);
}


GType xfmpc_preferences_get_type (void) {
	static volatile gsize xfmpc_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcPreferences), 0, (GInstanceInitFunc) xfmpc_preferences_instance_init, NULL };
		GType xfmpc_preferences_type_id;
		xfmpc_preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "XfmpcPreferences", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_preferences_type_id__volatile, xfmpc_preferences_type_id);
	}
	return xfmpc_preferences_type_id__volatile;
}


static void _vala_xfmpc_preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XfmpcPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XFMPC_TYPE_PREFERENCES, XfmpcPreferences);
	switch (property_id) {
		case XFMPC_PREFERENCES_LAST_WINDOW_POSX:
		g_value_set_int (value, xfmpc_preferences_get_last_window_posx (self));
		break;
		case XFMPC_PREFERENCES_LAST_WINDOW_POSY:
		g_value_set_int (value, xfmpc_preferences_get_last_window_posy (self));
		break;
		case XFMPC_PREFERENCES_LAST_WINDOW_WIDTH:
		g_value_set_int (value, xfmpc_preferences_get_last_window_width (self));
		break;
		case XFMPC_PREFERENCES_LAST_WINDOW_HEIGHT:
		g_value_set_int (value, xfmpc_preferences_get_last_window_height (self));
		break;
		case XFMPC_PREFERENCES_LAST_WINDOW_STATE_STICKY:
		g_value_set_boolean (value, xfmpc_preferences_get_last_window_state_sticky (self));
		break;
		case XFMPC_PREFERENCES_PLAYLIST_AUTOCENTER:
		g_value_set_boolean (value, xfmpc_preferences_get_playlist_autocenter (self));
		break;
		case XFMPC_PREFERENCES_PLAYLIST_SHOW_POSITION:
		g_value_set_boolean (value, xfmpc_preferences_get_playlist_show_position (self));
		break;
		case XFMPC_PREFERENCES_MPD_HOSTNAME:
		g_value_set_string (value, xfmpc_preferences_get_mpd_hostname (self));
		break;
		case XFMPC_PREFERENCES_MPD_PORT:
		g_value_set_int (value, xfmpc_preferences_get_mpd_port (self));
		break;
		case XFMPC_PREFERENCES_MPD_PASSWORD:
		g_value_set_string (value, xfmpc_preferences_get_mpd_password (self));
		break;
		case XFMPC_PREFERENCES_MPD_USE_DEFAULTS:
		g_value_set_boolean (value, xfmpc_preferences_get_mpd_use_defaults (self));
		break;
		case XFMPC_PREFERENCES_SHOW_STATUS_ICON:
		g_value_set_boolean (value, xfmpc_preferences_get_show_status_icon (self));
		break;
		case XFMPC_PREFERENCES_SHOW_STATUSBAR:
		g_value_set_boolean (value, xfmpc_preferences_get_show_statusbar (self));
		break;
		case XFMPC_PREFERENCES_SONG_FORMAT:
		g_value_set_enum (value, xfmpc_preferences_get_song_format (self));
		break;
		case XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM:
		g_value_set_string (value, xfmpc_preferences_get_song_format_custom (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_xfmpc_preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XfmpcPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XFMPC_TYPE_PREFERENCES, XfmpcPreferences);
	switch (property_id) {
		case XFMPC_PREFERENCES_LAST_WINDOW_POSX:
		xfmpc_preferences_set_last_window_posx (self, g_value_get_int (value));
		break;
		case XFMPC_PREFERENCES_LAST_WINDOW_POSY:
		xfmpc_preferences_set_last_window_posy (self, g_value_get_int (value));
		break;
		case XFMPC_PREFERENCES_LAST_WINDOW_WIDTH:
		xfmpc_preferences_set_last_window_width (self, g_value_get_int (value));
		break;
		case XFMPC_PREFERENCES_LAST_WINDOW_HEIGHT:
		xfmpc_preferences_set_last_window_height (self, g_value_get_int (value));
		break;
		case XFMPC_PREFERENCES_LAST_WINDOW_STATE_STICKY:
		xfmpc_preferences_set_last_window_state_sticky (self, g_value_get_boolean (value));
		break;
		case XFMPC_PREFERENCES_PLAYLIST_AUTOCENTER:
		xfmpc_preferences_set_playlist_autocenter (self, g_value_get_boolean (value));
		break;
		case XFMPC_PREFERENCES_PLAYLIST_SHOW_POSITION:
		xfmpc_preferences_set_playlist_show_position (self, g_value_get_boolean (value));
		break;
		case XFMPC_PREFERENCES_MPD_HOSTNAME:
		xfmpc_preferences_set_mpd_hostname (self, g_value_get_string (value));
		break;
		case XFMPC_PREFERENCES_MPD_PORT:
		xfmpc_preferences_set_mpd_port (self, g_value_get_int (value));
		break;
		case XFMPC_PREFERENCES_MPD_PASSWORD:
		xfmpc_preferences_set_mpd_password (self, g_value_get_string (value));
		break;
		case XFMPC_PREFERENCES_MPD_USE_DEFAULTS:
		xfmpc_preferences_set_mpd_use_defaults (self, g_value_get_boolean (value));
		break;
		case XFMPC_PREFERENCES_SHOW_STATUS_ICON:
		xfmpc_preferences_set_show_status_icon (self, g_value_get_boolean (value));
		break;
		case XFMPC_PREFERENCES_SHOW_STATUSBAR:
		xfmpc_preferences_set_show_statusbar (self, g_value_get_boolean (value));
		break;
		case XFMPC_PREFERENCES_SONG_FORMAT:
		xfmpc_preferences_set_song_format (self, g_value_get_enum (value));
		break;
		case XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM:
		xfmpc_preferences_set_song_format_custom (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



