/* playlist.c generated by valac 0.32.0, the Vala compiler
 * generated from playlist.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <libxfce4ui/libxfce4ui.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define XFMPC_TYPE_PLAYLIST (xfmpc_playlist_get_type ())
#define XFMPC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylist))
#define XFMPC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))
#define XFMPC_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PLAYLIST))
#define XFMPC_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PLAYLIST))
#define XFMPC_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))

typedef struct _XfmpcPlaylist XfmpcPlaylist;
typedef struct _XfmpcPlaylistClass XfmpcPlaylistClass;
typedef struct _XfmpcPlaylistPrivate XfmpcPlaylistPrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;

#define XFMPC_PLAYLIST_TYPE_COLUMNS (xfmpc_playlist_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define XFMPC_TYPE_DBBROWSER (xfmpc_dbbrowser_get_type ())
#define XFMPC_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser))
#define XFMPC_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))
#define XFMPC_IS_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_DBBROWSER))
#define XFMPC_IS_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_DBBROWSER))
#define XFMPC_DBBROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))

typedef struct _XfmpcDbbrowser XfmpcDbbrowser;
typedef struct _XfmpcDbbrowserClass XfmpcDbbrowserClass;

#define XFMPC_TYPE_EXTENDED_INTERFACE (xfmpc_extended_interface_get_type ())
#define XFMPC_EXTENDED_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterface))
#define XFMPC_EXTENDED_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterfaceClass))
#define XFMPC_IS_EXTENDED_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_EXTENDED_INTERFACE))
#define XFMPC_IS_EXTENDED_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_EXTENDED_INTERFACE))
#define XFMPC_EXTENDED_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterfaceClass))

typedef struct _XfmpcExtendedInterface XfmpcExtendedInterface;
typedef struct _XfmpcExtendedInterfaceClass XfmpcExtendedInterfaceClass;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

#define XFMPC_EXTENDED_INTERFACE_TYPE_EXTENDED_INTERFACE_WIDGET (xfmpc_extended_interface_extended_interface_widget_get_type ())
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define XFMPC_TYPE_SONG_DIALOG (xfmpc_song_dialog_get_type ())
#define XFMPC_SONG_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_SONG_DIALOG, XfmpcSongDialog))
#define XFMPC_SONG_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_SONG_DIALOG, XfmpcSongDialogClass))
#define XFMPC_IS_SONG_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_SONG_DIALOG))
#define XFMPC_IS_SONG_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_SONG_DIALOG))
#define XFMPC_SONG_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_SONG_DIALOG, XfmpcSongDialogClass))

typedef struct _XfmpcSongDialog XfmpcSongDialog;
typedef struct _XfmpcSongDialogClass XfmpcSongDialogClass;

struct _XfmpcPlaylist {
	GtkVBox parent_instance;
	XfmpcPlaylistPrivate * priv;
};

struct _XfmpcPlaylistClass {
	GtkVBoxClass parent_class;
};

struct _XfmpcPlaylistPrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkListStore* store;
	GtkTreeModelFilter* filter;
	GtkTreeView* treeview;
	GtkMenu* menu;
	GtkImageMenuItem* mi_browse;
	GtkImageMenuItem* mi_information;
	gint current;
	gboolean autocenter;
};

typedef enum  {
	XFMPC_PLAYLIST_COLUMNS_COLUMN_ID,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT,
	XFMPC_PLAYLIST_COLUMNS_N_COLUMNS
} XfmpcPlaylistColumns;

typedef enum  {
	XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_PLAYLIST,
	XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_DBBROWSER
} XfmpcExtendedInterfaceExtendedInterfaceWidget;


static gpointer xfmpc_playlist_parent_class = NULL;
static GtkEntry* xfmpc_playlist_filter_entry;
static GtkEntry* xfmpc_playlist_filter_entry = NULL;

GType xfmpc_playlist_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
#define XFMPC_PLAYLIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistPrivate))
enum  {
	XFMPC_PLAYLIST_DUMMY_PROPERTY
};
static GType xfmpc_playlist_columns_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean xfmpc_playlist_visible_func_filter_tree (GtkTreeModel* model, GtkTreeIter* iter);
static void xfmpc_playlist_cb_browse_selection (XfmpcPlaylist* self);
GType xfmpc_dbbrowser_get_type (void) G_GNUC_CONST;
GType xfmpc_extended_interface_get_type (void) G_GNUC_CONST;
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void xfmpc_dbbrowser_set_wdir (XfmpcDbbrowser* self, const gchar* dir);
void xfmpc_dbbrowser_reload (XfmpcDbbrowser* self);
GType xfmpc_extended_interface_extended_interface_widget_get_type (void) G_GNUC_CONST;
void xfmpc_extended_interface_set_active (XfmpcExtendedInterface* self, XfmpcExtendedInterfaceExtendedInterfaceWidget active_widget);
static void xfmpc_playlist_cb_info_selection (XfmpcPlaylist* self);
GType xfmpc_song_dialog_get_type (void) G_GNUC_CONST;
XfmpcSongDialog* xfmpc_song_dialog_new (gint song_id);
XfmpcSongDialog* xfmpc_song_dialog_construct (GType object_type, gint song_id);
static gboolean xfmpc_playlist_cb_popup_menu (XfmpcPlaylist* self);
static void xfmpc_playlist_menu_popup (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_pp_changed (XfmpcPlaylist* self, gboolean is_playing);
void xfmpc_playlist_refresh_current_song (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_song_changed (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_playlist_changed (XfmpcPlaylist* self);
void xfmpc_playlist_append (XfmpcPlaylist* self, gint id, gint pos, const gchar* filename, const gchar* song, const gchar* length);
static void xfmpc_playlist_cb_row_activated (XfmpcPlaylist* self, GtkTreePath* path, GtkTreeViewColumn* column);
static gboolean xfmpc_playlist_cb_key_released (XfmpcPlaylist* self, GdkEventKey* event);
void xfmpc_playlist_delete_selection (XfmpcPlaylist* self);
static gboolean xfmpc_playlist_cb_button_released (XfmpcPlaylist* self, GdkEventButton* event);
static void xfmpc_playlist_cb_filter_entry_activated (XfmpcPlaylist* self);
void xfmpc_playlist_select_row (XfmpcPlaylist* self, gint i);
static gboolean xfmpc_playlist_cb_filter_entry_key_released (XfmpcPlaylist* self, GdkEventKey* event);
static void xfmpc_playlist_cb_filter_entry_changed (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_filter_entry_icon_activated (XfmpcPlaylist* self, GtkEntryIconPosition icon_pos, GdkEvent* event);
gboolean xfmpc_playlist_has_filename (XfmpcPlaylist* self, const gchar* filename, gboolean is_dir);
XfmpcPlaylist* xfmpc_playlist_new (void);
XfmpcPlaylist* xfmpc_playlist_construct (GType object_type);
static GObject * xfmpc_playlist_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
XfmpcPreferences* xfmpc_preferences_get_default (void);
gboolean xfmpc_preferences_get_playlist_autocenter (XfmpcPreferences* self);
gboolean xfmpc_preferences_get_playlist_show_position (XfmpcPreferences* self);
static void _xfmpc_playlist_delete_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_playlist_cb_info_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self);
static void _xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean _xfmpc_playlist_cb_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _xfmpc_playlist_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self);
static void _xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean _xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _xfmpc_playlist_cb_playlist_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void xfmpc_playlist_finalize (GObject* obj);


static GType xfmpc_playlist_columns_get_type (void) {
	static volatile gsize xfmpc_playlist_columns_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_playlist_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, "XFMPC_PLAYLIST_COLUMNS_COLUMN_ID", "column-id"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, "XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME", "column-filename"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, "XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION", "column-position"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, "XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG", "column-song"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, "XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH", "column-length"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, "XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT", "column-weight"}, {XFMPC_PLAYLIST_COLUMNS_N_COLUMNS, "XFMPC_PLAYLIST_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType xfmpc_playlist_columns_type_id;
		xfmpc_playlist_columns_type_id = g_enum_register_static ("XfmpcPlaylistColumns", values);
		g_once_init_leave (&xfmpc_playlist_columns_type_id__volatile, xfmpc_playlist_columns_type_id);
	}
	return xfmpc_playlist_columns_type_id__volatile;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean xfmpc_playlist_visible_func_filter_tree (GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	gchar* song = NULL;
	gchar* _tmp0_ = NULL;
	gchar* search = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _result_ = FALSE;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	GtkEntry* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	song = _tmp0_;
	_tmp1_ = g_strdup ("");
	search = _tmp1_;
	_result_ = TRUE;
	_tmp2_ = model;
	_tmp3_ = *iter;
	gtk_tree_model_get (_tmp2_, &_tmp3_, XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, &song, -1, -1);
	_tmp5_ = song;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = song;
		_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp4_) {
		result = TRUE;
		_g_free0 (search);
		_g_free0 (song);
		return result;
	}
	_tmp7_ = xfmpc_playlist_filter_entry;
	_tmp8_ = gtk_entry_get_text (_tmp7_);
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (search);
	search = _tmp9_;
	_tmp10_ = search;
	_tmp11_ = g_utf8_casefold (_tmp10_, (gssize) -1);
	_g_free0 (search);
	search = _tmp11_;
	_tmp12_ = search;
	if (g_strcmp0 (_tmp12_, "") != 0) {
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp13_ = song;
		_tmp14_ = g_utf8_casefold (_tmp13_, (gssize) -1);
		_g_free0 (song);
		song = _tmp14_;
		_tmp15_ = song;
		_tmp16_ = search;
		_tmp17_ = string_index_of (_tmp15_, _tmp16_, 0);
		if (_tmp17_ == -1) {
			_result_ = FALSE;
		}
	}
	result = _result_;
	_g_free0 (search);
	_g_free0 (song);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void xfmpc_playlist_cb_browse_selection (XfmpcPlaylist* self) {
	XfmpcDbbrowser* dbbrowser = NULL;
	XfmpcExtendedInterface* extended_interface = NULL;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_ = NULL;
	GtkTreeSelection* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GtkTreeModel* model = NULL;
	GtkTreeModelFilter* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GList* list = NULL;
	GtkTreeSelection* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	GList* _tmp15_ = NULL;
	gconstpointer _tmp16_ = NULL;
	GtkTreePath* _tmp17_ = NULL;
	GtkTreeModelFilter* _tmp18_ = NULL;
	GtkTreePath* _tmp19_ = NULL;
	GtkTreeIter _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcDbbrowser");
	dbbrowser = (XfmpcDbbrowser*) _tmp0_;
	_tmp1_ = g_object_get_data ((GObject*) self, "XfmpcExtendedInterface");
	extended_interface = (XfmpcExtendedInterface*) _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	selection = _tmp4_;
	_tmp5_ = selection;
	_tmp6_ = gtk_tree_selection_count_selected_rows (_tmp5_);
	if (_tmp6_ > 1) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp7_ = self->priv->filter;
	_tmp8_ = _g_object_ref0 ((GtkTreeModel*) _tmp7_);
	model = _tmp8_;
	_tmp9_ = selection;
	_tmp11_ = gtk_tree_selection_get_selected_rows (_tmp9_, &_tmp10_);
	_g_object_unref0 (model);
	_tmp12_ = _g_object_ref0 (_tmp10_);
	model = _tmp12_;
	list = _tmp11_;
	_tmp13_ = list;
	_tmp14_ = g_list_length (_tmp13_);
	if (_tmp14_ == ((guint) 0)) {
		__g_list_free__gtk_tree_path_free0_0 (list);
		_g_object_unref0 (model);
		_g_object_unref0 (selection);
		return;
	}
	_tmp15_ = list;
	_tmp16_ = g_list_nth_data (_tmp15_, (guint) 0);
	_tmp17_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp16_);
	path = _tmp17_;
	_tmp18_ = self->priv->filter;
	_tmp19_ = path;
	_tmp21_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp18_, &_tmp20_, _tmp19_);
	iter = _tmp20_;
	if (_tmp21_) {
		gchar* filename = NULL;
		gchar* _tmp22_ = NULL;
		gchar* dir = NULL;
		GtkTreeModelFilter* _tmp23_ = NULL;
		GtkTreeIter _tmp24_ = {0};
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		XfmpcDbbrowser* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		XfmpcDbbrowser* _tmp29_ = NULL;
		XfmpcExtendedInterface* _tmp30_ = NULL;
		_tmp22_ = g_strdup ("");
		filename = _tmp22_;
		_tmp23_ = self->priv->filter;
		_tmp24_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp23_, &_tmp24_, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, &filename, -1, -1);
		_tmp25_ = filename;
		_tmp26_ = g_path_get_dirname (_tmp25_);
		_g_free0 (dir);
		dir = _tmp26_;
		_tmp27_ = dbbrowser;
		_tmp28_ = dir;
		xfmpc_dbbrowser_set_wdir (_tmp27_, _tmp28_);
		_tmp29_ = dbbrowser;
		xfmpc_dbbrowser_reload (_tmp29_);
		_tmp30_ = extended_interface;
		xfmpc_extended_interface_set_active (_tmp30_, XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_DBBROWSER);
		_g_free0 (dir);
		_g_free0 (filename);
	}
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void xfmpc_playlist_cb_info_selection (XfmpcPlaylist* self) {
	GtkTreeIter iter = {0};
	gint id = 0;
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkTreeModel* model = NULL;
	GtkTreeModelFilter* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GList* list = NULL;
	GtkTreeSelection* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	GtkTreePath* path = NULL;
	GList* _tmp13_ = NULL;
	gconstpointer _tmp14_ = NULL;
	GtkTreePath* _tmp15_ = NULL;
	GtkTreeModelFilter* _tmp16_ = NULL;
	GtkTreePath* _tmp17_ = NULL;
	GtkTreeIter _tmp18_ = {0};
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	id = 0;
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp4_ = gtk_tree_selection_count_selected_rows (_tmp3_);
	if (_tmp4_ > 1) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp5_ = self->priv->filter;
	_tmp6_ = _g_object_ref0 ((GtkTreeModel*) _tmp5_);
	model = _tmp6_;
	_tmp7_ = selection;
	_tmp9_ = gtk_tree_selection_get_selected_rows (_tmp7_, &_tmp8_);
	_g_object_unref0 (model);
	_tmp10_ = _g_object_ref0 (_tmp8_);
	model = _tmp10_;
	list = _tmp9_;
	_tmp11_ = list;
	_tmp12_ = g_list_length (_tmp11_);
	if (_tmp12_ == ((guint) 0)) {
		__g_list_free__gtk_tree_path_free0_0 (list);
		_g_object_unref0 (model);
		_g_object_unref0 (selection);
		return;
	}
	_tmp13_ = list;
	_tmp14_ = g_list_nth_data (_tmp13_, (guint) 0);
	_tmp15_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp14_);
	path = _tmp15_;
	_tmp16_ = self->priv->filter;
	_tmp17_ = path;
	_tmp19_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp16_, &_tmp18_, _tmp17_);
	iter = _tmp18_;
	if (_tmp19_) {
		GtkTreeModelFilter* _tmp20_ = NULL;
		GtkTreeIter _tmp21_ = {0};
		XfmpcSongDialog* dialog = NULL;
		gint _tmp22_ = 0;
		XfmpcSongDialog* _tmp23_ = NULL;
		XfmpcSongDialog* _tmp24_ = NULL;
		_tmp20_ = self->priv->filter;
		_tmp21_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp20_, &_tmp21_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &id, -1, -1);
		_tmp22_ = id;
		_tmp23_ = xfmpc_song_dialog_new (_tmp22_);
		g_object_ref_sink (_tmp23_);
		dialog = _tmp23_;
		_tmp24_ = dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp24_);
		_g_object_unref0 (dialog);
	}
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static gboolean xfmpc_playlist_cb_popup_menu (XfmpcPlaylist* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_playlist_menu_popup (self);
	result = TRUE;
	return result;
}


static void xfmpc_playlist_cb_pp_changed (XfmpcPlaylist* self, gboolean is_playing) {
	g_return_if_fail (self != NULL);
	xfmpc_playlist_refresh_current_song (self);
}


static void xfmpc_playlist_cb_song_changed (XfmpcPlaylist* self) {
	g_return_if_fail (self != NULL);
	xfmpc_playlist_refresh_current_song (self);
}


static void xfmpc_playlist_cb_playlist_changed (XfmpcPlaylist* self) {
	gchar* filename = NULL;
	gchar* song = NULL;
	gchar* length = NULL;
	gint id = 0;
	gint pos = 0;
	XfmpcMpdclient* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkListStore* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	filename = NULL;
	song = NULL;
	length = NULL;
	id = 0;
	pos = 0;
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_get_id (_tmp0_);
	self->priv->current = _tmp1_;
	_tmp2_ = self->priv->store;
	gtk_list_store_clear (_tmp2_);
	while (TRUE) {
		XfmpcMpdclient* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp3_ = self->priv->mpdclient;
		_tmp9_ = xfmpc_mpdclient_playlist_read (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
		id = _tmp4_;
		pos = _tmp5_;
		_g_free0 (filename);
		filename = _tmp6_;
		_g_free0 (song);
		song = _tmp7_;
		_g_free0 (length);
		length = _tmp8_;
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = id;
		_tmp11_ = pos;
		_tmp12_ = filename;
		_tmp13_ = song;
		_tmp14_ = length;
		xfmpc_playlist_append (self, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
	}
	xfmpc_playlist_refresh_current_song (self);
	_g_free0 (length);
	_g_free0 (song);
	_g_free0 (filename);
}


static void xfmpc_playlist_cb_row_activated (XfmpcPlaylist* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GtkTreePath* new_path = NULL;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	gint id = 0;
	GtkTreeModelFilter* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GtkTreeModelFilter* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GtkEntry* _tmp8_ = NULL;
	XfmpcMpdclient* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = path;
	_tmp1_ = _gtk_tree_path_copy0 (_tmp0_);
	new_path = _tmp1_;
	id = 0;
	_tmp2_ = self->priv->filter;
	_tmp3_ = new_path;
	_tmp5_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_gtk_tree_path_free0 (new_path);
		return;
	}
	_tmp6_ = self->priv->filter;
	_tmp7_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &id, -1, -1);
	_tmp8_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_text (_tmp8_, "");
	_tmp9_ = self->priv->mpdclient;
	_tmp10_ = id;
	xfmpc_mpdclient_set_id (_tmp9_, _tmp10_);
	_gtk_tree_path_free0 (new_path);
}


static gboolean xfmpc_playlist_cb_key_released (XfmpcPlaylist* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_ = {0};
	GdkEventType _tmp1_ = 0;
	GdkEventKey _tmp2_ = {0};
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	switch (_tmp3_) {
		case 0xffff:
		{
			xfmpc_playlist_delete_selection (self);
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean xfmpc_playlist_cb_button_released (XfmpcPlaylist* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	GtkTreeSelection* selection = NULL;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_ = {0};
	GdkEventType _tmp2_ = 0;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeSelection* _tmp6_ = NULL;
	GtkTreeSelection* _tmp7_ = NULL;
	gboolean sensitive = FALSE;
	GtkTreeSelection* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GtkImageMenuItem* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GtkImageMenuItem* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GtkTreeView* _tmp14_ = NULL;
	GdkEventButton _tmp15_ = {0};
	gdouble _tmp16_ = 0.0;
	GdkEventButton _tmp17_ = {0};
	gdouble _tmp18_ = 0.0;
	GtkTreePath* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GtkTreeSelection* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ != GDK_BUTTON_PRESS) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp3_ = {0};
		guint _tmp4_ = 0U;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.button;
		_tmp0_ = _tmp4_ != ((guint) 3);
	}
	if (_tmp0_) {
		result = FALSE;
		_g_object_unref0 (selection);
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp5_ = self->priv->treeview;
	_tmp6_ = gtk_tree_view_get_selection (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (selection);
	selection = _tmp7_;
	_tmp8_ = selection;
	_tmp9_ = gtk_tree_selection_count_selected_rows (_tmp8_);
	sensitive = _tmp9_ == 1;
	_tmp10_ = self->priv->mi_browse;
	_tmp11_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_);
	_tmp12_ = self->priv->mi_information;
	_tmp13_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp13_);
	_tmp14_ = self->priv->treeview;
	_tmp15_ = *event;
	_tmp16_ = _tmp15_.x;
	_tmp17_ = *event;
	_tmp18_ = _tmp17_.y;
	_tmp20_ = gtk_tree_view_get_path_at_pos (_tmp14_, (gint) _tmp16_, (gint) _tmp18_, &_tmp19_, NULL, NULL, NULL);
	_gtk_tree_path_free0 (path);
	path = _tmp19_;
	if (_tmp20_) {
		GtkTreeSelection* _tmp21_ = NULL;
		GtkTreePath* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = selection;
		_tmp22_ = path;
		_tmp23_ = gtk_tree_selection_path_is_selected (_tmp21_, _tmp22_);
		if (!_tmp23_) {
			GtkTreeSelection* _tmp24_ = NULL;
			GtkTreeSelection* _tmp25_ = NULL;
			GtkTreePath* _tmp26_ = NULL;
			_tmp24_ = selection;
			gtk_tree_selection_unselect_all (_tmp24_);
			_tmp25_ = selection;
			_tmp26_ = path;
			gtk_tree_selection_select_path (_tmp25_, _tmp26_);
		}
	}
	_tmp27_ = selection;
	_tmp28_ = gtk_tree_selection_count_selected_rows (_tmp27_);
	if (_tmp28_ < 1) {
		result = TRUE;
		_g_object_unref0 (selection);
		_gtk_tree_path_free0 (path);
		return result;
	}
	xfmpc_playlist_menu_popup (self);
	result = TRUE;
	_g_object_unref0 (selection);
	_gtk_tree_path_free0 (path);
	return result;
}


static void xfmpc_playlist_menu_popup (XfmpcPlaylist* self) {
	GtkMenu* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->menu;
	_tmp1_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp0_, NULL, NULL, NULL, NULL, (guint) 0, _tmp1_);
}


static void xfmpc_playlist_cb_filter_entry_activated (XfmpcPlaylist* self) {
	GtkTreeModel* model = NULL;
	GtkTreeModelFilter* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GList* list = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreePath* path = NULL;
	GList* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	GtkTreePath* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->filter;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	list = _tmp5_;
	_tmp7_ = list;
	_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
	_tmp9_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp8_);
	path = _tmp9_;
	_tmp10_ = list;
	_tmp11_ = g_list_length (_tmp10_);
	if (_tmp11_ > ((guint) 0)) {
		GtkTreeView* _tmp12_ = NULL;
		GtkTreePath* _tmp13_ = NULL;
		GtkTreeView* _tmp14_ = NULL;
		GtkTreeViewColumn* _tmp15_ = NULL;
		GtkEntry* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		GtkTreeView* _tmp18_ = NULL;
		_tmp12_ = self->priv->treeview;
		_tmp13_ = path;
		_tmp14_ = self->priv->treeview;
		_tmp15_ = gtk_tree_view_get_column (_tmp14_, 0);
		gtk_tree_view_row_activated (_tmp12_, _tmp13_, _tmp15_);
		_tmp16_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_text (_tmp16_, "");
		_tmp17_ = self->priv->current;
		xfmpc_playlist_select_row (self, _tmp17_);
		_tmp18_ = self->priv->treeview;
		gtk_widget_grab_focus ((GtkWidget*) _tmp18_);
	}
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (model);
}


static gboolean xfmpc_playlist_cb_filter_entry_key_released (XfmpcPlaylist* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_ = {0};
	GdkEventType _tmp1_ = 0;
	GdkEventKey _tmp2_ = {0};
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	if (_tmp3_ == ((guint) 0xff1b)) {
		GtkEntry* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GtkTreeView* _tmp6_ = NULL;
		_tmp4_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_text (_tmp4_, "");
		_tmp5_ = self->priv->current;
		xfmpc_playlist_select_row (self, _tmp5_);
		_tmp6_ = self->priv->treeview;
		gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
	} else {
		GtkEntry* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = xfmpc_playlist_filter_entry;
		_tmp8_ = gtk_entry_get_text (_tmp7_);
		if (g_strcmp0 (_tmp8_, "") != 0) {
			xfmpc_playlist_select_row (self, 0);
		} else {
			gint _tmp9_ = 0;
			_tmp9_ = self->priv->current;
			xfmpc_playlist_select_row (self, _tmp9_);
		}
	}
	result = TRUE;
	return result;
}


static void xfmpc_playlist_cb_filter_entry_changed (XfmpcPlaylist* self) {
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeModelFilter* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = xfmpc_playlist_filter_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GtkEntry* _tmp2_ = NULL;
		_tmp2_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_icon_from_stock (_tmp2_, GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_CLEAR);
	} else {
		GtkEntry* _tmp3_ = NULL;
		_tmp3_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_icon_from_stock (_tmp3_, GTK_ENTRY_ICON_SECONDARY, NULL);
	}
	_tmp4_ = self->priv->filter;
	gtk_tree_model_filter_refilter (_tmp4_);
}


static void xfmpc_playlist_cb_filter_entry_icon_activated (XfmpcPlaylist* self, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	GtkEntryIconPosition _tmp0_ = 0;
	GtkEntry* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = icon_pos;
	if (_tmp0_ != GTK_ENTRY_ICON_SECONDARY) {
		return;
	}
	_tmp1_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->current;
	xfmpc_playlist_select_row (self, _tmp2_);
}


void xfmpc_playlist_append (XfmpcPlaylist* self, gint id, gint pos, const gchar* filename, const gchar* song, const gchar* length) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (song != NULL);
	g_return_if_fail (length != NULL);
	_tmp0_ = self->priv->store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->store;
	_tmp3_ = iter;
	_tmp4_ = id;
	_tmp5_ = filename;
	_tmp6_ = pos;
	_tmp7_ = song;
	_tmp8_ = length;
	gtk_list_store_set (_tmp2_, &_tmp3_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, _tmp4_, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, _tmp5_, XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, _tmp6_ + 1, XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, _tmp7_, XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, _tmp8_, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_NORMAL, -1, -1);
}


void xfmpc_playlist_refresh_current_song (XfmpcPlaylist* self) {
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkTreePath* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	XfmpcMpdclient* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkTreePath* _tmp12_ = NULL;
	GtkListStore* _tmp13_ = NULL;
	GtkTreePath* _tmp14_ = NULL;
	GtkTreeIter _tmp15_ = {0};
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GtkEntry* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	if (_tmp0_ < 0) {
		self->priv->current = 0;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = gtk_tree_path_new_from_indices (_tmp1_, -1, -1);
	_gtk_tree_path_free0 (path);
	path = _tmp2_;
	_tmp3_ = self->priv->store;
	_tmp4_ = path;
	_tmp6_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp3_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	if (_tmp6_) {
		GtkListStore* _tmp7_ = NULL;
		GtkTreeIter _tmp8_ = {0};
		_tmp7_ = self->priv->store;
		_tmp8_ = iter;
		gtk_list_store_set (_tmp7_, &_tmp8_, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_NORMAL, -1, -1);
	}
	_tmp9_ = self->priv->mpdclient;
	_tmp10_ = xfmpc_mpdclient_get_pos (_tmp9_);
	self->priv->current = _tmp10_;
	_tmp11_ = self->priv->current;
	_tmp12_ = gtk_tree_path_new_from_indices (_tmp11_, -1, -1);
	_gtk_tree_path_free0 (path);
	path = _tmp12_;
	_tmp13_ = self->priv->store;
	_tmp14_ = path;
	_tmp16_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp13_, &_tmp15_, _tmp14_);
	iter = _tmp15_;
	if (_tmp16_) {
		GtkListStore* _tmp17_ = NULL;
		GtkTreeIter _tmp18_ = {0};
		_tmp17_ = self->priv->store;
		_tmp18_ = iter;
		gtk_list_store_set (_tmp17_, &_tmp18_, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_BOLD, -1, -1);
	}
	_tmp20_ = xfmpc_playlist_filter_entry;
	_tmp21_ = gtk_entry_get_text (_tmp20_);
	if (g_strcmp0 (_tmp21_, "") == 0) {
		gboolean _tmp22_ = FALSE;
		_tmp22_ = self->priv->autocenter;
		_tmp19_ = _tmp22_;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gint _tmp23_ = 0;
		_tmp23_ = self->priv->current;
		xfmpc_playlist_select_row (self, _tmp23_);
	}
	_gtk_tree_path_free0 (path);
}


void xfmpc_playlist_select_row (XfmpcPlaylist* self, gint i) {
	gint _tmp0_ = 0;
	GtkTreeModelFilter* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GtkTreePath* path = NULL;
	gint _tmp3_ = 0;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreePath* _tmp6_ = NULL;
	GtkTreeView* _tmp7_ = NULL;
	GtkTreePath* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	if (_tmp0_ < 0) {
		return;
	}
	_tmp1_ = self->priv->filter;
	_tmp2_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp1_, NULL);
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = i;
	_tmp4_ = gtk_tree_path_new_from_indices (_tmp3_, -1, -1);
	path = _tmp4_;
	_tmp5_ = self->priv->treeview;
	_tmp6_ = path;
	gtk_tree_view_set_cursor (_tmp5_, _tmp6_, NULL, FALSE);
	_tmp7_ = self->priv->treeview;
	_tmp8_ = path;
	gtk_tree_view_scroll_to_cell (_tmp7_, _tmp8_, NULL, TRUE, (gfloat) 0.42, (gfloat) 0);
	_gtk_tree_path_free0 (path);
}


void xfmpc_playlist_delete_selection (XfmpcPlaylist* self) {
	gint id = 0;
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeModelFilter* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GList* list = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	XfmpcMpdclient* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	id = 0;
	_tmp0_ = self->priv->filter;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	list = _tmp5_;
	_tmp7_ = list;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp7_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp8_ = NULL;
			GtkTreePath* path = NULL;
			_tmp8_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp8_;
			{
				GtkTreeModelFilter* _tmp9_ = NULL;
				GtkTreePath* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				gboolean _tmp12_ = FALSE;
				_tmp9_ = self->priv->filter;
				_tmp10_ = path;
				_tmp12_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp9_, &_tmp11_, _tmp10_);
				iter = _tmp11_;
				if (_tmp12_) {
					GtkTreeModelFilter* _tmp13_ = NULL;
					GtkTreeIter _tmp14_ = {0};
					XfmpcMpdclient* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					_tmp13_ = self->priv->filter;
					_tmp14_ = iter;
					gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &id, -1, -1);
					_tmp15_ = self->priv->mpdclient;
					_tmp16_ = id;
					xfmpc_mpdclient_queue_remove_id (_tmp15_, _tmp16_);
				}
				_gtk_tree_path_free0 (path);
			}
		}
	}
	_tmp17_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_commit (_tmp17_);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (model);
}


gboolean xfmpc_playlist_has_filename (XfmpcPlaylist* self, const gchar* filename, gboolean is_dir) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	gchar* name = NULL;
	gchar* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	name = _tmp0_;
	_tmp1_ = gtk_tree_path_new_from_indices (0, -1, -1);
	_gtk_tree_path_free0 (path);
	path = _tmp1_;
	while (TRUE) {
		GtkListStore* _tmp2_ = NULL;
		GtkTreePath* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		GtkListStore* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
		GtkTreePath* _tmp14_ = NULL;
		_tmp2_ = self->priv->store;
		_tmp3_ = path;
		_tmp5_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp2_, &_tmp4_, _tmp3_);
		iter = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = self->priv->store;
		_tmp7_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, &name, -1, -1);
		_tmp8_ = is_dir;
		if (_tmp8_) {
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			_tmp9_ = name;
			_tmp10_ = filename;
			_tmp11_ = g_str_has_prefix (_tmp9_, _tmp10_);
			if (_tmp11_) {
				result = TRUE;
				_g_free0 (name);
				_gtk_tree_path_free0 (path);
				return result;
			}
		} else {
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			_tmp12_ = name;
			_tmp13_ = filename;
			if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
				result = TRUE;
				_g_free0 (name);
				_gtk_tree_path_free0 (path);
				return result;
			}
		}
		_tmp14_ = path;
		gtk_tree_path_next (_tmp14_);
	}
	result = FALSE;
	_g_free0 (name);
	_gtk_tree_path_free0 (path);
	return result;
}


XfmpcPlaylist* xfmpc_playlist_construct (GType object_type) {
	XfmpcPlaylist * self = NULL;
	self = (XfmpcPlaylist*) g_object_new (object_type, NULL);
	return self;
}


XfmpcPlaylist* xfmpc_playlist_new (void) {
	return xfmpc_playlist_construct (XFMPC_TYPE_PLAYLIST);
}


static void _xfmpc_playlist_delete_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_playlist_delete_selection ((XfmpcPlaylist*) self);
}


static void _xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_playlist_cb_browse_selection ((XfmpcPlaylist*) self);
}


static void _xfmpc_playlist_cb_info_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_playlist_cb_info_selection ((XfmpcPlaylist*) self);
}


static void _xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self) {
	xfmpc_playlist_cb_pp_changed ((XfmpcPlaylist*) self, is_playing);
}


static void _xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_playlist_cb_song_changed ((XfmpcPlaylist*) self);
}


static void _xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_playlist_cb_playlist_changed ((XfmpcPlaylist*) self);
}


static void _xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	xfmpc_playlist_cb_row_activated ((XfmpcPlaylist*) self, path, column);
}


static gboolean _xfmpc_playlist_cb_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = xfmpc_playlist_cb_key_released ((XfmpcPlaylist*) self, event);
	return result;
}


static gboolean _xfmpc_playlist_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xfmpc_playlist_cb_button_released ((XfmpcPlaylist*) self, event);
	return result;
}


static gboolean _xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self) {
	gboolean result;
	result = xfmpc_playlist_cb_popup_menu ((XfmpcPlaylist*) self);
	return result;
}


static void _xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	xfmpc_playlist_cb_filter_entry_activated ((XfmpcPlaylist*) self);
}


static gboolean _xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = xfmpc_playlist_cb_filter_entry_key_released ((XfmpcPlaylist*) self, event);
	return result;
}


static void _xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	xfmpc_playlist_cb_filter_entry_changed ((XfmpcPlaylist*) self);
}


static void _xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	xfmpc_playlist_cb_filter_entry_icon_activated ((XfmpcPlaylist*) self, p0, p1);
}


static void _xfmpc_playlist_cb_playlist_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	xfmpc_playlist_cb_playlist_changed ((XfmpcPlaylist*) self);
}


static GObject * xfmpc_playlist_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcPlaylist * self;
	XfmpcMpdclient* _tmp0_ = NULL;
	XfmpcPreferences* _tmp1_ = NULL;
	XfmpcPreferences* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkListStore* _tmp5_ = NULL;
	GtkListStore* _tmp6_ = NULL;
	GtkTreeModelFilter* _tmp7_ = NULL;
	GtkTreeModelFilter* _tmp8_ = NULL;
	GtkTreeView* _tmp9_ = NULL;
	GtkTreeView* _tmp10_ = NULL;
	GtkTreeSelection* _tmp11_ = NULL;
	GtkTreeView* _tmp12_ = NULL;
	GtkTreeView* _tmp13_ = NULL;
	GtkTreeView* _tmp14_ = NULL;
	GtkTreeView* _tmp15_ = NULL;
	GtkTreeView* _tmp16_ = NULL;
	GtkTreeModelFilter* _tmp17_ = NULL;
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp18_ = NULL;
	GtkCellRendererText* _tmp19_ = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp20_ = NULL;
	GtkTreeViewColumn* _tmp21_ = NULL;
	GtkTreeViewColumn* _tmp22_ = NULL;
	XfmpcPreferences* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	GtkTreeView* _tmp26_ = NULL;
	GtkTreeViewColumn* _tmp27_ = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkCellRendererText* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkTreeViewColumn* _tmp31_ = NULL;
	GtkTreeViewColumn* _tmp32_ = NULL;
	GtkTreeView* _tmp33_ = NULL;
	GtkTreeViewColumn* _tmp34_ = NULL;
	GtkCellRendererText* _tmp35_ = NULL;
	GtkCellRendererText* _tmp36_ = NULL;
	GtkTreeView* _tmp37_ = NULL;
	GtkCellRendererText* _tmp38_ = NULL;
	GtkScrolledWindow* scrolled = NULL;
	GtkAdjustment* _tmp39_ = NULL;
	GtkAdjustment* _tmp40_ = NULL;
	GtkAdjustment* _tmp41_ = NULL;
	GtkAdjustment* _tmp42_ = NULL;
	GtkScrolledWindow* _tmp43_ = NULL;
	GtkScrolledWindow* _tmp44_ = NULL;
	GtkScrolledWindow* _tmp45_ = NULL;
	GtkMenu* _tmp46_ = NULL;
	GtkImageMenuItem* mi = NULL;
	GtkImageMenuItem* _tmp47_ = NULL;
	GtkMenu* _tmp48_ = NULL;
	GtkImageMenuItem* _tmp49_ = NULL;
	GtkImageMenuItem* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	GtkImageMenuItem* _tmp52_ = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp53_ = NULL;
	GtkImageMenuItem* _tmp54_ = NULL;
	GtkImage* _tmp55_ = NULL;
	GtkMenu* _tmp56_ = NULL;
	GtkImageMenuItem* _tmp57_ = NULL;
	GtkImageMenuItem* _tmp58_ = NULL;
	GtkImageMenuItem* _tmp59_ = NULL;
	GtkMenu* _tmp60_ = NULL;
	GtkImageMenuItem* _tmp61_ = NULL;
	GtkImageMenuItem* _tmp62_ = NULL;
	GtkMenu* _tmp63_ = NULL;
	GtkEntry* _tmp64_ = NULL;
	GtkEntry* _tmp65_ = NULL;
	GtkEntry* _tmp66_ = NULL;
	GtkEntry* _tmp67_ = NULL;
	GtkScrolledWindow* _tmp68_ = NULL;
	GtkTreeView* _tmp69_ = NULL;
	GtkScrolledWindow* _tmp70_ = NULL;
	GtkEntry* _tmp71_ = NULL;
	XfmpcMpdclient* _tmp72_ = NULL;
	XfmpcMpdclient* _tmp73_ = NULL;
	XfmpcMpdclient* _tmp74_ = NULL;
	GtkTreeView* _tmp75_ = NULL;
	GtkTreeView* _tmp76_ = NULL;
	GtkTreeView* _tmp77_ = NULL;
	GtkTreeView* _tmp78_ = NULL;
	GtkEntry* _tmp79_ = NULL;
	GtkEntry* _tmp80_ = NULL;
	GtkEntry* _tmp81_ = NULL;
	GtkEntry* _tmp82_ = NULL;
	XfmpcPreferences* _tmp83_ = NULL;
	XfmpcPreferences* _tmp84_ = NULL;
	parent_class = G_OBJECT_CLASS (xfmpc_playlist_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_PLAYLIST, XfmpcPlaylist);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	_tmp2_ = self->priv->preferences;
	_tmp3_ = xfmpc_preferences_get_playlist_autocenter (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->autocenter = _tmp4_;
	_tmp5_ = gtk_list_store_new ((gint) XFMPC_PLAYLIST_COLUMNS_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp5_;
	_tmp6_ = self->priv->store;
	_tmp7_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp6_, NULL);
	_g_object_unref0 (self->priv->filter);
	self->priv->filter = _tmp7_;
	_tmp8_ = self->priv->filter;
	gtk_tree_model_filter_set_visible_func (_tmp8_, (GtkTreeModelFilterVisibleFunc) xfmpc_playlist_visible_func_filter_tree, NULL, NULL);
	_tmp9_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp9_;
	_tmp10_ = self->priv->treeview;
	_tmp11_ = gtk_tree_view_get_selection (_tmp10_);
	gtk_tree_selection_set_mode (_tmp11_, GTK_SELECTION_MULTIPLE);
	_tmp12_ = self->priv->treeview;
	gtk_tree_view_set_rubber_banding (_tmp12_, TRUE);
	_tmp13_ = self->priv->treeview;
	gtk_tree_view_set_enable_search (_tmp13_, FALSE);
	_tmp14_ = self->priv->treeview;
	gtk_tree_view_set_headers_visible (_tmp14_, FALSE);
	_tmp15_ = self->priv->treeview;
	gtk_tree_view_set_rules_hint (_tmp15_, TRUE);
	_tmp16_ = self->priv->treeview;
	_tmp17_ = self->priv->filter;
	gtk_tree_view_set_model (_tmp16_, (GtkTreeModel*) _tmp17_);
	_tmp18_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp18_);
	cell = _tmp18_;
	_tmp19_ = cell;
	g_object_set ((GtkCellRenderer*) _tmp19_, "xalign", (gfloat) 1, NULL);
	_tmp20_ = cell;
	_tmp21_ = gtk_tree_view_column_new_with_attributes ("Position", (GtkCellRenderer*) _tmp20_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	g_object_ref_sink (_tmp21_);
	column = _tmp21_;
	_tmp22_ = column;
	_tmp23_ = self->priv->preferences;
	_tmp24_ = xfmpc_preferences_get_playlist_show_position (_tmp23_);
	_tmp25_ = _tmp24_;
	gtk_tree_view_column_set_visible (_tmp22_, _tmp25_);
	_tmp26_ = self->priv->treeview;
	_tmp27_ = column;
	gtk_tree_view_append_column (_tmp26_, _tmp27_);
	_tmp28_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (cell);
	cell = _tmp28_;
	_tmp29_ = cell;
	g_object_set (_tmp29_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp30_ = cell;
	_tmp31_ = gtk_tree_view_column_new_with_attributes ("Song", (GtkCellRenderer*) _tmp30_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (column);
	column = _tmp31_;
	_tmp32_ = column;
	gtk_tree_view_column_set_expand (_tmp32_, TRUE);
	_tmp33_ = self->priv->treeview;
	_tmp34_ = column;
	gtk_tree_view_append_column (_tmp33_, _tmp34_);
	_tmp35_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (cell);
	cell = _tmp35_;
	_tmp36_ = cell;
	g_object_set ((GtkCellRenderer*) _tmp36_, "xalign", (gfloat) 1, NULL);
	_tmp37_ = self->priv->treeview;
	_tmp38_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp37_, -1, "Length", (GtkCellRenderer*) _tmp38_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	_tmp39_ = (GtkAdjustment*) gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp39_);
	_tmp40_ = _tmp39_;
	_tmp41_ = (GtkAdjustment*) gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp41_);
	_tmp42_ = _tmp41_;
	_tmp43_ = (GtkScrolledWindow*) gtk_scrolled_window_new (_tmp40_, _tmp42_);
	g_object_ref_sink (_tmp43_);
	_tmp44_ = _tmp43_;
	_g_object_unref0 (_tmp42_);
	_g_object_unref0 (_tmp40_);
	scrolled = _tmp44_;
	_tmp45_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp45_, GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	_tmp46_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp46_;
	_tmp47_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_REMOVE, NULL);
	g_object_ref_sink (_tmp47_);
	mi = _tmp47_;
	_tmp48_ = self->priv->menu;
	_tmp49_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp48_, (GtkWidget*) ((GtkMenuItem*) _tmp49_));
	_tmp50_ = mi;
	g_signal_connect_object ((GtkMenuItem*) _tmp50_, "activate", (GCallback) _xfmpc_playlist_delete_selection_gtk_menu_item_activate, self, 0);
	_tmp51_ = _ ("Browse");
	_tmp52_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp51_);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->mi_browse);
	self->priv->mi_browse = _tmp52_;
	_tmp53_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_OPEN, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp53_);
	image = _tmp53_;
	_tmp54_ = self->priv->mi_browse;
	_tmp55_ = image;
	gtk_image_menu_item_set_image (_tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = self->priv->menu;
	_tmp57_ = self->priv->mi_browse;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp56_, (GtkWidget*) ((GtkMenuItem*) _tmp57_));
	_tmp58_ = self->priv->mi_browse;
	g_signal_connect_object ((GtkMenuItem*) _tmp58_, "activate", (GCallback) _xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate, self, 0);
	_tmp59_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_INFO, NULL);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->mi_information);
	self->priv->mi_information = _tmp59_;
	_tmp60_ = self->priv->menu;
	_tmp61_ = self->priv->mi_information;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp60_, (GtkWidget*) ((GtkMenuItem*) _tmp61_));
	_tmp62_ = self->priv->mi_information;
	g_signal_connect_object ((GtkMenuItem*) _tmp62_, "activate", (GCallback) _xfmpc_playlist_cb_info_selection_gtk_menu_item_activate, self, 0);
	_tmp63_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp63_);
	_tmp64_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (xfmpc_playlist_filter_entry);
	xfmpc_playlist_filter_entry = _tmp64_;
	_tmp65_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_from_stock (_tmp65_, GTK_ENTRY_ICON_PRIMARY, GTK_STOCK_FIND);
	_tmp66_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_activatable (_tmp66_, GTK_ENTRY_ICON_PRIMARY, FALSE);
	_tmp67_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_activatable (_tmp67_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp68_ = scrolled;
	_tmp69_ = self->priv->treeview;
	gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = scrolled;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 0);
	_tmp71_ = xfmpc_playlist_filter_entry;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp71_, FALSE, FALSE, (guint) 0);
	_tmp72_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp72_, "pp-changed", (GCallback) _xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed, self, 0);
	_tmp73_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp73_, "song-changed", (GCallback) _xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed, self, 0);
	_tmp74_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp74_, "playlist-changed", (GCallback) _xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp75_ = self->priv->treeview;
	g_signal_connect_object (_tmp75_, "row-activated", (GCallback) _xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated, self, 0);
	_tmp76_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp76_, "key-release-event", (GCallback) _xfmpc_playlist_cb_key_released_gtk_widget_key_release_event, self, 0);
	_tmp77_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp77_, "button-press-event", (GCallback) _xfmpc_playlist_cb_button_released_gtk_widget_button_press_event, self, 0);
	_tmp78_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp78_, "popup-menu", (GCallback) _xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp79_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object (_tmp79_, "activate", (GCallback) _xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate, self, 0);
	_tmp80_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object ((GtkWidget*) _tmp80_, "key-release-event", (GCallback) _xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event, self, 0);
	_tmp81_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object ((GtkEditable*) _tmp81_, "changed", (GCallback) _xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed, self, 0);
	_tmp82_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object (_tmp82_, "icon-release", (GCallback) _xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release, self, 0);
	_tmp83_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp83_, "notify::song-format", (GCallback) _xfmpc_playlist_cb_playlist_changed_g_object_notify, self, 0);
	_tmp84_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp84_, "notify::song-format-custom", (GCallback) _xfmpc_playlist_cb_playlist_changed_g_object_notify, self, 0);
	_g_object_unref0 (image);
	_g_object_unref0 (mi);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (column);
	_g_object_unref0 (cell);
	return obj;
}


static void xfmpc_playlist_class_init (XfmpcPlaylistClass * klass) {
	xfmpc_playlist_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcPlaylistPrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_playlist_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_playlist_finalize;
}


static void xfmpc_playlist_instance_init (XfmpcPlaylist * self) {
	self->priv = XFMPC_PLAYLIST_GET_PRIVATE (self);
	self->priv->current = 0;
}


static void xfmpc_playlist_finalize (GObject* obj) {
	XfmpcPlaylist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_PLAYLIST, XfmpcPlaylist);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->filter);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->mi_browse);
	_g_object_unref0 (self->priv->mi_information);
	G_OBJECT_CLASS (xfmpc_playlist_parent_class)->finalize (obj);
}


GType xfmpc_playlist_get_type (void) {
	static volatile gsize xfmpc_playlist_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_playlist_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcPlaylistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_playlist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcPlaylist), 0, (GInstanceInitFunc) xfmpc_playlist_instance_init, NULL };
		GType xfmpc_playlist_type_id;
		xfmpc_playlist_type_id = g_type_register_static (GTK_TYPE_VBOX, "XfmpcPlaylist", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_playlist_type_id__volatile, xfmpc_playlist_type_id);
	}
	return xfmpc_playlist_type_id__volatile;
}



