/* interface.c generated by valac 0.32.0, the Vala compiler
 * generated from interface.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <pango/pango.h>


#define XFMPC_TYPE_INTERFACE (xfmpc_interface_get_type ())
#define XFMPC_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_INTERFACE, XfmpcInterface))
#define XFMPC_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_INTERFACE, XfmpcInterfaceClass))
#define XFMPC_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_INTERFACE))
#define XFMPC_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_INTERFACE))
#define XFMPC_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_INTERFACE, XfmpcInterfaceClass))

typedef struct _XfmpcInterface XfmpcInterface;
typedef struct _XfmpcInterfaceClass XfmpcInterfaceClass;
typedef struct _XfmpcInterfacePrivate XfmpcInterfacePrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _XfmpcInterface {
	GtkVBox parent_instance;
	XfmpcInterfacePrivate * priv;
};

struct _XfmpcInterfaceClass {
	GtkVBoxClass parent_class;
};

struct _XfmpcInterfacePrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkButton* button_prev;
	GtkButton* button_pp;
	GtkButton* button_next;
	GtkVolumeButton* button_volume;
	GtkProgressBar* progress_bar;
	GtkLabel* title;
	GtkLabel* subtitle;
	gboolean progress_bar_sync;
};


static gpointer xfmpc_interface_parent_class = NULL;

GType xfmpc_interface_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
#define XFMPC_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_INTERFACE, XfmpcInterfacePrivate))
enum  {
	XFMPC_INTERFACE_DUMMY_PROPERTY
};
void xfmpc_interface_set_title (XfmpcInterface* self, const gchar* title);
void xfmpc_interface_set_subtitle (XfmpcInterface* self, const gchar* subtitle);
void xfmpc_interface_pp_clicked (XfmpcInterface* self);
void xfmpc_interface_set_pp (XfmpcInterface* self, gboolean play);
static gboolean xfmpc_interface_cb_progress_box_motion_event (XfmpcInterface* self, GdkEventMotion* event);
void xfmpc_interface_set_time (XfmpcInterface* self, gint song_time, gint time_total);
static gboolean xfmpc_interface_cb_progress_box_press_event (XfmpcInterface* self, GdkEventButton* event);
static gboolean xfmpc_interface_cb_progress_box_release_event (XfmpcInterface* self, GdkEventButton* event);
void xfmpc_interface_volume_changed (XfmpcInterface* self, gdouble value);
void xfmpc_interface_set_volume (XfmpcInterface* self, gint volume);
void xfmpc_interface_popup_volume (XfmpcInterface* self);
void xfmpc_interface_reset (XfmpcInterface* self);
void xfmpc_interface_update_title (XfmpcInterface* self);
static void xfmpc_interface_cb_song_changed (XfmpcInterface* self);
static void xfmpc_interface_cb_pp_changed (XfmpcInterface* self, gboolean is_playing);
static void xfmpc_interface_cb_time_changed (XfmpcInterface* self, gint song_time);
static void xfmpc_interface_cb_total_time_changed (XfmpcInterface* self, gint total_time);
static void xfmpc_interface_cb_volume_changed (XfmpcInterface* self, gint volume);
static void xfmpc_interface_cb_playlist_changed (XfmpcInterface* self);
static void xfmpc_interface_cb_stopped (XfmpcInterface* self);
static void xfmpc_interface_cb_mpdclient_previous (XfmpcInterface* self);
static void xfmpc_interface_cb_mpdclient_next (XfmpcInterface* self);
XfmpcInterface* xfmpc_interface_new (void);
XfmpcInterface* xfmpc_interface_construct (GType object_type);
static GObject * xfmpc_interface_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
XfmpcPreferences* xfmpc_preferences_get_default (void);
static void _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_pp_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_volume_changed_gtk_scale_button_value_changed (GtkScaleButton* _sender, gdouble value, gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self);
static void _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed (XfmpcMpdclient* _sender, gint song_time, gpointer self);
static void _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed (XfmpcMpdclient* _sender, gint total_time, gpointer self);
static void _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed (XfmpcMpdclient* _sender, gint volume, gpointer self);
static void _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender, gpointer self);
static void xfmpc_interface_finalize (GObject* obj);


void xfmpc_interface_set_title (XfmpcInterface* self, const gchar* title) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->title;
	_tmp1_ = title;
	gtk_label_set_text (_tmp0_, _tmp1_);
}


void xfmpc_interface_set_subtitle (XfmpcInterface* self, const gchar* subtitle) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subtitle != NULL);
	_tmp0_ = self->priv->subtitle;
	_tmp1_ = subtitle;
	gtk_label_set_text (_tmp0_, _tmp1_);
}


void xfmpc_interface_pp_clicked (XfmpcInterface* self) {
	XfmpcMpdclient* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	XfmpcMpdclient* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_pp (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->mpdclient;
	_tmp3_ = xfmpc_mpdclient_is_playing (_tmp2_);
	xfmpc_interface_set_pp (self, _tmp3_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void xfmpc_interface_set_pp (XfmpcInterface* self, gboolean play) {
	GtkImage* image = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_pp;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_IMAGE, GtkImage));
	image = _tmp2_;
	_tmp3_ = play;
	if (_tmp3_ == TRUE) {
		GtkImage* _tmp4_ = NULL;
		_tmp4_ = image;
		gtk_image_set_from_stock (_tmp4_, GTK_STOCK_MEDIA_PAUSE, GTK_ICON_SIZE_BUTTON);
	} else {
		GtkImage* _tmp5_ = NULL;
		_tmp5_ = image;
		gtk_image_set_from_stock (_tmp5_, GTK_STOCK_MEDIA_PLAY, GTK_ICON_SIZE_BUTTON);
	}
	_g_object_unref0 (image);
}


static gboolean xfmpc_interface_cb_progress_box_motion_event (XfmpcInterface* self, GdkEventMotion* event) {
	gboolean result = FALSE;
	gint time_total = 0;
	XfmpcMpdclient* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble song_time = 0.0;
	GdkEventMotion _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	GtkProgressBar* _tmp5_ = NULL;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gdouble _tmp8_ = 0.0;
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gint _tmp15_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_get_total_time (_tmp0_);
	time_total = _tmp1_;
	_tmp2_ = time_total;
	if (_tmp2_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.x;
	_tmp5_ = self->priv->progress_bar;
	_tmp6_ = ((GtkWidget*) _tmp5_)->allocation;
	_tmp7_ = _tmp6_.width;
	song_time = _tmp4_ / _tmp7_;
	_tmp8_ = song_time;
	_tmp9_ = time_total;
	song_time = _tmp8_ * _tmp9_;
	_tmp10_ = song_time;
	if (_tmp10_ < ((gdouble) 0)) {
		song_time = (gdouble) 0;
	} else {
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		_tmp11_ = song_time;
		_tmp12_ = time_total;
		if (_tmp11_ > ((gdouble) _tmp12_)) {
			gint _tmp13_ = 0;
			_tmp13_ = time_total;
			song_time = (gdouble) _tmp13_;
		}
	}
	_tmp14_ = song_time;
	_tmp15_ = time_total;
	xfmpc_interface_set_time (self, (gint) _tmp14_, _tmp15_);
	result = FALSE;
	return result;
}


static gboolean xfmpc_interface_cb_progress_box_press_event (XfmpcInterface* self, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->progress_bar_sync = FALSE;
	result = FALSE;
	return result;
}


static gboolean xfmpc_interface_cb_progress_box_release_event (XfmpcInterface* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_ = {0};
	GdkEventType _tmp2_ = 0;
	gint time_total = 0;
	XfmpcMpdclient* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gdouble song_time = 0.0;
	GdkEventButton _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	GtkProgressBar* _tmp10_ = NULL;
	GtkAllocation _tmp11_ = {0};
	gint _tmp12_ = 0;
	gdouble _tmp13_ = 0.0;
	gint _tmp14_ = 0;
	XfmpcMpdclient* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ != GDK_BUTTON_RELEASE) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp3_ = {0};
		guint _tmp4_ = 0U;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.button;
		_tmp0_ = _tmp4_ != ((guint) 1);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->progress_bar_sync = TRUE;
	_tmp5_ = self->priv->mpdclient;
	_tmp6_ = xfmpc_mpdclient_get_total_time (_tmp5_);
	time_total = _tmp6_;
	_tmp7_ = time_total;
	if (_tmp7_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp8_ = *event;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = self->priv->progress_bar;
	_tmp11_ = ((GtkWidget*) _tmp10_)->allocation;
	_tmp12_ = _tmp11_.width;
	song_time = _tmp9_ / _tmp12_;
	_tmp13_ = song_time;
	_tmp14_ = time_total;
	song_time = _tmp13_ * _tmp14_;
	_tmp15_ = self->priv->mpdclient;
	_tmp16_ = song_time;
	xfmpc_mpdclient_set_song_time (_tmp15_, (guint) ((gint) _tmp16_));
	result = TRUE;
	return result;
}


void xfmpc_interface_volume_changed (XfmpcInterface* self, gdouble value) {
	XfmpcMpdclient* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = value;
	xfmpc_mpdclient_set_volume (_tmp0_, (guchar) ((gchar) _tmp1_));
}


void xfmpc_interface_set_volume (XfmpcInterface* self, gint volume) {
	GtkVolumeButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_volume;
	_tmp1_ = volume;
	gtk_scale_button_set_value ((GtkScaleButton*) _tmp0_, (gdouble) _tmp1_);
}


void xfmpc_interface_popup_volume (XfmpcInterface* self) {
	GtkVolumeButton* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_volume;
	g_signal_emit_by_name (_tmp0_, "popup", NULL, NULL);
}


void xfmpc_interface_set_time (XfmpcInterface* self, gint song_time, gint time_total) {
	gint min = 0;
	gint sec = 0;
	gint min_total = 0;
	gint sec_total = 0;
	gdouble fraction = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GString* text = NULL;
	GString* _tmp4_ = NULL;
	GString* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GtkProgressBar* _tmp10_ = NULL;
	GString* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	GtkProgressBar* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	fraction = 1.0;
	_tmp0_ = song_time;
	min = _tmp0_ / 60;
	_tmp1_ = song_time;
	sec = _tmp1_ % 60;
	_tmp2_ = time_total;
	min_total = _tmp2_ / 60;
	_tmp3_ = time_total;
	sec_total = _tmp3_ % 60;
	_tmp4_ = g_string_new ("");
	text = _tmp4_;
	_tmp5_ = text;
	_tmp6_ = min;
	_tmp7_ = sec;
	_tmp8_ = min_total;
	_tmp9_ = sec_total;
	g_string_append_printf (_tmp5_, "%d:%02d / %d:%02d", _tmp6_, _tmp7_, _tmp8_, _tmp9_);
	_tmp10_ = self->priv->progress_bar;
	_tmp11_ = text;
	_tmp12_ = _tmp11_->str;
	gtk_progress_bar_set_text (_tmp10_, _tmp12_);
	_tmp13_ = time_total;
	if (_tmp13_ > 0) {
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp14_ = song_time;
		_tmp15_ = time_total;
		fraction = (gdouble) (((gfloat) _tmp14_) / ((gfloat) _tmp15_));
	}
	_tmp17_ = fraction;
	if (_tmp17_ <= 1.0) {
		gdouble _tmp18_ = 0.0;
		_tmp18_ = fraction;
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = 1.0;
	}
	_tmp19_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp19_, _tmp16_);
	_g_string_free0 (text);
}


void xfmpc_interface_reset (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, FALSE);
	xfmpc_interface_set_time (self, 0, 0);
	xfmpc_interface_set_volume (self, 0);
	xfmpc_interface_update_title (self);
}


void xfmpc_interface_update_title (XfmpcInterface* self) {
	XfmpcMpdclient* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_is_playing (_tmp0_);
	if (_tmp1_) {
		XfmpcMpdclient* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* text = NULL;
		const gchar* _tmp4_ = NULL;
		XfmpcMpdclient* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		XfmpcMpdclient* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		XfmpcMpdclient* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp2_ = self->priv->mpdclient;
		_tmp3_ = xfmpc_mpdclient_get_title (_tmp2_);
		xfmpc_interface_set_title (self, _tmp3_);
		_tmp4_ = _ ("by \"%s\" from \"%s\" (%s)");
		_tmp5_ = self->priv->mpdclient;
		_tmp6_ = xfmpc_mpdclient_get_artist (_tmp5_);
		_tmp7_ = self->priv->mpdclient;
		_tmp8_ = xfmpc_mpdclient_get_album (_tmp7_);
		_tmp9_ = self->priv->mpdclient;
		_tmp10_ = xfmpc_mpdclient_get_date (_tmp9_);
		_tmp11_ = g_strdup_printf (_tmp4_, _tmp6_, _tmp8_, _tmp10_);
		text = _tmp11_;
		_tmp12_ = text;
		xfmpc_interface_set_subtitle (self, _tmp12_);
		_g_free0 (text);
	} else {
		XfmpcMpdclient* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = self->priv->mpdclient;
		_tmp14_ = xfmpc_mpdclient_is_stopped (_tmp13_);
		if (_tmp14_) {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = _ ("Stopped");
			xfmpc_interface_set_title (self, _tmp15_);
			xfmpc_interface_set_subtitle (self, PACKAGE_STRING);
		} else {
			XfmpcMpdclient* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = self->priv->mpdclient;
			_tmp17_ = xfmpc_mpdclient_is_connected (_tmp16_);
			if (!_tmp17_) {
				const gchar* _tmp18_ = NULL;
				_tmp18_ = _ ("Not connected");
				xfmpc_interface_set_title (self, _tmp18_);
				xfmpc_interface_set_subtitle (self, PACKAGE_STRING);
			}
		}
	}
}


static void xfmpc_interface_cb_song_changed (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_pp_changed (XfmpcInterface* self, gboolean is_playing) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_playing;
	xfmpc_interface_set_pp (self, _tmp0_);
	xfmpc_interface_cb_song_changed (self);
}


static void xfmpc_interface_cb_time_changed (XfmpcInterface* self, gint song_time) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	XfmpcMpdclient* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar_sync;
	if (_tmp0_ == FALSE) {
		return;
	}
	_tmp1_ = song_time;
	_tmp2_ = self->priv->mpdclient;
	_tmp3_ = xfmpc_mpdclient_get_total_time (_tmp2_);
	xfmpc_interface_set_time (self, _tmp1_, _tmp3_);
}


static void xfmpc_interface_cb_total_time_changed (XfmpcInterface* self, gint total_time) {
	gboolean _tmp0_ = FALSE;
	XfmpcMpdclient* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar_sync;
	if (_tmp0_ == FALSE) {
		return;
	}
	_tmp1_ = self->priv->mpdclient;
	_tmp2_ = xfmpc_mpdclient_get_time (_tmp1_);
	_tmp3_ = total_time;
	xfmpc_interface_set_time (self, _tmp2_, _tmp3_);
}


static void xfmpc_interface_cb_volume_changed (XfmpcInterface* self, gint volume) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = volume;
	xfmpc_interface_set_volume (self, _tmp0_);
}


static void xfmpc_interface_cb_playlist_changed (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_stopped (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, FALSE);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_mpdclient_previous (XfmpcInterface* self) {
	XfmpcMpdclient* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_previous (_tmp0_);
}


static void xfmpc_interface_cb_mpdclient_next (XfmpcInterface* self) {
	XfmpcMpdclient* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_next (_tmp0_);
}


XfmpcInterface* xfmpc_interface_construct (GType object_type) {
	XfmpcInterface * self = NULL;
	self = (XfmpcInterface*) g_object_new (object_type, NULL);
	return self;
}


XfmpcInterface* xfmpc_interface_new (void) {
	return xfmpc_interface_construct (XFMPC_TYPE_INTERFACE);
}


static void _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_cb_mpdclient_previous ((XfmpcInterface*) self);
}


static void _xfmpc_interface_pp_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_pp_clicked ((XfmpcInterface*) self);
}


static void _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_cb_mpdclient_next ((XfmpcInterface*) self);
}


static void _xfmpc_interface_volume_changed_gtk_scale_button_value_changed (GtkScaleButton* _sender, gdouble value, gpointer self) {
	xfmpc_interface_volume_changed ((XfmpcInterface*) self, value);
}


static gboolean _xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = xfmpc_interface_cb_progress_box_motion_event ((XfmpcInterface*) self, event);
	return result;
}


static gboolean _xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xfmpc_interface_cb_progress_box_press_event ((XfmpcInterface*) self, event);
	return result;
}


static gboolean _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xfmpc_interface_cb_progress_box_release_event ((XfmpcInterface*) self, event);
	return result;
}


static void _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_song_changed ((XfmpcInterface*) self);
}


static void _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self) {
	xfmpc_interface_cb_pp_changed ((XfmpcInterface*) self, is_playing);
}


static void _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed (XfmpcMpdclient* _sender, gint song_time, gpointer self) {
	xfmpc_interface_cb_time_changed ((XfmpcInterface*) self, song_time);
}


static void _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed (XfmpcMpdclient* _sender, gint total_time, gpointer self) {
	xfmpc_interface_cb_total_time_changed ((XfmpcInterface*) self, total_time);
}


static void _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed (XfmpcMpdclient* _sender, gint volume, gpointer self) {
	xfmpc_interface_cb_volume_changed ((XfmpcInterface*) self, volume);
}


static void _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_playlist_changed ((XfmpcInterface*) self);
}


static void _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_stopped ((XfmpcInterface*) self);
}


static GObject * xfmpc_interface_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcInterface * self;
	XfmpcMpdclient* _tmp0_ = NULL;
	XfmpcPreferences* _tmp1_ = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkImage* _tmp11_ = NULL;
	GtkImage* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkImage* _tmp16_ = NULL;
	GtkVolumeButton* _tmp17_ = NULL;
	GtkVolumeButton* _tmp18_ = NULL;
	GtkAdjustment* adjustment = NULL;
	GtkVolumeButton* _tmp19_ = NULL;
	GtkAdjustment* _tmp20_ = NULL;
	GtkAdjustment* _tmp21_ = NULL;
	GtkAdjustment* _tmp22_ = NULL;
	GtkAdjustment* _tmp23_ = NULL;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	GtkAdjustment* _tmp26_ = NULL;
	GtkAdjustment* _tmp27_ = NULL;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	GtkAdjustment* _tmp30_ = NULL;
	GtkAdjustment* _tmp31_ = NULL;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	GtkEventBox* progress_box = NULL;
	GtkEventBox* _tmp34_ = NULL;
	GtkProgressBar* _tmp35_ = NULL;
	GtkProgressBar* _tmp36_ = NULL;
	GtkProgressBar* _tmp37_ = NULL;
	GtkEventBox* _tmp38_ = NULL;
	GtkProgressBar* _tmp39_ = NULL;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp40_ = NULL;
	PangoAttribute* attr = NULL;
	PangoAttribute* _tmp41_ = NULL;
	PangoAttribute* _tmp42_ = NULL;
	PangoAttribute* _tmp43_ = NULL;
	PangoAttrList* _tmp44_ = NULL;
	PangoAttribute* _tmp45_ = NULL;
	PangoAttribute* _tmp46_ = NULL;
	PangoAttribute* _tmp47_ = NULL;
	PangoAttribute* _tmp48_ = NULL;
	PangoAttribute* _tmp49_ = NULL;
	PangoAttrList* _tmp50_ = NULL;
	PangoAttribute* _tmp51_ = NULL;
	PangoAttribute* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	GtkLabel* _tmp54_ = NULL;
	GtkLabel* _tmp55_ = NULL;
	PangoAttrList* _tmp56_ = NULL;
	GtkLabel* _tmp57_ = NULL;
	GtkLabel* _tmp58_ = NULL;
	GtkLabel* _tmp59_ = NULL;
	PangoAttrList* _tmp60_ = NULL;
	PangoAttribute* _tmp61_ = NULL;
	PangoAttribute* _tmp62_ = NULL;
	PangoAttribute* _tmp63_ = NULL;
	PangoAttrList* _tmp64_ = NULL;
	PangoAttribute* _tmp65_ = NULL;
	PangoAttribute* _tmp66_ = NULL;
	GtkLabel* _tmp67_ = NULL;
	GtkLabel* _tmp68_ = NULL;
	PangoAttrList* _tmp69_ = NULL;
	GtkLabel* _tmp70_ = NULL;
	GtkLabel* _tmp71_ = NULL;
	GtkLabel* _tmp72_ = NULL;
	GtkHBox* box = NULL;
	GtkHBox* _tmp73_ = NULL;
	GtkHBox* _tmp74_ = NULL;
	GtkHBox* _tmp75_ = NULL;
	GtkButton* _tmp76_ = NULL;
	GtkHBox* _tmp77_ = NULL;
	GtkButton* _tmp78_ = NULL;
	GtkHBox* _tmp79_ = NULL;
	GtkButton* _tmp80_ = NULL;
	GtkHBox* _tmp81_ = NULL;
	GtkEventBox* _tmp82_ = NULL;
	GtkHBox* _tmp83_ = NULL;
	GtkVolumeButton* _tmp84_ = NULL;
	GtkVBox* vbox = NULL;
	GtkVBox* _tmp85_ = NULL;
	GtkVBox* _tmp86_ = NULL;
	GtkVBox* _tmp87_ = NULL;
	GtkLabel* _tmp88_ = NULL;
	GtkVBox* _tmp89_ = NULL;
	GtkLabel* _tmp90_ = NULL;
	GtkButton* _tmp91_ = NULL;
	GtkButton* _tmp92_ = NULL;
	GtkButton* _tmp93_ = NULL;
	GtkVolumeButton* _tmp94_ = NULL;
	GtkEventBox* _tmp95_ = NULL;
	GtkEventBox* _tmp96_ = NULL;
	GtkEventBox* _tmp97_ = NULL;
	XfmpcMpdclient* _tmp98_ = NULL;
	XfmpcMpdclient* _tmp99_ = NULL;
	XfmpcMpdclient* _tmp100_ = NULL;
	XfmpcMpdclient* _tmp101_ = NULL;
	XfmpcMpdclient* _tmp102_ = NULL;
	XfmpcMpdclient* _tmp103_ = NULL;
	XfmpcMpdclient* _tmp104_ = NULL;
	parent_class = G_OBJECT_CLASS (xfmpc_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_INTERFACE, XfmpcInterface);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 4);
	_tmp2_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_PREVIOUS, GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp2_);
	image = _tmp2_;
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->button_prev);
	self->priv->button_prev = _tmp3_;
	_tmp4_ = self->priv->button_prev;
	gtk_button_set_relief (_tmp4_, GTK_RELIEF_NONE);
	_tmp5_ = self->priv->button_prev;
	_tmp6_ = image;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_PLAY, GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (image);
	image = _tmp7_;
	_tmp8_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->button_pp);
	self->priv->button_pp = _tmp8_;
	_tmp9_ = self->priv->button_pp;
	gtk_button_set_relief (_tmp9_, GTK_RELIEF_NONE);
	_tmp10_ = self->priv->button_pp;
	_tmp11_ = image;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_NEXT, GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (image);
	image = _tmp12_;
	_tmp13_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->button_next);
	self->priv->button_next = _tmp13_;
	_tmp14_ = self->priv->button_next;
	gtk_button_set_relief (_tmp14_, GTK_RELIEF_NONE);
	_tmp15_ = self->priv->button_next;
	_tmp16_ = image;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkVolumeButton*) gtk_volume_button_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->button_volume);
	self->priv->button_volume = _tmp17_;
	_tmp18_ = self->priv->button_volume;
	gtk_button_set_relief ((GtkButton*) _tmp18_, GTK_RELIEF_NONE);
	_tmp19_ = self->priv->button_volume;
	_tmp20_ = gtk_scale_button_get_adjustment ((GtkScaleButton*) _tmp19_);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	adjustment = _tmp21_;
	_tmp22_ = adjustment;
	_tmp23_ = adjustment;
	_tmp24_ = gtk_adjustment_get_upper (_tmp23_);
	_tmp25_ = _tmp24_;
	gtk_adjustment_set_upper (_tmp23_, _tmp25_ * 100);
	_tmp26_ = adjustment;
	_tmp27_ = adjustment;
	_tmp28_ = gtk_adjustment_get_step_increment (_tmp27_);
	_tmp29_ = _tmp28_;
	gtk_adjustment_set_step_increment (_tmp27_, _tmp29_ * 100);
	_tmp30_ = adjustment;
	_tmp31_ = adjustment;
	_tmp32_ = gtk_adjustment_get_page_increment (_tmp31_);
	_tmp33_ = _tmp32_;
	gtk_adjustment_set_page_increment (_tmp31_, _tmp33_ * 100);
	_tmp34_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp34_);
	progress_box = _tmp34_;
	_tmp35_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp35_;
	_tmp36_ = self->priv->progress_bar;
	gtk_progress_bar_set_text (_tmp36_, "0:00 / 0:00");
	_tmp37_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp37_, 1.0);
	_tmp38_ = progress_box;
	_tmp39_ = self->priv->progress_bar;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = pango_attr_list_new ();
	attrs = _tmp40_;
	_tmp41_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	attr = _tmp41_;
	_tmp42_ = attr;
	_tmp42_->start_index = (guint) 0;
	_tmp43_ = attr;
	_tmp43_->end_index = (guint) -1;
	_tmp44_ = attrs;
	_tmp45_ = attr;
	_tmp46_ = pango_attribute_copy (_tmp45_);
	pango_attr_list_insert (_tmp44_, _tmp46_);
	_tmp47_ = pango_attr_scale_new ((gdouble) PANGO_SCALE_X_LARGE);
	_pango_attribute_destroy0 (attr);
	attr = _tmp47_;
	_tmp48_ = attr;
	_tmp48_->start_index = (guint) 0;
	_tmp49_ = attr;
	_tmp49_->end_index = (guint) -1;
	_tmp50_ = attrs;
	_tmp51_ = attr;
	_tmp52_ = pango_attribute_copy (_tmp51_);
	pango_attr_list_insert (_tmp50_, _tmp52_);
	_tmp53_ = _ ("Not connected");
	_tmp54_ = (GtkLabel*) gtk_label_new (_tmp53_);
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->title);
	self->priv->title = _tmp54_;
	_tmp55_ = self->priv->title;
	_tmp56_ = attrs;
	gtk_label_set_attributes (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->title;
	gtk_label_set_selectable (_tmp57_, TRUE);
	_tmp58_ = self->priv->title;
	gtk_label_set_ellipsize (_tmp58_, PANGO_ELLIPSIZE_END);
	_tmp59_ = self->priv->title;
	gtk_misc_set_alignment ((GtkMisc*) _tmp59_, (gfloat) 0, (gfloat) 0.5);
	_tmp60_ = pango_attr_list_new ();
	_pango_attr_list_unref0 (attrs);
	attrs = _tmp60_;
	_tmp61_ = pango_attr_scale_new ((gdouble) PANGO_SCALE_SMALL);
	_pango_attribute_destroy0 (attr);
	attr = _tmp61_;
	_tmp62_ = attr;
	_tmp62_->start_index = (guint) 0;
	_tmp63_ = attr;
	_tmp63_->end_index = (guint) -1;
	_tmp64_ = attrs;
	_tmp65_ = attr;
	_tmp66_ = pango_attribute_copy (_tmp65_);
	pango_attr_list_insert (_tmp64_, _tmp66_);
	_tmp67_ = (GtkLabel*) gtk_label_new (PACKAGE_STRING);
	g_object_ref_sink (_tmp67_);
	_g_object_unref0 (self->priv->subtitle);
	self->priv->subtitle = _tmp67_;
	_tmp68_ = self->priv->subtitle;
	_tmp69_ = attrs;
	gtk_label_set_attributes (_tmp68_, _tmp69_);
	_tmp70_ = self->priv->subtitle;
	gtk_label_set_selectable (_tmp70_, TRUE);
	_tmp71_ = self->priv->subtitle;
	gtk_label_set_ellipsize (_tmp71_, PANGO_ELLIPSIZE_END);
	_tmp72_ = self->priv->subtitle;
	gtk_misc_set_alignment ((GtkMisc*) _tmp72_, (gfloat) 0, (gfloat) 0.5);
	_tmp73_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	g_object_ref_sink (_tmp73_);
	box = _tmp73_;
	_tmp74_ = box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp74_, FALSE, FALSE, (guint) 0);
	_tmp75_ = box;
	_tmp76_ = self->priv->button_prev;
	gtk_box_pack_start ((GtkBox*) _tmp75_, (GtkWidget*) _tmp76_, FALSE, FALSE, (guint) 0);
	_tmp77_ = box;
	_tmp78_ = self->priv->button_pp;
	gtk_box_pack_start ((GtkBox*) _tmp77_, (GtkWidget*) _tmp78_, FALSE, FALSE, (guint) 0);
	_tmp79_ = box;
	_tmp80_ = self->priv->button_next;
	gtk_box_pack_start ((GtkBox*) _tmp79_, (GtkWidget*) _tmp80_, FALSE, FALSE, (guint) 0);
	_tmp81_ = box;
	_tmp82_ = progress_box;
	gtk_box_pack_start ((GtkBox*) _tmp81_, (GtkWidget*) _tmp82_, TRUE, TRUE, (guint) 4);
	_tmp83_ = box;
	_tmp84_ = self->priv->button_volume;
	gtk_box_pack_start ((GtkBox*) _tmp83_, (GtkWidget*) _tmp84_, FALSE, FALSE, (guint) 0);
	_tmp85_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	g_object_ref_sink (_tmp85_);
	vbox = _tmp85_;
	_tmp86_ = vbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp86_, FALSE, TRUE, (guint) 0);
	_tmp87_ = vbox;
	_tmp88_ = self->priv->title;
	gtk_container_add ((GtkContainer*) _tmp87_, (GtkWidget*) _tmp88_);
	_tmp89_ = vbox;
	_tmp90_ = self->priv->subtitle;
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = self->priv->button_prev;
	g_signal_connect_object (_tmp91_, "clicked", (GCallback) _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked, self, 0);
	_tmp92_ = self->priv->button_pp;
	g_signal_connect_object (_tmp92_, "clicked", (GCallback) _xfmpc_interface_pp_clicked_gtk_button_clicked, self, 0);
	_tmp93_ = self->priv->button_next;
	g_signal_connect_object (_tmp93_, "clicked", (GCallback) _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked, self, 0);
	_tmp94_ = self->priv->button_volume;
	g_signal_connect_object ((GtkScaleButton*) _tmp94_, "value-changed", (GCallback) _xfmpc_interface_volume_changed_gtk_scale_button_value_changed, self, 0);
	_tmp95_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp95_, "motion-notify-event", (GCallback) _xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event, self, 0);
	_tmp96_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp96_, "button-press-event", (GCallback) _xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event, self, 0);
	_tmp97_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp97_, "button-release-event", (GCallback) _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event, self, 0);
	_tmp98_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp98_, "song-changed", (GCallback) _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed, self, 0);
	_tmp99_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp99_, "pp-changed", (GCallback) _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed, self, 0);
	_tmp100_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp100_, "time-changed", (GCallback) _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed, self, 0);
	_tmp101_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp101_, "total-time-changed", (GCallback) _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed, self, 0);
	_tmp102_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp102_, "volume-changed", (GCallback) _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed, self, 0);
	_tmp103_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp103_, "playlist-changed", (GCallback) _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp104_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp104_, "stopped", (GCallback) _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped, self, 0);
	_g_object_unref0 (vbox);
	_g_object_unref0 (box);
	_pango_attribute_destroy0 (attr);
	_pango_attr_list_unref0 (attrs);
	_g_object_unref0 (progress_box);
	_g_object_unref0 (adjustment);
	_g_object_unref0 (image);
	return obj;
}


static void xfmpc_interface_class_init (XfmpcInterfaceClass * klass) {
	xfmpc_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcInterfacePrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_interface_finalize;
}


static void xfmpc_interface_instance_init (XfmpcInterface * self) {
	self->priv = XFMPC_INTERFACE_GET_PRIVATE (self);
	self->priv->progress_bar_sync = TRUE;
}


static void xfmpc_interface_finalize (GObject* obj) {
	XfmpcInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_INTERFACE, XfmpcInterface);
	_g_object_unref0 (self->priv->button_prev);
	_g_object_unref0 (self->priv->button_pp);
	_g_object_unref0 (self->priv->button_next);
	_g_object_unref0 (self->priv->button_volume);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->title);
	_g_object_unref0 (self->priv->subtitle);
	G_OBJECT_CLASS (xfmpc_interface_parent_class)->finalize (obj);
}


GType xfmpc_interface_get_type (void) {
	static volatile gsize xfmpc_interface_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcInterface), 0, (GInstanceInitFunc) xfmpc_interface_instance_init, NULL };
		GType xfmpc_interface_type_id;
		xfmpc_interface_type_id = g_type_register_static (GTK_TYPE_VBOX, "XfmpcInterface", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_interface_type_id__volatile, xfmpc_interface_type_id);
	}
	return xfmpc_interface_type_id__volatile;
}



