/* dbbrowser.c generated by valac 0.32.0, the Vala compiler
 * generated from dbbrowser.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define XFMPC_TYPE_DBBROWSER (xfmpc_dbbrowser_get_type ())
#define XFMPC_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser))
#define XFMPC_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))
#define XFMPC_IS_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_DBBROWSER))
#define XFMPC_IS_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_DBBROWSER))
#define XFMPC_DBBROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))

typedef struct _XfmpcDbbrowser XfmpcDbbrowser;
typedef struct _XfmpcDbbrowserClass XfmpcDbbrowserClass;
typedef struct _XfmpcDbbrowserPrivate XfmpcDbbrowserPrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;

#define XFMPC_DBBROWSER_TYPE_COLUMNS (xfmpc_dbbrowser_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define XFMPC_TYPE_PLAYLIST (xfmpc_playlist_get_type ())
#define XFMPC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylist))
#define XFMPC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))
#define XFMPC_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PLAYLIST))
#define XFMPC_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PLAYLIST))
#define XFMPC_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))

typedef struct _XfmpcPlaylist XfmpcPlaylist;
typedef struct _XfmpcPlaylistClass XfmpcPlaylistClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

struct _XfmpcDbbrowser {
	GtkVBox parent_instance;
	XfmpcDbbrowserPrivate * priv;
};

struct _XfmpcDbbrowserClass {
	GtkVBoxClass parent_class;
};

struct _XfmpcDbbrowserPrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkListStore* store;
	GtkTreeView* treeview;
	GtkMenu* menu;
	GtkEntry* search_entry;
	GtkImageMenuItem* mi_browse;
	gchar* wdir;
	gchar* last_wdir;
	gboolean is_searching;
	guint search_timeout;
};

typedef enum  {
	XFMPC_DBBROWSER_COLUMNS_COLUMN_ID,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT,
	XFMPC_DBBROWSER_COLUMNS_N_COLUMNS
} XfmpcDbbrowserColumns;


static gpointer xfmpc_dbbrowser_parent_class = NULL;

GType xfmpc_dbbrowser_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
#define XFMPC_DBBROWSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserPrivate))
enum  {
	XFMPC_DBBROWSER_DUMMY_PROPERTY
};
static GType xfmpc_dbbrowser_columns_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void xfmpc_dbbrowser_reload (XfmpcDbbrowser* self);
GType xfmpc_playlist_get_type (void) G_GNUC_CONST;
static void xfmpc_dbbrowser_clear (XfmpcDbbrowser* self);
gboolean xfmpc_dbbrowser_wdir_is_root (XfmpcDbbrowser* self);
gchar* xfmpc_dbbrowser_get_parent_wdir (XfmpcDbbrowser* self);
void xfmpc_dbbrowser_append (XfmpcDbbrowser* self, const gchar* filename, const gchar* basename, gboolean is_dir, gboolean is_bold);
gboolean xfmpc_playlist_has_filename (XfmpcPlaylist* self, const gchar* filename, gboolean is_dir);
void xfmpc_dbbrowser_set_wdir (XfmpcDbbrowser* self, const gchar* dir);
void xfmpc_dbbrowser_add_selected_rows (XfmpcDbbrowser* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void xfmpc_dbbrowser_search (XfmpcDbbrowser* self, const gchar* query);
static void xfmpc_dbbrowser_menu_popup (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_playlist_changed (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_popup_menu (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_key_pressed (XfmpcDbbrowser* self, GdkEventKey* event);
static gboolean xfmpc_dbbrowser_cb_button_released (XfmpcDbbrowser* self, GdkEventButton* event);
static void xfmpc_dbbrowser_cb_row_activated (XfmpcDbbrowser* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void xfmpc_dbbrowser_cb_replace_with_selected_rows (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_browse (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_search_entry_activated (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_search_entry_key_released (XfmpcDbbrowser* self, GdkEventKey* event);
static void xfmpc_dbbrowser_cb_search_entry_changed (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_timeout_search (XfmpcDbbrowser* self);
static gboolean _xfmpc_dbbrowser_timeout_search_gsource_func (gpointer self);
static void xfmpc_dbbrowser_cb_search_entry_icon_activated (XfmpcDbbrowser* self, GtkEntryIconPosition icon_pos, GdkEvent* event);
XfmpcDbbrowser* xfmpc_dbbrowser_new (void);
XfmpcDbbrowser* xfmpc_dbbrowser_construct (GType object_type);
static GObject * xfmpc_dbbrowser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
XfmpcPreferences* xfmpc_preferences_get_default (void);
static void _xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean _xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean _xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _xfmpc_dbbrowser_reload_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void xfmpc_dbbrowser_finalize (GObject* obj);


static GType xfmpc_dbbrowser_columns_get_type (void) {
	static volatile gsize xfmpc_dbbrowser_columns_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_dbbrowser_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{XFMPC_DBBROWSER_COLUMNS_COLUMN_ID, "XFMPC_DBBROWSER_COLUMNS_COLUMN_ID", "column-id"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, "XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF", "column-pixbuf"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, "XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME", "column-filename"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, "XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME", "column-basename"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, "XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR", "column-is-dir"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, "XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT", "column-weight"}, {XFMPC_DBBROWSER_COLUMNS_N_COLUMNS, "XFMPC_DBBROWSER_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType xfmpc_dbbrowser_columns_type_id;
		xfmpc_dbbrowser_columns_type_id = g_enum_register_static ("XfmpcDbbrowserColumns", values);
		g_once_init_leave (&xfmpc_dbbrowser_columns_type_id__volatile, xfmpc_dbbrowser_columns_type_id);
	}
	return xfmpc_dbbrowser_columns_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void xfmpc_dbbrowser_reload (XfmpcDbbrowser* self) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	gboolean is_dir = FALSE;
	gboolean is_bold = FALSE;
	gint i = 0;
	XfmpcPlaylist* playlist = NULL;
	gconstpointer _tmp0_ = NULL;
	XfmpcPlaylist* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	XfmpcMpdclient* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	filename = NULL;
	basename = NULL;
	is_dir = FALSE;
	is_bold = FALSE;
	i = 0;
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp1_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp0_);
	playlist = _tmp1_;
	_tmp2_ = self->priv->is_searching;
	if (_tmp2_) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	xfmpc_dbbrowser_clear (self);
	_tmp3_ = self->priv->mpdclient;
	_tmp4_ = xfmpc_mpdclient_is_connected (_tmp3_);
	if (!_tmp4_) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp5_ = xfmpc_dbbrowser_wdir_is_root (self);
	if (!_tmp5_) {
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp6_ = xfmpc_dbbrowser_get_parent_wdir (self);
		_g_free0 (filename);
		filename = _tmp6_;
		_tmp7_ = filename;
		xfmpc_dbbrowser_append (self, _tmp7_, "..", TRUE, FALSE);
		_tmp8_ = i;
		i = _tmp8_ + 1;
	}
	while (TRUE) {
		XfmpcMpdclient* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		XfmpcPlaylist* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		_tmp9_ = self->priv->mpdclient;
		_tmp10_ = self->priv->wdir;
		_tmp14_ = xfmpc_mpdclient_database_read (_tmp9_, _tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
		_g_free0 (filename);
		filename = _tmp11_;
		_g_free0 (basename);
		basename = _tmp12_;
		is_dir = _tmp13_;
		if (!_tmp14_) {
			break;
		}
		_tmp15_ = playlist;
		_tmp16_ = filename;
		_tmp17_ = is_dir;
		_tmp18_ = xfmpc_playlist_has_filename (_tmp15_, _tmp16_, _tmp17_);
		is_bold = _tmp18_;
		_tmp19_ = filename;
		_tmp20_ = basename;
		_tmp21_ = is_dir;
		_tmp22_ = is_bold;
		xfmpc_dbbrowser_append (self, _tmp19_, _tmp20_, _tmp21_, _tmp22_);
		_tmp23_ = filename;
		_tmp24_ = self->priv->last_wdir;
		_tmp25_ = g_utf8_collate (_tmp23_, _tmp24_);
		if (_tmp25_ == 0) {
			GtkTreePath* path = NULL;
			gint _tmp26_ = 0;
			GtkTreePath* _tmp27_ = NULL;
			GtkTreeView* _tmp28_ = NULL;
			GtkTreePath* _tmp29_ = NULL;
			GtkTreeView* _tmp30_ = NULL;
			GtkTreePath* _tmp31_ = NULL;
			_tmp26_ = i;
			_tmp27_ = gtk_tree_path_new_from_indices (_tmp26_, -1, -1);
			path = _tmp27_;
			_tmp28_ = self->priv->treeview;
			_tmp29_ = path;
			gtk_tree_view_set_cursor (_tmp28_, _tmp29_, NULL, FALSE);
			_tmp30_ = self->priv->treeview;
			_tmp31_ = path;
			gtk_tree_view_scroll_to_cell (_tmp30_, _tmp31_, NULL, TRUE, (gfloat) 0.10, (gfloat) 0);
			i = -1;
			_gtk_tree_path_free0 (path);
		} else {
			gint _tmp32_ = 0;
			_tmp32_ = i;
			i = _tmp32_ + 1;
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (basename);
	_g_free0 (filename);
}


gboolean xfmpc_dbbrowser_wdir_is_root (XfmpcDbbrowser* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->wdir;
	result = g_strcmp0 (_tmp0_, "") == 0;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* xfmpc_dbbrowser_get_parent_wdir (XfmpcDbbrowser* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->wdir;
	_tmp1_ = string_index_of (_tmp0_, "/", 0);
	if (_tmp1_ == -1) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = self->priv->wdir;
		_tmp4_ = g_path_get_dirname (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


void xfmpc_dbbrowser_append (XfmpcDbbrowser* self, const gchar* filename, const gchar* basename, gboolean is_dir, gboolean is_bold) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkPixbuf* pixbuf = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	PangoWeight _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	GtkListStore* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	GdkPixbuf* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (basename != NULL);
	_tmp1_ = is_dir;
	if (_tmp1_) {
		_tmp0_ = GTK_STOCK_DIRECTORY;
	} else {
		_tmp0_ = GTK_STOCK_FILE;
	}
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_widget_render_icon ((GtkWidget*) _tmp2_, _tmp0_, GTK_ICON_SIZE_MENU, NULL);
	pixbuf = _tmp3_;
	_tmp4_ = self->priv->store;
	gtk_list_store_append (_tmp4_, &_tmp5_);
	iter = _tmp5_;
	_tmp7_ = is_bold;
	if (_tmp7_) {
		_tmp6_ = PANGO_WEIGHT_BOLD;
	} else {
		_tmp6_ = PANGO_WEIGHT_NORMAL;
	}
	_tmp8_ = self->priv->store;
	_tmp9_ = iter;
	_tmp10_ = pixbuf;
	_tmp11_ = filename;
	_tmp12_ = basename;
	_tmp13_ = is_dir;
	gtk_list_store_set (_tmp8_, &_tmp9_, XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, _tmp10_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, _tmp11_, XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, _tmp12_, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, _tmp13_, XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, _tmp6_, -1, -1);
	_g_object_unref0 (pixbuf);
}


void xfmpc_dbbrowser_set_wdir (XfmpcDbbrowser* self, const gchar* dir) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = self->priv->wdir;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->last_wdir);
	self->priv->last_wdir = _tmp1_;
	_tmp2_ = dir;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->wdir);
	self->priv->wdir = _tmp3_;
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


void xfmpc_dbbrowser_add_selected_rows (XfmpcDbbrowser* self) {
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter iter = {0};
	gchar* filename = NULL;
	gchar* _tmp2_ = NULL;
	GList* list = NULL;
	GtkTreeView* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	XfmpcMpdclient* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = g_strdup ("");
	filename = _tmp2_;
	_tmp3_ = self->priv->treeview;
	_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
	_tmp6_ = gtk_tree_selection_get_selected_rows (_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp5_);
	model = _tmp7_;
	list = _tmp6_;
	_tmp8_ = list;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp8_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp9_ = NULL;
			GtkTreePath* path = NULL;
			_tmp9_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp9_;
			{
				GtkTreeModel* _tmp10_ = NULL;
				GtkTreePath* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = path;
				_tmp13_ = gtk_tree_model_get_iter (_tmp10_, &_tmp12_, _tmp11_);
				iter = _tmp12_;
				if (_tmp13_) {
					GtkTreeModel* _tmp14_ = NULL;
					GtkTreeIter _tmp15_ = {0};
					XfmpcMpdclient* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					_tmp14_ = model;
					_tmp15_ = iter;
					gtk_tree_model_get (_tmp14_, &_tmp15_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &filename, -1, -1);
					_tmp16_ = self->priv->mpdclient;
					_tmp17_ = filename;
					xfmpc_mpdclient_queue_add (_tmp16_, _tmp17_);
				}
				_gtk_tree_path_free0 (path);
			}
		}
	}
	_tmp18_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_commit (_tmp18_);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_free0 (filename);
	_g_object_unref0 (model);
}


void xfmpc_dbbrowser_search (XfmpcDbbrowser* self, const gchar* query) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	gboolean is_bold = FALSE;
	gint i = 0;
	XfmpcPlaylist* playlist = NULL;
	gconstpointer _tmp0_ = NULL;
	XfmpcPlaylist* _tmp1_ = NULL;
	XfmpcMpdclient* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean no_result_buf = FALSE;
	gboolean no_result = FALSE;
	GdkColor color = {0};
	GdkColor _tmp16_ = {0};
	gint _tmp17_ = 0;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gint _tmp33_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	filename = NULL;
	basename = NULL;
	i = 0;
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp1_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp0_);
	playlist = _tmp1_;
	_tmp2_ = self->priv->mpdclient;
	_tmp3_ = xfmpc_mpdclient_is_connected (_tmp2_);
	if (!_tmp3_) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	self->priv->is_searching = TRUE;
	xfmpc_dbbrowser_clear (self);
	while (TRUE) {
		XfmpcMpdclient* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		XfmpcPlaylist* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gint _tmp15_ = 0;
		_tmp4_ = self->priv->mpdclient;
		_tmp5_ = query;
		_tmp8_ = xfmpc_mpdclient_database_search (_tmp4_, _tmp5_, &_tmp6_, &_tmp7_);
		_g_free0 (filename);
		filename = _tmp6_;
		_g_free0 (basename);
		basename = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = playlist;
		_tmp10_ = filename;
		_tmp11_ = xfmpc_playlist_has_filename (_tmp9_, _tmp10_, FALSE);
		is_bold = _tmp11_;
		_tmp12_ = filename;
		_tmp13_ = basename;
		_tmp14_ = is_bold;
		xfmpc_dbbrowser_append (self, _tmp12_, _tmp13_, FALSE, _tmp14_);
		_tmp15_ = i;
		i = _tmp15_ + 1;
	}
	no_result_buf = FALSE;
	no_result = FALSE;
	gdk_color_parse ("white", &_tmp16_);
	color = _tmp16_;
	color.red = (guint16) 0xFFFF;
	color.green = (guint16) 0x6666;
	color.blue = (guint16) 0x6666;
	_tmp17_ = i;
	if (_tmp17_ == 0) {
		no_result = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		_tmp18_ = no_result;
		if (_tmp18_) {
			no_result = FALSE;
		}
	}
	_tmp20_ = no_result;
	_tmp21_ = no_result_buf;
	if (_tmp20_ == _tmp21_) {
		gboolean _tmp22_ = FALSE;
		_tmp22_ = no_result;
		_tmp19_ = _tmp22_;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		GtkEntry* _tmp23_ = NULL;
		GdkColor _tmp24_ = {0};
		GtkEntry* _tmp25_ = NULL;
		GdkColor _tmp26_ = {0};
		_tmp23_ = self->priv->search_entry;
		_tmp24_ = color;
		gtk_widget_modify_bg ((GtkWidget*) _tmp23_, GTK_STATE_NORMAL, &_tmp24_);
		_tmp25_ = self->priv->search_entry;
		_tmp26_ = color;
		gtk_widget_modify_bg ((GtkWidget*) _tmp25_, GTK_STATE_SELECTED, &_tmp26_);
	} else {
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp28_ = no_result;
		_tmp29_ = no_result_buf;
		if (_tmp28_ == _tmp29_) {
			gboolean _tmp30_ = FALSE;
			_tmp30_ = no_result;
			_tmp27_ = !_tmp30_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			GtkEntry* _tmp31_ = NULL;
			GtkEntry* _tmp32_ = NULL;
			_tmp31_ = self->priv->search_entry;
			gtk_widget_modify_bg ((GtkWidget*) _tmp31_, GTK_STATE_NORMAL, NULL);
			_tmp32_ = self->priv->search_entry;
			gtk_widget_modify_bg ((GtkWidget*) _tmp32_, GTK_STATE_SELECTED, NULL);
		}
	}
	_tmp33_ = i;
	if (_tmp33_ == 0) {
		GtkEntry* _tmp34_ = NULL;
		GdkColor _tmp35_ = {0};
		GtkEntry* _tmp36_ = NULL;
		GdkColor _tmp37_ = {0};
		_tmp34_ = self->priv->search_entry;
		_tmp35_ = color;
		gtk_widget_modify_bg ((GtkWidget*) _tmp34_, GTK_STATE_NORMAL, &_tmp35_);
		_tmp36_ = self->priv->search_entry;
		_tmp37_ = color;
		gtk_widget_modify_bg ((GtkWidget*) _tmp36_, GTK_STATE_SELECTED, &_tmp37_);
	} else {
		gboolean _tmp38_ = FALSE;
		_tmp38_ = no_result;
		if (_tmp38_) {
			GtkEntry* _tmp39_ = NULL;
			GtkEntry* _tmp40_ = NULL;
			_tmp39_ = self->priv->search_entry;
			gtk_widget_modify_bg ((GtkWidget*) _tmp39_, GTK_STATE_NORMAL, NULL);
			_tmp40_ = self->priv->search_entry;
			gtk_widget_modify_bg ((GtkWidget*) _tmp40_, GTK_STATE_SELECTED, NULL);
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (basename);
	_g_free0 (filename);
}


static void xfmpc_dbbrowser_clear (XfmpcDbbrowser* self) {
	GtkListStore* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	gtk_list_store_clear (_tmp0_);
}


static void xfmpc_dbbrowser_menu_popup (XfmpcDbbrowser* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	gint count = 0;
	GtkTreeSelection* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	GtkMenu* _tmp11_ = NULL;
	guint32 _tmp12_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp4_ = gtk_tree_selection_count_selected_rows (_tmp3_);
	count = _tmp4_;
	_tmp5_ = self->priv->is_searching;
	if (_tmp5_) {
		GtkImageMenuItem* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gint _tmp8_ = 0;
		GtkImageMenuItem* _tmp9_ = NULL;
		_tmp6_ = self->priv->mi_browse;
		gtk_widget_show ((GtkWidget*) _tmp6_);
		_tmp8_ = count;
		if (_tmp8_ == 1) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp9_ = self->priv->mi_browse;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp7_);
	} else {
		GtkImageMenuItem* _tmp10_ = NULL;
		_tmp10_ = self->priv->mi_browse;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	}
	_tmp11_ = self->priv->menu;
	_tmp12_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp11_, NULL, NULL, NULL, NULL, (guint) 0, _tmp12_);
	_g_object_unref0 (selection);
}


static void xfmpc_dbbrowser_cb_playlist_changed (XfmpcDbbrowser* self) {
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter iter = {0};
	gchar* filename = NULL;
	gchar* _tmp2_ = NULL;
	gboolean is_bold = FALSE;
	gboolean is_dir = FALSE;
	XfmpcPlaylist* playlist = NULL;
	gconstpointer _tmp3_ = NULL;
	XfmpcPlaylist* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = g_strdup ("");
	filename = _tmp2_;
	is_bold = FALSE;
	is_dir = FALSE;
	_tmp3_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp4_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp3_);
	playlist = _tmp4_;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (!_tmp7_) {
		_g_object_unref0 (playlist);
		_g_free0 (filename);
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			GtkTreeModel* _tmp11_ = NULL;
			GtkTreeIter _tmp12_ = {0};
			XfmpcPlaylist* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			PangoWeight _tmp17_ = 0;
			gboolean _tmp18_ = FALSE;
			GtkListStore* _tmp19_ = NULL;
			GtkTreeIter _tmp20_ = {0};
			if (!_tmp8_) {
				GtkTreeModel* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp9_ = model;
				_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
				if (!_tmp10_) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp11_ = model;
			_tmp12_ = iter;
			gtk_tree_model_get (_tmp11_, &_tmp12_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &filename, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, &is_dir, -1, -1);
			_tmp13_ = playlist;
			_tmp14_ = filename;
			_tmp15_ = is_dir;
			_tmp16_ = xfmpc_playlist_has_filename (_tmp13_, _tmp14_, _tmp15_);
			is_bold = _tmp16_;
			_tmp18_ = is_bold;
			if (_tmp18_) {
				_tmp17_ = PANGO_WEIGHT_BOLD;
			} else {
				_tmp17_ = PANGO_WEIGHT_NORMAL;
			}
			_tmp19_ = self->priv->store;
			_tmp20_ = iter;
			gtk_list_store_set (_tmp19_, &_tmp20_, XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, _tmp17_, -1, -1);
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (filename);
	_g_object_unref0 (model);
}


static gboolean xfmpc_dbbrowser_cb_popup_menu (XfmpcDbbrowser* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_dbbrowser_menu_popup (self);
	result = TRUE;
	return result;
}


static gboolean xfmpc_dbbrowser_cb_key_pressed (XfmpcDbbrowser* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_ = {0};
	GdkEventType _tmp1_ = 0;
	GdkEventKey _tmp2_ = {0};
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_KEY_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	switch (_tmp3_) {
		case 0xff0d:
		{
			GtkTreeSelection* selection = NULL;
			GtkTreeView* _tmp4_ = NULL;
			GtkTreeSelection* _tmp5_ = NULL;
			GtkTreeSelection* _tmp6_ = NULL;
			GtkTreeSelection* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			_tmp4_ = self->priv->treeview;
			_tmp5_ = gtk_tree_view_get_selection (_tmp4_);
			_tmp6_ = _g_object_ref0 (_tmp5_);
			selection = _tmp6_;
			_tmp7_ = selection;
			_tmp8_ = gtk_tree_selection_count_selected_rows (_tmp7_);
			if (_tmp8_ > 1) {
				xfmpc_dbbrowser_add_selected_rows (self);
			} else {
				result = FALSE;
				_g_object_unref0 (selection);
				return result;
			}
			_g_object_unref0 (selection);
			break;
		}
		case 0xff08:
		{
			gchar* filename = NULL;
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_tmp9_ = xfmpc_dbbrowser_get_parent_wdir (self);
			filename = _tmp9_;
			_tmp10_ = filename;
			xfmpc_dbbrowser_set_wdir (self, _tmp10_);
			xfmpc_dbbrowser_reload (self);
			_g_free0 (filename);
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean xfmpc_dbbrowser_cb_button_released (XfmpcDbbrowser* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_ = {0};
	GdkEventType _tmp2_ = 0;
	GtkTreePath* path = NULL;
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeSelection* _tmp6_ = NULL;
	GtkTreeSelection* _tmp7_ = NULL;
	GtkTreeView* _tmp8_ = NULL;
	GdkEventButton _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	GdkEventButton _tmp11_ = {0};
	gdouble _tmp12_ = 0.0;
	GtkTreePath* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GtkTreeSelection* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ != GDK_BUTTON_PRESS) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp3_ = {0};
		guint _tmp4_ = 0U;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.button;
		_tmp0_ = _tmp4_ != ((guint) 3);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->treeview;
	_tmp6_ = gtk_tree_view_get_selection (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	selection = _tmp7_;
	_tmp8_ = self->priv->treeview;
	_tmp9_ = *event;
	_tmp10_ = _tmp9_.x;
	_tmp11_ = *event;
	_tmp12_ = _tmp11_.y;
	_tmp14_ = gtk_tree_view_get_path_at_pos (_tmp8_, (gint) _tmp10_, (gint) _tmp12_, &_tmp13_, NULL, NULL, NULL);
	_gtk_tree_path_free0 (path);
	path = _tmp13_;
	if (_tmp14_) {
		GtkTreeSelection* _tmp15_ = NULL;
		GtkTreePath* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp15_ = selection;
		_tmp16_ = path;
		_tmp17_ = gtk_tree_selection_path_is_selected (_tmp15_, _tmp16_);
		if (!_tmp17_) {
			GtkTreeSelection* _tmp18_ = NULL;
			GtkTreeSelection* _tmp19_ = NULL;
			GtkTreePath* _tmp20_ = NULL;
			_tmp18_ = selection;
			gtk_tree_selection_unselect_all (_tmp18_);
			_tmp19_ = selection;
			_tmp20_ = path;
			gtk_tree_selection_select_path (_tmp19_, _tmp20_);
		}
	}
	_tmp21_ = selection;
	_tmp22_ = gtk_tree_selection_count_selected_rows (_tmp21_);
	if (_tmp22_ < 1) {
		result = TRUE;
		_g_object_unref0 (selection);
		_gtk_tree_path_free0 (path);
		return result;
	}
	xfmpc_dbbrowser_menu_popup (self);
	result = TRUE;
	_g_object_unref0 (selection);
	_gtk_tree_path_free0 (path);
	return result;
}


static void xfmpc_dbbrowser_cb_row_activated (XfmpcDbbrowser* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreePath* ppath = NULL;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	gchar* filename = NULL;
	gchar* _tmp4_ = NULL;
	gboolean is_dir = FALSE;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreePath* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	GtkTreeModel* _tmp9_ = NULL;
	GtkTreeIter _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = path;
	_tmp1_ = _gtk_tree_path_copy0 (_tmp0_);
	ppath = _tmp1_;
	_tmp2_ = self->priv->store;
	_tmp3_ = _g_object_ref0 ((GtkTreeModel*) _tmp2_);
	model = _tmp3_;
	_tmp4_ = g_strdup ("");
	filename = _tmp4_;
	is_dir = FALSE;
	_tmp5_ = model;
	_tmp6_ = ppath;
	_tmp8_ = gtk_tree_model_get_iter (_tmp5_, &_tmp7_, _tmp6_);
	iter = _tmp7_;
	if (!_tmp8_) {
		_g_free0 (filename);
		_g_object_unref0 (model);
		_gtk_tree_path_free0 (ppath);
		return;
	}
	_tmp9_ = model;
	_tmp10_ = iter;
	gtk_tree_model_get (_tmp9_, &_tmp10_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &filename, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, &is_dir, -1, -1);
	_tmp11_ = is_dir;
	if (_tmp11_) {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = filename;
		xfmpc_dbbrowser_set_wdir (self, _tmp12_);
		xfmpc_dbbrowser_reload (self);
	} else {
		XfmpcMpdclient* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		XfmpcMpdclient* _tmp15_ = NULL;
		_tmp13_ = self->priv->mpdclient;
		_tmp14_ = filename;
		xfmpc_mpdclient_queue_add (_tmp13_, _tmp14_);
		_tmp15_ = self->priv->mpdclient;
		xfmpc_mpdclient_queue_commit (_tmp15_);
	}
	_g_free0 (filename);
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (ppath);
}


static void xfmpc_dbbrowser_cb_replace_with_selected_rows (XfmpcDbbrowser* self) {
	XfmpcMpdclient* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_clear (_tmp0_);
	xfmpc_dbbrowser_add_selected_rows (self);
}


static void xfmpc_dbbrowser_cb_browse (XfmpcDbbrowser* self) {
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_ = NULL;
	GtkTreeSelection* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GList* list = NULL;
	GtkTreeSelection* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreePath* path = NULL;
	GList* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	GtkTreePath* _tmp13_ = NULL;
	GtkTreeModel* _tmp14_ = NULL;
	GtkTreePath* _tmp15_ = NULL;
	GtkTreeIter _tmp16_ = {0};
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	selection = _tmp4_;
	_tmp5_ = selection;
	_tmp6_ = gtk_tree_selection_count_selected_rows (_tmp5_);
	if (_tmp6_ > 1) {
		_g_object_unref0 (selection);
		_g_object_unref0 (model);
		return;
	}
	_tmp7_ = selection;
	_tmp9_ = gtk_tree_selection_get_selected_rows (_tmp7_, &_tmp8_);
	_g_object_unref0 (model);
	_tmp10_ = _g_object_ref0 (_tmp8_);
	model = _tmp10_;
	list = _tmp9_;
	_tmp11_ = list;
	_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
	_tmp13_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp12_);
	path = _tmp13_;
	_tmp14_ = model;
	_tmp15_ = path;
	_tmp17_ = gtk_tree_model_get_iter (_tmp14_, &_tmp16_, _tmp15_);
	iter = _tmp16_;
	if (_tmp17_) {
		gchar* filename = NULL;
		GtkTreeModel* _tmp18_ = NULL;
		GtkTreeIter _tmp19_ = {0};
		gchar* dir = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp18_ = model;
		_tmp19_ = iter;
		gtk_tree_model_get (_tmp18_, &_tmp19_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &filename, -1, -1);
		_tmp20_ = filename;
		_tmp21_ = g_path_get_dirname (_tmp20_);
		dir = _tmp21_;
		_tmp22_ = dir;
		xfmpc_dbbrowser_set_wdir (self, _tmp22_);
		xfmpc_dbbrowser_reload (self);
		_g_free0 (dir);
		_g_free0 (filename);
	}
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (selection);
	_g_object_unref0 (model);
}


static void xfmpc_dbbrowser_cb_search_entry_activated (XfmpcDbbrowser* self) {
	gchar* entry_text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	entry_text = _tmp2_;
	_tmp3_ = entry_text;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GtkEntry* _tmp4_ = NULL;
		GtkEntry* _tmp5_ = NULL;
		self->priv->is_searching = FALSE;
		xfmpc_dbbrowser_reload (self);
		_tmp4_ = self->priv->search_entry;
		gtk_widget_modify_bg ((GtkWidget*) _tmp4_, GTK_STATE_NORMAL, NULL);
		_tmp5_ = self->priv->search_entry;
		gtk_widget_modify_bg ((GtkWidget*) _tmp5_, GTK_STATE_SELECTED, NULL);
		_g_free0 (entry_text);
		return;
	}
	_tmp6_ = entry_text;
	xfmpc_dbbrowser_search (self, _tmp6_);
	_g_free0 (entry_text);
}


static gboolean xfmpc_dbbrowser_cb_search_entry_key_released (XfmpcDbbrowser* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_ = {0};
	GdkEventType _tmp1_ = 0;
	GdkEventKey _tmp2_ = {0};
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	if (_tmp3_ == ((guint) 0xff1b)) {
		GtkEntry* _tmp4_ = NULL;
		_tmp4_ = self->priv->search_entry;
		gtk_entry_set_text (_tmp4_, "");
	}
	result = TRUE;
	return result;
}


static gboolean _xfmpc_dbbrowser_timeout_search_gsource_func (gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_timeout_search ((XfmpcDbbrowser*) self);
	return result;
}


static void xfmpc_dbbrowser_cb_search_entry_changed (XfmpcDbbrowser* self) {
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp6_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GtkEntry* _tmp2_ = NULL;
		_tmp2_ = self->priv->search_entry;
		gtk_entry_set_icon_from_stock (_tmp2_, GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_CLEAR);
	} else {
		GtkEntry* _tmp3_ = NULL;
		_tmp3_ = self->priv->search_entry;
		gtk_entry_set_icon_from_stock (_tmp3_, GTK_ENTRY_ICON_SECONDARY, NULL);
	}
	_tmp4_ = self->priv->search_timeout;
	if (_tmp4_ > ((guint) 0)) {
		guint _tmp5_ = 0U;
		_tmp5_ = self->priv->search_timeout;
		g_source_remove (_tmp5_);
	}
	_tmp6_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 642, _xfmpc_dbbrowser_timeout_search_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->search_timeout = _tmp6_;
}


static gboolean xfmpc_dbbrowser_timeout_search (XfmpcDbbrowser* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_dbbrowser_cb_search_entry_activated (self);
	result = FALSE;
	return result;
}


static void xfmpc_dbbrowser_cb_search_entry_icon_activated (XfmpcDbbrowser* self, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	GtkEntryIconPosition _tmp0_ = 0;
	GtkEntry* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = icon_pos;
	if (_tmp0_ != GTK_ENTRY_ICON_SECONDARY) {
		return;
	}
	_tmp1_ = self->priv->search_entry;
	gtk_entry_set_text (_tmp1_, "");
}


XfmpcDbbrowser* xfmpc_dbbrowser_construct (GType object_type) {
	XfmpcDbbrowser * self = NULL;
	self = (XfmpcDbbrowser*) g_object_new (object_type, NULL);
	return self;
}


XfmpcDbbrowser* xfmpc_dbbrowser_new (void) {
	return xfmpc_dbbrowser_construct (XFMPC_TYPE_DBBROWSER);
}


static void _xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_dbbrowser_add_selected_rows ((XfmpcDbbrowser*) self);
}


static void _xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_replace_with_selected_rows ((XfmpcDbbrowser*) self);
}


static void _xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_browse ((XfmpcDbbrowser*) self);
}


static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_dbbrowser_reload ((XfmpcDbbrowser*) self);
}


static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_dbbrowser_reload ((XfmpcDbbrowser*) self);
}


static void _xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_playlist_changed ((XfmpcDbbrowser*) self);
}


static void _xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	xfmpc_dbbrowser_cb_row_activated ((XfmpcDbbrowser*) self, path, column);
}


static gboolean _xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_cb_key_pressed ((XfmpcDbbrowser*) self, event);
	return result;
}


static gboolean _xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_cb_button_released ((XfmpcDbbrowser*) self, event);
	return result;
}


static gboolean _xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_cb_popup_menu ((XfmpcDbbrowser*) self);
	return result;
}


static void _xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_search_entry_activated ((XfmpcDbbrowser*) self);
}


static gboolean _xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_cb_search_entry_key_released ((XfmpcDbbrowser*) self, event);
	return result;
}


static void _xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_search_entry_changed ((XfmpcDbbrowser*) self);
}


static void _xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	xfmpc_dbbrowser_cb_search_entry_icon_activated ((XfmpcDbbrowser*) self, p0, p1);
}


static void _xfmpc_dbbrowser_reload_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	xfmpc_dbbrowser_reload ((XfmpcDbbrowser*) self);
}


static GObject * xfmpc_dbbrowser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcDbbrowser * self;
	XfmpcMpdclient* _tmp0_ = NULL;
	XfmpcPreferences* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeView* _tmp6_ = NULL;
	GtkTreeSelection* _tmp7_ = NULL;
	GtkTreeView* _tmp8_ = NULL;
	GtkTreeView* _tmp9_ = NULL;
	GtkTreeView* _tmp10_ = NULL;
	GtkTreeView* _tmp11_ = NULL;
	GtkTreeView* _tmp12_ = NULL;
	GtkTreeView* _tmp13_ = NULL;
	GtkListStore* _tmp14_ = NULL;
	GtkCellRendererPixbuf* cell_pixbuf = NULL;
	GtkCellRendererPixbuf* _tmp15_ = NULL;
	GtkTreeView* _tmp16_ = NULL;
	GtkCellRendererPixbuf* _tmp17_ = NULL;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp18_ = NULL;
	GtkCellRendererText* _tmp19_ = NULL;
	GtkTreeView* _tmp20_ = NULL;
	GtkCellRendererText* _tmp21_ = NULL;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp22_ = NULL;
	GtkScrolledWindow* _tmp23_ = NULL;
	GtkMenu* _tmp24_ = NULL;
	GtkImageMenuItem* mi = NULL;
	GtkImageMenuItem* _tmp25_ = NULL;
	GtkMenu* _tmp26_ = NULL;
	GtkImageMenuItem* _tmp27_ = NULL;
	GtkImageMenuItem* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GtkImageMenuItem* _tmp30_ = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp31_ = NULL;
	GtkImageMenuItem* _tmp32_ = NULL;
	GtkImage* _tmp33_ = NULL;
	GtkMenu* _tmp34_ = NULL;
	GtkImageMenuItem* _tmp35_ = NULL;
	GtkImageMenuItem* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GtkImageMenuItem* _tmp38_ = NULL;
	GtkImage* _tmp39_ = NULL;
	GtkImageMenuItem* _tmp40_ = NULL;
	GtkImage* _tmp41_ = NULL;
	GtkMenu* _tmp42_ = NULL;
	GtkImageMenuItem* _tmp43_ = NULL;
	GtkImageMenuItem* _tmp44_ = NULL;
	GtkMenu* _tmp45_ = NULL;
	GtkEntry* _tmp46_ = NULL;
	GtkEntry* _tmp47_ = NULL;
	GtkEntry* _tmp48_ = NULL;
	GtkEntry* _tmp49_ = NULL;
	GtkScrolledWindow* _tmp50_ = NULL;
	GtkTreeView* _tmp51_ = NULL;
	GtkScrolledWindow* _tmp52_ = NULL;
	GtkEntry* _tmp53_ = NULL;
	XfmpcMpdclient* _tmp54_ = NULL;
	XfmpcMpdclient* _tmp55_ = NULL;
	XfmpcMpdclient* _tmp56_ = NULL;
	GtkTreeView* _tmp57_ = NULL;
	GtkTreeView* _tmp58_ = NULL;
	GtkTreeView* _tmp59_ = NULL;
	GtkTreeView* _tmp60_ = NULL;
	GtkEntry* _tmp61_ = NULL;
	GtkEntry* _tmp62_ = NULL;
	GtkEntry* _tmp63_ = NULL;
	GtkEntry* _tmp64_ = NULL;
	XfmpcPreferences* _tmp65_ = NULL;
	XfmpcPreferences* _tmp66_ = NULL;
	parent_class = G_OBJECT_CLASS (xfmpc_dbbrowser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->wdir);
	self->priv->wdir = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->last_wdir);
	self->priv->last_wdir = _tmp3_;
	_tmp4_ = gtk_list_store_new ((gint) XFMPC_DBBROWSER_COLUMNS_N_COLUMNS, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp4_;
	_tmp5_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp5_;
	_tmp6_ = self->priv->treeview;
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
	gtk_tree_selection_set_mode (_tmp7_, GTK_SELECTION_MULTIPLE);
	_tmp8_ = self->priv->treeview;
	gtk_tree_view_set_rubber_banding (_tmp8_, TRUE);
	_tmp9_ = self->priv->treeview;
	gtk_tree_view_set_enable_search (_tmp9_, TRUE);
	_tmp10_ = self->priv->treeview;
	gtk_tree_view_set_search_column (_tmp10_, (gint) XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME);
	_tmp11_ = self->priv->treeview;
	gtk_tree_view_set_headers_visible (_tmp11_, FALSE);
	_tmp12_ = self->priv->treeview;
	gtk_tree_view_set_rules_hint (_tmp12_, TRUE);
	_tmp13_ = self->priv->treeview;
	_tmp14_ = self->priv->store;
	gtk_tree_view_set_model (_tmp13_, (GtkTreeModel*) _tmp14_);
	_tmp15_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp15_);
	cell_pixbuf = _tmp15_;
	_tmp16_ = self->priv->treeview;
	_tmp17_ = cell_pixbuf;
	gtk_tree_view_insert_column_with_attributes (_tmp16_, -1, "", (GtkCellRenderer*) _tmp17_, "pixbuf", XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, NULL, NULL);
	_tmp18_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp18_);
	cell_text = _tmp18_;
	_tmp19_ = cell_text;
	g_object_set (_tmp19_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp20_ = self->priv->treeview;
	_tmp21_ = cell_text;
	gtk_tree_view_insert_column_with_attributes (_tmp20_, -1, "Filename", (GtkCellRenderer*) _tmp21_, "text", XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, "weight", XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	_tmp22_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp22_);
	scrolled = _tmp22_;
	_tmp23_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp23_, GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	_tmp24_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp24_;
	_tmp25_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ADD, NULL);
	g_object_ref_sink (_tmp25_);
	mi = _tmp25_;
	_tmp26_ = self->priv->menu;
	_tmp27_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp26_, (GtkWidget*) ((GtkMenuItem*) _tmp27_));
	_tmp28_ = mi;
	g_signal_connect_object ((GtkMenuItem*) _tmp28_, "activate", (GCallback) _xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate, self, 0);
	_tmp29_ = _ ("Replace");
	_tmp30_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp29_);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (mi);
	mi = _tmp30_;
	_tmp31_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CUT, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp31_);
	image = _tmp31_;
	_tmp32_ = mi;
	_tmp33_ = image;
	gtk_image_menu_item_set_image (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->menu;
	_tmp35_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp34_, (GtkWidget*) ((GtkMenuItem*) _tmp35_));
	_tmp36_ = mi;
	g_signal_connect_object ((GtkMenuItem*) _tmp36_, "activate", (GCallback) _xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate, self, 0);
	_tmp37_ = _ ("Browse");
	_tmp38_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp37_);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->mi_browse);
	self->priv->mi_browse = _tmp38_;
	_tmp39_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_OPEN, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (image);
	image = _tmp39_;
	_tmp40_ = self->priv->mi_browse;
	_tmp41_ = image;
	gtk_image_menu_item_set_image (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->menu;
	_tmp43_ = self->priv->mi_browse;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp42_, (GtkWidget*) ((GtkMenuItem*) _tmp43_));
	_tmp44_ = self->priv->mi_browse;
	g_signal_connect_object ((GtkMenuItem*) _tmp44_, "activate", (GCallback) _xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate, self, 0);
	_tmp45_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp45_);
	_tmp46_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp46_;
	_tmp47_ = self->priv->search_entry;
	gtk_entry_set_icon_from_stock (_tmp47_, GTK_ENTRY_ICON_PRIMARY, GTK_STOCK_FIND);
	_tmp48_ = self->priv->search_entry;
	gtk_entry_set_icon_activatable (_tmp48_, GTK_ENTRY_ICON_PRIMARY, FALSE);
	_tmp49_ = self->priv->search_entry;
	gtk_entry_set_icon_activatable (_tmp49_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp50_ = scrolled;
	_tmp51_ = self->priv->treeview;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = scrolled;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp52_, TRUE, TRUE, (guint) 0);
	_tmp53_ = self->priv->search_entry;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp53_, FALSE, FALSE, (guint) 0);
	_tmp54_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp54_, "connected", (GCallback) _xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected, self, 0);
	_tmp55_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp55_, "database-changed", (GCallback) _xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed, self, 0);
	_tmp56_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp56_, "playlist-changed", (GCallback) _xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp57_ = self->priv->treeview;
	g_signal_connect_object (_tmp57_, "row-activated", (GCallback) _xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated, self, 0);
	_tmp58_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp58_, "key-press-event", (GCallback) _xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event, self, 0);
	_tmp59_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp59_, "button-press-event", (GCallback) _xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event, self, 0);
	_tmp60_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp60_, "popup-menu", (GCallback) _xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp61_ = self->priv->search_entry;
	g_signal_connect_object (_tmp61_, "activate", (GCallback) _xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate, self, 0);
	_tmp62_ = self->priv->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp62_, "key-release-event", (GCallback) _xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event, self, 0);
	_tmp63_ = self->priv->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp63_, "changed", (GCallback) _xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed, self, 0);
	_tmp64_ = self->priv->search_entry;
	g_signal_connect_object (_tmp64_, "icon-release", (GCallback) _xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release, self, 0);
	_tmp65_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp65_, "notify::song-format", (GCallback) _xfmpc_dbbrowser_reload_g_object_notify, self, 0);
	_tmp66_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp66_, "notify::song-format-custom", (GCallback) _xfmpc_dbbrowser_reload_g_object_notify, self, 0);
	_g_object_unref0 (image);
	_g_object_unref0 (mi);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (cell_pixbuf);
	return obj;
}


static void xfmpc_dbbrowser_class_init (XfmpcDbbrowserClass * klass) {
	xfmpc_dbbrowser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcDbbrowserPrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_dbbrowser_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_dbbrowser_finalize;
}


static void xfmpc_dbbrowser_instance_init (XfmpcDbbrowser * self) {
	self->priv = XFMPC_DBBROWSER_GET_PRIVATE (self);
}


static void xfmpc_dbbrowser_finalize (GObject* obj) {
	XfmpcDbbrowser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->mi_browse);
	_g_free0 (self->priv->wdir);
	_g_free0 (self->priv->last_wdir);
	G_OBJECT_CLASS (xfmpc_dbbrowser_parent_class)->finalize (obj);
}


GType xfmpc_dbbrowser_get_type (void) {
	static volatile gsize xfmpc_dbbrowser_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_dbbrowser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcDbbrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_dbbrowser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcDbbrowser), 0, (GInstanceInitFunc) xfmpc_dbbrowser_instance_init, NULL };
		GType xfmpc_dbbrowser_type_id;
		xfmpc_dbbrowser_type_id = g_type_register_static (GTK_TYPE_VBOX, "XfmpcDbbrowser", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_dbbrowser_type_id__volatile, xfmpc_dbbrowser_type_id);
	}
	return xfmpc_dbbrowser_type_id__volatile;
}



