/*
 * * Copyright (C) 2009 Ali <aliov@xfce.org>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>

#include "parole-about.h"

void  parole_about (const gchar *package)
{
    XfceAboutInfo *info;
    GtkWidget *dialog;
    gint x, y;
    GdkPixbuf *icon;
    guint n;

    static const struct
    {
	gchar *name, *email, *language;
    } 	
    translators[] = 
    {
	{"", "", "",},
    };

    info = xfce_about_info_new ("Parole", VERSION, _("Parole Media Player"),
                                XFCE_COPYRIGHT_TEXT ("2009", "Ali Abdallah"), 
				XFCE_LICENSE_GPL);

    xfce_about_info_set_homepage (info, "http://goodies.xfce.org/projects/applications/parole-media-player");
    xfce_about_info_add_credit (info, "Ali Abdallah", "aliov@xfce.org", _("Author/Maintainer"));
  

    for (n = 0; n < G_N_ELEMENTS (translators); ++n) 
    {
	gchar *s;
	s = g_strdup_printf (_("Translator (%s)"), translators[n].language);
	xfce_about_info_add_credit (info, translators[n].name, translators[n].email, s);
	g_free (s);
    }

    gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &x, &y);
    icon = xfce_themed_icon_load ("parole", x);
    
    dialog = xfce_about_dialog_new_with_values (NULL, info, icon);
    
    if (icon)
	g_object_unref (G_OBJECT (icon));
	
    gtk_dialog_run (GTK_DIALOG (dialog));
    gtk_widget_destroy (dialog);

    xfce_about_info_free (info);
}
