/*
 Copyright (C) 2008 Christian Dywan <christian@twotoasts.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

#ifndef __MIDORI_APP_H__
#define __MIDORI_APP_H__

#include <katze/katze.h>

#include "midori-browser.h"
#include "midori-websettings.h"

G_BEGIN_DECLS

#define MIDORI_TYPE_APP \
    (midori_app_get_type ())
#define MIDORI_APP(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDORI_TYPE_APP, MidoriApp))
#define MIDORI_APP_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST ((klass), MIDORI_TYPE_APP, MidoriAppClass))
#define MIDORI_IS_APP(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDORI_TYPE_APP))
#define MIDORI_IS_APP_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDORI_TYPE_APP))
#define MIDORI_APP_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDORI_TYPE_APP, MidoriAppClass))

typedef struct _MidoriApp                MidoriApp;
typedef struct _MidoriAppClass           MidoriAppClass;

struct _MidoriAppClass
{
    GObjectClass parent_class;

    /* Signals */
    void
    (*add_browser)            (MidoriApp*     app,
                               MidoriBrowser* browser);
    void
    (*quit)                   (MidoriApp*     app);
};

GType
midori_app_get_type               (void);

MidoriApp*
midori_app_new                    (void);

gboolean
midori_app_instance_is_running    (MidoriApp*         app);

gboolean
midori_app_instance_send_activate (MidoriApp*         app);

gboolean
midori_app_instance_send_uris     (MidoriApp*         app,
                                   gchar**            uris);

void
midori_app_add_browser            (MidoriApp*         app,
                                   MidoriBrowser*     browser);

MidoriWebSettings*
midori_app_get_settings           (MidoriApp*         app);

void
midori_app_set_settings           (MidoriApp*         app,
                                   MidoriWebSettings* settings);

KatzeArray*
midori_app_get_trash              (MidoriApp*         app);

void
midori_app_quit                   (MidoriApp*         app);

G_END_DECLS

#endif /* __MIDORI_APP_H__ */
